/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.vuzeactivity;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesEntryBuddyRequest;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.DataSourceUtils;
import com.aelitis.azureus.util.PlayUtils;
import com.aelitis.azureus.util.StringCompareUtils;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnActivityActions
extends CoreTableColumn
implements TableCellSWTPaintListener,
TableCellRefreshListener,
TableCellMouseMoveListener,
TableCellAddedListener {
    public static final String COLUMN_ID = "activityActions";
    private Color colorLinkNormal;
    private Color colorLinkHover;
    private boolean useButton = false;
    private boolean mouseIn = false;
    private boolean disabled = false;
    private static UISWTGraphicImpl graphicRate;
    private static UISWTGraphicImpl graphicRateDown;
    private static UISWTGraphicImpl graphicRateUp;
    private static UISWTGraphicImpl[] graphicsWait;
    private static Rectangle boundsRate;
    private static Font font;
    boolean bMouseDowned = false;

    public ColumnActivityActions(String tableID) {
        super(COLUMN_ID, tableID);
        this.initializeAsGraphic(150);
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.colorLinkNormal = skinProperties.getColor("color.links.normal");
        this.colorLinkHover = skinProperties.getColor("color.links.hover");
        Image img = ImageLoaderFactory.getInstance().getImage("icon.rate.library");
        graphicRate = new UISWTGraphicImpl(img);
        img = ImageLoaderFactory.getInstance().getImage("icon.rate.library.down");
        graphicRateDown = new UISWTGraphicImpl(img);
        img = ImageLoaderFactory.getInstance().getImage("icon.rate.library.up");
        graphicRateUp = new UISWTGraphicImpl(img);
        boundsRate = img.getBounds();
        Image[] imgs = ImageLoaderFactory.getInstance().getImages("image.sidebar.vitality.dots");
        graphicsWait = new UISWTGraphicImpl[imgs.length];
        for (int i = 0; i < imgs.length; ++i) {
            ColumnActivityActions.graphicsWait[i] = new UISWTGraphicImpl(imgs[i]);
        }
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        if (entry.getTypeID().equals("Rating-Reminder")) {
            this.cellPaintForRate(gc, cell);
            return;
        }
        String text = cell.getText();
        if (text != null && text.length() > 0) {
            if (font == null) {
                FontData[] fontData = gc.getFont().getFontData();
                fontData[0].setStyle(1);
                font = new Font(gc.getDevice(), fontData);
            }
            gc.setFont(font);
            Rectangle bounds = this.getDrawBounds(cell);
            GCStringPrinter sp = new GCStringPrinter(gc, text, bounds, true, true, 0x1000040);
            sp.calculateMetrics();
            if (sp.hasHitUrl()) {
                GCStringPrinter.URLInfo[] hitUrlInfo = sp.getHitUrlInfo();
                for (int i = 0; i < hitUrlInfo.length; ++i) {
                    GCStringPrinter.URLInfo info = hitUrlInfo[i];
                    info.urlUnderline = cell.getTableRow().isSelected();
                    info.urlColor = info.urlUnderline ? null : this.colorLinkNormal;
                }
                int[] mouseOfs = cell.getMouseOffset();
                if (mouseOfs != null) {
                    Rectangle realBounds = cell.getBounds();
                    GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(mouseOfs[0] + realBounds.x, mouseOfs[1] + realBounds.y);
                    if (hitUrl != null) {
                        hitUrl.urlColor = this.colorLinkHover;
                    }
                }
            }
            sp.printString();
        }
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginHeight(0);
    }

    public void refresh(TableCell cell) {
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        if (entry == null) {
            return;
        }
        if ("Rating-Reminder".equals(entry.getTypeID())) {
            DownloadManager dm = DataSourceUtils.getDM(entry);
            if (dm == null) {
                return;
            }
            int rating = PlatformTorrentUtils.getUserRating(dm.getTorrent());
            if (cell.setSortValue(rating)) {
                ((TableCellSWT)cell).redraw();
            }
            return;
        }
        if (!cell.setSortValue((Comparable)((Object)entry.getTypeID())) && cell.isValid()) {
            return;
        }
        if (entry instanceof VuzeActivitiesEntryBuddyRequest) {
            VuzeActivitiesEntryBuddyRequest br = (VuzeActivitiesEntryBuddyRequest)entry;
            String urlAccept = br.getUrlAccept();
            String text = "<A HREF=\"" + urlAccept + "\" TARGET=\"browse\">Accept</A>";
            cell.setText(text);
        } else {
            boolean canRun;
            DownloadManager dm = entry.getDownloadManger();
            boolean canPlay = PlayUtils.canPlayDS(entry);
            boolean canDL = dm == null && entry.getDownloadManger() == null && (entry.getTorrent() != null || entry.getAssetHash() != null);
            boolean bl = canRun = !canPlay && dm != null;
            if (canRun && dm != null && !dm.getAssumedComplete()) {
                canRun = false;
            }
            StringBuffer sb = new StringBuffer();
            if (canDL) {
                if (sb.length() > 0) {
                    sb.append(" | ");
                }
                sb.append("<A HREF=\"download\">Download</A>");
            }
            if (canPlay) {
                if (sb.length() > 0) {
                    sb.append(" | ");
                }
                sb.append("<A HREF=\"play\">Play</A>");
            }
            if (canRun) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("<A HREF=\"launch\">Launch</A>");
            }
            cell.setText(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String oldTooltip;
        Object o;
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)event2.cell.getDataSource();
        if (entry.getTypeID().equals("Rating-Reminder")) {
            this.cellMouseTriggerForRate(event2);
            return;
        }
        String tooltip = null;
        boolean invalidateAndRefresh = false;
        Rectangle bounds = ((TableCellSWT)event2.cell).getBounds();
        String text = event2.cell.getText();
        GCStringPrinter sp = null;
        GC gc = new GC((Drawable)Display.getDefault());
        try {
            if (font != null) {
                gc.setFont(font);
            }
            Rectangle drawBounds = this.getDrawBounds((TableCellSWT)event2.cell);
            sp = new GCStringPrinter(gc, text, drawBounds, true, true, 0x1000040);
            sp.calculateMetrics();
        }
        catch (Exception e) {
            Debug.out(e);
        }
        finally {
            gc.dispose();
        }
        if (sp != null) {
            int newCursor;
            GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(event2.x + bounds.x, event2.y + bounds.y);
            if (hitUrl != null) {
                if (event2.eventType == 1) {
                    String referal;
                    if (hitUrl.url.equals("download")) {
                        referal = null;
                        Object ds = event2.cell.getDataSource();
                        if (ds instanceof VuzeActivitiesEntry) {
                            if (((VuzeActivitiesEntry)ds).isDRM()) {
                                String hash = this.getHash(event2.cell.getDataSource(), true);
                                if (hash != null) {
                                    TorrentListViewsUtils.viewDetails(hash, "activity-dl");
                                }
                                return;
                            }
                            referal = "dashboardactivity-" + ((VuzeActivitiesEntry)ds).getTypeID();
                        }
                        TorrentListViewsUtils.downloadDataSource(ds, false, referal);
                    } else if (hitUrl.url.equals("play")) {
                        referal = null;
                        Object ds = event2.cell.getDataSource();
                        if (ds instanceof VuzeActivitiesEntry) {
                            if (((VuzeActivitiesEntry)ds).isDRM() && ((VuzeActivitiesEntry)ds).getDownloadManger() == null) {
                                String hash = this.getHash(event2.cell.getDataSource(), true);
                                if (hash != null) {
                                    TorrentListViewsUtils.viewDetails(hash, "thumb");
                                }
                                return;
                            }
                            referal = "playdashboardactivity-" + ((VuzeActivitiesEntry)ds).getTypeID();
                        }
                        TorrentListViewsUtils.playOrStreamDataSource(ds, null, referal);
                    } else if (hitUrl.url.equals("launch")) {
                        Object ds = event2.cell.getDataSource();
                        TorrentListViewsUtils.playOrStreamDataSource(ds, null, "launch");
                    } else if (!PlatformConfigMessenger.urlCanRPC(hitUrl.url)) {
                        Utils.launch(hitUrl.url);
                    } else {
                        UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
                        if (uif != null) {
                            String target = hitUrl.target == null ? "browse" : hitUrl.target;
                            uif.viewURL(hitUrl.url, target, 0, 0, false, false);
                            return;
                        }
                    }
                }
                newCursor = 21;
                tooltip = PlatformConfigMessenger.urlCanRPC(hitUrl.url) ? hitUrl.title : hitUrl.url;
            } else {
                newCursor = 0;
            }
            int oldCursor = ((TableCellSWT)event2.cell).getCursorID();
            if (oldCursor != newCursor) {
                invalidateAndRefresh = true;
                ((TableCellSWT)event2.cell).setCursorID(newCursor);
            }
        }
        if ((o = event2.cell.getToolTip()) == null | o instanceof String && !StringCompareUtils.equals(oldTooltip = (String)o, tooltip)) {
            invalidateAndRefresh = true;
            event2.cell.setToolTip(tooltip);
        }
        if (invalidateAndRefresh) {
            event2.cell.invalidate();
            ((TableCellSWT)event2.cell).redraw();
        }
    }

    public void cellMouseTriggerForRate(final TableCellMouseEvent event2) {
        if (this.disabled) {
            return;
        }
        DownloadManager dm = DataSourceUtils.getDM(event2.cell.getDataSource());
        if (dm == null) {
            return;
        }
        TOTorrent torrent0 = dm.getTorrent();
        if (torrent0 == null) {
            return;
        }
        if (this.useButton) {
            if (event2.eventType == 4) {
                this.mouseIn = true;
                this.refresh(event2.cell);
            } else if (event2.eventType == 5) {
                this.mouseIn = false;
                this.refresh(event2.cell);
            }
        }
        TOTorrent torrent = torrent0;
        if (event2.button != 1) {
            return;
        }
        TableRow row = event2.cell.getTableRow();
        if (row != null && !row.isSelected()) {
            return;
        }
        if (!PlatformTorrentUtils.isContent(torrent, true)) {
            return;
        }
        if (event2.eventType == 1) {
            int alpha;
            boolean cancel = true;
            int cellWidth = event2.cell.getWidth();
            int cellHeight = event2.cell.getHeight();
            int x = event2.x - (cellWidth - ColumnActivityActions.boundsRate.width) / 2;
            int y = event2.y - (cellHeight - ColumnActivityActions.boundsRate.height) / 2;
            Graphic currentGraphic = event2.cell.getGraphic();
            if (x >= 0 && y >= 0 && x < ColumnActivityActions.boundsRate.width && y < ColumnActivityActions.boundsRate.height && (alpha = graphicRate.getImage().getImageData().getAlpha(x, y)) > 0) {
                try {
                    cancel = false;
                    int value = x < ColumnActivityActions.boundsRate.width / 2 ? 0 : 1;
                    int previousValue = PlatformTorrentUtils.getUserRating(torrent);
                    if (value != previousValue) {
                        PlatformRatingMessenger.setUserRating(torrent, value, true, 0L, new PlatformMessengerListener(){

                            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                                ColumnActivityActions.this.refresh(event2.cell);
                            }

                            public void messageSent(PlatformMessage message) {
                            }
                        });
                        this.refresh(event2.cell);
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
            if (cancel) {
                try {
                    int oldValue = PlatformTorrentUtils.getUserRating(torrent);
                    if (oldValue == -2 || oldValue == -1) {
                        return;
                    }
                    PlatformRatingMessenger.setUserRating(torrent, -1, true, 0L, new PlatformMessengerListener(){

                        public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                            ColumnActivityActions.this.refresh(event2.cell);
                        }

                        public void messageSent(PlatformMessage message) {
                        }
                    });
                    this.refresh(event2.cell);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    public void cellPaintForRate(GC gc, TableCellSWT cell) {
        UISWTGraphicImpl graphic;
        Object ds = cell.getDataSource();
        DownloadManager dm = DataSourceUtils.getDM(ds);
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        if (!PlatformTorrentUtils.isContent(torrent, true)) {
            return;
        }
        int rating = PlatformTorrentUtils.getUserRating(torrent);
        if (!cell.isShown()) {
            return;
        }
        switch (rating) {
            case -2: {
                graphic = graphicsWait[0];
                break;
            }
            case -1: {
                graphic = graphicRate;
                break;
            }
            case 0: {
                graphic = graphicRateDown;
                break;
            }
            case 1: {
                graphic = graphicRateUp;
                break;
            }
            default: {
                graphic = null;
            }
        }
        if (graphic != null) {
            Rectangle drawBounds = this.getDrawBounds(cell);
            gc.drawImage(graphic.getImage(), drawBounds.x + (drawBounds.width - ColumnActivityActions.boundsRate.width) / 2, drawBounds.y + (drawBounds.height - ColumnActivityActions.boundsRate.height) / 2);
        }
    }

    private Rectangle getDrawBounds(TableCellSWT cell) {
        Rectangle bounds = cell.getBounds();
        bounds.height -= 12;
        bounds.y += 6;
        bounds.x += 4;
        bounds.width -= 4;
        return bounds;
    }

    private String getHash(Object ds, boolean onlyOurs) {
        if (onlyOurs && !DataSourceUtils.isPlatformContent(ds)) {
            return null;
        }
        return DataSourceUtils.getHash(ds);
    }

    static {
        font = null;
    }
}

