/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.vuzeactivity;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnActivityNew
extends CoreTableColumn
implements TableCellSWTPaintListener,
TableCellAddedListener,
TableCellRefreshListener,
TableCellMouseListener {
    public static final String COLUMN_ID = "activityNew";
    private static int WIDTH = 38;
    private static Image imgNew;
    private Rectangle imgBounds;

    public ColumnActivityNew(String tableID) {
        super(COLUMN_ID, tableID);
        this.initializeAsGraphic(WIDTH);
        imgNew = ImageLoaderFactory.getInstance().getImage("image.activity.unread");
        this.imgBounds = imgNew.getBounds();
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        if (entry.getReadOn() <= 0L) {
            Rectangle cellBounds = cell.getBounds();
            gc.drawImage(imgNew, cellBounds.x + (cellBounds.width - this.imgBounds.width) / 2, cellBounds.y + (cellBounds.height - this.imgBounds.height) / 2);
        }
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    public void refresh(TableCell cell) {
        int sortVal;
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        boolean isRead = entry.getReadOn() > 0L;
        int n = sortVal = isRead ? 1 : 0;
        if (!cell.setSortValue(sortVal) && cell.isValid()) {
            return;
        }
        cell.invalidate();
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        VuzeActivitiesEntry entry;
        if (event2.eventType == 0 && event2.button == 1 && (entry = (VuzeActivitiesEntry)event2.cell.getDataSource()).canFlipRead()) {
            entry.setRead(!entry.isRead());
            event2.cell.invalidate();
        }
    }
}

