/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.vuzeactivity;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesEntryContentShare;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.util.GeneralUtils;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.util.StringCompareUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnActivityText
extends CoreTableColumn
implements TableCellSWTPaintListener,
TableCellRefreshListener,
TableCellMouseMoveListener,
TableCellToolTipListener {
    public static final String COLUMN_ID = "activityText";
    private Color colorLinkNormal;
    private Color colorLinkHover;
    private static Font font = null;

    public ColumnActivityText(String tableID) {
        super(COLUMN_ID, tableID);
        this.initializeAsGraphic(480);
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.colorLinkNormal = skinProperties.getColor("color.links.normal");
        this.colorLinkHover = skinProperties.getColor("color.links.hover");
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        GCStringPrinter sp = this.setupStringPrinter(gc, cell);
        if (sp.hasHitUrl()) {
            GCStringPrinter.URLInfo[] hitUrlInfo = sp.getHitUrlInfo();
            for (int i = 0; i < hitUrlInfo.length; ++i) {
                GCStringPrinter.URLInfo info = hitUrlInfo[i];
                info.urlUnderline = cell.getTableRow().isSelected();
                info.urlColor = info.urlUnderline ? null : this.colorLinkNormal;
            }
            int[] mouseOfs = cell.getMouseOffset();
            if (mouseOfs != null) {
                Rectangle realBounds = cell.getBounds();
                GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(mouseOfs[0] + realBounds.x, mouseOfs[1] + realBounds.y);
                if (hitUrl != null) {
                    hitUrl.urlColor = this.colorLinkHover;
                }
            }
        }
        sp.printString();
        gc.setFont(null);
    }

    private GCStringPrinter setupStringPrinter(GC gc, TableCellSWT cell) {
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        String text = entry.getText();
        Rectangle drawBounds = this.getDrawBounds(cell);
        if (!entry.isRead()) {
            if (font == null) {
                FontData[] fontData = gc.getFont().getFontData();
                fontData[0].setStyle(1);
                font = new Font(gc.getDevice(), fontData);
            }
            gc.setFont(font);
        }
        int style = drawBounds.height < 40 ? 0 : 64;
        GCStringPrinter sp = new GCStringPrinter(gc, text, drawBounds, true, true, style);
        sp.calculateMetrics();
        return sp;
    }

    public void refresh(TableCell cell) {
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        cell.setSortValue((Comparable)((Object)entry.getText()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String oldTooltip;
        Object o;
        String tooltip = null;
        boolean invalidateAndRefresh = false;
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)event2.cell.getDataSource();
        Rectangle bounds = ((TableCellSWT)event2.cell).getBounds();
        String text = entry.getText();
        GC gc = new GC((Drawable)Display.getDefault());
        GCStringPrinter sp = null;
        try {
            sp = this.setupStringPrinter(gc, (TableCellSWT)event2.cell);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        finally {
            gc.dispose();
        }
        if (sp != null) {
            int newCursor;
            GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(event2.x + bounds.x, event2.y + bounds.y);
            if (hitUrl != null) {
                if (event2.eventType == 0) {
                    if ("showsharemessage".equals(hitUrl.url)) {
                        String userMessage = ((VuzeActivitiesEntryContentShare)entry).getUserMessage();
                        Utils.openMessageBox(null, 32, "", userMessage);
                    } else if (!PlatformConfigMessenger.urlCanRPC(hitUrl.url)) {
                        Utils.launch(hitUrl.url);
                    } else {
                        UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
                        if (uif != null) {
                            String target = hitUrl.target == null ? "browse" : hitUrl.target;
                            uif.viewURL(hitUrl.url, target, 0, 0, false, false);
                            return;
                        }
                    }
                }
                newCursor = 21;
                if (PlatformConfigMessenger.urlCanRPC(hitUrl.url) || "showsharemessage".equals(hitUrl.url)) {
                    try {
                        tooltip = hitUrl.title == null ? null : URLDecoder.decode(hitUrl.title, "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {}
                } else {
                    tooltip = hitUrl.url;
                }
            } else {
                newCursor = 0;
            }
            int oldCursor = ((TableCellSWT)event2.cell).getCursorID();
            if (oldCursor != newCursor) {
                invalidateAndRefresh = true;
                ((TableCellSWT)event2.cell).setCursorID(newCursor);
            }
        }
        if ((o = event2.cell.getToolTip()) == null | o instanceof String && !StringCompareUtils.equals(oldTooltip = (String)o, tooltip)) {
            invalidateAndRefresh = true;
            event2.cell.setToolTip(tooltip);
        }
        if (invalidateAndRefresh) {
            event2.cell.invalidate();
            ((TableCellSWT)event2.cell).redraw();
        }
    }

    private Rectangle getDrawBounds(TableCellSWT cell) {
        Rectangle bounds = cell.getBounds();
        bounds.x += 4;
        bounds.width -= 4;
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellHover(TableCell cell) {
        if (cell.getToolTip() != null) {
            return;
        }
        if (!(cell instanceof TableCellSWT)) {
            return;
        }
        if (!Utils.isThisThreadSWT()) {
            System.err.println("you broke it");
            return;
        }
        GC gc = new GC((Drawable)Display.getDefault());
        try {
            GCStringPrinter sp = this.setupStringPrinter(gc, (TableCellSWT)cell);
            if (sp.isCutoff()) {
                cell.setToolTip(GeneralUtils.stripOutHyperlinks(sp.getText()));
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        finally {
            gc.dispose();
        }
    }

    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }
}

