/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.shells.main.DebugMenuHelper;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.views.skin.FriendsToolbar;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.ToolBarView;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.util.ConstantsV3;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.IMainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.IMenuConstants;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;

public class MainMenu
implements IMainMenu,
IMenuConstants {
    private static final boolean ALLOW_ACTIONBAR_HIDING = false;
    private static final boolean ALLOW_SIDEBAR_HIDING = true;
    final String PREFIX_V2 = "MainWindow.menu";
    final String PREFIX_V3 = "v3.MainWindow.menu";
    private Menu menuBar;
    private final SWTSkin skin;
    private AzureusCore core;

    public MainMenu(SWTSkin skin, Shell shell) {
        this.skin = skin;
        if (null == skin) {
            throw new NullPointerException("The parameter [SWTSkin skin] can not be null");
        }
        this.buildMenu(shell);
    }

    private void buildMenu(Shell parent) {
        if (this.core == null) {
            this.core = AzureusCoreFactory.getSingleton();
        }
        this.menuBar = new Menu((Decorations)parent, 2);
        parent.setMenuBar(this.menuBar);
        this.addFileMenu();
        this.addSimpleViewMenu();
        this.addCommunityMenu();
        this.addPublishMenu();
        this.addToolsMenu();
        if (COConfigurationManager.getBooleanParameter("show_torrents_menu")) {
            this.addTorrentMenu();
        }
        this.addWindowMenu();
        if (Constants.isCVSVersion()) {
            Menu menuDebug = org.gudy.azureus2.ui.swt.mainwindow.DebugMenuHelper.createDebugMenuItem(this.menuBar);
            DebugMenuHelper.createDebugMenuItem(menuDebug);
        }
        this.addHelpMenu();
        MenuFactory.updateEnabledStates(this.menuBar);
    }

    private void addPublishMenu() {
        try {
            MenuItem publishItem = MenuFactory.createPublishMenuItem(this.menuBar);
            Menu publishMenu = publishItem.getMenu();
            this.addPublishMenuItems(publishMenu);
        }
        catch (Exception e) {
            Debug.out("Error creating View Menu", e);
        }
    }

    private void addFileMenu() {
        MenuItem fileItem = MenuFactory.createFileMenuItem(this.menuBar);
        final Menu fileMenu = fileItem.getMenu();
        this.builFileMenu(fileMenu);
        fileMenu.addListener(22, new Listener(){
            private boolean isAZ3_ADV = MenuFactory.isAZ3_ADV;

            public void handleEvent(Event event2) {
                if (this.isAZ3_ADV != MenuFactory.isAZ3_ADV) {
                    MenuItem[] menuItems = fileMenu.getItems();
                    for (int i = 0; i < menuItems.length; ++i) {
                        menuItems[i].dispose();
                    }
                    MainMenu.this.builFileMenu(fileMenu);
                    this.isAZ3_ADV = MenuFactory.isAZ3_ADV;
                }
            }
        });
    }

    private void builFileMenu(Menu fileMenu) {
        MenuItem openMenuItem = MenuFactory.createOpenMenuItem(fileMenu);
        Menu openSubMenu = openMenuItem.getMenu();
        MenuFactory.addOpenTorrentMenuItem(openSubMenu);
        MenuFactory.addOpenTorrentForTrackingMenuItem(openSubMenu);
        MenuFactory.addOpenVuzeFileMenuItem(openSubMenu);
        if (MenuFactory.isAZ3_ADV) {
            Menu shareSubMenu = MenuFactory.createShareMenuItem(fileMenu).getMenu();
            MenuFactory.addShareFileMenuItem(shareSubMenu);
            MenuFactory.addShareFolderMenuItem(shareSubMenu);
            MenuFactory.addShareFolderContentMenuItem(shareSubMenu);
            MenuFactory.addShareFolderContentRecursiveMenuItem(shareSubMenu);
        }
        MenuFactory.addCreateMenuItem(fileMenu);
        MenuFactory.addSeparatorMenuItem(fileMenu);
        MenuFactory.addCloseWindowMenuItem(fileMenu);
        MenuFactory.addCloseDetailsMenuItem(fileMenu);
        MenuFactory.addCloseDownloadBarsToMenu(fileMenu);
        MenuFactory.addSeparatorMenuItem(fileMenu);
        MenuFactory.createTransfersMenuItem(fileMenu);
        if (!ConstantsV3.isOSX) {
            MenuFactory.addSeparatorMenuItem(fileMenu);
            MenuFactory.addRestartMenuItem(fileMenu);
            MenuFactory.addExitMenuItem(fileMenu);
        }
    }

    private void addSimpleViewMenu() {
        try {
            MenuItem viewItem = MenuFactory.createViewMenuItem(this.menuBar);
            final Menu viewMenu = viewItem.getMenu();
            MenuFactory.addMenuItem(viewMenu, 32, "v3.MainWindow.menu.view.sidebar", new Listener(){

                public void handleEvent(Event event2) {
                    SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                    if (sidebar != null) {
                        sidebar.flipSideBarVisibility();
                    }
                }
            });
            MenuFactory.addMenuItem(viewMenu, 32, "v3.MainWindow.menu.view.toolbartext", new Listener(){

                public void handleEvent(Event event2) {
                    ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
                    if (tb != null) {
                        tb.flipShowText();
                    }
                }
            });
            viewMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    ToolBarView tb;
                    MenuItem itemShowText;
                    SideBar sidebar;
                    MenuItem sidebarMenuItem = MenuFactory.findMenuItem(viewMenu, "v3.MainWindow.menu.view.sidebar");
                    if (sidebarMenuItem != null && (sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class)) != null) {
                        sidebarMenuItem.setSelection(sidebar.isVisible());
                    }
                    if ((itemShowText = MenuFactory.findMenuItem(viewMenu, "v3.MainWindow.menu.view.toolbartext")) != null && (tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class)) != null) {
                        itemShowText.setSelection(tb.getShowText());
                    }
                }

                public void menuHidden(MenuEvent e) {
                }
            });
        }
        catch (Exception e) {
            Debug.out("Error creating View Menu", e);
        }
    }

    private void addViewMenu() {
        try {
            MenuItem viewItem = MenuFactory.createViewMenuItem(this.menuBar);
            Menu viewMenu = viewItem.getMenu();
            this.addViewToolBarsMenu(viewMenu);
        }
        catch (Exception e) {
            Debug.out("Error creating View Menu", e);
        }
    }

    private void addViewToolBarsMenu(Menu parent) {
        try {
            MenuItem viewToolBarsItem = MenuFactory.createTopLevelMenuItem(parent, "v3.MainWindow.menu.view.toolbars");
            final Menu viewToolBarsMenu = viewToolBarsItem.getMenu();
            MenuFactory.addMenuItem(viewToolBarsMenu, 32, "v3.MainWindow.menu.view.sidebar", new Listener(){

                public void handleEvent(Event event2) {
                    SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                    if (sidebar != null) {
                        sidebar.flipSideBarVisibility();
                    }
                }
            });
            viewToolBarsMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    SWTSkinObject so;
                    MenuItem actionbarMenuItem;
                    SideBar sidebar;
                    MenuItem sidebarMenuItem = MenuFactory.findMenuItem(viewToolBarsMenu, "v3.MainWindow.menu.view.sidebar");
                    if (sidebarMenuItem != null && (sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class)) != null) {
                        sidebarMenuItem.setSelection(sidebar.isVisible());
                    }
                    if ((actionbarMenuItem = MenuFactory.findMenuItem(viewToolBarsMenu, "v3.MainWindow.menu.view.actionbar")) != null && MainMenu.this.skin != null && (so = MainMenu.this.skin.getSkinObject("tabbar")) != null) {
                        actionbarMenuItem.setSelection(so.isVisible());
                    }
                    if (null == MenuFactory.findMenuItem(viewToolBarsMenu, "v3.MainWindow.menu.view.pluginbar")) {
                        MainMenu.createViewMenuItem(MainMenu.this.skin, viewToolBarsMenu, "v3.MainWindow.menu.view.pluginbar", "pluginbar.visible", "pluginbar", true, 0);
                    }
                    if (null == MenuFactory.findMenuItem(viewToolBarsMenu, "v3.MainWindow.menu.view.buddies-viewer")) {
                        MainMenu.createViewMenuItem(MainMenu.this.skin, viewToolBarsMenu, "v3.MainWindow.menu.view.buddies-viewer", "Friends.visible", "buddies-viewer", true, -1);
                    }
                }

                public void menuHidden(MenuEvent e) {
                }
            });
        }
        catch (Exception e) {
            Debug.out("Error creating View Menu", e);
        }
    }

    private void addViewMenuItems(Menu viewMenu) {
        MenuFactory.addMenuItem(viewMenu, "v3.MainWindow.menu.browse", new Listener(){

            public void handleEvent(Event event2) {
                SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                sidebar.showItemByID("Browse");
            }
        });
        MenuFactory.addMenuItem(viewMenu, "v3.MainWindow.menu.library", new Listener(){

            public void handleEvent(Event event2) {
                SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                sidebar.showItemByID("Library");
            }
        });
        MenuFactory.addMenuItem(viewMenu, "v3.MainWindow.menu.publish", new Listener(){

            public void handleEvent(Event event2) {
                SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                sidebar.showItemByID("Publish");
            }
        });
    }

    private void addPublishMenuItems(Menu publishMenu) {
        MenuFactory.addMenuItem(publishMenu, "v3.MainWindow.menu.publish.new", new Listener(){

            public void handleEvent(Event event2) {
                String sURL = ConstantsV3.URL_PREFIX + "PublishNewContent.html" + "?" + ConstantsV3.URL_SUFFIX;
                SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                SideBarEntrySWT entry = SideBar.getSideBarInfo("Publish");
                if (entry.getIView() == null) {
                    entry = sidebar.createEntryFromSkinRef("Browse", "Publish", "publishtab.area", "Publish", null, sURL, true, -1);
                } else {
                    SWTSkinObject so;
                    UISWTViewEventListener eventListener = entry.getEventListener();
                    if (eventListener instanceof SideBar.UISWTViewEventListenerSkinObject && (so = ((SideBar.UISWTViewEventListenerSkinObject)eventListener).getSkinObject()) instanceof SWTSkinObjectBrowser) {
                        ((SWTSkinObjectBrowser)so).setURL(sURL);
                    }
                }
                sidebar.showItemByID("Publish");
            }
        });
        MenuFactory.addMenuItem(publishMenu, "v3.MainWindow.menu.publish.mine", new Listener(){

            public void handleEvent(Event event2) {
                String sURL = ConstantsV3.URL_PREFIX + "PublishedContent.html" + "?" + ConstantsV3.URL_SUFFIX;
                SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                SideBarEntrySWT entry = SideBar.getSideBarInfo("Publish");
                if (entry.getIView() == null) {
                    entry = sidebar.createEntryFromSkinRef("Browse", "Publish", "publishtab.area", "Publish", null, sURL, true, -1);
                } else {
                    SWTSkinObject so;
                    UISWTViewEventListener eventListener = entry.getEventListener();
                    if (eventListener instanceof SideBar.UISWTViewEventListenerSkinObject && (so = ((SideBar.UISWTViewEventListenerSkinObject)eventListener).getSkinObject()) instanceof SWTSkinObjectBrowser) {
                        ((SWTSkinObjectBrowser)so).setURL(sURL);
                    }
                }
                sidebar.showItemByID("Publish");
            }
        });
        MenuFactory.addSeparatorMenuItem(publishMenu);
        MenuFactory.addMenuItem(publishMenu, "v3.MainWindow.menu.publish.about", new Listener(){

            public void handleEvent(Event event2) {
                String sURL = ConstantsV3.URL_PREFIX + "Publish.html";
                Utils.launch(sURL);
            }
        });
    }

    private void addToolsMenu() {
        MenuItem toolsItem = MenuFactory.createToolsMenuItem(this.menuBar);
        Menu toolsMenu = toolsItem.getMenu();
        MenuFactory.addMyTrackerMenuItem(toolsMenu);
        MenuFactory.addMySharesMenuItem(toolsMenu);
        MenuFactory.addConsoleMenuItem(toolsMenu);
        MenuFactory.addStatisticsMenuItem(toolsMenu);
        MenuFactory.addTransferBarToMenu(toolsMenu);
        MenuFactory.addAllPeersMenuItem(toolsMenu);
        MenuFactory.addBlockedIPsMenuItem(toolsMenu);
        MenuFactory.addSeparatorMenuItem(toolsMenu);
        MenuFactory.createPluginsMenuItem(toolsMenu, true);
        if (!ConstantsV3.isOSX) {
            MenuFactory.addOptionsMenuItem(toolsMenu);
        }
    }

    private void addHelpMenu() {
        MenuItem helpItem = MenuFactory.createHelpMenuItem(this.menuBar);
        Menu helpMenu = helpItem.getMenu();
        if (!ConstantsV3.isOSX) {
            MenuFactory.addAboutMenuItem(helpMenu);
            MenuFactory.addSeparatorMenuItem(helpMenu);
        }
        MenuFactory.addMenuItem(helpMenu, "v3.MainWindow.menu.getting_started", new Listener(){

            public void handleEvent(Event event2) {
                SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                sidebar.showItemByID("Welcome");
            }
        });
        MenuFactory.addHelpSupportMenuItem(helpMenu, ConstantsV3.URL_SUPPORT);
        MenuFactory.addReleaseNotesMenuItem(helpMenu);
        if (!SystemProperties.isJavaWebStartInstance()) {
            MenuFactory.addSeparatorMenuItem(helpMenu);
            MenuFactory.addCheckUpdateMenuItem(helpMenu);
        }
        MenuFactory.addSeparatorMenuItem(helpMenu);
        MenuFactory.addConfigWizardMenuItem(helpMenu);
        MenuFactory.addNatTestMenuItem(helpMenu);
        MenuFactory.addSpeedTestMenuItem(helpMenu);
        MenuFactory.addSeparatorMenuItem(helpMenu);
        MenuFactory.addDebugHelpMenuItem(helpMenu);
    }

    private void addWindowMenu() {
        MenuItem menu_window = MenuFactory.createWindowMenuItem(this.menuBar);
        Menu windowMenu = menu_window.getMenu();
        MenuFactory.addMinimizeWindowMenuItem(windowMenu);
        MenuFactory.addZoomWindowMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.addBringAllToFrontMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.appendWindowMenuItems(windowMenu);
    }

    private void addTorrentMenu() {
        MenuFactory.setEnablementKeys((Widget)MenuFactory.createTorrentMenuItem(this.menuBar), 5);
    }

    public Menu getMenu(String id) {
        if ("menu.bar".equals(id)) {
            return this.menuBar;
        }
        return MenuFactory.findMenu(this.menuBar, id);
    }

    private void addCommunityMenu() {
        MenuItem item = MenuFactory.createTopLevelMenuItem(this.menuBar, "MainWindow.menu.community");
        Menu communityMenu = item.getMenu();
        MenuFactory.addMenuItem(communityMenu, "MainWindow.menu.community.forums", new Listener(){

            public void handleEvent(Event e) {
                Utils.launch("http://forum.vuze.com/");
            }
        });
        MenuFactory.addMenuItem(communityMenu, "MainWindow.menu.community.wiki", new Listener(){

            public void handleEvent(Event e) {
                Utils.launch("http://wiki.vuze.com/");
            }
        });
        MenuFactory.addMenuItem(communityMenu, "MainWindow.menu.community.blog", new Listener(){

            public void handleEvent(Event e) {
                Utils.launch("http://blog.vuze.com/");
            }
        });
        MenuFactory.addMenuItem(communityMenu, "MainWindow.menu.help.faq", new Listener(){

            public void handleEvent(Event e) {
                Utils.launch("http://faq.vuze.com/");
            }
        });
        MenuFactory.addSeparatorMenuItem(communityMenu);
        MenuFactory.addMenuItem(communityMenu, "MainWindow.menu.community.add_friends", new Listener(){

            public void handleEvent(Event e) {
                FriendsToolbar friendsToolbar = (FriendsToolbar)SkinViewManager.getByClass(FriendsToolbar.class);
                if (friendsToolbar != null) {
                    friendsToolbar.addBuddy();
                }
            }
        });
    }

    public Menu getMenuBar() {
        return this.menuBar;
    }

    public static MenuItem createViewMenuItem(final SWTSkin skin, Menu viewMenu, String textID, final String configID, final String viewID, final boolean fast, int menuIndex) {
        if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID)) {
            COConfigurationManager.setBooleanDefault(configID, true);
        }
        MenuItem item = MenuFactory.addMenuItem(viewMenu, 32, menuIndex, textID, new Listener(){

            public void handleEvent(Event event2) {
                SWTSkinObject skinObject = skin.getSkinObject(viewID);
                if (skinObject != null) {
                    boolean newVisibility = !skinObject.isVisible();
                    SWTSkinUtils.setVisibility(skin, configID, viewID, newVisibility, true, fast);
                }
            }
        });
        SWTSkinUtils.setVisibility(skin, configID, viewID, COConfigurationManager.getBooleanParameter(configID), false, true);
        final MenuItem itemViewPluginBar = item;
        final ParameterListener listener = new ParameterListener(){

            public void parameterChanged(String parameterName) {
                itemViewPluginBar.setSelection(COConfigurationManager.getBooleanParameter(parameterName));
            }
        };
        COConfigurationManager.addAndFireParameterListener(configID, listener);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                COConfigurationManager.removeParameterListener(configID, listener);
            }
        });
        return item;
    }

    public static void setVisibility(SWTSkin skin, String configID, String viewID, boolean visible) {
        SWTSkinUtils.setVisibility(skin, configID, viewID, visible, true, false);
    }

    public static void setVisibility(SWTSkin skin, String configID, String viewID, boolean visible, boolean save) {
        SWTSkinUtils.setVisibility(skin, configID, viewID, visible, save, false);
    }
}

