/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import com.aelitis.azureus.ui.UIStatusTextClickListener;
import com.aelitis.azureus.ui.common.updater.UIUpdater;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.shells.BrowserWindow;
import com.aelitis.azureus.ui.swt.shells.main.MainMenu;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.ToolBarView;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.util.ConstantsV3;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarEntry;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.IMainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.IMainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;
import org.gudy.azureus2.ui.swt.minibar.AllTransfersBar;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTPluginView;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.ConfigShell;
import org.gudy.azureus2.ui.swt.views.DetailedListView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.ManagerView;
import org.gudy.azureus2.ui.swt.views.MySharesView;
import org.gudy.azureus2.ui.swt.views.MyTrackerView;
import org.gudy.azureus2.ui.swt.views.PeerSuperView;
import org.gudy.azureus2.ui.swt.views.TorrentOptionsView;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;

public class UIFunctionsImpl
implements UIFunctionsSWT {
    private static final LogIDs LOGID = LogIDs.GUI;
    private final MainWindow mainWindow;
    private final Map mapPluginViews = new HashMap();
    private final AEMonitor pluginViews_mon = new AEMonitor("v3.uif.pluginViews");
    private SWTSkin skin = null;

    public UIFunctionsImpl(MainWindow window) {
        this.mainWindow = window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginView(PluginView view) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                this.pluginViews_mon.enter();
                try {
                    this.mapPluginViews.put(view, null);
                }
                finally {
                    this.pluginViews_mon.exit();
                }
                return;
            }
            uiFunctions.addPluginView(view);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "addPluginView", e));
        }
    }

    public void addPluginView(final String viewID, final UISWTViewEventListener l) {
        try {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    PluginsMenuHelper.getInstance().addPluginView(viewID, l);
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "addPluginView", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginView(UISWTPluginView view) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                this.pluginViews_mon.enter();
                try {
                    this.mapPluginViews.put(view, null);
                }
                finally {
                    this.pluginViews_mon.exit();
                }
                return;
            }
            uiFunctions.addPluginView(view);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "addPluginView", e));
        }
    }

    public void bringToFront() {
        this.bringToFront(true);
    }

    public void bringToFront(final boolean tryTricks) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    UIFunctionsImpl.this.mainWindow.setVisible(true, tryTricks);
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "bringToFront", e));
                }
            }
        });
    }

    public void closeDownloadBars() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                return;
            }
            uiFunctions.closeDownloadBars();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closeDownloadBars", e));
        }
    }

    public void closePluginView(IView view) {
        try {
            SkinView sideBarView;
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions != null) {
                uiFunctions.closePluginView(view);
            }
            if ((sideBarView = SkinViewManager.getByClass(SideBar.class)) instanceof SideBar) {
                String id;
                SideBar sideBar = (SideBar)sideBarView;
                if (view instanceof UISWTViewImpl) {
                    id = ((UISWTViewImpl)view).getViewID();
                } else {
                    id = view.getClass().getName();
                    int i = id.lastIndexOf(46);
                    if (i > 0) {
                        id = id.substring(i + 1);
                    }
                }
                sideBar.closeSideBar(id);
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closePluginView", e));
        }
    }

    public void closePluginViews(String sViewID) {
        try {
            SkinView sideBarView;
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions != null) {
                uiFunctions.closePluginViews(sViewID);
            }
            if ((sideBarView = SkinViewManager.getByClass(SideBar.class)) instanceof SideBar) {
                SideBar sideBar = (SideBar)sideBarView;
                sideBar.closeSideBar(sViewID);
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closePluginViews", e));
        }
    }

    public boolean dispose(boolean for_restart, boolean close_already_in_progress) {
        try {
            return this.mainWindow.dispose(for_restart, close_already_in_progress);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Disposing MainWindow", e));
            return false;
        }
    }

    public Shell getMainShell() {
        return this.mainWindow.shell;
    }

    public Menu getMenu(int id) {
        return null;
    }

    public UISWTView[] getPluginViews() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return new UISWTView[0];
            }
            return uiFunctions.getPluginViews();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "getPluginViews", e));
            return new UISWTView[0];
        }
    }

    public UISWTInstanceImpl getSWTPluginInstanceImpl() {
        try {
            return (UISWTInstanceImpl)this.mainWindow.getUISWTInstanceImpl();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "getSWTPluginInstanceImpl", e));
            return null;
        }
    }

    public void openPluginView(AbstractIView view, String name) {
        try {
            SideBar sideBar;
            SkinView sideBarView = SkinViewManager.getByClass(SideBar.class);
            if (sideBarView instanceof SideBar && (sideBar = (SideBar)sideBarView).createTreeItemFromIView(null, view, name, null, true, true) != null) {
                return;
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "openPluginView", e));
        }
    }

    public void openPluginView(PluginView view) {
        this.openPluginView(view, view.getPluginViewName());
    }

    public void openPluginView(String sParentID, String sViewID, UISWTViewEventListener l, Object dataSource, boolean bSetFocus) {
        try {
            SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
            if (sideBar != null) {
                String sidebarParentID = null;
                if ("MyTorrents".equals(sParentID)) {
                    sidebarParentID = "Library";
                } else if (!"Main".equals(sParentID)) {
                    System.err.println("Can't find parent " + sParentID + " for " + sViewID);
                }
                sideBar.createTreeItemFromEventListener(sidebarParentID, null, l, sViewID, true, dataSource);
                if (bSetFocus) {
                    sideBar.showItemByID(sViewID);
                }
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "openPluginView", e));
        }
    }

    public void openPluginView(UISWTPluginView view) {
        this.openPluginView(view, view.getPluginViewName());
    }

    public void refreshIconBar() {
        try {
            ToolBarView tb;
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions != null) {
                uiFunctions.refreshIconBar();
            }
            if ((tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class)) != null) {
                tb.refreshCoreToolBarItems();
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshIconBar", e));
        }
    }

    public void refreshLanguage() {
        try {
            this.mainWindow.setSelectedLanguageItem();
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                return;
            }
            uiFunctions.refreshLanguage();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshLanguage", e));
        }
    }

    public void removeManagerView(DownloadManager dm) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                return;
            }
            uiFunctions.removeManagerView(dm);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "removeManagerView", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginView(String viewID) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                this.pluginViews_mon.enter();
                try {
                    this.mapPluginViews.remove(viewID);
                }
                finally {
                    this.pluginViews_mon.exit();
                }
                return;
            }
            uiFunctions.removePluginView(viewID);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "removePluginView", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginView(UISWTPluginView view) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                this.pluginViews_mon.enter();
                try {
                    this.mapPluginViews.remove(view);
                }
                finally {
                    this.pluginViews_mon.exit();
                }
                return;
            }
            uiFunctions.removePluginView(view);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "removePluginView", e));
        }
    }

    public void setStatusText(String string) {
    }

    public void setStatusText(int statustype, String string, UIStatusTextClickListener l) {
    }

    public MainStatusBar getMainStatusBar() {
        return this.mainWindow.getMainStatusBar();
    }

    public boolean showConfig(String string) {
        try {
            ConfigShell.getInstance().open();
            return true;
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "showConfig", e));
            return false;
        }
    }

    public void openView(int viewID, Object data) {
        UIFunctionsSWT uiFunctions;
        if (this.mainWindow.isOnAdvancedView() && (uiFunctions = this.mainWindow.getOldUIFunctions(false)) != null) {
            uiFunctions.openView(viewID, data);
            return;
        }
        switch (viewID) {
            case 0: {
                this.mainWindow.openView("Tools", LoggerView.class, null, data, true);
                break;
            }
            case 10: {
                this.mainWindow.openView("Tools", PeerSuperView.class, null, data, true);
                break;
            }
            case 4: {
                ConfigShell.getInstance().open();
                break;
            }
            case 5: {
                DownloadManager dm;
                TOTorrent torrent;
                String id = "DMDetails_";
                if (data instanceof DownloadManager && (torrent = (dm = (DownloadManager)data).getTorrent()) != null) {
                    try {
                        id = id + torrent.getHashWrapper().toBase32String();
                    }
                    catch (TOTorrentException e) {
                        e.printStackTrace();
                    }
                }
                this.mainWindow.openView("Library", ManagerView.class, id, data, true);
                break;
            }
            case 6: {
                this.mainWindow.openView("Library", TorrentOptionsView.class, null, data, true);
                break;
            }
            case 7: {
                this.mainWindow.openView("Library", MySharesView.class, null, data, true);
                break;
            }
            case 8: {
                SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                if (sideBar == null) break;
                sideBar.showItemByID("Library");
                break;
            }
            case 9: {
                this.mainWindow.openView("Tools", MyTrackerView.class, null, data, true);
                break;
            }
            case 1: {
                this.mainWindow.openView("Tools", StatsView.class, null, data, true);
                break;
            }
            case 11: {
                this.mainWindow.openView("Tools", DetailedListView.class, null, data, true);
                break;
            }
        }
    }

    public UISWTInstance getUISWTInstance() {
        return this.mainWindow.getUISWTInstanceImpl();
    }

    public boolean viewURL(final String url, final String target, final int w, final int h, final boolean allowResize, final boolean isModal) {
        this.mainWindow.shell.getDisplay().syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                String realURL = ConstantsV3.urlRelativeToPlatform(url);
                if (target == null) {
                    if (PlatformConfigMessenger.urlCanRPC(realURL)) {
                        realURL = ConstantsV3.appendURLSuffix(realURL);
                    }
                    BrowserWindow window = new BrowserWindow(((UIFunctionsImpl)UIFunctionsImpl.this).mainWindow.shell, realURL, w, h, allowResize, isModal);
                    window.waitUntilClosed();
                } else {
                    UIFunctionsImpl.this.mainWindow.showURL(realURL, target);
                }
            }
        });
        return true;
    }

    public boolean viewURL(final String url, final String target, final double w, final double h, final boolean allowResize, final boolean isModal) {
        this.mainWindow.shell.getDisplay().syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                String realURL = ConstantsV3.urlRelativeToPlatform(url);
                if (target == null) {
                    if (PlatformConfigMessenger.urlCanRPC(realURL)) {
                        realURL = ConstantsV3.appendURLSuffix(realURL);
                    }
                    BrowserWindow window = new BrowserWindow(((UIFunctionsImpl)UIFunctionsImpl.this).mainWindow.shell, realURL, w, h, allowResize, isModal);
                    window.waitUntilClosed();
                } else {
                    UIFunctionsImpl.this.mainWindow.showURL(realURL, target);
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oldMainWindowInitialized(org.gudy.azureus2.ui.swt.mainwindow.MainWindow oldMainWindow) {
        UIFunctionsSWT uiFunctions = oldMainWindow.getUIFunctions();
        if (uiFunctions == null) {
            return;
        }
        this.pluginViews_mon.enter();
        try {
            for (Object key : this.mapPluginViews.keySet()) {
                if (key instanceof PluginView) {
                    uiFunctions.addPluginView((PluginView)key);
                    continue;
                }
                if (key instanceof UISWTPluginView) {
                    uiFunctions.addPluginView((UISWTPluginView)key);
                    continue;
                }
                if (!(key instanceof String)) continue;
                UISWTViewEventListener value = (UISWTViewEventListener)this.mapPluginViews.get(key);
                uiFunctions.addPluginView((String)key, value);
            }
            this.mapPluginViews.clear();
        }
        finally {
            this.pluginViews_mon.exit();
        }
    }

    public int promptUser(String title, String text, String[] buttons, int defaultOption, String rememberID, String rememberText, boolean rememberByDefault, int autoCloseInMS) {
        return MessageBoxShell.open(this.getMainShell(), title, text, buttons, defaultOption, rememberID, rememberText, rememberByDefault, autoCloseInMS);
    }

    public UIFunctionsUserPrompter getUserPrompter(String title, String text, String[] buttons, int defaultOption) {
        MessageBoxShell mb = new MessageBoxShell(this.getMainShell(), title, text, buttons, defaultOption);
        return mb;
    }

    public boolean isGlobalTransferBarShown() {
        return AllTransfersBar.getManager().isOpen(AzureusCoreFactory.getSingleton().getGlobalManager());
    }

    public void showGlobalTransferBar() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                AllTransfersBar.open(AzureusCoreFactory.getSingleton().getGlobalManager(), UIFunctionsImpl.this.getMainShell());
            }
        });
    }

    public void closeGlobalTransferBar() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                AllTransfersBar.close(AzureusCoreFactory.getSingleton().getGlobalManager());
            }
        });
    }

    public void refreshTorrentMenu() {
        try {
            if (this.mainWindow.isOnAdvancedView()) {
                UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
                if (uiFunctions != null) {
                    uiFunctions.refreshTorrentMenu();
                }
                return;
            }
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    MenuItem torrentItem = MenuFactory.findMenuItem(UIFunctionsImpl.this.mainWindow.getMainMenu().getMenu("menu.bar"), "MainWindow.menu.torrent");
                    if (null != torrentItem) {
                        DownloadManager[] dms;
                        DownloadManager[] dm_final = dms = SelectedContentManager.getDMSFromSelectedContent();
                        Object tv_final = null;
                        boolean detailed_view_final = false;
                        if (null == dm_final) {
                            torrentItem.setEnabled(false);
                        } else {
                            torrentItem.setData("downloads", (Object)dm_final);
                            torrentItem.setData("TableView", tv_final);
                            torrentItem.setData("is_detailed_view", (Object)false);
                            torrentItem.setEnabled(true);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshTorrentMenu", e));
        }
    }

    public IMainMenu createMainMenu(Shell shell) {
        return new MainMenu(this.getSkin(), shell);
    }

    public SWTSkin getSkin() {
        return this.skin;
    }

    public void setSkin(SWTSkin skin) {
        this.skin = skin;
    }

    public IMainWindow getMainWindow() {
        return this.mainWindow;
    }

    public UIUpdater getUIUpdater() {
        return UIUpdaterSWT.getInstance();
    }

    public void closeAllDetails() {
        UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
        if (uiFunctions != null) {
            uiFunctions.closeAllDetails();
            return;
        }
        SkinView sideBarView = SkinViewManager.getByClass(SideBar.class);
        if (sideBarView instanceof SideBar) {
            SideBar sideBar = (SideBar)sideBarView;
            SideBarEntry[] sideBarEntries = sideBar.getSideBarEntries();
            for (int i = 0; i < sideBarEntries.length; ++i) {
                SideBarEntry entry = sideBarEntries[i];
                String id = entry.getId();
                if (id == null || !id.startsWith("DMDetails_")) continue;
                sideBar.closeSideBar(id);
            }
        }
    }

    public boolean hasDetailViews() {
        UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
        if (uiFunctions != null) {
            return uiFunctions.hasDetailViews();
        }
        SkinView sideBarView = SkinViewManager.getByClass(SideBar.class);
        if (sideBarView instanceof SideBar) {
            SideBar sideBar = (SideBar)sideBarView;
            SideBarEntry[] sideBarEntries = sideBar.getSideBarEntries();
            for (int i = 0; i < sideBarEntries.length; ++i) {
                SideBarEntry entry = sideBarEntries[i];
                String id = entry.getId();
                if (id == null || !id.startsWith("DMDetails_")) continue;
                return true;
            }
        }
        return false;
    }
}

