/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import java.util.ArrayList;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectSlider
extends SWTSkinObjectBasic
implements PaintListener,
MouseListener,
MouseMoveListener {
    private Image imageFG;
    private Object imageFGLeft;
    private Object imageFGRight;
    private Canvas canvas;
    private Image imageThumbRight;
    private Image imageThumb;
    private Image imageThumbLeft;
    private Image imageBGRight;
    private Image imageBG;
    private Image imageBGLeft;
    private double percent;
    private Rectangle imageFGbounds;
    private Rectangle imageBGbounds;
    private Rectangle imageThumbBounds;
    private Point maxSize = new Point(0, 0);
    private boolean mouseDown;
    private boolean mouseMoveAdjusts = true;
    private ArrayList listeners = new ArrayList();
    private double draggingPercent;
    private boolean disabled;

    public SWTSkinObjectSlider(SWTSkin skin, SWTSkinProperties skinProperties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parent) {
        super(skin, skinProperties, sID, sConfigID, "slider", parent);
        String sSuffix = ".complete";
        ImageLoader imageLoader = skin.getImageLoader(this.properties);
        Image[] images = imageLoader.getImages(sConfigID + sSuffix);
        if (images.length == 1 && ImageLoader.isRealImage(images[0])) {
            this.imageFG = images[0];
            this.imageFGLeft = imageLoader.getImage(sConfigID + sSuffix + "-left");
            this.imageFGRight = imageLoader.getImage(sConfigID + sSuffix + "-right");
        } else if (images.length == 3 && ImageLoader.isRealImage(images[2])) {
            this.imageFGLeft = images[0];
            this.imageFG = images[1];
            this.imageFGRight = images[2];
        }
        if (this.imageFG != null) {
            this.imageFGbounds = this.imageFG.getBounds();
        }
        sSuffix = ".incomplete";
        images = imageLoader.getImages(sConfigID + sSuffix);
        if (images.length == 1 && ImageLoader.isRealImage(images[0])) {
            this.imageBG = images[0];
            this.imageBGLeft = imageLoader.getImage(sConfigID + sSuffix + "-left");
            this.imageBGRight = imageLoader.getImage(sConfigID + sSuffix + "-right");
        } else if (images.length == 3 && ImageLoader.isRealImage(images[2])) {
            this.imageBGLeft = images[0];
            this.imageBG = images[1];
            this.imageBGRight = images[2];
        }
        if (this.imageBG != null) {
            this.imageBGbounds = this.imageBG.getBounds();
        }
        sSuffix = ".thumb";
        images = imageLoader.getImages(sConfigID + sSuffix);
        if (images.length == 1) {
            this.imageThumb = images[0];
            this.imageThumbLeft = imageLoader.getImage(sConfigID + sSuffix + "-left");
            this.imageThumbRight = imageLoader.getImage(sConfigID + sSuffix + "-right");
        } else if (images.length == 3 && ImageLoader.isRealImage(images[2])) {
            this.imageThumbLeft = images[0];
            this.imageThumb = images[1];
            this.imageThumbRight = images[2];
        }
        if (this.imageThumb != null) {
            this.imageThumbBounds = this.imageThumb.getBounds();
        }
        this.maxSize = this.buildMaxSize(new Rectangle[]{this.imageThumbBounds, this.imageBGbounds, this.imageFGbounds});
        if (skinProperties.getStringValue(sConfigID + ".width", "").equalsIgnoreCase("auto")) {
            this.maxSize.x = 0;
        }
        int style = 0;
        if (skinProperties.getIntValue(sConfigID + ".border", 0) == 1) {
            style |= 0x800;
        }
        Object createOn = parent == null ? skin.getShell() : (Composite)parent.getControl();
        this.canvas = new Canvas((Composite)createOn, style);
        this.canvas.setLayoutData((Object)new FormData(this.maxSize.x == 0 ? -1 : this.maxSize.x, this.maxSize.y));
        this.canvas.setSize(-1, this.maxSize.y);
        this.setControl((Control)this.canvas);
        this.setAlwaysHookPaintListener(true);
        this.canvas.addMouseListener((MouseListener)this);
        this.canvas.addMouseMoveListener((MouseMoveListener)this);
    }

    private Point buildMaxSize(Rectangle[] bounds) {
        Point maxSize = new Point(0, 0);
        for (int i = 0; i < bounds.length; ++i) {
            if (bounds[i] == null) continue;
            if (bounds[i].width > maxSize.x) {
                maxSize.x = bounds[i].width;
            }
            if (bounds[i].height <= maxSize.y) continue;
            maxSize.y = bounds[i].height;
        }
        return maxSize;
    }

    public void paintControl(GC gc) {
        int fullWidth;
        super.paintControl(gc);
        int n = fullWidth = this.maxSize.x == 0 || this.imageFGbounds == null ? this.canvas.getClientArea().width : this.imageFGbounds.width;
        if (this.percent > 0.0 && this.imageFG != null) {
            int xDrawTo = (int)((double)fullWidth * this.percent);
            int xDrawToSrc = xDrawTo > this.imageFGbounds.width ? this.imageFGbounds.width : xDrawTo;
            int y = (this.maxSize.y - this.imageFGbounds.height) / 2;
            gc.drawImage(this.imageFG, 0, 0, xDrawToSrc, this.imageFGbounds.height, 0, y, xDrawTo, this.imageFGbounds.height);
        }
        if (this.percent < 100.0 && this.imageBG != null) {
            int xDrawFrom = (int)((double)this.imageBGbounds.width * this.percent);
            int xDrawWidth = this.imageBGbounds.width - xDrawFrom;
            gc.drawImage(this.imageBG, xDrawFrom, 0, xDrawWidth, this.imageFGbounds.height, xDrawFrom, 0, xDrawWidth, this.imageFGbounds.height);
        }
        int drawWidth = fullWidth - this.imageThumbBounds.width;
        int xThumbPos = (int)((this.mouseDown && !this.mouseMoveAdjusts ? this.draggingPercent : this.percent) * (double)drawWidth);
        gc.drawImage(this.imageThumb, xThumbPos, 0);
    }

    public double getPercent() {
        return this.percent;
    }

    public void setPercent(double percent) {
        this.setPercent(percent, false);
    }

    private boolean areDoublesEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-6;
    }

    private void setPercent(double newPercent, boolean triggerListeners) {
        if (this.areDoublesEqual(this.percent, newPercent)) {
            return;
        }
        if (this.areDoublesEqual(this.percent, newPercent = this.validatePercent(newPercent, triggerListeners))) {
            return;
        }
        this.percent = newPercent;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SWTSkinObjectSlider.this.canvas != null && !SWTSkinObjectSlider.this.canvas.isDisposed()) {
                    SWTSkinObjectSlider.this.canvas.redraw();
                    SWTSkinObjectSlider.this.canvas.update();
                }
            }
        });
        if (triggerListeners) {
            Object[] listenersArray = this.listeners.toArray();
            for (int i = 0; i < listenersArray.length; ++i) {
                SWTSkinListenerSliderSelection l = (SWTSkinListenerSliderSelection)listenersArray[i];
                l.selectionChanged(this.percent);
            }
        }
    }

    private double validatePercent(double percent, boolean triggerListeners) {
        if (triggerListeners) {
            Object[] listenersArray = this.listeners.toArray();
            for (int i = 0; i < listenersArray.length; ++i) {
                SWTSkinListenerSliderSelection l = (SWTSkinListenerSliderSelection)listenersArray[i];
                Double changedPercent = l.selectionChanging(this.percent, percent);
                if (changedPercent == null) continue;
                return changedPercent.floatValue();
            }
        }
        if (percent < 0.0) {
            return 0.0;
        }
        if (percent > 1.0) {
            return 1.0;
        }
        return percent;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.disabled) {
            return;
        }
        this.mouseDown = true;
        int offset = this.imageThumbBounds.width / 2;
        int sizeX = this.maxSize.x;
        if (this.maxSize.x == 0) {
            sizeX = this.canvas.getClientArea().width;
        }
        float newPercent = (float)(e.x - offset) / (float)(sizeX - this.imageThumbBounds.width);
        if (this.mouseMoveAdjusts) {
            this.setPercent(newPercent, true);
        } else {
            this.draggingPercent = this.validatePercent(newPercent, true);
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (SWTSkinObjectSlider.this.canvas != null && !SWTSkinObjectSlider.this.canvas.isDisposed()) {
                        SWTSkinObjectSlider.this.canvas.redraw();
                        SWTSkinObjectSlider.this.canvas.update();
                    }
                }
            });
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.disabled) {
            return;
        }
        this.mouseDown = false;
        if (!this.mouseMoveAdjusts) {
            int offset = this.imageThumbBounds.width / 2;
            int sizeX = this.maxSize.x;
            if (this.maxSize.x == 0) {
                sizeX = this.canvas.getClientArea().width;
            }
            float newPercent = (float)(e.x - offset) / (float)(sizeX - this.imageThumbBounds.width);
            this.setPercent(newPercent, true);
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.disabled) {
            return;
        }
        if (this.mouseDown) {
            int offset = this.imageThumbBounds.width / 2;
            int sizeX = this.maxSize.x;
            if (this.maxSize.x == 0) {
                sizeX = this.canvas.getClientArea().width;
            }
            float newPercent = (float)(e.x - offset) / (float)(sizeX - this.imageThumbBounds.width);
            if (this.mouseMoveAdjusts) {
                this.setPercent(newPercent, true);
            } else {
                this.draggingPercent = this.validatePercent(newPercent, true);
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (SWTSkinObjectSlider.this.canvas != null && !SWTSkinObjectSlider.this.canvas.isDisposed()) {
                            SWTSkinObjectSlider.this.canvas.redraw();
                            SWTSkinObjectSlider.this.canvas.update();
                        }
                    }
                });
            }
        }
    }

    public void addListener(SWTSkinListenerSliderSelection listener) {
        this.listeners.add(listener);
    }

    public boolean getMouseMoveAdjusts() {
        return this.mouseMoveAdjusts;
    }

    public void setMouseMoveAdjusts(boolean mouseMoveAdjusts) {
        this.mouseMoveAdjusts = mouseMoveAdjusts;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        if (disabled == this.disabled) {
            return;
        }
        this.disabled = disabled;
        if (disabled) {
            this.mouseDown = false;
        }
    }

    public static class SWTSkinListenerSliderSelection {
        public Double selectionChanging(double oldPercent, double newPercent) {
            return null;
        }

        public void selectionChanged(double percent) {
        }
    }
}

