/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.ui.skin.SkinProperties;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.ui.swt.Utils;

public class ImageLoader {
    private static final boolean DEBUG_UNLOAD = false;
    private final String[] sSuffixChecks = new String[]{"-over", "-down", "-disabled", "-selected"};
    private Display display;
    public static Image noImage;
    private final Map mapImages;
    private final ArrayList notFound;
    private SkinProperties skinProperties;
    private final ClassLoader classLoader;
    private int disabledOpacity;

    public ImageLoader(ClassLoader classLoader, Display display, SkinProperties skinProperties) {
        this.classLoader = classLoader;
        this.mapImages = new HashMap();
        this.notFound = new ArrayList();
        this.display = display;
        this.skinProperties = skinProperties;
        this.disabledOpacity = skinProperties.getIntValue("imageloader.disabled-opacity", -1);
    }

    private Image loadImage(Display display, String key) {
        return this.loadImage(display, this.skinProperties.getStringValue(key), key);
    }

    private Image[] findResources(String sKey) {
        int i;
        if (Collections.binarySearch(this.notFound, sKey) >= 0) {
            return null;
        }
        for (i = 0; i < this.sSuffixChecks.length; ++i) {
            String sSuffix = this.sSuffixChecks[i];
            if (!sKey.endsWith(sSuffix)) continue;
            String sParentName = sKey.substring(0, sKey.length() - sSuffix.length());
            String[] sParentFiles = this.skinProperties.getStringArray(sParentName);
            if (sParentFiles != null) {
                Image image;
                int j;
                boolean bFoundOne = false;
                Image[] images = this.parseValuesString(sKey, sParentFiles, sSuffix);
                if (images == null) continue;
                for (j = 0; j < images.length; ++j) {
                    image = images[j];
                    if (!ImageLoader.isRealImage(image)) continue;
                    bFoundOne = true;
                }
                if (!bFoundOne) {
                    for (j = 0; j < images.length; ++j) {
                        image = images[j];
                        if (!ImageLoader.isRealImage(image)) continue;
                        image.dispose();
                    }
                    continue;
                }
                return images;
            }
            Image[] images = this.findResources(sParentName);
            if (images == null) continue;
            return images;
        }
        i = Collections.binarySearch(this.notFound, sKey) * -1 - 1;
        if (i >= 0) {
            this.notFound.add(i, sKey);
        }
        return null;
    }

    private Image[] parseValuesString(String sKey, String[] values, String suffix) {
        Image[] images;
        block8: {
            String sTryFile;
            int locationStart;
            int splitX;
            block7: {
                images = null;
                splitX = 0;
                locationStart = 0;
                if (values[0].equals("multi") && values.length > 2) {
                    splitX = Integer.parseInt(values[1]);
                    locationStart = 2;
                }
                if (locationStart != 0 && splitX > 0) break block7;
                images = new Image[values.length];
                for (int i = 0; i < values.length; ++i) {
                    int index = values[i].lastIndexOf(46);
                    if (index > 0) {
                        String sTryFile2 = values[i].substring(0, index) + suffix + values[i].substring(index);
                        images[i] = this.loadImage(this.display, sTryFile2, sKey);
                        if (images[i] == null) {
                            sTryFile2 = values[i].substring(0, index) + suffix.replace('-', '_') + values[i].substring(index);
                            images[i] = this.loadImage(this.display, sTryFile2, sKey);
                        }
                    }
                    if (images[i] != null) continue;
                    images[i] = ImageLoader.getNoImage();
                }
                break block8;
            }
            Image image = null;
            String origFile = values[locationStart];
            int index = origFile.lastIndexOf(46);
            if (index > 0 && (image = this.loadImage(this.display, sTryFile = origFile.substring(0, index) + suffix + origFile.substring(index), sKey)) == null) {
                sTryFile = origFile.substring(0, index) + suffix.replace('-', '_') + origFile.substring(index);
                image = this.loadImage(this.display, sTryFile, sKey);
            }
            if (image == null) {
                image = this.loadImage(this.display, values[locationStart], sKey);
            }
            if (image == null) break block8;
            Rectangle bounds = image.getBounds();
            images = new Image[(bounds.width + splitX - 1) / splitX];
            for (int i = 0; i < images.length; ++i) {
                Image imgBG = Utils.createAlphaImage((Device)this.display, splitX, bounds.height, (byte)0);
                images[i] = Utils.blitImage((Device)this.display, image, new Rectangle(i * splitX, 0, splitX, bounds.height), imgBG, new Point(0, 0));
                imgBG.dispose();
            }
        }
        return images;
    }

    private Image loadImage(Display display, String res, String sKey) {
        Image img;
        block11: {
            img = null;
            if (res == null) {
                String sTryFile;
                int index;
                String sParentName;
                String sParentFile;
                String sSuffix;
                for (int i = 0; i < this.sSuffixChecks.length && (!sKey.endsWith(sSuffix = this.sSuffixChecks[i]) || (sParentFile = this.skinProperties.getStringValue(sParentName = sKey.substring(0, sKey.length() - sSuffix.length()))) == null || (index = sParentFile.lastIndexOf(46)) <= 0 || (img = this.loadImage(display, sTryFile = sParentFile.substring(0, index) + sSuffix + sParentFile.substring(index), sKey)) == null && (img = this.loadImage(display, sTryFile = sParentFile.substring(0, index) + sSuffix.replace('-', '_') + sParentFile.substring(index), sKey)) == null); ++i) {
                }
            }
            if (img == null) {
                try {
                    Image imgToFade;
                    InputStream is = this.classLoader.getResourceAsStream(res);
                    if (is != null) {
                        img = new Image((Device)display, is);
                    }
                    if (img != null || !sKey.endsWith("-disabled") && !sKey.endsWith("_disabled") || !ImageLoader.isRealImage(imgToFade = this.getImage(sKey.substring(0, sKey.length() - 9)))) break block11;
                    ImageData imageData = imgToFade.getImageData();
                    if (imageData.alphaData != null) {
                        if (this.disabledOpacity == -1) {
                            for (int i = 0; i < imageData.alphaData.length; ++i) {
                                imageData.alphaData[i] = (byte)((imageData.alphaData[i] & 0xFF) >> 3);
                            }
                        } else {
                            for (int i = 0; i < imageData.alphaData.length; ++i) {
                                imageData.alphaData[i] = (byte)((imageData.alphaData[i] & 0xFF) * this.disabledOpacity / 100);
                            }
                        }
                        img = new Image((Device)display, imageData);
                        break block11;
                    }
                    Rectangle bounds = imgToFade.getBounds();
                    Image bg = Utils.createAlphaImage((Device)display, bounds.width, bounds.height, (byte)0);
                    img = Utils.renderTransparency(display, bg, imgToFade, new Point(0, 0), this.disabledOpacity == -1 ? 64 : this.disabledOpacity * 255 / 100);
                    bg.dispose();
                }
                catch (Throwable e) {
                    System.err.println("ImageRepository:loadImage:: Resource not found: " + res + "\n" + e);
                }
            }
        }
        return img;
    }

    public void unLoadImages() {
        for (Image[] images : this.mapImages.values()) {
            if (images == null) continue;
            for (int i = 0; i < images.length; ++i) {
                Image image = images[i];
                if (image == null || image.isDisposed()) continue;
                image.dispose();
            }
        }
    }

    public Image[] getImages(String sKey) {
        if (sKey == null) {
            return new Image[0];
        }
        Image[] images = (Image[])this.mapImages.get(sKey);
        if (images != null) {
            return images;
        }
        String[] locations = this.skinProperties.getStringArray(sKey);
        if (locations == null || locations.length == 0) {
            images = this.findResources(sKey);
            if (images == null) {
                images = new Image[]{};
            }
            for (int i = 0; i < images.length; ++i) {
                if (images[i] != null) continue;
                images[i] = ImageLoader.getNoImage();
            }
        } else {
            images = this.parseValuesString(sKey, locations, "");
        }
        this.mapImages.put(sKey, images);
        return images;
    }

    public Image getImage(String sKey) {
        Image[] images = this.getImages(sKey);
        if (images == null || images.length == 0) {
            return ImageLoader.getNoImage();
        }
        return images[0];
    }

    private static Image getNoImage() {
        if (noImage == null) {
            Display display = Display.getDefault();
            int SIZE = 10;
            noImage = new Image((Device)display, 10, 10);
            GC gc = new GC((Drawable)noImage);
            gc.setBackground(display.getSystemColor(7));
            gc.fillRectangle(0, 0, 10, 10);
            gc.setBackground(display.getSystemColor(3));
            gc.drawRectangle(0, 0, 9, 9);
            gc.dispose();
        }
        return noImage;
    }

    public boolean imageExists(String name) {
        return ImageLoader.isRealImage(this.getImage(name));
    }

    public static boolean isRealImage(Image image) {
        return image != null && image != ImageLoader.getNoImage() && !image.isDisposed();
    }

    public int getAnimationDelay(String sKey) {
        return this.skinProperties.getIntValue(sKey + ".delay", 100);
    }
}

