/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.plugins.magnet.MagnetPlugin;
import com.aelitis.azureus.plugins.magnet.MagnetPluginListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.net.magneturi.MagnetURIHandler;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.swt.UISwitcherUtil;
import org.gudy.azureus2.ui.swt.Utils;

public class UIMagnetHandler {
    public UIMagnetHandler(AzureusCore core) {
        int val = Integer.parseInt(Constants.getBaseVersion().replaceAll("\\.", ""));
        String ui = COConfigurationManager.getStringParameter("ui");
        if (!"az2".equals(ui)) {
            val += 10000;
        }
        MagnetURIHandler magnetURIHandler = MagnetURIHandler.getSingleton();
        magnetURIHandler.addInfo("get-version-info", val);
        core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void componentCreated(final AzureusCore core, AzureusCoreComponent component) {
                PluginInterface pi;
                if (component instanceof PluginInterface && (pi = (PluginInterface)((Object)component)).getPlugin() instanceof MagnetPlugin) {
                    MagnetPlugin magnetPlugin = (MagnetPlugin)pi.getPlugin();
                    magnetPlugin.addListener(new MagnetPluginListener(){

                        public boolean set(String name, Map values) {
                            String val;
                            if (name.equals("AZMSG") && values != null && (val = (String)values.get("value")).indexOf(";switch-ui;") > 0) {
                                if (COConfigurationManager.getStringParameter("ui", "az3").equals("az3")) {
                                    return false;
                                }
                                if (!UISwitcherUtil.isAZ3Avail()) {
                                    return false;
                                }
                                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                if (uif == null) {
                                    core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

                                        public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                                            if (component instanceof UIFunctions) {
                                                UIMagnetHandler.uiswitch((UIFunctions)component);
                                            }
                                        }
                                    });
                                } else {
                                    UIMagnetHandler.uiswitch(uif);
                                }
                                return true;
                            }
                            return false;
                        }

                        public int get(String name, Map values) {
                            return Integer.MIN_VALUE;
                        }
                    });
                }
            }
        });
    }

    private static void uiswitch(final UIFunctions uif) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                uif.bringToFront();
                int i = uif.promptUser(MessageText.getString("dialog.uiswitch.title"), MessageText.getString("dialog.uiswitch.text"), new String[]{MessageText.getString("dialog.uiswitch.button")}, 0, null, null, false, 0);
                if (i == 0) {
                    COConfigurationManager.setParameter("ui", "az3");
                    COConfigurationManager.save();
                    AzureusCore core = AzureusCoreFactory.getSingleton();
                    if (core != null) {
                        core.requestRestart();
                    }
                }
            }
        });
    }
}

