/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.list;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.views.list.ListCell;
import com.aelitis.azureus.ui.swt.views.list.ListCellGraphic;
import com.aelitis.azureus.ui.swt.views.list.ListView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseListener;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ListRow
implements TableRowSWT {
    private static final boolean READJUST_CELL_HEIGHT = true;
    private SWTSkinProperties skinProperties;
    private Object coreDataSource;
    private Object pluginDataSource;
    private Map mapTableCells;
    private boolean bDisposed;
    private boolean bNeverRefreshed = true;
    private boolean bSelected;
    private ListView view;
    private final Composite parent;
    private Color fg;
    private Color bg;
    private Color customBG;
    private boolean bRowVisuallyChangedSinceRefresh;
    private ArrayList mouseListeners;
    private AEMonitor this_mon = new AEMonitor("ListRow");
    private Map dataList;
    private int height = 0;
    private int basicYPos = -1;

    public ListRow(ListView view, Composite parent, Object datasource) {
        this.parent = parent;
        this.coreDataSource = datasource;
        this.view = view;
        this.setHeight(view.rowHeightDefault);
        this.pluginDataSource = null;
        this.bDisposed = false;
        this.bSelected = false;
        this.mapTableCells = new LinkedHashMap();
        this.skinProperties = view.getSkinProperties();
        TableColumnCore[] columns = view.getAllColumns();
        int iStartPos = ListView.COLUMN_MARGIN_WIDTH;
        for (int i = 0; i < columns.length; ++i) {
            TableColumnCore column = columns[i];
            boolean bVisible = column.isVisible();
            int margin = view.getRowMarginHeight();
            Rectangle bounds = new Rectangle(iStartPos, margin, bVisible ? column.getWidth() : 0, this.height - margin * 2);
            int iColumnPos = column.getPosition();
            int iSWTAlign = CoreTableColumn.getSWTAlign(column.getAlignment());
            ListCell listCell = column.getType() == 2 ? new ListCellGraphic(this, iSWTAlign, bounds) : new ListCell(this, iSWTAlign, bounds);
            if (bVisible) {
                iStartPos += bounds.width + ListView.COLUMN_MARGIN_WIDTH * 2;
            }
            TableCellImpl cell = new TableCellImpl(this, column, i, listCell);
            listCell.setTableCell(cell);
            cell.setUpToDate(false);
            this.mapTableCells.put(column.getName(), cell);
        }
    }

    private void checkCellForSetting() {
        if (this.bDisposed) {
            throw new UIRuntimeException("ListRow is disposed.");
        }
    }

    public void setBackgroundColor(Color bg) {
        this.customBG = bg;
    }

    private void setBackgroundColor(int iPosition) {
        Color newFG;
        Color newBG;
        boolean bOdd;
        this.checkCellForSetting();
        boolean changed = false;
        boolean bl = bOdd = (iPosition + 1) % 2 == 0;
        if (this.bSelected) {
            newBG = bOdd ? this.view.colorRowSelectedOddBG : this.view.colorRowSelectedEvenBG;
            newFG = bOdd ? this.view.colorRowSelectedOddFG : this.view.colorRowSelectedEvenFG;
        } else {
            newBG = bOdd ? this.view.colorRowOddBG : this.view.colorRowEvenBG;
            Color color = newFG = bOdd ? this.view.colorRowOddFG : this.view.colorRowEvenFG;
        }
        if (!this.colorsEqual(newBG, this.bg)) {
            changed = true;
            this.bg = newBG;
        }
        if (!this.colorsEqual(newFG, this.fg)) {
            changed = true;
            this.fg = newFG;
        }
        if (changed) {
            this.bRowVisuallyChangedSinceRefresh = true;
            this.invalidateGraphic();
            if (this.isVisible()) {
                this.redraw();
            }
        }
    }

    private boolean colorsEqual(Color color1, Color color2) {
        if (color1 == color2) {
            return true;
        }
        if (color1 == null || color2 == null) {
            return false;
        }
        return color1.equals((Object)color2);
    }

    private Color getAlternatingColor() {
        String sColorID;
        Color color;
        boolean bOdd;
        boolean bl = bOdd = (this.getIndex() + 1) % 2 == 0;
        if (this.skinProperties != null && (color = this.skinProperties.getColor(sColorID = bOdd ? "color.row.odd.bg" : "color.row.even.bg")) != null) {
            return color;
        }
        return this.parent.getBackground();
    }

    public void delete() {
        this.bDisposed = true;
        for (TableCellSWT item : this.mapTableCells.values()) {
            try {
                item.dispose();
            }
            catch (Exception e) {
                Debug.out("Disposing ListRow Column", e);
            }
        }
    }

    public void doPaint(GC gc, boolean bVisible) {
        this.doPaint(gc, bVisible, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPaint(GC gc, boolean bVisible, boolean bListCellPaint) {
        if (gc == null || gc.isDisposed()) {
            Debug.out("gc is null or disposed");
            return;
        }
        if (this.bDisposed || !bVisible) {
            return;
        }
        if (this.bNeverRefreshed) {
            this.bNeverRefreshed = false;
            this._refresh(true, true);
        }
        TableColumnCore[] visibleColumns = this.view.getVisibleColumns();
        long lTimeStart = System.currentTimeMillis();
        Rectangle oldClipping = gc.getClipping();
        try {
            gc.setBackground(this.getBackground());
            Rectangle clientArea = this.view.getClientArea();
            int yofs = this.view.rowGetVisibleYOffset(this);
            gc.fillRectangle(0, yofs, clientArea.width, this.height);
            if (this.isFocused()) {
                if (this.view.colorRowFocus != null) {
                    gc.setForeground(this.view.colorRowFocus);
                    gc.setLineStyle(this.view.rowFocusStyle);
                    gc.drawRectangle(0, yofs, clientArea.width - 1, this.height - 1);
                }
            } else {
                int yy = this.height + yofs - 1;
                if (yy > 0 && this.view.colorRowDivider != null && clientArea.width > 10) {
                    gc.setForeground(this.view.colorRowDivider);
                    gc.drawLine(5, yy, clientArea.width - 10, yy);
                }
            }
            gc.setForeground(this.getForeground());
            for (int i = 0; i < visibleColumns.length; ++i) {
                long lTimeStart2 = System.currentTimeMillis();
                TableColumnCore column = visibleColumns[i];
                TableCellSWT cell = (TableCellSWT)this.mapTableCells.get(column.getName());
                if (cell == null) continue;
                try {
                    Rectangle bounds;
                    if (cell.needsPainting() && (bounds = cell.getBounds()) != null) {
                        Rectangle clipping = bounds.intersection(oldClipping);
                        gc.setClipping(clipping);
                        if (bListCellPaint) {
                            ListCell listcell = (ListCell)cell.getBufferedTableItem();
                            listcell.doPaint(gc);
                        } else {
                            cell.doPaint(gc);
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("column " + column.getName() + ";" + cell);
                }
                long diff = System.currentTimeMillis() - lTimeStart2;
                if (diff <= 120L) continue;
                this.view.log("doPaint " + column.getName() + " took " + diff + "ms. " + this.toString());
            }
        }
        finally {
            gc.setClipping(oldClipping);
        }
        long diff = System.currentTimeMillis() - lTimeStart;
        if (diff > 90L) {
            this.view.log("doPaint took " + diff + "ms. " + this.toString());
        }
    }

    public Object getDataSource(boolean bCoreObject) {
        if (bCoreObject) {
            return this.coreDataSource;
        }
        if (this.pluginDataSource != null) {
            return this.pluginDataSource;
        }
        this.pluginDataSource = PluginCoreUtils.convert(this.coreDataSource, bCoreObject);
        return this.pluginDataSource;
    }

    public Color getForeground() {
        if (this.fg == null) {
            this.setBackgroundColor(this.getIndex());
        }
        return this.fg;
    }

    public int getIndex() {
        return this.view.indexOf(this);
    }

    public TableCellCore getTableCellCore(String field) {
        if (this.bDisposed) {
            return null;
        }
        return (TableCellCore)this.mapTableCells.get(field);
    }

    public void invalidate() {
        if (this.bDisposed) {
            return;
        }
        long lTimeStart = System.currentTimeMillis();
        for (TableCellSWT cell : this.mapTableCells.values()) {
            if (cell == null) continue;
            cell.invalidate(true);
        }
        long diff = System.currentTimeMillis() - lTimeStart;
        if (diff >= 10L) {
            System.out.println("invalidate: " + diff + "ms");
        }
    }

    public void invalidateGraphic() {
        if (this.bDisposed) {
            return;
        }
        long lTimeStart = System.currentTimeMillis();
        for (TableCellSWT cell : this.mapTableCells.values()) {
            if (cell.getTableColumn().getType() != 2) continue;
            cell.invalidate(true);
        }
        long diff = System.currentTimeMillis() - lTimeStart;
        if (diff >= 10L) {
            System.out.println("invalidate: " + diff + "ms");
        }
    }

    public boolean isRowDisposed() {
        return this.bDisposed;
    }

    public boolean isSelected() {
        return this.bSelected;
    }

    public boolean isVisible() {
        return this.view.isRowVisible(this);
    }

    public void locationChanged(int iStartColumn) {
    }

    public List refresh(boolean bDoGraphics) {
        if (this.bDisposed) {
            return Collections.EMPTY_LIST;
        }
        boolean bVisible = this.isVisible();
        return this.refresh(bDoGraphics, bVisible);
    }

    public List refresh(boolean bDoGraphics, boolean bVisible) {
        if (this.bDisposed) {
            return Collections.EMPTY_LIST;
        }
        return this.view.rowRefresh(this, bDoGraphics, bVisible);
    }

    protected List _refresh(boolean bDoGraphics, boolean bVisible) {
        if (this.bDisposed) {
            return Collections.EMPTY_LIST;
        }
        if (!bVisible) {
            this.setUpToDate(false);
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (TableCellSWT cell : this.mapTableCells.values()) {
            boolean thisChanged;
            Rectangle bounds = cell.getBounds();
            TableColumn column = cell.getTableColumn();
            if (bounds == null || !column.isVisible() || !(thisChanged = cell.refresh(bDoGraphics, bVisible))) continue;
            list.add(cell);
        }
        if (this.bRowVisuallyChangedSinceRefresh) {
            list.add(0, this);
        }
        this.bRowVisuallyChangedSinceRefresh = false;
        return list;
    }

    public void setForeground(Color c) {
        if (this.isRowDisposed()) {
            return;
        }
        for (TableCellSWT item : this.mapTableCells.values()) {
            item.setForeground(c);
        }
    }

    public void setForeground(int r, int g, int b) {
        for (TableCellSWT item : this.mapTableCells.values()) {
            item.setForeground(r, g, b);
        }
    }

    public void setForeground(int[] rgb) {
        if (rgb == null || rgb.length < 3) {
            this.setForeground((Color)null);
            return;
        }
        this.setForeground(rgb[0], rgb[1], rgb[2]);
    }

    public void setForegroundToErrorColor() {
        this.setForeground(Colors.colorError);
    }

    public boolean setDrawableHeight(int iHeight) {
        return this.setHeight(iHeight + this.view.getRowMarginHeight() * 2);
    }

    public boolean setHeight(int iHeight) {
        int newHeight = iHeight;
        if (this.height == newHeight) {
            return false;
        }
        this.bRowVisuallyChangedSinceRefresh = true;
        int oldHeight = this.height;
        this.height = newHeight;
        if (this.mapTableCells != null) {
            for (TableCellSWT cell : this.mapTableCells.values()) {
                if (cell == null) continue;
                ListCell listcell = (ListCell)cell.getBufferedTableItem();
                Rectangle bounds = listcell.getBounds();
                bounds.height = this.height;
                listcell.setBounds(bounds);
            }
        }
        this.view.rowHeightChanged(this, oldHeight, this.height);
        return true;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDrawableHeight() {
        return this.height - this.view.getRowMarginHeight() * 2;
    }

    public boolean setIconSize(Point pt) {
        this.bRowVisuallyChangedSinceRefresh = true;
        return false;
    }

    public void setSelected(boolean bSelected) {
        if (this.bSelected == bSelected) {
            return;
        }
        this.bSelected = bSelected;
        this.setBackgroundColor(this.getIndex());
        this.view.rowSetSelected(this, bSelected);
    }

    public void setFocused(boolean b) {
        ListRow oldRow = this.view.getRowFocused();
        if (b) {
            this.view.rowSetFocused(this);
        } else if (this.isFocused()) {
            this.view.rowSetFocused(null);
        }
        if (oldRow != null) {
            oldRow.redraw();
        }
        this.redraw();
    }

    public boolean isFocused() {
        return this.equals(this.view.getRowFocused());
    }

    public boolean setTableItem(int newIndex, boolean isVisible) {
        return this.setTableItem(newIndex);
    }

    public boolean setTableItem(int iRowPos) {
        if (!this.fixupPosition()) {
            return false;
        }
        ListRow row = (ListRow)this.view.getRow(iRowPos + 1);
        if (row != null) {
            row.fixupPosition();
        }
        this.bRowVisuallyChangedSinceRefresh = true;
        return true;
    }

    public boolean fixupPosition() {
        int iRowPos = this.getIndex();
        this.setBackgroundColor(iRowPos);
        return this.parent != null && !this.parent.isDisposed();
    }

    public void setUpToDate(boolean upToDate) {
        if (this.bDisposed) {
            return;
        }
        long lTimeStart = System.currentTimeMillis();
        for (TableCellSWT cell : this.mapTableCells.values()) {
            boolean bOldUpToDate;
            if (cell == null || (bOldUpToDate = cell.isUpToDate()) == upToDate) continue;
            cell.setUpToDate(upToDate);
            ListCell listcell = (ListCell)cell.getBufferedTableItem();
            listcell.isShown();
        }
        long diff = System.currentTimeMillis() - lTimeStart;
        if (diff >= 50L) {
            System.out.println("sutd: " + upToDate + " for " + this.getIndex() + "; " + diff + "ms");
        }
    }

    public Object getDataSource() {
        return this.getDataSource(false);
    }

    public TableCell getTableCell(String sColumnName) {
        if (this.bDisposed) {
            return null;
        }
        return (TableCell)this.mapTableCells.get(sColumnName);
    }

    public TableCellSWT getTableCellSWT(String sColumnName) {
        if (this.bDisposed) {
            return null;
        }
        return (TableCellSWT)this.mapTableCells.get(sColumnName);
    }

    public String getTableID() {
        return this.view.getTableID();
    }

    public boolean isValid() {
        if (this.bDisposed) {
            return true;
        }
        boolean valid = true;
        for (TableCellSWT cell : this.mapTableCells.values()) {
            if (cell == null) continue;
            valid &= cell.isValid();
        }
        return valid;
    }

    public boolean getVisuallyChangedSinceLastRefresh() {
        if (this.bDisposed) {
            return true;
        }
        if (this.bRowVisuallyChangedSinceRefresh) {
            return true;
        }
        for (TableCellSWT cell : this.mapTableCells.values()) {
            if (cell == null || !cell.getVisuallyChangedSinceRefresh()) continue;
            return true;
        }
        return false;
    }

    public Color getBackground() {
        if (this.customBG != null && !this.customBG.isDisposed()) {
            return this.customBG;
        }
        if (this.bg == null) {
            this.setBackgroundColor(this.getIndex());
        }
        return this.bg;
    }

    public TableCellSWT getTableCellSWT(int x, int y) {
        for (TableCellSWT cell : this.mapTableCells.values()) {
            Rectangle bounds;
            if (!cell.isShown() || (bounds = cell.getBounds()) == null || !bounds.contains(x, y)) continue;
            return cell;
        }
        return null;
    }

    public TableView getView() {
        return this.view;
    }

    public void redraw() {
        this.view.rowRefreshAsync(this, true, true);
    }

    public void setAlternatingBGColor(boolean bEvenIfNotVisible) {
        this.setBackgroundColor(this.getIndex());
    }

    public void doPaint(GC gc) {
        if (this.bDisposed) {
            return;
        }
        this.doPaint(gc, this.isVisible());
    }

    public String toString() {
        return "ListRow {" + this.getIndex() + (this.bDisposed ? ", Disposed" : "") + "," + this.view.getTableID() + "," + (this.isVisible() ? "visible" : "invisible") + "}";
    }

    public int getVisibleYOffset() {
        return this.view.rowGetVisibleYOffset(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMouseListener(TableRowMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.mouseListeners == null) {
                this.mouseListeners = new ArrayList(1);
            }
            this.mouseListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMouseListener(TableRowMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.mouseListeners == null) {
                return;
            }
            this.mouseListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void invokeMouseListeners(TableRowMouseEvent event2) {
        ArrayList listeners = this.mouseListeners;
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                TableRowMouseListener l = (TableRowMouseListener)listeners.get(i);
                l.rowMouseTrigger(event2);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public boolean isMouseOver() {
        return this.view.getTableRowWithCursor() == this;
    }

    public void setBasicYPos(int y) {
        this.basicYPos = y;
    }

    public int getBasicYPos() {
        return this.basicYPos;
    }

    public void setData(String id, Object data) {
        if (this.dataList == null) {
            this.dataList = new HashMap(1);
        }
        if (data == null) {
            this.dataList.remove("id");
        } else {
            this.dataList.put(id, data);
        }
    }

    public Object getData(String id) {
        return this.dataList == null ? null : this.dataList.get(id);
    }

    public Rectangle getBounds() {
        Rectangle area = this.view.getClientArea();
        area.y = this.getBasicYPos();
        area.height = this.getHeight();
        return area;
    }

    public void setBackgroundImage(Image image) {
    }

    public int getAlpha() {
        return 255;
    }

    public int getFontStyle() {
        return 0;
    }

    public boolean setAlpha(int alpha) {
        return false;
    }

    public boolean setFontStyle(int style) {
        return false;
    }
}

