/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.list;

import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableCountChangeListener;
import com.aelitis.azureus.ui.common.table.TableGroupRowRunner;
import com.aelitis.azureus.ui.common.table.TableGroupRowVisibilityRunner;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableStructureEventDispatcher;
import com.aelitis.azureus.ui.common.table.TableStructureModificationListener;
import com.aelitis.azureus.ui.common.table.impl.TableViewImpl;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.ui.swt.views.list.ListCell;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.list.TableColumnMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableObject;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRowRefreshListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTPanelCreator;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableTooltips;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnEditorWindow;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;

public class ListView
extends TableViewImpl
implements TableViewSWT,
UIUpdatable,
Listener,
TableStructureModificationListener,
KeyListener {
    public static int COLUMN_MARGIN_WIDTH = 3;
    public static int COLUMN_PADDING_WIDTH = COLUMN_MARGIN_WIDTH * 2;
    private static final LogIDs LOGID = LogIDs.UI3;
    private static final boolean DEBUGPAINT = false;
    private static final boolean DEBUG_SORTER = false;
    private static final boolean DEBUG_COLUMNSIZE = false;
    private static final boolean DEMO_DRAGROW = false;
    private static final boolean DELAY_SCROLL = false;
    private static final ConfigurationManager configMan = ConfigurationManager.getInstance();
    private static final String CFG_SORTDIRECTION = "config.style.table.defaultSortOrder";
    private static final long IMMEDIATE_ADDREMOVE_DELAY = 150L;
    private static final long IMMEDIATE_ADDREMOVE_MAXDELAY = 2000L;
    public int rowMarginHeight = 2;
    public int rowHeightDefault = 38;
    private Canvas listCanvas;
    private boolean isPaintingCanvas = false;
    private SWTSkinProperties skinProperties;
    private TableColumnCore[] lastVisibleColumns;
    private int lastClientWidth = 0;
    private ArrayList selectedRows = new ArrayList();
    private AEMonitor selectedRows_mon = new AEMonitor("ListView:SR");
    private ArrayList rows = new ArrayList();
    private Map mapDataSourceToRow = new HashMap();
    private AEMonitor row_mon = new AEMonitor("ListView:OTSI");
    private ListRow rowFocused = null;
    private String sTableID;
    private List dataSourcesToAdd = new ArrayList(4);
    private List dataSourcesToRemove = new ArrayList(4);
    private long lCancelSelectionTriggeredOn = -1L;
    private List listenersCountChange = new ArrayList();
    private boolean bMouseClickIsDefaultSelection = false;
    private int iGraphicRefresh;
    protected int graphicsUpdate;
    private TableColumnCore sortColumn;
    private long lLastSortedOn;
    private Composite headerArea;
    private TableColumnCore[] allColumns = new TableColumnCore[0];
    private ScrollBar vBar;
    private Image imgView = null;
    private GC gcImgView = null;
    private int iLastVBarPos;
    protected Object[] restartRefreshVisible = null;
    private boolean bInRefreshVisible;
    protected boolean viewVisible;
    private List listenersMenuFill = new ArrayList();
    private ArrayList listenersKey = new ArrayList();
    private int style;
    private Composite listParent;
    private Image imgSortAsc;
    private Image imgSortDesc;
    private boolean bTitleIsMinWidth;
    private TableViewSWTPanelCreator mainPanelCreator;
    private Map mapColumnMetrics = new HashMap();
    private boolean bSkipSelectionTrigger = false;
    private ArrayList rowsToRefresh = new ArrayList();
    private AEMonitor rowsToRefresh_mon = new AEMonitor("rowsToRefresh");
    private Rectangle lastBounds = new Rectangle(0, 0, 0, 0);
    private Listener lShowHide;
    private RowInfo topRowInfo = null;
    private RowInfo bottomRowInfo = null;
    private int totalHeight;
    private Rectangle clientArea;
    private Menu menuHeader;
    private static final Comparator rowYPosComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            long index0 = arg0 instanceof ListRow ? (long)((ListRow)arg0).getBasicYPos() : (Long)arg0;
            long index1 = arg1 instanceof ListRow ? (long)((ListRow)arg1).getBasicYPos() : (Long)arg1;
            return (int)(index0 - index1);
        }
    };
    protected Color colorRowOddBG;
    protected Color colorRowOddFG;
    protected Color colorRowEvenBG;
    protected Color colorRowEvenFG;
    protected Color colorRowSelectedOddBG;
    protected Color colorRowSelectedOddFG;
    protected Color colorRowSelectedEvenBG;
    protected Color colorRowSelectedEvenFG;
    protected Color colorRowDivider;
    protected Color colorRowFocus;
    private Display display;
    protected int rowFocusStyle;
    private Class dataSourceType;
    private Utils.addDataSourceCallback processDataSourceQueueCallback = new Utils.addDataSourceCallback(){

        public void process() {
            ListView.this.processDataSourceQueue();
        }

        public void debug(String str) {
            ListView.this.logADDREMOVE(str);
        }
    };
    private boolean syncColumnSizes = false;
    boolean adjustingColumns = false;
    int lastVisColumnWidth = 0;

    public ListView() {
    }

    public void init(String sTableID, SWTSkinProperties skinProperties, Composite parent, Composite headerArea, int style) {
        ImageLoader imgLoader;
        this.skinProperties = skinProperties;
        this.sTableID = sTableID;
        this.style = style;
        this.headerArea = headerArea;
        if (headerArea != null && (imgLoader = ImageLoaderFactory.getInstance()) != null) {
            this.imgSortAsc = imgLoader.getImage("image.sort.asc");
            this.imgSortDesc = imgLoader.getImage("image.sort.desc");
        }
        this.display = parent.getDisplay();
        this.initialize(parent);
        try {
            UIFunctionsManager.getUIFunctions().getUIUpdater().addUpdater(this);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public ListView(String sTableID, int style) {
        this.sTableID = sTableID;
        this.style = style;
    }

    public void setHeaderArea(Composite headerArea, Image imgSortAsc, Image imgSortDesc) {
        this.headerArea = headerArea;
        this.imgSortAsc = imgSortAsc;
        this.imgSortDesc = imgSortDesc;
    }

    public void initialize(Composite parent) {
        COConfigurationManager.addAndFireParameterListener("Graphics Update", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                ListView.this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
            }
        });
        TableViewSWTPanelCreator mainPanelCreator = this.getMainPanelCreator();
        this.listParent = mainPanelCreator != null ? mainPanelCreator.createTableViewPanel(parent) : parent;
        this.listParent.setBackgroundMode(2);
        this.listCanvas = new Canvas(this.listParent, 0x140000 | this.style);
        this.listCanvas.setLayout((Layout)new FormLayout());
        this.clientArea = this.listCanvas.getClientArea();
        Layout layout = this.listParent.getLayout();
        if (layout instanceof FormLayout) {
            FormData formData = new FormData();
            formData.left = new FormAttachment(0);
            formData.top = new FormAttachment(0);
            formData.right = new FormAttachment(100);
            formData.bottom = new FormAttachment(100);
            this.listCanvas.setLayoutData((Object)formData);
        } else if (layout instanceof GridLayout) {
            GridData gd = new GridData(1808);
            this.listCanvas.setLayoutData((Object)gd);
        }
        this.vBar = this.listCanvas.getVerticalBar();
        if (this.vBar != null) {
            this.vBar.addListener(13, new Listener(){
                private TimerEvent event;

                public void handleEvent(Event e) {
                    ListView.this.scrollTo(ListView.this.vBar.getSelection());
                }
            });
        }
        this.lShowHide = new Listener(){

            public void handleEvent(Event event2) {
                boolean toBeVisible;
                boolean bl = toBeVisible = event2.type == 22;
                if (event2.widget == ListView.this.listCanvas) {
                    ListView.this.viewVisible = toBeVisible;
                } else if (!toBeVisible || ListView.this.listCanvas.isVisible()) {
                    ListView.this.viewVisible = toBeVisible;
                } else {
                    ListView.this.viewVisible = true;
                    ListView.this.display.asyncExec((Runnable)new AERunnable(){

                        public void runSupport() {
                            ListView.this.viewVisible = ListView.this.listCanvas.isVisible();
                        }
                    });
                }
                if (ListView.this.viewVisible) {
                    ListView.this.display.asyncExec((Runnable)new AERunnable(){

                        public void runSupport() {
                            ListView.this.refreshVisible(true, true, true);
                            ListView.this.refreshScrollbar();
                            ListView.this.handleResize(true);
                        }
                    });
                }
            }
        };
        this.viewVisible = false;
        Canvas walkUp = this.listCanvas;
        do {
            walkUp.addListener(22, this.lShowHide);
            walkUp.addListener(23, this.lShowHide);
        } while ((walkUp = walkUp.getParent()) != null);
        this.listCanvas.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                ListView.this.handleResize(false);
            }
        });
        this.listCanvas.addListener(9, (Listener)new canvasPaintListener());
        selectionListener l = new selectionListener();
        this.listCanvas.addListener(3, (Listener)l);
        this.listCanvas.addListener(4, (Listener)l);
        this.listCanvas.addListener(5, (Listener)l);
        this.listCanvas.addListener(8, (Listener)l);
        this.listCanvas.addListener(15, (Listener)this);
        this.listCanvas.addListener(16, (Listener)this);
        this.listCanvas.addListener(31, (Listener)this);
        this.listCanvas.addListener(14, (Listener)this);
        this.listCanvas.addKeyListener((KeyListener)this);
        this.listCanvas.setMenu(this.createMenu());
        Listener mouseListener = new Listener(){
            TableCellSWT lastCell = null;
            TableRowCore lastRow = null;
            int lastCursorID = -1;

            public void handleEvent(Event e) {
                try {
                    TableColumnCore tc;
                    TableCellMouseEvent event2;
                    boolean changedRow;
                    boolean bExited = e.type == 7;
                    TableRowCore row = bExited ? null : ListView.this.getRow(e.x, e.y);
                    TableCellSWT cell = bExited ? null : ListView.this.getTableCell(e.x, e.y);
                    int iCursorID = -2;
                    boolean changedCell = this.lastCell != cell;
                    boolean bl = changedRow = row != this.lastRow;
                    if (changedCell && this.lastCell != null && !this.lastCell.isDisposed() && (event2 = ListView.this.createMouseEvent(this.lastCell, e, 5)) != null) {
                        tc = (TableColumnCore)this.lastCell.getTableColumn();
                        tc.invokeCellMouseListeners(event2);
                        this.lastCell.invokeMouseListeners(event2);
                    }
                    if (changedRow && this.lastRow != null && !this.lastRow.isRowDisposed()) {
                        event2 = ListView.this.createMouseEvent(this.lastCell, e, 5);
                        if (event2 != null) {
                            event2.row = this.lastRow;
                            this.lastRow.invokeMouseListeners(event2);
                        }
                        ListView.this.triggerMouseEnterExitRow(this.lastRow, false);
                    }
                    if (cell == null) {
                        this.lastCell = null;
                    } else if (changedCell) {
                        event2 = ListView.this.createMouseEvent(cell, e, 4);
                        if (event2 != null) {
                            tc = (TableColumnCore)cell.getTableColumn();
                            tc.invokeCellMouseListeners(event2);
                            cell.invokeMouseListeners(event2);
                        }
                        iCursorID = cell.getCursorID();
                        this.lastCell = cell;
                    }
                    if (row == null) {
                        this.lastRow = null;
                    } else if (changedRow) {
                        event2 = ListView.this.createMouseEvent(cell, e, 4);
                        if (event2 != null) {
                            event2.row = row;
                            row.invokeMouseListeners(event2);
                        }
                        this.lastRow = row;
                        ListView.this.triggerMouseEnterExitRow(row, true);
                    }
                    if (iCursorID != this.lastCursorID) {
                        this.lastCursorID = iCursorID;
                        if (iCursorID >= 0) {
                            ListView.this.listParent.setCursor(ListView.this.display.getSystemCursor(iCursorID));
                        } else if (iCursorID == -1) {
                            ListView.this.listParent.setCursor(null);
                        }
                    }
                    if (cell != null && (event2 = ListView.this.createMouseEvent(cell, e, 3)) != null) {
                        tc = (TableColumnCore)cell.getTableColumn();
                        if (tc.hasCellMouseMoveListener()) {
                            ((TableColumnCore)cell.getTableColumn()).invokeCellMouseListeners(event2);
                        }
                        cell.invokeMouseListeners(event2);
                    }
                    if (row != null && (event2 = ListView.this.createMouseEvent(cell, e, 3)) != null) {
                        event2.row = row;
                        row.invokeMouseListeners(event2);
                    }
                }
                catch (Exception ex) {
                    Debug.out(ex);
                }
            }
        };
        this.listCanvas.addListener(5, mouseListener);
        this.listCanvas.addListener(7, mouseListener);
        this.listCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ListView.this.delete();
            }
        });
        new TableTooltips(this, (Composite)this.listCanvas);
        if (this.headerArea != null) {
            this.setupHeader(this.headerArea);
        }
        if (this.syncColumnSizes) {
            TableStructureEventDispatcher.getInstance(this.sTableID).addListener(this);
        }
        this.initializeDefaultRowInfo();
        this.triggerLifeCycleListener(0);
        if (!this.viewVisible && this.listCanvas.isVisible()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    Event e = new Event();
                    e.type = 22;
                    e.widget = ListView.this.listCanvas;
                    ListView.this.lShowHide.handleEvent(e);
                }
            });
        }
    }

    private void initializeDefaultRowInfo() {
        if (this.skinProperties != null) {
            this.rowMarginHeight = this.skinProperties.getIntValue("table." + this.sTableID + ".row.margin.height", this.rowMarginHeight);
            this.rowHeightDefault = this.skinProperties.getIntValue("table." + this.sTableID + ".row.height", this.rowHeightDefault);
            String sID = "color.row.odd.selected.bg";
            this.colorRowSelectedOddBG = this.getSkinColor("table." + this.sTableID + "." + sID, sID);
            sID = "color.row.even.selected.bg";
            this.colorRowSelectedEvenBG = this.getSkinColor("table." + this.sTableID + "." + sID, sID);
            sID = "color.row.odd.selected.fg";
            this.colorRowSelectedOddFG = this.getSkinColor("table." + this.sTableID + "." + sID, sID);
            sID = "color.row.even.selected.fg";
            this.colorRowSelectedEvenFG = this.getSkinColor("table." + this.sTableID + "." + sID, sID);
            sID = "color.row.odd.bg";
            this.colorRowOddBG = this.getSkinColor("table." + this.sTableID + "." + sID, sID);
            sID = "color.row.even.bg";
            this.colorRowEvenBG = this.getSkinColor("table." + this.sTableID + "." + sID, sID);
            sID = "color.row.odd.fg";
            this.colorRowOddFG = this.getSkinColor("table." + this.sTableID + "." + sID, sID);
            sID = "color.row.even.fg";
            this.colorRowEvenFG = this.getSkinColor("table." + this.sTableID + "." + sID, sID);
            sID = "color.row.divider";
            String sID2 = "table." + this.sTableID + "." + sID;
            String val = this.skinProperties.getStringValue(sID2);
            this.colorRowDivider = val != null && val.length() == 0 ? null : this.getSkinColor(sID2, sID);
            sID = "color.row.focus";
            sID2 = "table." + this.sTableID + "." + sID;
            val = this.skinProperties.getStringValue(sID2);
            this.colorRowFocus = val != null && val.length() == 0 ? null : this.getSkinColor(sID2, sID);
            this.rowFocusStyle = this.skinProperties.getStringValue("table." + this.sTableID + ".row.focus.style", "dot").toLowerCase().equals("dot") ? 3 : 1;
        }
        this.colorRowOddBG = this.pickColorIfNull(this.colorRowOddBG, this.colorRowEvenBG, this.display.getSystemColor(25));
        this.colorRowOddFG = this.pickColorIfNull(this.colorRowOddFG, this.colorRowEvenFG, this.display.getSystemColor(24));
        this.colorRowEvenBG = this.pickColorIfNull(this.colorRowEvenBG, this.colorRowOddBG, this.display.getSystemColor(25));
        this.colorRowEvenFG = this.pickColorIfNull(this.colorRowEvenFG, this.colorRowOddFG, this.display.getSystemColor(24));
        this.colorRowSelectedEvenBG = this.pickColorIfNull(this.colorRowSelectedEvenBG, this.colorRowSelectedOddBG, this.display.getSystemColor(26));
        this.colorRowSelectedEvenFG = this.pickColorIfNull(this.colorRowSelectedEvenFG, this.colorRowSelectedOddFG, this.display.getSystemColor(27));
        this.colorRowSelectedOddBG = this.pickColorIfNull(this.colorRowSelectedOddBG, this.colorRowSelectedEvenBG, this.display.getSystemColor(26));
        this.colorRowSelectedOddFG = this.pickColorIfNull(this.colorRowSelectedOddFG, this.colorRowSelectedEvenFG, this.display.getSystemColor(27));
    }

    private Color pickColorIfNull(Color colorMaybeNull, Color replacementColor, Color backupColor) {
        if (colorMaybeNull == null) {
            if (replacementColor != null) {
                return replacementColor;
            }
            return backupColor;
        }
        return colorMaybeNull;
    }

    private Color getSkinColor(String id1, String id2) {
        Color color = this.skinProperties.getColor(id1);
        if (color == null) {
            color = this.skinProperties.getColor(id2);
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResize(boolean bForce) {
        boolean bNeedsRefresh = false;
        if (this.listCanvas == null || this.listCanvas.isDisposed()) {
            return;
        }
        this.clientArea = this.listCanvas.getClientArea();
        if (this.clientArea.width == 0 || this.clientArea.height == 0) {
            return;
        }
        if (this.lastBounds.height != this.clientArea.height || this.bottomRowInfo == null) {
            this.setBottomRowInfo(this.findBottomRow(this.iLastVBarPos, this.clientArea.height));
        }
        boolean needGCImgView = false;
        if (this.imgView == null || bForce) {
            boolean bl = needGCImgView = this.gcImgView != null && !this.gcImgView.isDisposed();
            if (needGCImgView) {
                this.gcImgView.dispose();
            }
            if (this.imgView != null && !this.imgView.isDisposed()) {
                this.imgView.dispose();
            }
            this.imgView = new Image((Device)this.display, this.clientArea);
            this.lastBounds = new Rectangle(0, 0, 0, 0);
            bNeedsRefresh = true;
        } else if (!this.lastBounds.equals((Object)this.clientArea)) {
            boolean bl = needGCImgView = this.gcImgView != null && !this.gcImgView.isDisposed();
            if (needGCImgView) {
                this.gcImgView.dispose();
            }
            bNeedsRefresh = this.lastBounds.height != this.clientArea.height;
            Image newImageView = new Image((Device)this.display, this.clientArea);
            GC gc = null;
            try {
                gc = new GC((Drawable)newImageView);
                gc.setAdvanced(true);
                gc.drawImage(this.imgView, 0, 0);
                Region reg = new Region();
                reg.add(this.clientArea);
                reg.subtract(this.imgView.getBounds());
                gc.setClipping(reg);
                gc.setBackground(this.listCanvas.getBackground());
                gc.fillRectangle(this.clientArea);
                gc.setClipping((Region)null);
                reg.dispose();
            }
            finally {
                if (gc != null) {
                    gc.dispose();
                }
            }
            this.imgView.dispose();
            this.imgView = newImageView;
        }
        if (needGCImgView) {
            this.gcImgView = new GC((Drawable)this.imgView);
        }
        if (bNeedsRefresh) {
            boolean isOurGC = this.gcImgView == null;
            try {
                if (isOurGC) {
                    this.gcImgView = new GC((Drawable)this.imgView);
                }
                this.gcImgView.setForeground(this.listCanvas.getForeground());
                this.gcImgView.setBackground(this.listCanvas.getBackground());
                if (this.lastBounds.isEmpty()) {
                    this.gcImgView.fillRectangle(this.clientArea);
                }
                int y0 = this.iLastVBarPos + this.lastBounds.y + this.lastBounds.height;
                long lStart = System.currentTimeMillis();
                int y = y0;
                int numDrawn = 0;
                RowInfo rowInfo = this.getRowAbsolute(0, y);
                while (rowInfo != null && rowInfo.row.isVisible()) {
                    rowInfo.row.doPaint(this.gcImgView, true);
                    rowInfo = this.getRowAbsolute(0, y += rowInfo.row.getHeight());
                    ++numDrawn;
                }
                int gap = this.clientArea.y + this.clientArea.height - this.totalHeight;
                if (gap > 0) {
                    this.gcImgView.setBackground(this.listCanvas.getBackground());
                    this.gcImgView.fillRectangle(0, this.clientArea.y + this.clientArea.height - gap, this.clientArea.width, gap);
                }
                this.listCanvas.redraw();
                long diff = System.currentTimeMillis() - lStart;
                if (diff > 100L) {
                    this.log(diff + "ms to paint " + numDrawn + " on redraw");
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof IllegalArgumentException)) {
                    Debug.out(ex);
                }
            }
            finally {
                if (isOurGC && this.gcImgView != null) {
                    GC gcDispose = this.gcImgView;
                    this.gcImgView = null;
                    gcDispose.dispose();
                }
            }
        }
        this.lastBounds = this.clientArea;
        if (this.vBar == null || !this.refreshScrollbar()) {
            this.getVisibleColumns();
        }
    }

    private int getBottomRowHeight(int vBarPos) {
        int rowHeight;
        if (this.bottomRowInfo == null) {
            return 0;
        }
        int visibleHeight = vBarPos + this.clientArea.height - this.bottomRowInfo.row.getBasicYPos();
        if (visibleHeight > (rowHeight = this.bottomRowInfo.row.getHeight())) {
            visibleHeight = rowHeight;
        }
        return visibleHeight;
    }

    protected boolean refreshScrollbar() {
        if (!this.viewVisible || this.vBar == null || this.vBar.isDisposed()) {
            return false;
        }
        boolean changed = false;
        if (this.totalHeight < this.clientArea.height || this.clientArea.height == 0) {
            if (this.vBar.isVisible()) {
                this.vBar.setVisible(false);
                this.logPAINT("redraw via refreshScrollbar");
                this.listCanvas.redraw();
                if (this.headerArea != null) {
                    this.headerArea.redraw();
                }
            }
            this.iLastVBarPos = 0;
        } else {
            if (!this.vBar.isVisible()) {
                this.vBar.setVisible(true);
                this.logPAINT("redraw via refreshScrollbar");
                this.listCanvas.redraw();
                if (this.headerArea != null) {
                    this.headerArea.redraw();
                }
                changed = true;
            }
            this.vBar.setIncrement(this.rowHeightDefault);
            int thumb = this.clientArea.height;
            int maximum = this.vBar.getMaximum();
            if (maximum != this.totalHeight) {
                this.vBar.setMaximum(this.totalHeight);
            }
            this.vBar.setThumb(thumb);
            this.vBar.setPageIncrement(this.clientArea.height / 2);
            if (this.iLastVBarPos != this.vBar.getSelection()) {
                this.scrollTo(this.vBar.getSelection());
                changed = true;
            }
        }
        if (changed) {
            this.listCanvas.update();
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollTo(int pos) {
        if (this.vBar == null || !this.vBar.getVisible()) {
            return;
        }
        if (pos == this.iLastVBarPos && pos == this.vBar.getSelection()) {
            return;
        }
        long lTimeStart = System.currentTimeMillis();
        if (pos < 0) {
            System.err.println("scrollto " + pos + " via " + Debug.getCompressedStackTrace());
            pos = 0;
        }
        if (pos != this.vBar.getSelection()) {
            this.vBar.setSelection(pos);
        }
        int iThisVBarPos = this.vBar.getSelection();
        int diff = this.iLastVBarPos - iThisVBarPos;
        this.iLastVBarPos = iThisVBarPos;
        if (diff != 0 && this.imgView != null && !this.imgView.isDisposed()) {
            this.setTopRowInfo(this.findTopRow(this.iLastVBarPos));
            this.setBottomRowInfo(this.findBottomRow(this.iLastVBarPos, this.clientArea.height));
            boolean isOurGC = this.gcImgView == null;
            try {
                if (isOurGC) {
                    this.gcImgView = new GC((Drawable)this.imgView);
                }
                this.scrollToWithGC(this.gcImgView, diff, false, true);
            }
            catch (Exception ex) {
                Debug.out(ex);
            }
            finally {
                if (isOurGC && this.gcImgView != null) {
                    this.gcImgView.dispose();
                    this.gcImgView = null;
                }
            }
            this.logPAINT("redraw via scrollTo");
            this.listCanvas.redraw();
            this.listCanvas.update();
        }
    }

    private RowInfo findTopRow(int atYPos) {
        RowInfo rowInfo = this.getRowAbsolute(0, atYPos);
        if (rowInfo == null) {
            return null;
        }
        return rowInfo;
    }

    private RowInfo findBottomRow(int atYPos, int height) {
        RowInfo rowInfo = this.getRowAbsolute(0, atYPos + height - 1);
        if (rowInfo == null) {
            if (this.rows.size() == 0) {
                return null;
            }
            ListRow row = (ListRow)this.rows.get(this.rows.size() - 1);
            rowInfo = new RowInfo(row, this.rows.size() - 1);
        }
        return rowInfo;
    }

    private void scrollToWithGC(GC gc, int diff, boolean bMoveOnly, boolean bGCisImage) {
        int h;
        Rectangle bounds = this.imgView.getBounds();
        if (diff > 0) {
            h = bounds.height - diff;
            if (h > 0) {
                if (Constants.isOSX) {
                    gc.drawImage(this.imgView, 0, 0, bounds.width, h, 0, diff, bounds.width, h);
                } else {
                    gc.copyArea(0, 0, bounds.width, h, 0, diff);
                }
            }
        } else {
            h = bounds.height + diff;
            if (h > 0) {
                if (Constants.isOSX) {
                    gc.drawImage(this.imgView, 0, -diff, bounds.width, h, 0, 0, bounds.width, h);
                } else {
                    gc.copyArea(0, -diff, bounds.width, h, 0, 0);
                }
            }
        }
        if (bMoveOnly) {
            return;
        }
        this.setBottomRowInfo(this.findBottomRow(this.iLastVBarPos, this.clientArea.height));
        TableRowSWT[] visibleRows = this.getVisibleRows();
        if (diff < 0) {
            int ofs = this.getBottomRowHeight(this.iLastVBarPos);
            int i = visibleRows.length - 1;
            if (i < 0) {
                return;
            }
            ListRow row = (ListRow)visibleRows[i];
            while (diff <= 0) {
                row.doPaint(gc, true);
                if (--i < 0) break;
                diff += ofs;
                row = (ListRow)visibleRows[i];
                ofs = row.getHeight();
            }
            if (i >= 0 && !(row = (ListRow)visibleRows[i]).isValid()) {
                row.doPaint(gc, true);
            }
        } else {
            int i = 0;
            int ofs = this.topRowInfo.row.getHeight() - (this.iLastVBarPos - this.topRowInfo.row.getBasicYPos());
            ListRow row = (ListRow)visibleRows[i];
            while (diff >= 0) {
                row.doPaint(gc, true);
                if (++i >= visibleRows.length) break;
                diff -= ofs;
                row = (ListRow)visibleRows[i];
                ofs = row.getHeight();
            }
        }
    }

    private void setupHeader(final Composite headerArea) {
        this.headerArea = headerArea;
        this.menuHeader = new Menu((Decorations)headerArea.getShell(), 8);
        headerArea.setMenu(this.menuHeader);
        this.menuHeader.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                Object[] items = ListView.this.menuHeader.getItems();
                Utils.disposeSWTObjects(items);
                Point pt = headerArea.toControl(ListView.this.display.getCursorLocation());
                final TableColumnCore inColumn = ListView.this.getColumnHeaderMouseIn(pt.x, pt.y);
                if (inColumn != null) {
                    MenuItem itemSortOn = new MenuItem(ListView.this.menuHeader, 8);
                    Messages.setLanguageText((Widget)itemSortOn, "menu.sortByColumn", new String[]{MessageText.getString(inColumn.getTitleLanguageKey())});
                    itemSortOn.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            ListView.this.setSortColumn(inColumn);
                        }
                    });
                }
                MenuItem itemEdit = new MenuItem(ListView.this.menuHeader, 8);
                itemEdit.setText(MessageText.getString("MyTorrentsView.menu.editTableColumns"));
                itemEdit.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        String tableID = ListView.this.getTableID();
                        TableRowCore focusedRow = ListView.this.getFocusedRow();
                        new TableColumnEditorWindow(ListView.this.getComposite().getShell(), tableID, ListView.this.getAllColumns(), focusedRow, null, TableStructureEventDispatcher.getInstance(tableID));
                    }
                });
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        final Cursor cursor = new Cursor((Device)this.display, 21);
        headerArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Utils.disposeSWTObjects(new Object[]{cursor});
            }
        });
        if (this.bTitleIsMinWidth) {
            this.setColumnMinWidthToHeaders();
        }
        headerArea.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                TableColumnCore inColumn = ListView.this.getColumnHeaderMouseIn(e.x, e.y);
                if (inColumn != null) {
                    ListView.this.setSortColumn(inColumn);
                }
            }
        });
        headerArea.addMouseMoveListener(new MouseMoveListener(){
            Cursor cursor = null;

            public void mouseMove(MouseEvent e) {
                Cursor newCursor;
                boolean inColumn;
                TableColumnCore[] columns = ListView.this.getVisibleColumns();
                int inColumnNo = -1;
                Rectangle bounds = null;
                for (int i = 0; i < columns.length; ++i) {
                    bounds = (Rectangle)headerArea.getData("Column" + i + "Bounds");
                    if (bounds == null || !bounds.contains(e.x, e.y)) continue;
                    inColumnNo = i;
                    break;
                }
                boolean bl = inColumn = inColumnNo != -1;
                if (inColumn) {
                    // empty if block
                }
                Cursor cursor = newCursor = inColumn ? this.cursor : null;
                if (this.cursor != newCursor) {
                    headerArea.setCursor(newCursor);
                    this.cursor = newCursor;
                }
            }
        });
        headerArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TableColumnCore[] columns = ListView.this.lastVisibleColumns;
                if (columns == null) {
                    return;
                }
                Color colorFG = null;
                Color colorDivider = null;
                if (ListView.this.skinProperties != null) {
                    colorFG = ListView.this.skinProperties.getColor("color.list.header.fg");
                    colorDivider = ListView.this.skinProperties.getColor("color.list.header.divider");
                }
                Rectangle clientArea = headerArea.getClientArea();
                int pos = clientArea.x + COLUMN_MARGIN_WIDTH;
                int lastExtraSpace = -1;
                for (int i = 0; i < columns.length; ++i) {
                    Rectangle bounds;
                    int width = columns[i].getWidth();
                    String key = columns[i].getTitleLanguageKey();
                    String text = MessageText.getString(key, "");
                    int align = CoreTableColumn.getSWTAlign(columns[i].getAlignment());
                    int drawWidth = width;
                    Point size = e.gc.textExtent(text);
                    if (size.x > drawWidth && lastExtraSpace > 0) {
                        if (align == 0x1000000) {
                            align = 131072;
                        }
                        int giveSpace = Math.min(lastExtraSpace, size.x - (drawWidth += COLUMN_MARGIN_WIDTH));
                        bounds = new Rectangle(pos - giveSpace, clientArea.y + 2, drawWidth + giveSpace, clientArea.height);
                    } else {
                        bounds = new Rectangle(pos, clientArea.y + 2, drawWidth, clientArea.height);
                    }
                    if (i > 0 && colorDivider != null) {
                        e.gc.setForeground(colorDivider);
                        e.gc.drawLine(pos - 2, clientArea.y + size.y + 7, pos - 2, clientArea.y + clientArea.height);
                    }
                    headerArea.setData("Column" + i + "Bounds", (Object)bounds);
                    if (text.length() > 0) {
                        if (colorFG != null) {
                            e.gc.setForeground(colorFG);
                        }
                        GCStringPrinter.printString(e.gc, text, bounds, false, false, align | 0x80);
                    }
                    int middlePos = bounds.x;
                    if (align == 16384) {
                        lastExtraSpace = bounds.width - size.x;
                        middlePos += size.x / 2;
                    } else if (align == 0x1000000) {
                        lastExtraSpace = (bounds.width - size.x) / 2 + 1;
                        middlePos += bounds.width / 2;
                    } else {
                        lastExtraSpace = 0;
                        middlePos += bounds.width - size.x / 2;
                    }
                    if (columns[i].equals(ListView.this.sortColumn)) {
                        Image img;
                        Image image = img = ListView.this.sortColumn.isSortAscending() ? ListView.this.imgSortAsc : ListView.this.imgSortDesc;
                        if (img != null) {
                            Rectangle imgBounds = img.getBounds();
                            e.gc.drawImage(img, middlePos - imgBounds.width / 2, bounds.height + bounds.y - imgBounds.height - 3);
                        }
                    }
                    pos += width + COLUMN_MARGIN_WIDTH * 2;
                }
            }
        });
    }

    protected TableColumnCore getColumnHeaderMouseIn(int x, int y) {
        TableColumnCore[] columns = this.getVisibleColumns();
        int inColumn = -1;
        for (int i = 0; i < columns.length; ++i) {
            Rectangle bounds = (Rectangle)this.headerArea.getData("Column" + i + "Bounds");
            if (bounds == null || !bounds.contains(x, y)) continue;
            inColumn = i;
            break;
        }
        if (inColumn != -1) {
            return columns[inColumn];
        }
        return null;
    }

    public Menu getTableHeaderMenu() {
        return this.menuHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setColumnMinWidthToHeaders() {
        if (this.headerArea == null) {
            return;
        }
        int sortWidth = Math.max(this.imgSortAsc == null ? -2 : this.imgSortAsc.getBounds().width, this.imgSortDesc == null ? -2 : this.imgSortDesc.getBounds().width) + 2;
        GC gc = new GC((Drawable)this.headerArea);
        try {
            TableColumnCore[] columns = this.getAllColumns();
            if (columns == null) {
                return;
            }
            for (int i = 0; i < columns.length; ++i) {
                TableColumnCore column = columns[i];
                String title = MessageText.getString(column.getTitleLanguageKey(), "");
                int minWidth = gc.textExtent((String)title).x + sortWidth;
                int oldWidth = column.getMinWidth();
                if (minWidth <= oldWidth) continue;
                column.setMinWidth(minWidth);
            }
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveFocus(int relative, boolean moveall) {
        if (moveall) {
            System.err.println("moveall not supported " + Debug.getCompressedStackTrace());
        }
        this.selectedRows_mon.enter();
        try {
            if (this.selectedRows.size() == 0) {
                return;
            }
            ListRow firstRow = (ListRow)this.selectedRows.get(0);
            int index = this.indexOf(firstRow) + relative;
            if (index < 0) {
                index = 0;
            }
            if (index >= this.rows.size()) {
                if (index == 0) {
                    return;
                }
                index = this.rows.size() - 1;
            }
            ListRow newRow = (ListRow)this.rows.get(index);
            this.setSelectedRows(new ListRow[]{newRow});
        }
        finally {
            this.selectedRows_mon.exit();
        }
    }

    public void refreshVisible(final boolean doGraphics, final boolean bForceRedraw, final boolean bAsync) {
        if (this.isDisposed() || !this.viewVisible) {
            return;
        }
        if (this.bInRefreshVisible) {
            this.restartRefreshVisible = new Object[]{new Boolean(doGraphics), new Boolean(bForceRedraw), new Boolean(bAsync)};
            return;
        }
        this.bInRefreshVisible = true;
        AERunnable runnable = new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                int i;
                TableRowSWT[] visibleRows = ListView.this.getVisibleRows();
                try {
                    for (i = 0; i < visibleRows.length; ++i) {
                        if (ListView.this.restartRefreshVisible == null) break block8;
                    }
                }
                catch (Throwable throwable) {
                    ListView.this.bInRefreshVisible = false;
                    if (ListView.this.restartRefreshVisible != null) {
                        Object[] params = ListView.this.restartRefreshVisible;
                        ListView.this.restartRefreshVisible = null;
                        boolean newDoGraphics = (Boolean)params[0] != false || doGraphics;
                        boolean newForceRedraw = (Boolean)params[1] != false || bForceRedraw;
                        boolean newAsync = (Boolean)params[2];
                        ListView.this.refreshVisible(newDoGraphics, newForceRedraw, newAsync);
                    }
                    throw throwable;
                }
                {
                    block8: {
                        ListView.this.bInRefreshVisible = false;
                        if (ListView.this.restartRefreshVisible != null) {
                            Object[] params = ListView.this.restartRefreshVisible;
                            ListView.this.restartRefreshVisible = null;
                            boolean newDoGraphics = (Boolean)params[0] != false || doGraphics;
                            boolean newForceRedraw = (Boolean)params[1] != false || bForceRedraw;
                            boolean newAsync = (Boolean)params[2];
                            ListView.this.refreshVisible(newDoGraphics, newForceRedraw, newAsync);
                        }
                        return;
                    }
                    final ListRow row = (ListRow)visibleRows[i];
                    AERunnable rowRunnable = new AERunnable(){

                        public void runSupport() {
                            if (ListView.this.restartRefreshVisible != null) {
                                return;
                            }
                            if (!row.isVisible()) {
                                ListView.this.restartRefreshVisible = new Object[]{new Boolean(doGraphics), new Boolean(bForceRedraw), new Boolean(bAsync)};
                                return;
                            }
                            if (bForceRedraw) {
                                row.invalidate();
                            }
                            if (row.isVisible()) {
                                ListView.this.rowRefreshAsync(row, doGraphics, bForceRedraw);
                            }
                        }
                    };
                    if (bAsync) {
                        ListView.this.display.asyncExec((Runnable)rowRunnable);
                        continue;
                    }
                    ListView.this.display.syncExec((Runnable)rowRunnable);
                    continue;
                }
                ListView.this.bInRefreshVisible = false;
                if (ListView.this.restartRefreshVisible != null) {
                    Object[] params = ListView.this.restartRefreshVisible;
                    ListView.this.restartRefreshVisible = null;
                    boolean newDoGraphics = (Boolean)params[0] != false || doGraphics;
                    boolean newForceRedraw = (Boolean)params[1] != false || bForceRedraw;
                    boolean newAsync = (Boolean)params[2];
                    ListView.this.refreshVisible(newDoGraphics, newForceRedraw, newAsync);
                }
            }
        };
        if (bAsync) {
            this.display.asyncExec((Runnable)runnable);
        } else {
            this.display.syncExec((Runnable)runnable);
        }
    }

    private void refreshenProcessDataSourcesTimer() {
        if (this.processDataSourceQueueCallback == null) {
            return;
        }
        boolean processQueueImmediately = Utils.addDataSourceAggregated(this.processDataSourceQueueCallback);
        if (processQueueImmediately) {
            this.processDataSourceQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataSourceQueue() {
        Object[] dataSourcesAdd = null;
        Object[] dataSourcesRemove = null;
        try {
            this.row_mon.enter();
            if (this.dataSourcesToAdd.size() > 0) {
                dataSourcesAdd = this.dataSourcesToAdd.toArray();
                this.dataSourcesToAdd.clear();
                if (this.dataSourcesToRemove != null && this.dataSourcesToRemove.size() > 0) {
                    for (int i = 0; i < dataSourcesAdd.length; ++i) {
                        if (!this.dataSourcesToRemove.contains(dataSourcesAdd[i])) continue;
                        this.dataSourcesToRemove.remove(dataSourcesAdd[i]);
                        dataSourcesAdd[i] = null;
                        if (!DEBUGADDREMOVE) continue;
                        this.logADDREMOVE("Saved time by not adding a row that was removed");
                    }
                }
            }
            if (this.dataSourcesToRemove != null && this.dataSourcesToRemove.size() > 0) {
                dataSourcesRemove = this.dataSourcesToRemove.toArray();
                if (DEBUGADDREMOVE && dataSourcesRemove.length > 1) {
                    this.logADDREMOVE("Streamlining removing " + dataSourcesRemove.length + " rows");
                }
                this.dataSourcesToRemove.clear();
            }
        }
        finally {
            this.row_mon.exit();
        }
        if (dataSourcesAdd != null && dataSourcesAdd.length > 0) {
            this.addDataSources(dataSourcesAdd, true);
            if (DEBUGADDREMOVE && dataSourcesAdd.length > 1) {
                this.logADDREMOVE("Streamlined adding " + dataSourcesAdd.length + " rows");
            }
        }
        if (dataSourcesRemove != null && dataSourcesRemove.length > 0) {
            this.reallyRemoveDataSources(dataSourcesRemove);
        }
    }

    public void addDataSource(Object dataSource) {
        this.addDataSources(new Object[]{dataSource}, false);
    }

    public void addDataSource(Object datasource, boolean bImmediate) {
        this.addDataSources(new Object[]{datasource}, bImmediate);
    }

    public void addDataSources(Object[] dataSources) {
        this.addDataSources(dataSources, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSources(Object[] _dataSources, boolean bImmediate) {
        long lTimeStart = System.currentTimeMillis();
        if (_dataSources == null) {
            return;
        }
        if (!bImmediate) {
            int count = 0;
            try {
                this.row_mon.enter();
                if (this.dataSourcesToAdd == null) {
                    this.dataSourcesToAdd = new ArrayList(4);
                }
                for (int i = 0; i < _dataSources.length; ++i) {
                    if (this.mapDataSourceToRow.containsKey(_dataSources[i])) continue;
                    this.dataSourcesToAdd.add(_dataSources[i]);
                    if (!DEBUGADDREMOVE) continue;
                    ++count;
                }
                if (DEBUGADDREMOVE && count > 0) {
                    this.logADDREMOVE(this.sTableID + ": Queueing " + count + " dataSources to add");
                }
                return;
            }
            finally {
                this.row_mon.exit();
                this.refreshenProcessDataSourcesTimer();
            }
        }
        if (DEBUGADDREMOVE) {
            this.logADDREMOVE(this.sTableID + ": Add immediate via " + Debug.getCompressedStackTrace(3));
        }
        final Object[] dataSources = new Object[_dataSources.length];
        System.arraycopy(_dataSources, 0, dataSources, 0, _dataSources.length);
        try {
            this.row_mon.enter();
            for (int i = 0; i < dataSources.length; ++i) {
                Object datasource = dataSources[i];
                if (datasource == null) continue;
                if (this.mapDataSourceToRow.containsKey(datasource)) {
                    dataSources[i] = null;
                    continue;
                }
                this.mapDataSourceToRow.put(datasource, null);
            }
        }
        finally {
            this.row_mon.exit();
        }
        Utils.execSWTThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block15: {
                    int iFirstChange = -1;
                    try {
                        ListView.this.row_mon.enter();
                        for (int i = 0; i < dataSources.length; ++i) {
                            int index;
                            TableCellCore cell;
                            Object datasource = dataSources[i];
                            if (datasource == null) continue;
                            ListRow row = new ListRow(ListView.this, (Composite)ListView.this.listCanvas, datasource);
                            if (ListView.this.rows.size() == 0) {
                                ListView.this.setTopRowInfo(new RowInfo(row, 0));
                                ListView.this.setBottomRowInfo(new RowInfo(row, 0));
                            }
                            if (ListView.this.sortColumn != null && (cell = row.getTableCellCore(ListView.this.sortColumn.getName())) != null) {
                                try {
                                    cell.invalidate();
                                    cell.refresh(true);
                                }
                                catch (Exception e) {
                                    Logger.log(new LogEvent(LOGID, "Minor error adding a row to table " + ListView.this.sTableID, e));
                                }
                            }
                            if (ListView.this.sortColumn == null || ListView.this.rows.size() > 0 && ListView.this.sortColumn.compare(row, ListView.this.rows.get(ListView.this.rows.size() - 1)) >= 0) {
                                index = ListView.this.rows.size();
                            } else {
                                index = Collections.binarySearch(ListView.this.rows, row, ListView.this.sortColumn);
                                if (index < 0) {
                                    index = -1 * index - 1;
                                }
                                if (index > ListView.this.rows.size()) {
                                    index = ListView.this.rows.size();
                                }
                            }
                            if (iFirstChange < 0 || iFirstChange > index) {
                                iFirstChange = index;
                            }
                            ListView.this.rows.add(index, row);
                            ListView.this.logADDREMOVE("addDS pos " + index);
                            ListView.this.mapDataSourceToRow.put(datasource, row);
                            ListView.this.triggerListenerRowAdded(row);
                        }
                        Object var8_8 = null;
                        ListView.this.row_mon.exit();
                        if (iFirstChange < 0) break block15;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        ListView.this.row_mon.exit();
                        if (iFirstChange >= 0) {
                            ListView.this.fixUpPositions(iFirstChange, false);
                        }
                        ListView.this.setBottomRowInfo(ListView.this.findBottomRow(ListView.this.iLastVBarPos, ((ListView)ListView.this).clientArea.height));
                        ListView.this.setTopRowInfo(ListView.this.findTopRow(ListView.this.iLastVBarPos));
                        if (!ListView.this.viewVisible && ListView.this.listCanvas.isVisible() && ListView.this.lShowHide != null) {
                            Event e = new Event();
                            e.type = 22;
                            e.widget = ListView.this.listCanvas;
                            ListView.this.lShowHide.handleEvent(e);
                        }
                        ListView.this.refreshScrollbar();
                        ListView.this.refreshVisible(true, true, true);
                        throw throwable;
                    }
                    ListView.this.fixUpPositions(iFirstChange, false);
                }
                ListView.this.setBottomRowInfo(ListView.this.findBottomRow(ListView.this.iLastVBarPos, ((ListView)ListView.this).clientArea.height));
                ListView.this.setTopRowInfo(ListView.this.findTopRow(ListView.this.iLastVBarPos));
                if (!ListView.this.viewVisible && ListView.this.listCanvas.isVisible() && ListView.this.lShowHide != null) {
                    Event e = new Event();
                    e.type = 22;
                    e.widget = ListView.this.listCanvas;
                    ListView.this.lShowHide.handleEvent(e);
                }
                ListView.this.refreshScrollbar();
                ListView.this.refreshVisible(true, true, true);
            }
        });
        long diff = System.currentTimeMillis() - lTimeStart;
        if (diff > 20L) {
            this.logADDREMOVE("addDS(" + dataSources.length + "): " + diff + "ms");
        }
    }

    protected void logADDREMOVE(String string) {
        if (DEBUGADDREMOVE) {
            System.out.println(System.currentTimeMillis() + ":" + this.sTableID + "] " + string);
        }
    }

    protected void log(String string) {
        System.err.println(System.currentTimeMillis() + ":" + this.sTableID + "] " + string);
    }

    protected void logPAINT(String string) {
    }

    protected void logCOLUMNSIZE(String string) {
    }

    public void removeDataSource(Object dataSource) {
        this.removeDataSources(new Object[]{dataSource});
    }

    public void removeDataSource(Object datasource, boolean bImmediate) {
        this.removeDataSources(new Object[]{datasource});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSources(Object[] dataSources) {
        if (dataSources == null) {
            return;
        }
        try {
            this.row_mon.enter();
            for (int i = 0; i < dataSources.length; ++i) {
                this.dataSourcesToRemove.add(dataSources[i]);
            }
            if (DEBUGADDREMOVE) {
                this.logADDREMOVE("Queued " + dataSources.length + " dataSources to remove.  Total Queued: " + this.dataSourcesToRemove.size());
            }
        }
        finally {
            this.row_mon.exit();
        }
        this.refreshenProcessDataSourcesTimer();
    }

    private void reallyRemoveDataSources(final Object[] dataSources) {
        Utils.execSWTThread(new AERunnable(){

            /*
             * Exception decompiling
             */
            public void runSupport() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 55[SIMPLE_IF_TAKEN]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    public void removeAllDataSources(boolean bImmediate) {
        Utils.execSWTThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ListView.this.row_mon.enter();
                ListView.this.logADDREMOVE("removeAll");
                try {
                    for (Object datasource : ListView.this.mapDataSourceToRow.keySet()) {
                        ListRow row = (ListRow)ListView.this.mapDataSourceToRow.get(datasource);
                        if (row == null) continue;
                        ListView.this.rows.remove(row);
                        row.setSelected(false);
                        row.setFocused(false);
                        row.delete();
                    }
                    ListView.this.mapDataSourceToRow.clear();
                    ListView.this.rows.clear();
                    ListView.this.totalHeight = 0;
                }
                finally {
                    ListView.this.row_mon.exit();
                }
                ListView.this.handleResize(true);
                ListView.this.listCanvas.redraw();
            }
        }, !bImmediate);
    }

    private TableCellMouseEvent createMouseEvent(TableCellSWT cell, Event e, int type) {
        TableCellMouseEvent event2 = new TableCellMouseEvent();
        event2.cell = cell;
        if (cell != null) {
            event2.row = cell.getTableRow();
        }
        event2.eventType = type;
        event2.button = e.button;
        event2.keyboardState = e.stateMask;
        event2.skipCoreFunctionality = false;
        if (cell != null) {
            Rectangle r = cell.getBounds();
            event2.x = e.x - r.x;
            event2.y = e.y - r.y;
            if (event2.x < 0 || event2.y < 0 || event2.x >= r.width || event2.y >= r.height) {
                // empty if block
            }
        }
        return event2;
    }

    public TableRowCore getRow(int x, int y) {
        if (y < 0 || x >= this.clientArea.x + this.clientArea.width || x < 0 || y >= this.clientArea.y + this.clientArea.height) {
            return null;
        }
        RowInfo rowInfo = this.getRowAbsolute(x, this.iLastVBarPos + y);
        if (rowInfo == null) {
            return null;
        }
        if (y > rowInfo.row.getBasicYPos() + rowInfo.row.getHeight()) {
            return null;
        }
        return rowInfo.row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowInfo getRowAbsolute(int x, int y) {
        this.row_mon.enter();
        try {
            ListRow row;
            int numRows = this.rows.size();
            if (numRows == 0) {
                RowInfo rowInfo = null;
                return rowInfo;
            }
            int index = Collections.binarySearch(this.rows, new Long(y), rowYPosComparator);
            if (index < 0 && (index = -1 * index - 2) < 0) {
                index = 0;
            }
            if (index >= numRows) {
                index = numRows;
            }
            if ((row = (ListRow)this.rows.get(index)) == null) {
                RowInfo rowInfo = null;
                return rowInfo;
            }
            if (y > row.getBasicYPos() + row.getHeight()) {
                RowInfo rowInfo = null;
                return rowInfo;
            }
            RowInfo rowInfo = new RowInfo(row, index);
            return rowInfo;
        }
        finally {
            this.row_mon.exit();
        }
    }

    public TableCellSWT getTableCell(int x, int y) {
        ListRow row = (ListRow)this.getRow(x, y);
        if (row == null) {
            return null;
        }
        return row.getTableCellSWT(x, y);
    }

    public TableColumn getTableColumn(String columnName) {
        for (int i = 0; i < this.allColumns.length; ++i) {
            TableColumnCore tc = this.allColumns[i];
            if (!tc.getName().equals(columnName)) continue;
            return tc;
        }
        return null;
    }

    public int indexOf(TableRowCore row) {
        return this.rows.indexOf(row);
    }

    public int size(boolean bIncludeQueue) {
        int size = this.rows.size();
        if (bIncludeQueue) {
            if (this.dataSourcesToAdd != null) {
                size += this.dataSourcesToAdd.size();
            }
            if (this.dataSourcesToRemove != null) {
                size += this.dataSourcesToRemove.size();
            }
        }
        return size;
    }

    public TableRowCore getRow(int position) {
        if (position < 0 || position >= this.rows.size()) {
            return null;
        }
        return (TableRowCore)this.rows.get(position);
    }

    public TableRowCore getRow(Object dataSource) {
        return (ListRow)this.mapDataSourceToRow.get(dataSource);
    }

    public TableRowSWT getRowSWT(Object dataSource) {
        return (TableRowSWT)this.mapDataSourceToRow.get(dataSource);
    }

    public List getSelectedDataSourcesList() {
        return this.getSelectedDataSourcesList(true);
    }

    public List getSelectedDataSourcesList(boolean bCoreDataSource) {
        ArrayList<Object> l = new ArrayList<Object>();
        TableRowCore[] selectedRows = this.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            TableRowCore row = selectedRows[i];
            if (row == null) continue;
            l.add(row.getDataSource(bCoreDataSource));
        }
        return l;
    }

    public Object[] getSelectedDataSources() {
        return this.getSelectedDataSourcesList().toArray();
    }

    public Object[] getSelectedDataSources(boolean bCoreDataSource) {
        return this.getSelectedDataSourcesList(bCoreDataSource).toArray();
    }

    public boolean dataSourceExists(Object dataSource) {
        return this.mapDataSourceToRow.containsKey(dataSource) || this.dataSourcesToAdd.contains(dataSource);
    }

    public SWTSkinProperties getSkinProperties() {
        return this.skinProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableColumnCore[] getVisibleColumns() {
        if (this.lastVisibleColumns == null) {
            return new TableColumnCore[0];
        }
        if (this.adjustingColumns) {
            return this.lastVisibleColumns;
        }
        this.adjustingColumns = true;
        try {
            int i;
            int width;
            int iClientWidth = this.clientArea.width;
            if (iClientWidth <= 0) {
                TableColumnCore[] tableColumnCoreArray = new TableColumnCore[]{};
                return tableColumnCoreArray;
            }
            if (this.lastClientWidth == iClientWidth) {
                TableColumnCore[] tableColumnCoreArray = this.lastVisibleColumns;
                return tableColumnCoreArray;
            }
            this.lastClientWidth = iClientWidth;
            TableColumnManager tcManager = TableColumnManager.getInstance();
            List autoHideOrder = tcManager.getAutoHideOrder(this.sTableID);
            int totalWidthVis = 0;
            int totalMinWidth = 0;
            int totalMinWidthVis = 0;
            int totalPrefWidthVis = 0;
            ArrayList<TableColumnCore> visibleColumnsList = new ArrayList<TableColumnCore>(this.allColumns.length);
            for (int i2 = 0; i2 < this.allColumns.length; ++i2) {
                TableColumnCore column = this.allColumns[i2];
                if (!column.isVisible() && !autoHideOrder.contains(column)) continue;
                visibleColumnsList.add(this.allColumns[i2]);
                int minWidth = column.getMinWidth();
                totalMinWidth += minWidth + COLUMN_PADDING_WIDTH;
                if (!column.isVisible()) continue;
                totalMinWidthVis += minWidth + COLUMN_PADDING_WIDTH;
                totalWidthVis += column.getWidth() + COLUMN_PADDING_WIDTH;
                totalPrefWidthVis += column.getPreferredWidth() + COLUMN_PADDING_WIDTH;
            }
            if (totalMinWidthVis > iClientWidth) {
                for (int pos = 0; totalMinWidthVis > iClientWidth && pos < autoHideOrder.size(); ++pos) {
                    TableColumn columnToHide = (TableColumn)autoHideOrder.get(pos);
                    if (!columnToHide.isVisible()) continue;
                    totalMinWidth -= columnToHide.getMinWidth() + COLUMN_PADDING_WIDTH;
                    totalWidthVis -= columnToHide.getWidth() + COLUMN_PADDING_WIDTH;
                    totalMinWidthVis -= columnToHide.getMinWidth() + COLUMN_PADDING_WIDTH;
                    columnToHide.setVisible(false);
                    visibleColumnsList.remove(columnToHide);
                }
            } else if (totalMinWidth != totalMinWidthVis) {
                for (int i3 = autoHideOrder.size() - 1; i3 >= 0; --i3) {
                    TableColumnCore column = (TableColumnCore)autoHideOrder.get(i3);
                    if (column.isVisible()) continue;
                    TableColumnCore columnToShow = column;
                    int iMinWidth = columnToShow.getMinWidth();
                    this.logCOLUMNSIZE("+++ attempt add column " + column.getName() + ";mw=" + iMinWidth);
                    if (totalMinWidthVis + iMinWidth + COLUMN_PADDING_WIDTH < iClientWidth) {
                        columnToShow.setWidth(iMinWidth);
                        columnToShow.setVisible(true);
                        width = columnToShow.getWidth();
                        totalWidthVis += width + COLUMN_PADDING_WIDTH;
                        totalMinWidthVis += width + COLUMN_PADDING_WIDTH;
                        continue;
                    }
                    break;
                }
            }
            Iterator iter = visibleColumnsList.iterator();
            while (iter.hasNext()) {
                TableColumnCore column = (TableColumnCore)iter.next();
                if (column.isVisible()) continue;
                iter.remove();
            }
            if (totalWidthVis > iClientWidth) {
                int width2;
                int i4;
                int iNeededSpace = totalWidthVis - iClientWidth;
                for (i4 = 0; i4 < visibleColumnsList.size() && iNeededSpace > 0; ++i4) {
                    int diff;
                    TableColumnCore column = (TableColumnCore)visibleColumnsList.get(i4);
                    width2 = column.getWidth();
                    int prefWidth = column.getPreferredWidth();
                    if (prefWidth <= 0 || width2 < prefWidth) continue;
                    int minWidth = column.getMinWidth();
                    if (prefWidth < minWidth) {
                        prefWidth = minWidth;
                    }
                    if ((diff = width2 - prefWidth) > iNeededSpace) {
                        column.setWidth(width2 - iNeededSpace);
                        iNeededSpace = 0;
                        continue;
                    }
                    column.setWidth(prefWidth);
                    iNeededSpace -= diff;
                }
                for (i4 = visibleColumnsList.size() - 1; i4 >= 0 && iNeededSpace > 0; --i4) {
                    int minWidth;
                    TableColumnCore column = (TableColumnCore)visibleColumnsList.get(i4);
                    width2 = column.getWidth();
                    int diff = width2 - (minWidth = column.getMinWidth());
                    if (diff > iNeededSpace) {
                        column.setWidth(width2 - iNeededSpace);
                        iNeededSpace = 0;
                        continue;
                    }
                    column.setWidth(minWidth);
                    iNeededSpace -= diff;
                }
            } else if (totalWidthVis < iClientWidth) {
                int newWidth;
                int expandBy;
                int width3;
                int numExpandableColumns;
                boolean bMoreSpace;
                int iExtraSpace = iClientWidth - totalWidthVis;
                ArrayList<TableColumnCore> expandableColumns = new ArrayList<TableColumnCore>();
                for (int i5 = 0; i5 < visibleColumnsList.size(); ++i5) {
                    int maxWidth;
                    TableColumnCore column = (TableColumnCore)visibleColumnsList.get(i5);
                    width = column.getWidth();
                    if (width == (maxWidth = column.getMaxWidth())) continue;
                    expandableColumns.add(column);
                }
                block12: do {
                    numExpandableColumns = expandableColumns.size();
                    bMoreSpace = false;
                    for (TableColumnCore column : expandableColumns) {
                        int prefWidth;
                        width3 = column.getWidth();
                        if (width3 >= (prefWidth = column.getPreferredWidth())) continue;
                        expandBy = (int)((double)iExtraSpace / (double)numExpandableColumns);
                        if (expandBy == 0) {
                            expandBy = 1;
                        }
                        if ((newWidth = width3 + expandBy) > prefWidth) {
                            expandBy -= newWidth - prefWidth;
                            newWidth = prefWidth;
                        } else {
                            bMoreSpace = true;
                        }
                        column.setWidth(newWidth);
                        --numExpandableColumns;
                        if ((iExtraSpace -= expandBy) > 0) continue;
                        continue block12;
                    }
                } while (bMoreSpace && iExtraSpace > 0);
                if (iExtraSpace > 0) {
                    numExpandableColumns = expandableColumns.size();
                    for (TableColumnCore column : expandableColumns) {
                        width3 = column.getWidth();
                        int maxWidth = column.getMaxWidth();
                        expandBy = (int)((double)iExtraSpace / (double)numExpandableColumns);
                        newWidth = width3 + expandBy;
                        if (maxWidth != -1 && newWidth > maxWidth) {
                            newWidth = maxWidth;
                            expandBy = maxWidth - width3;
                        }
                        column.setWidth(newWidth);
                        expandBy = column.getWidth() - width3;
                        --numExpandableColumns;
                        iExtraSpace -= expandBy;
                    }
                }
            }
            int iPrefWidthsOver = 0;
            int iPrefWidthsUnder = 0;
            int iPrefWidthsOverCount = 0;
            int iPrefWidthsUnderCount = 0;
            int iPrefWidthDiff = 0;
            for (int i6 = 0; i6 < visibleColumnsList.size(); ++i6) {
                TableColumnCore column = (TableColumnCore)visibleColumnsList.get(i6);
                int iPrefWidth = column.getPreferredWidth();
                if (iPrefWidth <= 0) continue;
                int diff = column.getWidth() - iPrefWidth;
                if (diff > 0) {
                    ++iPrefWidthsOverCount;
                    iPrefWidthsOver += diff;
                } else {
                    ++iPrefWidthsUnderCount;
                    iPrefWidthsUnder -= diff;
                }
                iPrefWidthDiff += diff;
            }
            if (iPrefWidthsOver > 0 && iPrefWidthsUnder > 0) {
                int remaining;
                if (iPrefWidthDiff >= 0) {
                    remaining = iPrefWidthsUnder;
                    int adj = remaining / iPrefWidthsOverCount + 1;
                    for (i = 0; i < visibleColumnsList.size(); ++i) {
                        TableColumnCore column = (TableColumnCore)visibleColumnsList.get(i);
                        int iPrefWidth = column.getPreferredWidth();
                        if (iPrefWidth <= 0) continue;
                        int iWidth = column.getWidth();
                        int diff = iWidth - iPrefWidth;
                        if (diff < 0) {
                            diff *= -1;
                            column.setWidth(iPrefWidth);
                            continue;
                        }
                        if (diff <= 0) continue;
                        if (adj > remaining) {
                            column.setWidth(iWidth - remaining);
                        } else {
                            column.setWidth(iWidth - adj);
                        }
                        remaining -= column.getWidth() - iWidth;
                    }
                } else {
                    remaining = iPrefWidthsOver;
                    double pctPerColumn = (double)iPrefWidthsOver / (double)iPrefWidthsUnder;
                    for (int i7 = 0; i7 < visibleColumnsList.size(); ++i7) {
                        TableColumnCore column = (TableColumnCore)visibleColumnsList.get(i7);
                        int iPrefWidth = column.getPreferredWidth();
                        if (iPrefWidth <= 0) continue;
                        int iWidth = column.getWidth();
                        int diff = iWidth - iPrefWidth;
                        if (diff < 0 && remaining > 0) {
                            if (iPrefWidthsUnderCount == 1) {
                                diff = remaining;
                            } else if ((diff = (int)((double)(diff * -1) * pctPerColumn)) > remaining) {
                                diff = remaining;
                            }
                            column.setWidth(iWidth + diff);
                            remaining -= column.getWidth() - iWidth;
                            --iPrefWidthsUnderCount;
                            continue;
                        }
                        if (diff <= 0) continue;
                        column.setWidth(iPrefWidth);
                    }
                }
            }
            HashMap<TableColumnCore, TableColumnMetrics> mapColumnMetricsNew = new HashMap<TableColumnCore, TableColumnMetrics>();
            int iStartPos = COLUMN_MARGIN_WIDTH;
            for (i = 0; i < visibleColumnsList.size(); ++i) {
                TableColumnCore column = (TableColumnCore)visibleColumnsList.get(i);
                int width4 = column.getWidth();
                TableColumnMetrics metrics = new TableColumnMetrics(iStartPos, width4);
                mapColumnMetricsNew.put(column, metrics);
                iStartPos += width4 + COLUMN_PADDING_WIDTH;
            }
            this.mapColumnMetrics = mapColumnMetricsNew;
            this.lastVisibleColumns = new TableColumnCore[visibleColumnsList.size()];
            visibleColumnsList.toArray(this.lastVisibleColumns);
            this.changeColumnIndicator();
            this.logCOLUMNSIZE("refresh " + this.lastVisibleColumns.length + " columns");
            this.refreshVisible(true, true, true);
        }
        finally {
            this.adjustingColumns = false;
        }
        return this.lastVisibleColumns;
    }

    public void setColumnList(TableColumnCore[] columns, String defaultSortColumnID, boolean defaultSortAscending, boolean titleIsMinWidth) {
        this.bTitleIsMinWidth = titleIsMinWidth;
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.addColumns(columns);
        tcManager.ensureIntegrety(this.sTableID);
        this.allColumns = tcManager.getAllTableColumnCoreAsArray(this.dataSourceType, this.sTableID);
        Arrays.sort(this.allColumns, TableColumnManager.getTableColumnOrderComparator());
        ArrayList<TableColumnCore> visibleColumnsList = new ArrayList<TableColumnCore>();
        for (int i = 0; i < this.allColumns.length; ++i) {
            if (this.allColumns[i].getPosition() < 0 || !this.allColumns[i].isVisible()) continue;
            visibleColumnsList.add(this.allColumns[i]);
        }
        this.lastVisibleColumns = visibleColumnsList.toArray(new TableColumnCore[0]);
        String sSortColumn = defaultSortColumnID;
        boolean bSortAscending = defaultSortAscending;
        TableColumnCore tc = tcManager.getTableColumnCore(this.sTableID, sSortColumn);
        if (tc == null) {
            tc = this.lastVisibleColumns[0];
        }
        this.sortColumn = tc;
        this.sortColumn.setSortAscending(bSortAscending);
        if (this.bTitleIsMinWidth) {
            this.setColumnMinWidthToHeaders();
        }
        this.changeColumnIndicator();
    }

    private void changeColumnIndicator() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (ListView.this.headerArea != null && !ListView.this.headerArea.isDisposed()) {
                    ListView.this.headerArea.redraw();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRowCore[] getSelectedRows() {
        this.selectedRows_mon.enter();
        try {
            TableRowCore[] rows = new ListRow[this.selectedRows.size()];
            TableRowCore[] tableRowCoreArray = rows = this.selectedRows.toArray(rows);
            return tableRowCoreArray;
        }
        finally {
            this.selectedRows_mon.exit();
        }
    }

    public int getSelectedRowsSize() {
        return this.selectedRows.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedRows(TableRowCore[] rows) {
        this.selectedRows_mon.enter();
        try {
            ArrayList<TableRowCore> rowsToSelect = new ArrayList<TableRowCore>();
            ArrayList<TableRowCore> rowsToDeselect = new ArrayList<TableRowCore>();
            for (int i = 0; i < rows.length; ++i) {
                rowsToSelect.add(rows[i]);
            }
            TableRowCore[] selectedRows = this.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                TableRowCore tableRowCore = selectedRows[i];
                boolean bStillSelected = false;
                for (int j = 0; j < rows.length; ++j) {
                    TableRowCore row = rows[j];
                    if (!row.equals(tableRowCore)) continue;
                    bStillSelected = true;
                    break;
                }
                if (!bStillSelected) {
                    rowsToDeselect.add(tableRowCore);
                    continue;
                }
                rowsToSelect.remove(tableRowCore);
            }
            this.bSkipSelectionTrigger = true;
            for (ListRow listRow : rowsToDeselect) {
                listRow.setSelected(false);
            }
            for (ListRow listRow : rowsToSelect) {
                listRow.setSelected(true);
            }
            if (rows.length > 0) {
                ((ListRow)rows[0]).setFocused(true);
            }
            this.bSkipSelectionTrigger = false;
            TableRowCore[] rowsToDeselectArray = new TableRowCore[rowsToDeselect.size()];
            rowsToDeselect.toArray(rowsToDeselectArray);
            this.triggerDeselectionListeners(rowsToDeselectArray);
            TableRowCore[] tableRowCoreArray = new TableRowCore[rowsToSelect.size()];
            rowsToSelect.toArray(tableRowCoreArray);
            this.triggerSelectionListeners(tableRowCoreArray);
        }
        finally {
            this.bSkipSelectionTrigger = false;
            this.selectedRows_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rowSetSelected(ListRow row, boolean bSelected) {
        if (row == null || this.selectedRows.indexOf(row) >= 0 == bSelected) {
            return;
        }
        this.selectedRows_mon.enter();
        try {
            if (bSelected) {
                this.selectedRows.add(row);
            } else {
                this.selectedRows.remove(row);
            }
        }
        finally {
            this.selectedRows_mon.exit();
        }
        if (!this.bSkipSelectionTrigger) {
            if (bSelected) {
                this.triggerDeselectionListeners(new TableRowCore[]{row});
            } else {
                this.triggerSelectionListeners(new TableRowCore[]{row});
            }
        }
    }

    public ListRow getRowFocused() {
        return this.rowFocused;
    }

    protected void rowSetFocused(ListRow row) {
        if (row != null) {
            this.rowShow(row);
        }
        this.rowFocused = row;
        this.triggerFocusChangedListeners(row);
    }

    public boolean rowIsSelected(ListRow row) {
        this.selectedRows_mon.enter();
        return this.selectedRows.indexOf(row) >= 0;
    }

    public void rowShow(ListRow row) {
        if (row == null) {
            return;
        }
        int y = row.getBasicYPos();
        int height = row.getHeight();
        if (y < this.iLastVBarPos) {
            this.scrollTo(y);
        } else if (y + height > this.iLastVBarPos + this.clientArea.height) {
            if (y <= this.iLastVBarPos + this.clientArea.height) {
                row = this.topRowInfo.row;
                int y2 = row.getBasicYPos();
                int i = this.topRowInfo.index;
                while (y + height > y2 + this.clientArea.height) {
                    y2 += row.getHeight();
                    row = (ListRow)this.getRow(++i);
                }
                this.scrollTo(y2);
            } else {
                int ofs = 0;
                ListRow rowFocused = this.getRowFocused();
                if (rowFocused != null && (ofs = rowFocused.getBasicYPos() - this.iLastVBarPos) > 0 && ofs < this.clientArea.height) {
                    y -= ofs;
                }
                this.scrollTo(y);
            }
        }
    }

    public boolean isFocused() {
        return this.listCanvas.isFocusControl();
    }

    public String getUpdateUIName() {
        return "ListView";
    }

    public void updateUI() {
        this.refreshTable(false);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.clientArea.x, -this.iLastVBarPos, this.clientArea.width, this.clientArea.height);
    }

    public Rectangle getClientArea() {
        return this.clientArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event2) {
        block32: {
            block31: {
                if (event2.type == 15 || event2.type == 16) {
                    this.selectedRows_mon.enter();
                    try {
                        for (ListRow row : this.selectedRows) {
                            if (row == null) continue;
                            row.redraw();
                        }
                    }
                    finally {
                        this.selectedRows_mon.exit();
                    }
                }
                if (event2.type != 31) break block31;
                event2.doit = true;
                switch (event2.detail) {
                    case 64: {
                        if (event2.stateMask == SWT.MOD2) {
                            ListRow focusedRow = this.getRowFocused();
                            if (focusedRow != null) {
                                ListRow nextRow;
                                int index = focusedRow.getIndex();
                                if ((nextRow = (ListRow)this.getRow(++index)) != null) {
                                    if (nextRow.isSelected()) {
                                        focusedRow.setSelected(false);
                                    }
                                    nextRow.setSelected(true);
                                    nextRow.setFocused(true);
                                    break;
                                }
                            }
                        } else if (event2.stateMask == SWT.MOD1) {
                            ListRow focusedRow = this.getRowFocused();
                            if (focusedRow != null) {
                                ListRow nextRow;
                                int index = focusedRow.getIndex();
                                if ((nextRow = (ListRow)this.getRow(++index)) != null) {
                                    nextRow.setFocused(true);
                                    break;
                                }
                            }
                        } else if (event2.stateMask == 0) {
                            this.moveFocus(1, false);
                            break;
                        }
                        break block32;
                    }
                    case 32: {
                        if (event2.stateMask == SWT.MOD2) {
                            ListRow activeRow = this.getRowFocused();
                            if (activeRow != null) {
                                ListRow previousRow;
                                int index = activeRow.getIndex();
                                if ((previousRow = (ListRow)this.getRow(--index)) != null) {
                                    if (previousRow.isSelected()) {
                                        activeRow.setSelected(false);
                                    }
                                    previousRow.setSelected(true);
                                    previousRow.setFocused(true);
                                    break;
                                }
                            }
                        } else if (event2.stateMask == SWT.MOD1) {
                            ListRow focusedRow = this.getRowFocused();
                            if (focusedRow != null) {
                                ListRow nextRow;
                                int index = focusedRow.getIndex();
                                if ((nextRow = (ListRow)this.getRow(--index)) != null) {
                                    nextRow.setFocused(true);
                                    break;
                                }
                            }
                        } else if (event2.stateMask == 0) {
                            this.moveFocus(-1, false);
                            break;
                        }
                        break block32;
                    }
                    case 4: {
                        this._runDefaultAction(event2.stateMask);
                        break;
                    }
                    default: {
                        System.out.println("TR" + event2.detail);
                        break;
                    }
                }
                break block32;
            }
            if (event2.type == 14) {
                this._runDefaultAction(event2.stateMask);
            }
        }
    }

    private void _runDefaultAction(int stateMask) {
        if (this.lCancelSelectionTriggeredOn > 0L && System.currentTimeMillis() - this.lCancelSelectionTriggeredOn < 200L) {
            this.lCancelSelectionTriggeredOn = -1L;
        } else {
            this.triggerDefaultSelectedListeners(this.getSelectedRows(), stateMask);
        }
    }

    public void setMouseClickIsDefaultSelection(boolean b) {
        this.bMouseClickIsDefaultSelection = b;
    }

    public void addCountChangeListener(TableCountChangeListener listener) {
        this.listenersCountChange.add(listener);
    }

    protected void triggerListenerRowAdded(ListRow row) {
        for (TableCountChangeListener l : this.listenersCountChange) {
            l.rowAdded(row);
        }
    }

    protected void triggerListenerRowRemoved(ListRow row) {
        for (TableCountChangeListener l : this.listenersCountChange) {
            l.rowRemoved(row);
        }
    }

    public Control getControl() {
        return this.listCanvas;
    }

    public String getTableID() {
        return this.sTableID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListRow[] getRowsUnsorted() {
        try {
            this.row_mon.enter();
            ListRow[] listRowArray = this.rows.toArray(new ListRow[0]);
            return listRowArray;
        }
        finally {
            this.row_mon.exit();
        }
    }

    public void columnInvalidate(TableColumnCore tableColumn) {
        if (tableColumn.isVisible()) {
            this.columnInvalidate(tableColumn, true);
        }
    }

    public void columnInvalidate(TableColumnCore tableColumn, final boolean bMustRefresh) {
        if (tableColumn == null) {
            return;
        }
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                TableCellSWT cell = ((TableRowSWT)row).getTableCellSWT(sColumnName);
                if (cell != null) {
                    cell.invalidate(bMustRefresh);
                }
            }
        });
        if (tableColumn.equals(this.getSortColumn())) {
            this.sortTable(true);
        }
    }

    public void columnOrderChanged(int[] iPositions) {
        Arrays.sort(this.allColumns, TableColumnManager.getTableColumnOrderComparator());
        this.logCOLUMNSIZE("Clear lastClientWidth via columnOrdereChanged");
        this.lastClientWidth = 0;
        this.getVisibleColumns();
    }

    public void columnSizeChanged(TableColumnCore tableColumn) {
        if (this.adjustingColumns) {
            return;
        }
        if (this.isDisposed()) {
            return;
        }
        if (!tableColumn.isVisible()) {
            return;
        }
        this.logCOLUMNSIZE("Clear lastClientWidth via columnSizeChanged " + tableColumn.getName());
        this.lastClientWidth = 0;
        this.getVisibleColumns();
    }

    public void tableStructureChanged() {
        this.triggerLifeCycleListener(1);
        this.removeAllTableRows();
        Arrays.sort(this.allColumns, TableColumnManager.getTableColumnOrderComparator());
        this.logCOLUMNSIZE("Clear lastClientWidth via tableStructureChanged");
        this.lastClientWidth = 0;
        this.getVisibleColumns();
        this.triggerLifeCycleListener(0);
    }

    public TableColumnCore getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(TableColumnCore sorter) {
        boolean bSameColumn = this.sortColumn.equals(sorter);
        if (!bSameColumn) {
            this.sortColumn = sorter;
            int iSortDirection = configMan.getIntParameter(CFG_SORTDIRECTION);
            if (iSortDirection == 0) {
                this.sortColumn.setSortAscending(true);
            } else if (iSortDirection == 1) {
                this.sortColumn.setSortAscending(false);
            } else {
                this.sortColumn.setSortAscending(!this.sortColumn.isSortAscending());
            }
            TableColumnManager.getInstance().setDefaultSortColumnName(this.sTableID, this.sortColumn.getName());
        } else {
            this.sortColumn.setSortAscending(!this.sortColumn.isSortAscending());
        }
        this.sortColumn.setLastSortValueChange(SystemTime.getCurrentTime());
        this.changeColumnIndicator();
        this.sortTable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sortTable(boolean bForce) {
        int iFirstChange = -1;
        try {
            this.row_mon.enter();
            if (this.sortColumn != null && (bForce || this.sortColumn.getLastSortValueChange() > this.lLastSortedOn)) {
                this.lLastSortedOn = SystemTime.getCurrentTime();
                if (this.sortColumn != null) {
                    String sColumnID = this.sortColumn.getName();
                    for (TableRowCore row : this.rows) {
                        TableCellCore cell = row.getTableCellCore(sColumnID);
                        if (cell == null) continue;
                        cell.refresh(true);
                    }
                }
                Object[] rowsArray = this.rows.toArray();
                Arrays.sort(rowsArray, this.sortColumn);
                int iNumChanged = 0;
                for (int i = 0; i < rowsArray.length; ++i) {
                    ListRow row = (ListRow)rowsArray[i];
                    if (row == this.rows.get(i)) continue;
                    ++iNumChanged;
                    if (iFirstChange >= 0) continue;
                    iFirstChange = i;
                }
                List<Object> list = Arrays.asList(rowsArray);
                this.rows = list instanceof ArrayList ? (ArrayList)list : new ArrayList<Object>(list);
                if (iFirstChange >= 0) {
                    this.fixUpPositions(iFirstChange, false);
                    this.setTopRowInfo(this.findTopRow(this.iLastVBarPos));
                    this.setBottomRowInfo(this.findBottomRow(this.iLastVBarPos, this.clientArea.height));
                    this.rowShow(this.getRowFocused());
                    this.refreshVisible(true, true, true);
                }
            }
        }
        finally {
            this.row_mon.exit();
        }
        return iFirstChange >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixUpPositions(int startAtIndex, boolean onlyHeight) {
        this.row_mon.enter();
        try {
            int y;
            if (this.rows.size() < startAtIndex || startAtIndex < 0) {
                return;
            }
            if (startAtIndex > 0) {
                ListRow prevRow = (ListRow)this.rows.get(startAtIndex - 1);
                y = prevRow.getBasicYPos() + prevRow.getHeight();
            } else {
                y = 0;
            }
            for (int i = startAtIndex; i < this.rows.size(); ++i) {
                ListRow row = (ListRow)this.rows.get(i);
                row.setBasicYPos(y);
                y += row.getHeight();
                if (onlyHeight) continue;
                row.fixupPosition();
            }
        }
        finally {
            this.row_mon.exit();
        }
    }

    public TableColumnCore[] getAllColumns() {
        return this.allColumns;
    }

    public boolean isRowVisible(TableRowCore row) {
        int iTopIndex;
        if (!this.viewVisible) {
            return false;
        }
        if (row instanceof ListRow) {
            ListRow listRow = (ListRow)row;
            int yPos = listRow.getBasicYPos();
            if (yPos < 0 || yPos >= this.iLastVBarPos + this.clientArea.height) {
                return false;
            }
            int height = listRow.getHeight();
            return yPos + height > this.iLastVBarPos;
        }
        if (this.topRowInfo == null || this.bottomRowInfo == null) {
            return false;
        }
        int i = this.indexOf(row);
        if (i < (iTopIndex = this.topRowInfo.index)) {
            return false;
        }
        if (i == iTopIndex) {
            return true;
        }
        return i <= this.bottomRowInfo.index;
    }

    public TableRowSWT[] getVisibleRows() {
        if (this.listCanvas == null || this.listCanvas.isDisposed() || this.topRowInfo == null || this.bottomRowInfo == null || !this.viewVisible) {
            return new TableRowSWT[0];
        }
        int iBottomIndex = this.bottomRowInfo.index;
        int iTopIndex = this.topRowInfo.index;
        int size = iBottomIndex - iTopIndex + 1;
        if (size <= 0) {
            return new TableRowSWT[0];
        }
        TableRowSWT[] visiblerows = new TableRowSWT[size];
        int pos = 0;
        for (int i = iTopIndex; i <= iBottomIndex; ++i) {
            TableRowSWT row;
            if (i < 0 || i >= this.rows.size() || (row = (TableRowSWT)this.rows.get(i)) == null) continue;
            visiblerows[pos++] = row;
        }
        if (pos <= visiblerows.length) {
            TableRowSWT[] temp = new TableRowSWT[pos];
            System.arraycopy(visiblerows, 0, temp, 0, pos);
            return temp;
        }
        return visiblerows;
    }

    public boolean cellRefresh(final ListCell cell, final boolean bDoGraphics, final boolean bForceRedraw) {
        if (!this.isRowVisible(cell.getRow()) || cell.cell.isDisposed()) {
            return true;
        }
        final Boolean[] b = new Boolean[1];
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                b[0] = new Boolean(ListView.this._cellRefresh(cell, bDoGraphics, bForceRedraw));
            }
        }, false);
        return b[0] == null ? false : b[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _cellRefresh(ListCell cell, boolean bDoGraphics, boolean bForceRedraw) {
        if (this.imgView == null || !cell.isShown()) {
            return true;
        }
        boolean isOurGC = this.gcImgView == null;
        try {
            if (isOurGC) {
                this.gcImgView = new GC((Drawable)this.imgView);
            }
            ((TableCellSWT)cell.cell).doPaint(this.gcImgView);
            Rectangle rect = cell.getBounds();
            if (rect != null) {
                this.logPAINT("redraw via cellRefresh " + rect + ";" + Debug.getCompressedStackTrace());
                this.listCanvas.redraw(rect.x, rect.y, rect.width, rect.height, false);
                this.listCanvas.update();
            }
        }
        catch (Exception e) {
            if (cell instanceof TableCellCore) {
                Debug.out(((TableCellCore)((Object)cell)).getTableColumn().getName(), e);
            } else {
                Debug.out(e);
            }
        }
        finally {
            if (this.gcImgView != null && isOurGC) {
                this.gcImgView.dispose();
                this.gcImgView = null;
            }
        }
        return true;
    }

    public List rowRefresh(final ListRow row, final boolean bDoGraphics, final boolean bForceRedraw) {
        List list = (List)Utils.execSWTThreadWithObject("rowRefresh", new AERunnableObject(){

            public Object runSupport() {
                return ListView.this._rowRefresh(row, bDoGraphics, bForceRedraw);
            }
        });
        return list == null ? new ArrayList() : list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rowRefreshAsync(ListRow row, final boolean bDoGraphics, final boolean bForceRedraw) {
        try {
            this.rowsToRefresh_mon.enter();
            if (this.rowsToRefresh.contains(row)) {
                return;
            }
            this.rowsToRefresh.add(row);
            if (this.rowsToRefresh.size() > 1) {
                return;
            }
        }
        finally {
            this.rowsToRefresh_mon.exit();
        }
        if (!this.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    Object[] rows;
                    try {
                        ListView.this.rowsToRefresh_mon.enter();
                        rows = ListView.this.rowsToRefresh.toArray();
                        ListView.this.rowsToRefresh.clear();
                    }
                    finally {
                        ListView.this.rowsToRefresh_mon.exit();
                    }
                    for (int i = 0; i < rows.length; ++i) {
                        ListRow row = (ListRow)rows[i];
                        if (!row.isVisible()) continue;
                        ListView.this._rowRefresh(row, bDoGraphics, bForceRedraw);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List _rowRefresh(ListRow row, boolean bDoGraphics, boolean bForceRedraw) {
        Rectangle rect;
        List changedItems;
        boolean changed;
        block17: {
            if (this.listCanvas == null || this.listCanvas.isDisposed() || !this.isRowVisible(row)) {
                return Collections.EMPTY_LIST;
            }
            changed = false;
            changedItems = null;
            rect = new Rectangle(this.clientArea.x, this.rowGetVisibleYOffset(row), this.clientArea.width, row.getHeight());
            if (this.imgView != null) {
                boolean isOurGC = this.gcImgView == null || this.gcImgView.isDisposed();
                try {
                    if (isOurGC) {
                        this.gcImgView = new GC((Drawable)this.imgView);
                    }
                    this.gcImgView.setClipping(rect);
                    changedItems = row._refresh(bDoGraphics, true);
                    boolean thisChanged = changedItems.size() > 0;
                    changed |= thisChanged;
                    if (bForceRedraw) {
                        int endPosY;
                        row.doPaint(this.gcImgView, true);
                        if (row.getIndex() == this.rows.size() - 1 && (endPosY = row.getBasicYPos() + row.getHeight()) < this.clientArea.height) {
                            this.gcImgView.setClipping((Rectangle)null);
                            this.gcImgView.setBackground(this.listCanvas.getBackground());
                            this.gcImgView.fillRectangle(0, endPosY, this.clientArea.width, this.clientArea.height - endPosY);
                            this.listCanvas.redraw(0, endPosY, this.clientArea.width, this.clientArea.height - endPosY, false);
                        }
                        break block17;
                    }
                    if (!thisChanged) break block17;
                    String sChanged = "" + row.getIndex() + " ";
                    for (Object item : changedItems) {
                        if (item instanceof TableRowSWT) {
                            sChanged = sChanged + ", r" + ((TableRowSWT)item).getIndex();
                            ((TableRowSWT)item).doPaint(this.gcImgView, true);
                            break;
                        }
                        if (!(item instanceof TableCellSWT)) continue;
                        sChanged = sChanged + "," + item;
                        ((TableCellSWT)item).doPaint(this.gcImgView);
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof IllegalArgumentException)) {
                        Debug.out(e);
                    } else {
                        this.log("Already drawing on image: " + Debug.getCompressedStackTrace());
                    }
                }
                finally {
                    if (isOurGC && this.gcImgView != null) {
                        this.gcImgView.dispose();
                        this.gcImgView = null;
                    }
                }
            }
        }
        if (changed || bForceRedraw) {
            this.logPAINT("redraw via rowRefresh " + rect);
            this.listCanvas.redraw(rect.x, rect.y, rect.width, rect.height, false);
            if (!this.isPaintingCanvas) {
                // empty if block
            }
        }
        return changedItems == null ? new ArrayList() : changedItems;
    }

    protected int rowGetVisibleYOffset(TableRowCore row) {
        ListRow listRow = (ListRow)row;
        int basicYPos = listRow.getBasicYPos();
        return basicYPos - this.iLastVBarPos;
    }

    public void rowHeightChanged(ListRow rowChanged, int oldHeight, int newHeight) {
        this.totalHeight = this.totalHeight - oldHeight + newHeight;
        if (rowChanged.getBasicYPos() < 0) {
            return;
        }
        int startPos = this.indexOf(rowChanged);
        this.fixUpPositions(startPos, true);
        if (this.bottomRowInfo == null || startPos <= this.bottomRowInfo.index) {
            RowInfo newBottomRow = this.findBottomRow(this.iLastVBarPos, this.clientArea.height);
            this.setBottomRowInfo(newBottomRow);
        }
        this.refreshScrollbar();
        this.refreshVisible(true, true, true);
    }

    public Menu createMenu() {
        final Menu menu = new Menu((Decorations)this.listCanvas.getShell(), 8);
        menu.addMenuListener(new MenuListener(){
            boolean bShown = false;

            public void menuHidden(MenuEvent e) {
                this.bShown = false;
                if (Constants.isOSX) {
                    return;
                }
                ListView.this.display.asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        if (bShown || menu.isDisposed()) {
                            return;
                        }
                        MenuItem[] items = menu.getItems();
                        for (int i = 0; i < items.length; ++i) {
                            items[i].dispose();
                        }
                    }
                });
            }

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                this.bShown = true;
                ListView.this.fillMenu(menu);
            }
        });
        return menu;
    }

    public void fillMenu(Menu menu) {
        Object[] listeners = this.listenersMenuFill.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            TableViewSWTMenuFillListener l = (TableViewSWTMenuFillListener)listeners[i];
            l.fillMenu(menu);
        }
    }

    public void addKeyListener(KeyListener listener) {
        if (this.listenersKey.contains(listener)) {
            return;
        }
        this.listenersKey.add(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.listenersKey.remove(listener);
    }

    public void addMenuFillListener(TableViewSWTMenuFillListener l) {
        this.listenersMenuFill.add(l);
    }

    public DragSource createDragSource(int style) {
        return null;
    }

    public DropTarget createDropTarget(int style) {
        return null;
    }

    public Composite getComposite() {
        return this.listParent;
    }

    public TableRowCore getRow(DropTargetEvent event2) {
        return null;
    }

    public Composite getTableComposite() {
        return this.listCanvas;
    }

    public Image obfusticatedImage(Image image, Point shellOffset) {
        return image;
    }

    public void clipboardSelected() {
    }

    public void columnInvalidate(String columnName) {
        TableColumnCore tc = TableColumnManager.getInstance().getTableColumnCore(this.sTableID, columnName);
        if (tc != null) {
            this.columnInvalidate(tc, tc.getType() == 3);
        }
    }

    public void cellInvalidate(TableColumnCore tableColumn, Object data_source) {
        this.cellInvalidate(tableColumn, data_source, true);
    }

    public void cellInvalidate(TableColumnCore tableColumn, final Object data_source, final boolean bMustRefresh) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                TableCellSWT cell = ((TableRowSWT)row).getTableCellSWT(sColumnName);
                if (cell != null && cell.getDataSource() != null && cell.getDataSource().equals(data_source)) {
                    cell.invalidate(bMustRefresh);
                }
            }
        });
    }

    public void delete() {
        this.viewVisible = false;
        this.triggerLifeCycleListener(1);
        try {
            UIFunctionsManager.getUIFunctions().getUIUpdater().removeUpdater(this);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        TableStructureEventDispatcher.getInstance(this.sTableID).removeListener(this);
        this.processDataSourceQueueCallback = null;
        Utils.disposeSWTObjects(new Object[]{this.headerArea, this.listCanvas});
        TableColumnManager.getInstance().saveTableColumns(null, this.sTableID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableCellCore[] getColumnCells(String sColumnName) {
        TableCellCore[] cells = new TableCellCore[this.rows.size()];
        try {
            this.row_mon.enter();
            int i = 0;
            for (TableRowCore row : this.rows) {
                cells[i++] = row.getTableCellCore(sColumnName);
            }
        }
        finally {
            this.row_mon.exit();
        }
        return cells;
    }

    public IView[] getCoreTabViews() {
        return new IView[0];
    }

    public Object[] getDataSources() {
        return this.mapDataSourceToRow.keySet().toArray();
    }

    public Object getFirstSelectedDataSource() {
        Object[] selectedDataSources = this.getSelectedDataSources();
        if (selectedDataSources.length > 0) {
            return selectedDataSources[0];
        }
        return null;
    }

    public TableRowCore getFocusedRow() {
        return this.getRowFocused();
    }

    public String getPropertiesPrefix() {
        return this.sTableID;
    }

    public TableRowCore[] getRows() {
        return this.rows.toArray(new TableRowCore[0]);
    }

    public boolean isDisposed() {
        return this.listCanvas == null || this.listCanvas.isDisposed();
    }

    public boolean isTableFocus() {
        return this.listCanvas.isFocusControl();
    }

    public void refreshTable(final boolean forceSort) {
        if (this.listCanvas.isDisposed() || !this.viewVisible) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (!ListView.this.sortTable(forceSort)) {
                    ListView.this.iGraphicRefresh++;
                    boolean bDoGraphics = ListView.this.iGraphicRefresh % ListView.this.graphicsUpdate == 0;
                    ListView.this.refreshVisible(bDoGraphics, false, true);
                }
            }
        });
    }

    public void removeAllTableRows() {
        this.removeAllDataSources(true);
    }

    public void selectAll() {
        this.setSelectedRows(this.getRowsUnsorted());
    }

    public void setCoreTabViews(IView[] coreTabViews) {
    }

    public void setEnableTabViews(boolean enableTabViews) {
    }

    public void setFocus() {
        this.listCanvas.setFocus();
    }

    public void setRowDefaultHeight(int height) {
        this.rowHeightDefault = height + this.rowMarginHeight * 2;
    }

    public int getRowDefaultHeight() {
        return this.rowHeightDefault;
    }

    public void setRowDefaultIconSize(Point size) {
        this.rowHeightDefault = size.y + this.rowMarginHeight * 2;
    }

    public void updateLanguage() {
    }

    public void generate(IndentWriter writer) {
    }

    public void runForAllRows(TableGroupRowVisibilityRunner runner) {
        TableRowCore[] rows = this.getRows();
        for (int i = 0; i < rows.length; ++i) {
            runner.run(rows[i], rows[i].isVisible());
        }
    }

    public void runForSelectedRows(TableGroupRowRunner runner) {
        TableRowCore[] rows = this.getSelectedRows();
        if (runner.run(rows)) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            runner.run(rows[i]);
        }
    }

    protected TableViewSWTPanelCreator getMainPanelCreator() {
        return this.mainPanelCreator;
    }

    public void setMainPanelCreator(TableViewSWTPanelCreator mainPanelCreator) {
        this.mainPanelCreator = mainPanelCreator;
    }

    public TableColumnMetrics getColumnMetrics(TableColumn column) {
        if (this.mapColumnMetrics.size() == 0) {
            this.getVisibleColumns();
        }
        TableColumnMetrics metrics = (TableColumnMetrics)this.mapColumnMetrics.get(column);
        return metrics;
    }

    public void keyPressed(KeyEvent event2) {
        Object[] listeners = this.listenersKey.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            KeyListener l = (KeyListener)listeners[i];
            l.keyPressed(event2);
            if (event2.doit) continue;
            return;
        }
        int key = event2.character;
        if (key <= 26 && key > 0) {
            key += 96;
        }
        if (event2.stateMask == SWT.MOD1) {
            switch (event2.keyCode) {
                case 97: {
                    this.selectAll();
                    break;
                }
                case 32: {
                    event2.doit = false;
                    ListRow focusedRow = this.getRowFocused();
                    if (focusedRow == null) break;
                    focusedRow.setSelected(!focusedRow.isSelected());
                    break;
                }
                case 0x100000E: {
                    System.out.println(this.sTableID + "] ^F5");
                    this.fixUpPositions(0, true);
                    this.sortTable(true);
                }
            }
        } else {
            switch (event2.keyCode) {
                case 0x1000005: {
                    this.moveFocus(this.getClientArea().height / -this.rowHeightDefault, false);
                    break;
                }
                case 0x1000006: {
                    this.moveFocus(this.getClientArea().height / this.rowHeightDefault, false);
                    break;
                }
                case 0x1000007: {
                    ListRow row = (ListRow)this.rows.get(0);
                    if (row == null) break;
                    this.setSelectedRows(new ListRow[]{row});
                    break;
                }
                case 0x1000008: {
                    ListRow row;
                    int i = this.rows.size();
                    if (i <= 0 || (row = (ListRow)this.rows.get(i - 1)) == null) break;
                    this.setSelectedRows(new ListRow[]{row});
                    break;
                }
                case 0x100000E: {
                    System.out.println(this.sTableID + "] F5");
                    TableRowCore[] rows = this.getSelectedRows();
                    for (int i = 0; i < rows.length; ++i) {
                        rows[i].invalidate();
                        rows[i].refresh(true);
                    }
                    break;
                }
            }
        }
    }

    public void keyReleased(KeyEvent event2) {
        Object[] listeners = this.listenersKey.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            KeyListener l = (KeyListener)listeners[i];
            l.keyReleased(event2);
            if (event2.doit) continue;
            return;
        }
    }

    public TableCellCore getTableCellWithCursor() {
        Point pt = this.display.getCursorLocation();
        pt = this.listCanvas.toControl(pt);
        return this.getTableCell(pt.x, pt.y);
    }

    public Point getTableCellMouseOffset(TableCellSWT tableCell) {
        if (tableCell == null) {
            return null;
        }
        Point pt = this.display.getCursorLocation();
        pt = this.listCanvas.toControl(pt);
        Rectangle bounds = tableCell.getBounds();
        return new Point(pt.x - bounds.x, pt.y - bounds.y);
    }

    public TableRowCore getTableRowWithCursor() {
        Point pt = this.display.getCursorLocation();
        pt = this.listCanvas.toControl(pt);
        return (TableRowSWT)this.getRow(pt.x, pt.y);
    }

    public boolean isColumnShown(TableColumn column) {
        for (int i = 0; i < this.lastVisibleColumns.length; ++i) {
            TableColumnCore tc = this.lastVisibleColumns[i];
            if (tc != column) continue;
            return true;
        }
        return false;
    }

    public boolean isColumnVisible(TableColumn column) {
        return true;
    }

    public int getRowMarginHeight() {
        return this.rowMarginHeight;
    }

    public void setRowMarginHeight(int h) {
        this.rowMarginHeight = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTopRowInfo(RowInfo newTopRowInfo) {
        try {
            this.row_mon.enter();
            if (this.topRowInfo != null && newTopRowInfo.index > this.topRowInfo.index) {
                for (int i = this.topRowInfo.index + 1; i <= newTopRowInfo.index; ++i) {
                    TableRowCore row = this.getRow(i);
                    if (row == null) continue;
                    row.setUpToDate(false);
                }
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        finally {
            this.row_mon.exit();
        }
        this.topRowInfo = newTopRowInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBottomRowInfo(RowInfo newBottomRowInfo) {
        try {
            this.row_mon.enter();
            if (this.bottomRowInfo != null && newBottomRowInfo != null && newBottomRowInfo.index < this.bottomRowInfo.index) {
                for (int i = newBottomRowInfo.index + 1; i <= this.bottomRowInfo.index; ++i) {
                    TableRowCore row = this.getRow(i);
                    if (row == null) continue;
                    row.setUpToDate(false);
                }
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        finally {
            this.row_mon.exit();
        }
        this.bottomRowInfo = newBottomRowInfo;
    }

    public boolean getSyncColumnSizes() {
        return this.syncColumnSizes;
    }

    public void setSyncColumnSizes(boolean syncColumnSizes) {
        this.syncColumnSizes = syncColumnSizes;
        if (syncColumnSizes) {
            TableStructureEventDispatcher.getInstance(this.sTableID).addListener(this);
        } else {
            TableStructureEventDispatcher.getInstance(this.sTableID).removeListener(this);
        }
    }

    public Class getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(Class dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public void addRefreshListener(TableRowRefreshListener listener) {
    }

    public void removeRefreshListener(TableRowRefreshListener listener) {
    }

    static /* synthetic */ int access$2820(ListView x0, int x1) {
        return x0.totalHeight -= x1;
    }

    static /* synthetic */ GC access$3000(ListView x0) {
        return x0.gcImgView;
    }

    static /* synthetic */ GC access$3002(ListView x0, GC x1) {
        x0.gcImgView = x1;
        return x0.gcImgView;
    }

    private class canvasPaintListener
    implements Listener {
        long makeSureWeDraw = -1L;
        Rectangle lastBounds = new Rectangle(0, 0, 0, 0);

        private canvasPaintListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Event e) {
            try {
                ListView.this.isPaintingCanvas = true;
                this.doPaint(e);
            }
            finally {
                ListView.this.isPaintingCanvas = false;
            }
        }

        private void doPaint(Event e) {
            if (ListView.this.imgView == null) {
                e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                return;
            }
            if (ListView.this.vBar != null && !ListView.this.vBar.isDisposed() && ListView.this.vBar.isVisible() && ListView.this.iLastVBarPos != ListView.this.vBar.getSelection()) {
                if (this.makeSureWeDraw < 0L) {
                    this.makeSureWeDraw = SystemTime.getCurrentTime();
                } else if (SystemTime.getCurrentTime() < this.makeSureWeDraw + 3000L) {
                    return;
                }
            }
            if (e.width > 0) {
                this.makeSureWeDraw = -1L;
                e.gc.drawImage(ListView.this.imgView, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
            }
        }
    }

    private class selectionListener
    implements Listener {
        Image imgMove;
        Point mouseDownAt;

        private selectionListener() {
        }

        public void handleEvent(Event e) {
            ListRow row = (ListRow)ListView.this.getRow(e.x, e.y);
            if (row == null) {
                return;
            }
            int mouseEventType = -1;
            switch (e.type) {
                case 5: {
                    break;
                }
                case 3: {
                    boolean MOD4;
                    boolean MOD1 = (e.stateMask & SWT.MOD1) > 0;
                    boolean MOD2 = (e.stateMask & SWT.MOD2) > 0;
                    boolean bl = MOD4 = (e.stateMask & SWT.MOD4) > 0;
                    if (MOD1 && MOD2) {
                        TableCellSWT cell = row.getTableCellSWT(e.x, e.y);
                        if (cell instanceof TableCellImpl) {
                            ((TableCellImpl)cell).bDebug = !((TableCellImpl)cell).bDebug;
                            System.out.println("DEBUG ROW " + cell.getTableColumn().getName() + ":" + row.getIndex() + " " + (((TableCellImpl)cell).bDebug ? "ON" : "OFF"));
                        }
                    } else if (MOD1) {
                        boolean select = !row.isSelected();
                        row.setSelected(select);
                        if (select) {
                            row.setFocused(true);
                        }
                    } else if (MOD2) {
                        ListRow rowFocused = ListView.this.getRowFocused();
                        if (rowFocused == null) {
                            boolean select = !row.isSelected();
                            row.setSelected(select);
                            if (select) {
                                row.setFocused(true);
                            }
                        } else {
                            int idxStart = rowFocused.getIndex();
                            int idxEnd = row.getIndex();
                            if (idxEnd != idxStart) {
                                int dir = idxStart < idxEnd ? 1 : -1;
                                for (int i = idxStart; i != idxEnd; i += dir) {
                                    ListRow rowToSelect = (ListRow)ListView.this.getRow(i);
                                    if (rowToSelect == null) continue;
                                    rowToSelect.setSelected(true);
                                }
                                ListRow rowToSelect = (ListRow)ListView.this.getRow(idxEnd);
                                if (rowToSelect != null) {
                                    rowToSelect.setSelected(true);
                                    rowToSelect.setFocused(true);
                                }
                            }
                        }
                    } else if (!MOD4) {
                        ListView.this.setSelectedRows(new ListRow[]{row});
                    }
                    if (ListView.this.listCanvas.isDisposed()) {
                        return;
                    }
                    ListView.this.listCanvas.setFocus();
                    mouseEventType = 0;
                    break;
                }
                case 4: {
                    mouseEventType = 1;
                    break;
                }
                case 8: {
                    mouseEventType = 2;
                }
            }
            if (mouseEventType != -1) {
                TableCellMouseEvent event2;
                TableCellSWT cell = row.getTableCellSWT(e.x, e.y);
                if (cell != null) {
                    TableColumn tc = cell.getTableColumn();
                    TableCellMouseEvent event3 = ListView.this.createMouseEvent(cell, e, mouseEventType);
                    ((TableColumnCore)tc).invokeCellMouseListeners(event3);
                    cell.invokeMouseListeners(event3);
                    if (event3.skipCoreFunctionality) {
                        ListView.this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                    }
                }
                if ((event2 = ListView.this.createMouseEvent(cell, e, mouseEventType)) != null) {
                    event2.row = row;
                    row.invokeMouseListeners(event2);
                    if (event2.skipCoreFunctionality) {
                        ListView.this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                    }
                }
            }
            if (ListView.this.bMouseClickIsDefaultSelection && e.type == 4) {
                ListView.this._runDefaultAction(e.stateMask);
            }
            if (e.type == 8) {
                ListView.this._runDefaultAction(e.stateMask);
            }
        }
    }

    public static class RowInfo {
        int index;
        ListRow row;

        public RowInfo(ListRow row, int index) {
            this.row = row;
            this.index = index;
        }
    }
}

