/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.buddy.chat.ChatDiscussion;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.config.PlatformBuddyMessenger;
import com.aelitis.azureus.core.messenger.config.VuzeBuddySyncListener;
import com.aelitis.azureus.login.NotLoggedInException;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.buddy.VuzeBuddySWT;
import com.aelitis.azureus.ui.swt.buddy.chat.impl.ChatWindow;
import com.aelitis.azureus.ui.swt.shells.friends.SharePage;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.ui.swt.views.skin.BuddiesViewer;
import com.aelitis.azureus.ui.swt.views.skin.VuzeShareUtils;
import com.aelitis.azureus.util.LoginInfoManager;
import java.io.File;
import java.net.URL;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.shells.InputShell;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class AvatarWidget {
    private static final boolean SHOW_ONLINE_BORDER = System.getProperty("az.buddy.show_online", "1").equals("1");
    protected static final boolean OLD_DRAWNAME = false;
    private Canvas canvas = null;
    private BuddiesViewer viewer = null;
    private Composite parent = null;
    private int highlightBorder = 0;
    private int imageBorder = 1;
    private Point imageSize = null;
    private Point size = null;
    private Point nameAreaSize = null;
    private Rectangle imageBounds = null;
    private Rectangle nameAreaBounds = null;
    private Rectangle chatAreaBounds = null;
    private VuzeBuddySWT vuzeBuddy = null;
    private boolean isActivated = false;
    private boolean isSelected = false;
    private boolean isEnabled = true;
    private boolean isDisposing = false;
    private boolean nameLinkActive = false;
    private Color textColor = null;
    private Color selectedTextColor = null;
    private Color textLinkColor = null;
    private Color imageBorderColor = null;
    private Color selectedColor = null;
    private Color highlightedColor = null;
    private Rectangle decorator_remove_friend = null;
    private Rectangle decorator_add_to_share = null;
    private int alpha = 255;
    private boolean sharedAlready = false;
    private Image image = null;
    private Rectangle sourceImageBounds = null;
    private Menu menu;
    private static Font fontDisplayName;
    private String tooltip_remove_friend;
    private String tooltip_add_to_share;
    private String tooltip;
    private Image removeImage = null;
    private Image add_to_share_Image = null;
    private Image removeImage_normal = null;
    private Image add_to_share_Image_normal = null;
    private Image removeImage_over = null;
    private Image add_to_share_Image_over = null;
    private boolean isDragging = false;
    private Image add_to_share_Image_selected = null;
    private boolean isCreatingFile = false;
    private int creationPercent = 0;
    private ChatWindow chatWindow;
    private ChatDiscussion discussion;
    private SharePage sharePage = null;

    public AvatarWidget(BuddiesViewer viewer, Point avatarSize, Point avatarImageSize, Point avatarNameSize, VuzeBuddySWT vuzeBuddy) {
        if (null == viewer || null == vuzeBuddy) {
            throw new NullPointerException("The variable 'viewer' and 'vuzeBuddy' can not be null");
        }
        this.viewer = viewer;
        if (null == viewer.getControl() || viewer.getControl().isDisposed()) {
            throw new NullPointerException("The given 'viewer' is not properly initialized");
        }
        this.parent = viewer.getControl();
        this.size = avatarSize;
        this.imageSize = avatarImageSize;
        this.nameAreaSize = avatarNameSize;
        this.vuzeBuddy = vuzeBuddy;
        this.canvas = new Canvas(this.parent, 0x20000000);
        this.canvas.setData("AvatarWidget", (Object)this);
        this.init();
    }

    private void init() {
        ImageLoader imageLoader = ImageLoaderFactory.getInstance();
        this.removeImage_normal = imageLoader.getImage("image.buddy.remove");
        this.add_to_share_Image_normal = imageLoader.getImage("image.buddy.add.to.share");
        this.removeImage_over = imageLoader.getImage("image.buddy.remove-over");
        this.add_to_share_Image_selected = imageLoader.getImage("image.buddy.add.to.share-selected");
        this.removeImage = this.removeImage_normal;
        this.add_to_share_Image = this.add_to_share_Image_normal;
        this.tooltip_remove_friend = MessageText.getString("v3.buddies.remove");
        this.tooltip_add_to_share = MessageText.getString("v3.buddies.add.to.share");
        this.tooltip = this.vuzeBuddy.getDisplayName() + " (" + this.vuzeBuddy.getLoginID() + ")";
        this.imageBounds = new Rectangle(this.size.x / 2 - this.imageSize.x / 2, 8, this.imageSize.x, this.imageSize.y);
        this.nameAreaBounds = new Rectangle(this.size.x / 2 - (this.nameAreaSize.x - 6) / 2, this.imageBounds.y + this.imageBounds.height + 2, this.nameAreaSize.x - 6, this.nameAreaSize.y);
        this.decorator_remove_friend = new Rectangle(this.size.x - (this.highlightBorder + this.imageBorder) - 12 - 1, this.highlightBorder + this.imageBorder + 1, 12, 12);
        this.decorator_add_to_share = new Rectangle(this.highlightBorder + this.imageBorder + 1, this.highlightBorder + this.imageBorder + 1, 12, 12);
        this.image = this.vuzeBuddy.getAvatarImage();
        this.sourceImageBounds = null == this.image ? null : this.image.getBounds();
        int operations = 1;
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)this.canvas, operations);
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event2) {
                if (AvatarWidget.this.isCreatingFile) {
                    event2.detail = 0;
                } else {
                    event2.detail = 1;
                    AvatarWidget.this.isDragging = true;
                }
            }

            public void dragOver(DropTargetEvent event2) {
            }

            public void dragLeave(DropTargetEvent event2) {
                AvatarWidget.this.isDragging = false;
            }

            public void dragOperationChanged(DropTargetEvent event2) {
            }

            public void dropAccept(DropTargetEvent event2) {
            }

            public void drop(DropTargetEvent event2) {
                AvatarWidget.this.isDragging = false;
                if (event2.data == null) {
                    event2.detail = 0;
                    return;
                }
                String[] files = null;
                if (event2.data instanceof String[]) {
                    files = (String[])event2.data;
                } else if (event2.data instanceof String) {
                    files = new String[]{(String)event2.data};
                }
                if (files != null) {
                    if (files.length == 1) {
                        try {
                            if (!AvatarWidget.this.isCreatingFile) {
                                MessageBoxShell mb = new MessageBoxShell(AvatarWidget.this.canvas.getShell(), MessageText.getString("v3.buddies.dnd.info.dialog.title"), MessageText.getString("v3.buddies.dnd.info.dialog.text"), new String[]{MessageText.getString("v3.buddies.dnd.info.dialog.ok")}, 0, "v3.buddies.dnd.info", MessageText.getString("v3.buddies.dnd.info.dialog.remember"), false, 0);
                                mb.open();
                                AvatarWidget.this.creationPercent = 0;
                                AvatarWidget.this.isCreatingFile = true;
                                final File file = new File(files[0]);
                                final TOTorrentCreator creator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(file, new URL("dht:"), false);
                                creator.addListener(new TOTorrentProgressListener(){

                                    public void reportCurrentTask(String task_description) {
                                    }

                                    public void reportProgress(int percent_complete) {
                                        AvatarWidget.this.creationPercent = percent_complete;
                                        if (!AvatarWidget.this.canvas.isDisposed()) {
                                            AvatarWidget.this.canvas.getDisplay().asyncExec(new Runnable(){

                                                public void run() {
                                                    AvatarWidget.this.canvas.redraw();
                                                }
                                            });
                                        }
                                    }
                                });
                                new AEThread2("DNDBuddy::Share", true){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run() {
                                        try {
                                            TOTorrent torrent = creator.create();
                                            TorrentUtils.setDecentralised(torrent);
                                            TorrentUtils.setDHTBackupEnabled(torrent, true);
                                            LocaleTorrentUtil.setDefaultTorrentEncoding(torrent);
                                            File v3Shares = new File(SystemProperties.getUserPath(), "v3shares");
                                            if (!v3Shares.exists()) {
                                                v3Shares.mkdirs();
                                            }
                                            TorrentUtils.setFlag(torrent, 1, true);
                                            File torrent_file = new File(v3Shares, file.getName() + ".torrent");
                                            torrent.serialiseToBEncodedFile(torrent_file);
                                            byte[] hash = null;
                                            try {
                                                hash = torrent.getHash();
                                            }
                                            catch (TOTorrentException e1) {
                                                // empty catch block
                                            }
                                            final DownloadManager dm = AzureusCoreFactory.getSingleton().getGlobalManager().addDownloadManager(torrent_file.getAbsolutePath(), hash, file.getAbsolutePath(), 75, true, true, null);
                                            dm.getDownloadState().setFlag(64L, true);
                                            AvatarWidget.this.isSelected = true;
                                            if (!AvatarWidget.this.canvas.isDisposed()) {
                                                AvatarWidget.this.canvas.getDisplay().asyncExec(new Runnable(){

                                                    public void run() {
                                                        try {
                                                            SelectedContentV3 sc = new SelectedContentV3(dm);
                                                            VuzeShareUtils.getInstance().shareTorrent(sc, "buddy-dnd");
                                                        }
                                                        catch (Exception e) {
                                                            e.printStackTrace();
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        finally {
                                            AvatarWidget.this.isCreatingFile = false;
                                        }
                                    }
                                }.start();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            AvatarWidget.this.isCreatingFile = false;
                        }
                        AvatarWidget.this.canvas.redraw();
                    } else {
                        MessageBoxShell mb = new MessageBoxShell(AvatarWidget.this.canvas.getShell(), MessageText.getString("v3.buddies.dnd.multifile.dialog.title"), MessageText.getString("v3.buddies.dnd.multifile.dialog.text"), new String[]{MessageText.getString("v3.buddies.dnd.multifile.dialog.ok")}, 0);
                        mb.open();
                    }
                }
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                boolean showChatIcon;
                if (!AvatarWidget.this.isFullyVisible()) {
                    return;
                }
                try {
                    e.gc.setAntialias(1);
                    e.gc.setAlpha(AvatarWidget.this.getAlpha());
                    e.gc.setInterpolation(2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (AvatarWidget.this.isActivated) {
                    e.gc.setForeground(AvatarWidget.this.highlightedColor);
                    Rectangle bounds = AvatarWidget.this.canvas.getBounds();
                    e.gc.drawRoundRectangle(AvatarWidget.this.highlightBorder, AvatarWidget.this.highlightBorder, bounds.width - 2 * AvatarWidget.this.highlightBorder - 1, bounds.height - 2 * AvatarWidget.this.highlightBorder - 1, 6, 6);
                }
                if (null == AvatarWidget.this.image || AvatarWidget.this.image.isDisposed()) {
                    Debug.out("No avatar image found and no default image supplies?");
                } else if (AvatarWidget.this.viewer.isEditMode()) {
                    e.gc.setAlpha((int)((double)AvatarWidget.this.getAlpha() * 0.7));
                    e.gc.drawImage(AvatarWidget.this.image, 0, 0, ((AvatarWidget)AvatarWidget.this).sourceImageBounds.width, ((AvatarWidget)AvatarWidget.this).sourceImageBounds.height, ((AvatarWidget)AvatarWidget.this).imageBounds.x, ((AvatarWidget)AvatarWidget.this).imageBounds.y, ((AvatarWidget)AvatarWidget.this).imageBounds.width, ((AvatarWidget)AvatarWidget.this).imageBounds.height);
                    e.gc.setAlpha(AvatarWidget.this.getAlpha());
                    if (AvatarWidget.this.imageBorder > 0 && AvatarWidget.this.imageBorderColor != null) {
                        e.gc.setForeground(AvatarWidget.this.imageBorderColor);
                        e.gc.setLineWidth(AvatarWidget.this.imageBorder);
                        e.gc.drawRectangle(((AvatarWidget)AvatarWidget.this).imageBounds.x - AvatarWidget.this.imageBorder, ((AvatarWidget)AvatarWidget.this).imageBounds.y - AvatarWidget.this.imageBorder, ((AvatarWidget)AvatarWidget.this).imageBounds.width + AvatarWidget.this.imageBorder, ((AvatarWidget)AvatarWidget.this).imageBounds.height + AvatarWidget.this.imageBorder);
                        e.gc.setForeground(AvatarWidget.this.canvas.getForeground());
                    }
                } else {
                    e.gc.drawImage(AvatarWidget.this.image, 0, 0, ((AvatarWidget)AvatarWidget.this).sourceImageBounds.width, ((AvatarWidget)AvatarWidget.this).sourceImageBounds.height, ((AvatarWidget)AvatarWidget.this).imageBounds.x, ((AvatarWidget)AvatarWidget.this).imageBounds.y, ((AvatarWidget)AvatarWidget.this).imageBounds.width, ((AvatarWidget)AvatarWidget.this).imageBounds.height);
                    if (AvatarWidget.this.imageBorder > 0 && AvatarWidget.this.imageBorderColor != null) {
                        e.gc.setForeground(AvatarWidget.this.imageBorderColor);
                        e.gc.setLineWidth(AvatarWidget.this.imageBorder);
                        e.gc.drawRectangle(((AvatarWidget)AvatarWidget.this).imageBounds.x - AvatarWidget.this.imageBorder, ((AvatarWidget)AvatarWidget.this).imageBounds.y - AvatarWidget.this.imageBorder, ((AvatarWidget)AvatarWidget.this).imageBounds.width + AvatarWidget.this.imageBorder, ((AvatarWidget)AvatarWidget.this).imageBounds.height + AvatarWidget.this.imageBorder);
                        e.gc.setForeground(AvatarWidget.this.canvas.getForeground());
                    }
                }
                if (AvatarWidget.this.isSharedAlready()) {
                    AvatarWidget.this.add_to_share_Image = AvatarWidget.this.add_to_share_Image_selected;
                } else {
                    AvatarWidget.this.add_to_share_Image = AvatarWidget.this.add_to_share_Image_normal;
                }
                if (AvatarWidget.this.viewer.isEditMode()) {
                    e.gc.drawImage(AvatarWidget.this.removeImage, 0, 0, ((AvatarWidget)AvatarWidget.this).removeImage.getBounds().width, ((AvatarWidget)AvatarWidget.this).removeImage.getBounds().height, ((AvatarWidget)AvatarWidget.this).decorator_remove_friend.x, ((AvatarWidget)AvatarWidget.this).decorator_remove_friend.y, ((AvatarWidget)AvatarWidget.this).decorator_remove_friend.width, ((AvatarWidget)AvatarWidget.this).decorator_remove_friend.height);
                } else if (AvatarWidget.this.viewer.isShareMode()) {
                    e.gc.drawImage(AvatarWidget.this.add_to_share_Image, 0, 0, ((AvatarWidget)AvatarWidget.this).add_to_share_Image.getBounds().width, ((AvatarWidget)AvatarWidget.this).add_to_share_Image.getBounds().height, ((AvatarWidget)AvatarWidget.this).decorator_add_to_share.x, ((AvatarWidget)AvatarWidget.this).decorator_add_to_share.y, ((AvatarWidget)AvatarWidget.this).decorator_add_to_share.width, ((AvatarWidget)AvatarWidget.this).decorator_add_to_share.height);
                }
                if (AvatarWidget.this.nameLinkActive && AvatarWidget.this.isActivated) {
                    e.gc.setForeground(AvatarWidget.this.textLinkColor == null ? AvatarWidget.this.canvas.getForeground() : AvatarWidget.this.textLinkColor);
                    if (!AvatarWidget.this.isDragging) {
                        AvatarWidget.this.canvas.setCursor(AvatarWidget.this.canvas.getDisplay().getSystemCursor(21));
                    }
                } else {
                    if (!AvatarWidget.this.isDragging) {
                        AvatarWidget.this.canvas.setCursor(null);
                    }
                    e.gc.setForeground(AvatarWidget.this.textColor == null ? AvatarWidget.this.canvas.getForeground() : AvatarWidget.this.textColor);
                }
                if (!AvatarWidget.this.isCreatingFile) {
                    e.gc.setFont(fontDisplayName);
                    e.gc.setForeground(AvatarWidget.this.textLinkColor);
                    if (SHOW_ONLINE_BORDER && AvatarWidget.this.vuzeBuddy.isOnline(true)) {
                        GCStringPrinter stringPrinter = new GCStringPrinter(e.gc, "%0 " + AvatarWidget.this.vuzeBuddy.getDisplayName(), AvatarWidget.this.nameAreaBounds, false, false, 0x10000C0);
                        stringPrinter.setImages(new Image[]{ImageRepository.getImage("friend_online_icon")});
                        stringPrinter.printString();
                    } else {
                        GCStringPrinter.printString(e.gc, AvatarWidget.this.vuzeBuddy.getDisplayName(), AvatarWidget.this.nameAreaBounds, false, false, 0x10000C0);
                    }
                } else {
                    Rectangle progressArea = new Rectangle(((AvatarWidget)AvatarWidget.this).nameAreaBounds.x + 5, ((AvatarWidget)AvatarWidget.this).nameAreaBounds.y + 5, ((AvatarWidget)AvatarWidget.this).nameAreaBounds.width - 10, ((AvatarWidget)AvatarWidget.this).nameAreaBounds.height - 10);
                    e.gc.setForeground(AvatarWidget.this.viewer.getColorFileDragBorder());
                    e.gc.drawRectangle(progressArea.x, progressArea.y, progressArea.width, progressArea.height);
                    ++progressArea.x;
                    ++progressArea.y;
                    --progressArea.height;
                    progressArea.width = AvatarWidget.this.creationPercent * (progressArea.width - 1) / 100;
                    e.gc.setBackground(AvatarWidget.this.viewer.getColorFileDragBG());
                    e.gc.fillRectangle(progressArea.x, progressArea.y, progressArea.width, progressArea.height);
                }
                if (AvatarWidget.this.chatWindow != null && AvatarWidget.this.chatWindow.isDisposed()) {
                    AvatarWidget.this.chatWindow = null;
                }
                boolean bl = showChatIcon = !AvatarWidget.this.viewer.isEditMode() && AvatarWidget.this.discussion != null && (AvatarWidget.this.chatWindow != null && !AvatarWidget.this.chatWindow.isDisposed() && AvatarWidget.this.discussion.getNbMessages() > 0 || AvatarWidget.this.discussion.getUnreadMessages() > 0);
                if (showChatIcon) {
                    AvatarWidget.this.chatAreaBounds = new Rectangle(40, 0, 20, 19);
                    int nbMessages = AvatarWidget.this.discussion.getUnreadMessages();
                    if (!(nbMessages <= 0 || AvatarWidget.this.chatWindow != null && AvatarWidget.this.chatWindow.isVisible())) {
                        int startPixel = 0;
                        if (nbMessages >= 10) {
                            e.gc.drawImage(ImageRepository.getImage("large_red_bubble"), 35, -1);
                            startPixel = 49;
                        } else {
                            e.gc.drawImage(ImageRepository.getImage("red_bubble"), 40, 0);
                            startPixel = 52;
                        }
                        e.gc.setForeground(ColorCache.getColor(e.gc.getDevice(), 255, 255, 255));
                        Point textSize = e.gc.stringExtent("" + nbMessages);
                        e.gc.drawText("" + nbMessages, startPixel - textSize.x / 2, 3, true);
                    } else {
                        e.gc.drawImage(ImageRepository.getImage("grey_bubble"), 40, 0);
                    }
                } else {
                    AvatarWidget.this.chatAreaBounds = null;
                }
            }
        });
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (!AvatarWidget.this.isFullyVisible()) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (AvatarWidget.this.viewer.isShareMode()) {
                    AvatarWidget.this.doAddBuddyToShare();
                    return;
                }
                if (AvatarWidget.this.nameAreaBounds.contains(e.x, e.y)) {
                    AvatarWidget.this.doLinkClicked();
                } else if (AvatarWidget.this.decorator_remove_friend.contains(e.x, e.y)) {
                    if (AvatarWidget.this.viewer.isEditMode()) {
                        AvatarWidget.this.doRemoveBuddy();
                    }
                } else if (AvatarWidget.this.decorator_add_to_share.contains(e.x, e.y)) {
                    // empty if block
                }
            }

            public void mouseDown(MouseEvent e) {
                if (AvatarWidget.this.chatAreaBounds != null && AvatarWidget.this.chatAreaBounds.contains(e.x, e.y)) {
                    AvatarWidget.this.doChatClicked();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (!AvatarWidget.this.viewer.isShareMode() && !AvatarWidget.this.viewer.isEditMode()) {
                    AvatarWidget.this.doChatClicked();
                    return;
                }
            }
        });
        this.canvas.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                if (!AvatarWidget.this.isFullyVisible()) {
                    return;
                }
                AvatarWidget.this.isActivated = false;
                AvatarWidget.this.canvas.redraw();
            }

            public void mouseEnter(MouseEvent e) {
                if (!AvatarWidget.this.isFullyVisible()) {
                    return;
                }
                if (!AvatarWidget.this.isActivated) {
                    AvatarWidget.this.isActivated = true;
                    AvatarWidget.this.canvas.redraw();
                }
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){
            private boolean lastActiveState = false;
            private String lastTooltipText = AvatarWidget.access$200(AvatarWidget.this).getToolTipText();

            public void mouseMove(MouseEvent e) {
                if (!AvatarWidget.this.isFullyVisible()) {
                    return;
                }
                if ((e.stateMask & SWT.MOD1) == SWT.MOD1) {
                    return;
                }
                String tooltipText = "";
                tooltipText = AvatarWidget.this.viewer.isShareMode() ? (!AvatarWidget.this.isSharedAlready() ? AvatarWidget.this.tooltip_add_to_share : AvatarWidget.this.tooltip) : (AvatarWidget.this.decorator_remove_friend.contains(e.x, e.y) ? (AvatarWidget.this.viewer.isEditMode() ? AvatarWidget.this.tooltip_remove_friend : AvatarWidget.this.tooltip) : AvatarWidget.this.tooltip);
                if (!tooltipText.equals(this.lastTooltipText)) {
                    AvatarWidget.this.canvas.setToolTipText(tooltipText);
                    this.lastTooltipText = tooltipText;
                }
                Cursor cursor = null;
                if (AvatarWidget.this.nameAreaBounds.contains(e.x, e.y)) {
                    if (!this.lastActiveState) {
                        AvatarWidget.this.nameLinkActive = true;
                        AvatarWidget.this.canvas.redraw();
                        this.lastActiveState = true;
                    }
                } else if (AvatarWidget.this.chatAreaBounds != null && AvatarWidget.this.chatAreaBounds.contains(e.x, e.y)) {
                    cursor = AvatarWidget.this.canvas.getDisplay().getSystemCursor(21);
                } else if (this.lastActiveState) {
                    AvatarWidget.this.nameLinkActive = false;
                    AvatarWidget.this.canvas.redraw();
                    this.lastActiveState = false;
                }
                if (AvatarWidget.this.nameLinkActive) {
                    cursor = AvatarWidget.this.canvas.getDisplay().getSystemCursor(21);
                }
                AvatarWidget.this.canvas.setCursor(cursor);
            }
        });
        this.initMenu();
    }

    public boolean isFullyVisible() {
        return this.viewer.isFullyVisible(this);
    }

    private void initMenu() {
        this.menu = new Menu((Control)this.canvas);
        this.canvas.setMenu(this.menu);
        this.menu.addMenuListener(new MenuListener(){
            boolean bShown = false;

            public void menuHidden(MenuEvent e) {
                this.bShown = false;
                if (Constants.isOSX) {
                    return;
                }
                e.widget.getDisplay().asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        if (bShown || AvatarWidget.this.menu.isDisposed()) {
                            return;
                        }
                        MenuItem[] items = AvatarWidget.this.menu.getItems();
                        for (int i = 0; i < items.length; ++i) {
                            items[i].dispose();
                        }
                    }
                });
            }

            public void menuShown(MenuEvent e) {
                MenuItem[] items = AvatarWidget.this.menu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                this.bShown = true;
                AvatarWidget.this.fillMenu(AvatarWidget.this.menu);
            }
        });
    }

    protected void fillMenu(Menu menu) {
        MenuItem item = new MenuItem(menu, 8);
        item.setEnabled(false);
        item.setText(this.vuzeBuddy.getDisplayName());
        item = new MenuItem(menu, 2);
        Messages.setLanguageText((Widget)item, "v3.buddy.menu.viewprofile");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvatarWidget aw = (AvatarWidget)AvatarWidget.this.canvas.getData("AvatarWidget");
                if (aw != null) {
                    aw.doLinkClicked();
                }
            }
        });
        item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)item, "v3.buddy.menu.viewprofile");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvatarWidget aw = (AvatarWidget)AvatarWidget.this.canvas.getData("AvatarWidget");
                if (aw != null) {
                    aw.doLinkClicked();
                }
            }
        });
        item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)item, "v3.buddy.menu.chat");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvatarWidget aw = (AvatarWidget)AvatarWidget.this.canvas.getData("AvatarWidget");
                if (aw != null) {
                    aw.doChatClicked();
                }
            }
        });
        if (Constants.isCVSVersion()) {
            MenuItem itemMenuDebug = new MenuItem(menu, 64);
            itemMenuDebug.setText("Debug");
            Menu menuCVS = new Menu(menu);
            itemMenuDebug.setMenu(menuCVS);
            item = new MenuItem(menuCVS, 8);
            Messages.setLanguageText((Widget)item, "v3.buddy.menu.remove");
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AvatarWidget aw = (AvatarWidget)AvatarWidget.this.canvas.getData("AvatarWidget");
                    if (aw != null) {
                        AvatarWidget.this.doRemoveBuddy();
                    }
                }
            });
            item = new MenuItem(menuCVS, 8);
            item.setText("Send Activity Message");
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!LoginInfoManager.getInstance().isLoggedIn()) {
                        Utils.openMessageBox(null, 1, "No", "not logged in. no can do");
                        return;
                    }
                    InputShell is = new InputShell("Moo", "Message:");
                    String txt = is.open();
                    if (txt != null) {
                        txt = LoginInfoManager.getInstance().getUserInfo().userName + " says: \n" + txt;
                        VuzeActivitiesEntry entry = new VuzeActivitiesEntry(SystemTime.getCurrentTime(), txt, "Test");
                        System.out.println("sending to " + AvatarWidget.this.vuzeBuddy.getDisplayName());
                        try {
                            AvatarWidget.this.vuzeBuddy.sendActivity(entry);
                        }
                        catch (NotLoggedInException e1) {
                            Debug.out("Shouldn't Happen", e1);
                        }
                    }
                }
            });
            item = new MenuItem(menuCVS, 8);
            item.setText("Sync this buddy (via PK)");
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!LoginInfoManager.getInstance().isLoggedIn()) {
                        Utils.openMessageBox(null, 1, "No", "not logged in. no can do");
                        return;
                    }
                    String pk = AvatarWidget.this.vuzeBuddy.getPublicKeys()[0];
                    final long lastUpdate = AvatarWidget.this.vuzeBuddy.getLastUpdated();
                    try {
                        PlatformBuddyMessenger.sync(new String[]{pk}, new VuzeBuddySyncListener(){

                            public void syncComplete() {
                                Utils.execSWTThread(new AERunnable(){

                                    public void runSupport() {
                                        if (AvatarWidget.this.vuzeBuddy.getLastUpdated() != lastUpdate) {
                                            Utils.openMessageBox(Utils.findAnyShell(), 32, "Yay", "Updated");
                                        } else {
                                            Utils.openMessageBox(Utils.findAnyShell(), 32, "Boo", "Not Updated");
                                        }
                                    }
                                });
                            }
                        });
                    }
                    catch (NotLoggedInException e1) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void doRemoveBuddy() {
        MessageBoxShell mBox = new MessageBoxShell(this.parent.getShell(), MessageText.getString("v3.buddies.remove.buddy.dialog.title"), MessageText.getString("v3.buddies.remove.buddy.dialog.text", new String[]{this.vuzeBuddy.getLoginID()}), new String[]{MessageText.getString("Button.remove"), MessageText.getString("Button.cancel")}, 1);
        mBox.setLeftImage(4);
        if (0 != mBox.open()) {
            return;
        }
        try {
            VuzeBuddyManager.removeBuddy(this.vuzeBuddy, true);
        }
        catch (NotLoggedInException e) {
            Debug.out(e);
        }
    }

    private void doAddBuddyToShare() {
        if (!this.isSharedAlready()) {
            this.viewer.addToShare(this);
            this.sharedAlready = true;
        } else {
            this.viewer.removeFromShare(this.vuzeBuddy);
            this.sharedAlready = false;
        }
        this.canvas.redraw();
        this.canvas.update();
    }

    public void doHover() {
    }

    public void doClick() {
    }

    public void doMouseEnter() {
    }

    public void doDoubleClick() {
    }

    public void doLinkClicked() {
        UIFunctionsSWT uiFunctions;
        if (!this.viewer.isShareMode() && !this.viewer.isAddBuddyMode() && null != (uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT())) {
            String url = this.getVuzeBuddy().getProfileUrl("buddy-bar");
            uiFunctions.viewURL(url, "browse", 0, 0, true, true);
        }
    }

    public void setChatDiscussion(ChatDiscussion discussion) {
        if (this.discussion != discussion) {
            this.discussion = discussion;
        }
        if (discussion.getUnreadMessages() > 0 && this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!AvatarWidget.this.canvas.isDisposed()) {
                        AvatarWidget.this.canvas.redraw();
                    }
                }
            });
        }
    }

    public boolean isChatWindowVisible() {
        return this.chatWindow != null && this.chatWindow.isVisible();
    }

    public void doChatClicked() {
        this.doChatClicked(false);
    }

    public void doChatClicked(boolean noHide) {
        if (!this.viewer.isShareMode() && !this.viewer.isAddBuddyMode()) {
            if (this.chatWindow == null || this.chatWindow.isDisposed()) {
                if (this.discussion == null) {
                    this.discussion = this.viewer.getChat().getChatDiscussionFor(this.vuzeBuddy);
                }
                Display display = this.canvas.getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        AvatarWidget.this.chatWindow = new ChatWindow(AvatarWidget.this, AvatarWidget.this.viewer.getChat(), AvatarWidget.this.discussion);
                    }
                });
            } else if (this.chatWindow.isVisible() && !noHide) {
                this.chatWindow.hide();
            } else {
                this.chatWindow.show();
            }
            this.canvas.redraw();
        }
    }

    public Control getControl() {
        return this.canvas;
    }

    public int getBorderWidth() {
        return this.highlightBorder;
    }

    public void setBorderWidth(int borderWidth) {
    }

    public VuzeBuddySWT getVuzeBuddy() {
        return this.vuzeBuddy;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public void refreshVisual() {
        this.image = this.vuzeBuddy.getAvatarImage();
        this.sourceImageBounds = null == this.image ? null : this.image.getBounds();
        this.tooltip = this.vuzeBuddy.getDisplayName() + " (" + this.vuzeBuddy.getLoginID() + ")";
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (null != AvatarWidget.this.canvas && !AvatarWidget.this.canvas.isDisposed()) {
                    AvatarWidget.this.canvas.redraw();
                }
            }
        });
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(Color selectedTextColor) {
        this.selectedTextColor = selectedTextColor;
    }

    public Color getTextLinkColor() {
        return this.textLinkColor;
    }

    public void setTextLinkColor(Color textLinkColor) {
        this.textLinkColor = textLinkColor;
    }

    public void dispose(boolean animate, final AfterDisposeListener listener) {
        if (null != this.canvas && !this.canvas.isDisposed()) {
            if (this.chatWindow != null && !this.chatWindow.isDisposed()) {
                this.chatWindow.close();
            }
            if (animate) {
                Utils.execSWTThreadLater(0, new AERunnable(){

                    public void runSupport() {
                        AvatarWidget.this.isDisposing = true;
                        while (AvatarWidget.this.alpha > 20 && !AvatarWidget.this.canvas.isDisposed()) {
                            AvatarWidget.this.alpha -= 30;
                            AvatarWidget.this.canvas.redraw();
                            AvatarWidget.this.canvas.update();
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        if (!AvatarWidget.this.canvas.isDisposed()) {
                            AvatarWidget.this.canvas.dispose();
                            AvatarWidget.this.parent.layout(true);
                            if (null != listener) {
                                listener.disposed();
                            }
                        }
                    }
                });
            } else if (!this.canvas.isDisposed()) {
                this.canvas.dispose();
                this.parent.layout(true);
                if (null != listener) {
                    listener.disposed();
                }
            }
        }
    }

    public boolean isSharedAlready() {
        return this.sharedAlready;
    }

    public void setSharedAlready(boolean sharedAlready) {
        this.sharedAlready = sharedAlready;
        this.refreshVisual();
    }

    public void setVuzeBuddy(VuzeBuddySWT vuzeBuddy) {
        if (null != vuzeBuddy) {
            this.vuzeBuddy = vuzeBuddy;
            this.refreshVisual();
        }
    }

    public Point getAvatarImageSize() {
        return this.imageSize;
    }

    public void setAvatarImageSize(Point avatarImageSize) {
        this.imageSize = avatarImageSize;
    }

    public Point getAvatarNameSize() {
        return this.nameAreaSize;
    }

    public void setAvatarNameSize(Point avatarNameSize) {
        this.nameAreaSize = avatarNameSize;
    }

    public Image getAvatarImage() {
        return this.image;
    }

    public void setAvatarImage(Image avatarImage) {
        this.image = avatarImage;
    }

    public Color getImageBorderColor() {
        return this.imageBorderColor;
    }

    public void setImageBorderColor(Color imageBorderColor) {
        this.imageBorderColor = imageBorderColor;
    }

    public int getAvatarImageBorder() {
        return this.imageBorder;
    }

    public void setAvatarImageBorder(int avatarImageBorder) {
        this.imageBorder = avatarImageBorder;
    }

    public int getImageBorder() {
        return this.imageBorder;
    }

    public void setImageBorder(int imageBorder) {
        this.imageBorder = imageBorder;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
    }

    public Color getHighlightedColor() {
        return this.highlightedColor;
    }

    public void setHighlightedColor(Color highlightedColor) {
        this.highlightedColor = highlightedColor;
    }

    public boolean isEnabled() {
        if (!this.isEnabled) {
            return this.isEnabled;
        }
        return this.viewer.isEnabled();
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    private int getAlpha() {
        if (!this.isDisposing) {
            this.alpha = true == this.isEnabled() ? 255 : 128;
        }
        return this.alpha;
    }

    public void setSharePage(SharePage sharePage) {
        this.sharePage = sharePage;
    }

    static {
        ImageRepository.addPath("com/aelitis/azureus/ui/images/friend_online_icon.png", "friend_online_icon");
        ImageRepository.addPath("com/aelitis/azureus/ui/images/grey_bubble.png", "grey_bubble");
        ImageRepository.addPath("com/aelitis/azureus/ui/images/red_bubble.png", "red_bubble");
        ImageRepository.addPath("com/aelitis/azureus/ui/images/large_red_bubble.png", "large_red_bubble");
    }

    public static interface AfterDisposeListener {
        public void disposed();
    }
}

