/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.views.TorrentListView;
import com.aelitis.azureus.ui.swt.views.TorrentListViewListener;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.util.PublishUtils;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Utils;

public class ManageCdList
extends SkinView {
    private SWTSkinObjectText lblCountAreaNotOurs;
    private SWTSkinObjectText lblCountAreaOurs;
    private TorrentListView view;
    private String PREFIX = "manage-cd-";
    private SWTSkinObjectText statusObject;
    private AzureusCore core;
    private boolean bShowMyPublished = false;

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        SWTSkin skin = skinObject.getSkin();
        this.core = AzureusCoreFactory.getSingleton();
        skinObject = skin.getSkinObject(this.PREFIX + "titlextra");
        if (skinObject != null) {
            this.lblCountAreaNotOurs = (SWTSkinObjectText)skinObject;
            SWTSkinButtonUtility btnCountAreaNotOurs = new SWTSkinButtonUtility(skinObject);
            btnCountAreaNotOurs.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    if (ManageCdList.this.bShowMyPublished) {
                        ManageCdList.this.bShowMyPublished = false;
                        ManageCdList.this.lblCountAreaOurs.switchSuffix("", 1, true);
                        ManageCdList.this.lblCountAreaNotOurs.switchSuffix("-selected", 1, true);
                        ManageCdList.this.view.regetDownloads();
                    }
                }
            });
        }
        this.lblCountAreaNotOurs.switchSuffix("-selected", 1, true);
        skinObject = skin.getSkinObject(this.PREFIX + "titlextra-2");
        if (skinObject != null) {
            this.lblCountAreaOurs = (SWTSkinObjectText)skinObject;
            SWTSkinButtonUtility btnCountAreaOurs = new SWTSkinButtonUtility(skinObject);
            btnCountAreaOurs.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    if (!ManageCdList.this.bShowMyPublished) {
                        ManageCdList.this.bShowMyPublished = true;
                        ManageCdList.this.lblCountAreaNotOurs.switchSuffix("", 1, true);
                        ManageCdList.this.lblCountAreaOurs.switchSuffix("-selected", 1, true);
                        ManageCdList.this.view.regetDownloads();
                    }
                }
            });
        }
        this.view = new TorrentListView(this, this.PREFIX, 1, false, true){

            public boolean isOurDownload(DownloadManager dm) {
                if (dm == null) {
                    Debug.out("DM == null");
                    return false;
                }
                boolean bDownloadComplete = dm.isDownloadComplete(false);
                boolean isPublished = PublishUtils.isPublished(dm);
                try {
                    return bDownloadComplete && isPublished == ManageCdList.this.bShowMyPublished;
                }
                catch (Exception e) {
                    Debug.out("STUPID ERROR", e);
                    return false;
                }
            }
        };
        this.view.addListener(new TorrentListViewListener(){
            boolean countChanging = false;

            public void countChanged() {
                if (this.countChanging) {
                    return;
                }
                this.countChanging = true;
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        countChanging = false;
                        long totalOurs = 0L;
                        long totalNotOurs = 0L;
                        GlobalManager globalManager = ManageCdList.this.core.getGlobalManager();
                        Object[] dms = globalManager.getDownloadManagers().toArray();
                        for (int i = 0; i < dms.length; ++i) {
                            DownloadManager dm = (DownloadManager)dms[i];
                            if (!dm.isDownloadComplete(false)) continue;
                            if (PublishUtils.isPublished(dm)) {
                                ++totalOurs;
                                continue;
                            }
                            ++totalNotOurs;
                        }
                        if (ManageCdList.this.lblCountAreaOurs != null) {
                            ManageCdList.this.lblCountAreaOurs.setText(MessageText.getString("v3.MainWindow." + ManageCdList.this.PREFIX + "ours.count", new String[]{"" + totalOurs}));
                        }
                        if (ManageCdList.this.lblCountAreaNotOurs != null) {
                            ManageCdList.this.lblCountAreaNotOurs.setText(MessageText.getString("v3.MainWindow." + ManageCdList.this.PREFIX + "notours.count", new String[]{"" + totalNotOurs}));
                            ManageCdList.this.lblCountAreaNotOurs.getControl().getParent().layout(true, true);
                        }
                    }
                });
            }
        });
        skinObject = skin.getSkinObject(this.PREFIX + "status");
        if (skinObject instanceof SWTSkinObjectText) {
            this.statusObject = (SWTSkinObjectText)skinObject;
            this.view.addListener(new TorrentListViewListener(){

                public void stateChanged(DownloadManager manager) {
                    TableRowCore[] selectedRows = ManageCdList.this.view.getSelectedRows();
                    ManageCdList.this.updateStatusText(selectedRows.length == 1 ? selectedRows[0] : null);
                }
            });
        }
        this.view.addSelectionListener(new TableSelectionAdapter(){

            public void deselected(TableRowCore[] row) {
                this.update();
            }

            public void selected(TableRowCore[] row) {
                this.update();
            }

            public void focusChanged(TableRowCore focusedRow) {
                this.update();
            }

            private void update() {
                TableRowCore[] rows = ManageCdList.this.view.getSelectedRows();
                if (rows.length == 0 || rows.length > 1) {
                    ManageCdList.this.updateStatusText(null);
                } else {
                    ManageCdList.this.updateStatusText(rows[0]);
                }
            }
        }, true);
        return null;
    }

    protected void updateStatusText(TableRowCore row) {
        if (row != null) {
            DownloadManager dm = (DownloadManager)row.getDataSource(true);
            this.statusObject.setText(DisplayFormatters.formatDownloadStatus(dm));
        } else {
            this.statusObject.setTextID("v3.MainWindow." + this.PREFIX + "status.noselection");
        }
    }
}

