/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.views.skin.SBC_LibraryView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.DataSourceUtils;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;

public class MyTorrentsView_Big
extends MyTorrentsView {
    private final int torrentFilterMode;

    public MyTorrentsView_Big(AzureusCore _azureus_core, int torrentFilterMode, TableColumnCore[] basicItems) {
        this.torrentFilterMode = torrentFilterMode;
        this.init(_azureus_core, SBC_LibraryView.getTableIdFromFilterMode(torrentFilterMode, true), torrentFilterMode != 2, basicItems);
    }

    public boolean isOurDownloadManager(DownloadManager dm) {
        if (PlatformTorrentUtils.getAdId(dm.getTorrent()) != null || PlatformTorrentUtils.isUpdateDM(dm)) {
            return false;
        }
        if (this.torrentFilterMode == 3) {
            if (PlatformTorrentUtils.getHasBeenOpened(dm)) {
                return false;
            }
        } else if (this.torrentFilterMode == 0) {
            return this.isInCurrentCategory(dm) && this.filterCheck(dm);
        }
        return super.isOurDownloadManager(dm);
    }

    protected TableViewSWT createTableView(TableColumnCore[] basicItems) {
        String tableID;
        switch (this.torrentFilterMode) {
            case 1: {
                tableID = "MySeeders.big";
                break;
            }
            case 2: {
                tableID = "MyTorrents.big";
                break;
            }
            case 3: {
                tableID = "Unopened.big";
                break;
            }
            case 0: {
                tableID = "MyLibrary.big";
                break;
            }
            default: {
                tableID = "bad";
            }
        }
        TableViewSWTImpl tv = new TableViewSWTImpl(tableID, "MyTorrentsView_Big", basicItems, "#", 268503042);
        return tv;
    }

    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        if (!this.isSeedingView) {
            return;
        }
        if (rows == null || rows.length > 1 || rows.length == 0) {
            return;
        }
        Object ds = rows[0].getDataSource(true);
        DownloadManager dm = DataSourceUtils.getDM(ds);
        if (dm.getAssumedComplete() || (stateMask & 0x40000) > 0) {
            TorrentListViewsUtils.playOrStreamDataSource(ds, null, "dblclick");
        }
    }

    protected int getRowDefaultHeight() {
        return 36;
    }
}

