/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesListener;
import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.ui.common.RememberedDecisionsManager;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.columns.utils.TableColumnCreatorV3;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import java.util.ArrayList;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.IconBarEnabler;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.InputShell;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;

public class SBC_ActivityTableView
extends SkinView
implements UIUpdatable,
IconBarEnabler,
VuzeActivitiesListener {
    private static final String TABLE_ID_PREFIX = "activity-";
    private TableViewSWT view;
    private String tableID;
    private Composite viewComposite;
    private int viewMode = 0;

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        skinObject.addListener(new SWTSkinObjectListener(){

            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    SelectedContentManager.changeCurrentlySelectedContent(SBC_ActivityTableView.this.tableID, SBC_ActivityTableView.this.getCurrentlySelectedContent(), SBC_ActivityTableView.this.view);
                } else if (eventType == 1) {
                    SelectedContentManager.changeCurrentlySelectedContent(SBC_ActivityTableView.this.tableID, null, SBC_ActivityTableView.this.view);
                }
                return null;
            }
        });
        SWTSkinObject soParent = skinObject.getParent();
        Object data = soParent.getControl().getData("ViewMode");
        if (data instanceof Long) {
            this.viewMode = (int)((Long)data).longValue();
        }
        boolean big = this.viewMode == -1;
        this.tableID = big ? "Activity.big" : "Activity";
        TableColumnCore[] columns = big ? TableColumnCreatorV3.createActivityBig(this.tableID) : TableColumnCreatorV3.createActivitySmall(this.tableID);
        this.view = new TableViewSWTImpl(this.tableID, this.tableID, columns, "name", 0x10010002);
        this.view.setRowDefaultHeight(big ? 50 : 32);
        this.view.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                InputShell is;
                String txt;
                if (e.keyCode == 127) {
                    SBC_ActivityTableView.this.removeSelected();
                } else if (e.keyCode == 0x100000E) {
                    if ((e.stateMask & 0x20000) > 0) {
                        VuzeActivitiesManager.resetRemovedEntries();
                    }
                    if ((e.stateMask & 0x40000) > 0) {
                        System.out.println("pull all vuze news entries");
                        VuzeActivitiesManager.pullActivitiesNow(2592000000L, 0L);
                    } else {
                        System.out.println("pull latest vuze news entries");
                        VuzeActivitiesManager.pullActivitiesNow(0L);
                    }
                } else if (e.keyCode == 0x100000B && (txt = (is = new InputShell("Moo", "url:")).open()) != null) {
                    UIFunctionsManagerSWT.getUIFunctionsSWT().viewURL(txt, "minibrowse", 0, 0, false, false);
                }
            }
        });
        this.view.addSelectionListener(new TableSelectionAdapter(){

            public void selected(TableRowCore[] rows) {
                this.selectionChanged();
                for (int i = 0; i < rows.length; ++i) {
                    VuzeActivitiesEntry entry = (VuzeActivitiesEntry)rows[i].getDataSource(true);
                    if (entry.isRead() || !entry.canFlipRead()) continue;
                    entry.setRead(true);
                }
            }

            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                if (rows.length == 1) {
                    TorrentListViewsUtils.playOrStreamDataSource(rows[0].getDataSource(), null);
                }
            }

            public void deselected(TableRowCore[] rows) {
                this.selectionChanged();
            }

            public void selectionChanged() {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        ISelectedContent[] contents = SBC_ActivityTableView.this.getCurrentlySelectedContent();
                        if (SBC_ActivityTableView.this.soMain.isVisible()) {
                            SelectedContentManager.changeCurrentlySelectedContent(SBC_ActivityTableView.this.tableID, contents, SBC_ActivityTableView.this.view);
                        }
                    }
                });
            }
        }, false);
        this.view.addLifeCycleListener(new TableLifeCycleListener(){

            public void tableViewInitialized() {
                SBC_ActivityTableView.this.view.addDataSources(VuzeActivitiesManager.getAllEntries());
            }

            public void tableViewDestroyed() {
            }
        });
        SWTSkinObjectContainer soContents = new SWTSkinObjectContainer(this.skin, this.skin.getSkinProperties(), this.getUpdateUIName(), "", this.soMain);
        this.skin.layout();
        this.viewComposite = soContents.getComposite();
        this.viewComposite.setBackground(this.viewComposite.getDisplay().getSystemColor(22));
        this.viewComposite.setForeground(this.viewComposite.getDisplay().getSystemColor(21));
        this.viewComposite.setLayoutData((Object)Utils.getFilledFormData());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.viewComposite.setLayout((Layout)gridLayout);
        this.view.initialize(this.viewComposite);
        VuzeActivitiesManager.addListener(this);
        return super.skinObjectInitialShow(skinObject, params);
    }

    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        this.view.delete();
        return super.skinObjectDestroyed(skinObject, params);
    }

    public String getUpdateUIName() {
        return this.tableID;
    }

    public void updateUI() {
        this.view.refreshTable(false);
    }

    public boolean isEnabled(String itemKey) {
        return false;
    }

    public boolean isSelected(String itemKey) {
        return false;
    }

    public void itemActivated(String itemKey) {
    }

    public ISelectedContent[] getCurrentlySelectedContent() {
        if (this.view == null) {
            return null;
        }
        ArrayList<SelectedContentV3> listContent = new ArrayList<SelectedContentV3>();
        Object[] selectedDataSources = this.view.getSelectedDataSources(true);
        for (int i = 0; i < selectedDataSources.length; ++i) {
            VuzeActivitiesEntry ds = (VuzeActivitiesEntry)selectedDataSources[i];
            if (ds == null) continue;
            try {
                SelectedContentV3 currentContent = ds.createSelectedContentObject();
                if (currentContent == null) continue;
                listContent.add(currentContent);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return listContent.toArray(new ISelectedContent[listContent.size()]);
    }

    public void vuzeNewsEntriesAdded(VuzeActivitiesEntry[] entries) {
        this.view.addDataSources(entries);
    }

    public void vuzeNewsEntriesRemoved(VuzeActivitiesEntry[] entries) {
        this.view.removeDataSources(entries);
        this.view.processDataSourceQueue();
    }

    public void vuzeNewsEntryChanged(VuzeActivitiesEntry entry) {
        TableRowCore row = this.view.getRow(entry);
        if (row != null) {
            row.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSelected() {
        Shell shell = this.view.getComposite().getShell();
        Cursor oldCursor = shell.getCursor();
        try {
            Object[] selectedDataSources = this.view.getSelectedDataSources();
            VuzeActivitiesEntry[] entriesToRemove = new VuzeActivitiesEntry[selectedDataSources.length];
            int entriesToRemovePos = 0;
            shell.setCursor(shell.getDisplay().getSystemCursor(1));
            int rememberedDecision = RememberedDecisionsManager.getRememberedDecision(this.tableID + "-Remove");
            if (rememberedDecision == 0) {
                try {
                    for (int i = 0; i < selectedDataSources.length; ++i) {
                        VuzeActivitiesEntry entry;
                        boolean isHeader;
                        if (!(selectedDataSources[i] instanceof VuzeActivitiesEntry) || (isHeader = "Header".equals((entry = (VuzeActivitiesEntry)selectedDataSources[i]).getTypeID()))) continue;
                        entriesToRemove[entriesToRemovePos++] = entry;
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            } else {
                try {
                    for (int i = 0; i < selectedDataSources.length; ++i) {
                        VuzeActivitiesEntry entry;
                        boolean isHeader;
                        if (!(selectedDataSources[i] instanceof VuzeActivitiesEntry) || (isHeader = "Header".equals((entry = (VuzeActivitiesEntry)selectedDataSources[i]).getTypeID()))) continue;
                        MessageBoxShell mb = new MessageBoxShell(Utils.findAnyShell(), MessageText.getString("v3.activity.remove.title"), MessageText.getString("v3.activity.remove.text", new String[]{entry.getText()}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0, this.tableID + "-Remove", MessageText.getString("MessageBoxWindow.nomoreprompting"), false, 0);
                        mb.setRememberOnlyIfButton(0);
                        mb.setHandleHTML(false);
                        int result = mb.open();
                        if (result == 0) {
                            entriesToRemove[entriesToRemovePos++] = entry;
                            continue;
                        }
                        if (result != -1) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
            if (entriesToRemovePos > 0) {
                VuzeActivitiesManager.removeEntries(entriesToRemove);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        finally {
            shell.setCursor(oldCursor);
        }
    }

    public TableViewSWT getView() {
        return this.view;
    }
}

