/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.swt.columns.utils.TableColumnCreatorV3;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.utils.TorrentUIUtilsV3;
import com.aelitis.azureus.ui.swt.views.skin.MyTorrentsView_Big;
import com.aelitis.azureus.ui.swt.views.skin.SBC_LibraryView;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.DataSourceUtils;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.ui.tables.TableRowRefreshListener;
import org.gudy.azureus2.ui.swt.IconBarEnabler;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.MyTorrentsSuperView;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;

public class SBC_LibraryTableView
extends SkinView
implements UIUpdatable,
IconBarEnabler {
    private static final String ID = "SBC_LibraryTableView";
    private IView view;
    private Composite viewComposite;
    private TableViewSWT tv;
    protected int torrentFilterMode = 0;

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        SWTSkinObject so;
        TableColumnCore[] columns;
        SWTSkinObject soParent = skinObject.getParent();
        Object data = soParent.getControl().getData("TorrentFilterMode");
        if (data instanceof Long) {
            this.torrentFilterMode = (int)((Long)data).longValue();
        }
        if (null != (columns = this.getColumns())) {
            TableColumnManager tcManager = TableColumnManager.getInstance();
            tcManager.addColumns(columns);
        }
        if (this.useBigTable()) {
            this.view = this.torrentFilterMode == 1 || this.torrentFilterMode == 2 || this.torrentFilterMode == 3 ? new MyTorrentsView_Big(AzureusCoreFactory.getSingleton(), this.torrentFilterMode, columns) : new MyTorrentsView_Big(AzureusCoreFactory.getSingleton(), this.torrentFilterMode, columns);
        } else {
            String tableID = SBC_LibraryView.getTableIdFromFilterMode(this.torrentFilterMode, false);
            if (this.torrentFilterMode == 1) {
                this.view = new MyTorrentsView(AzureusCoreFactory.getSingleton(), tableID, true, columns);
                ((MyTorrentsView)this.view).overrideDefaultSelected(new TableSelectionAdapter(){

                    public void defaultSelected(TableRowCore[] rows, int stateMask) {
                        if (rows == null || rows.length > 1) {
                            return;
                        }
                        Object ds = rows[0].getDataSource(true);
                        DownloadManager dm = DataSourceUtils.getDM(ds);
                        if (dm.getAssumedComplete() || (stateMask & 0x40000) > 0) {
                            TorrentListViewsUtils.playOrStreamDataSource(ds, null, "dblclick");
                        }
                    }
                });
            } else {
                this.view = this.torrentFilterMode == 2 ? new MyTorrentsView(AzureusCoreFactory.getSingleton(), tableID, false, columns) : (this.torrentFilterMode == 3 ? new MyTorrentsView(AzureusCoreFactory.getSingleton(), tableID, true, columns){

                    public boolean isOurDownloadManager(DownloadManager dm) {
                        if (PlatformTorrentUtils.getHasBeenOpened(dm)) {
                            return false;
                        }
                        return super.isOurDownloadManager(dm);
                    }
                } : new MyTorrentsSuperView(){

                    public void initialize(Composite parent) {
                        super.initialize(parent);
                        MyTorrentsView seedingview = this.getSeedingview();
                        if (seedingview != null) {
                            seedingview.overrideDefaultSelected(new TableSelectionAdapter(){

                                public void defaultSelected(TableRowCore[] rows, int stateMask) {
                                    if (rows == null || rows.length > 1) {
                                        return;
                                    }
                                    Object ds = rows[0].getDataSource(true);
                                    DownloadManager dm = DataSourceUtils.getDM(ds);
                                    if (dm.getAssumedComplete() || (stateMask & 0x40000) > 0) {
                                        TorrentListViewsUtils.playOrStreamDataSource(ds, null, "dblclick");
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
        if (this.tv == null) {
            if (this.view instanceof TableViewTab) {
                TableViewTab tvt = (TableViewTab)this.view;
                this.tv = tvt.getTableView();
            } else if (this.view instanceof TableViewSWT) {
                this.tv = (TableViewSWT)((Object)this.view);
            }
        }
        if (this.torrentFilterMode == 0 && this.tv != null) {
            this.tv.addRefreshListener(new TableRowRefreshListener(){

                public void rowRefresh(TableRow row) {
                    TableRowSWT rowCore = (TableRowSWT)row;
                    DownloadManager dm = (DownloadManager)rowCore.getDataSource(true);
                    boolean changed = false;
                    boolean assumedComplete = dm.getAssumedComplete();
                    if (!assumedComplete) {
                        changed |= rowCore.setAlpha(160);
                        changed |= rowCore.setFontStyle(0);
                    } else if (!PlatformTorrentUtils.getHasBeenOpened(dm)) {
                        changed |= rowCore.setAlpha(255);
                        changed |= rowCore.setFontStyle(1);
                    } else {
                        changed |= rowCore.setAlpha(255);
                        changed |= rowCore.setFontStyle(0);
                    }
                }
            });
        }
        if (this.tv != null) {
            this.tv.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\u000f' && e.stateMask == 393216) {
                        Object[] selectedDataSources = SBC_LibraryTableView.this.tv.getSelectedDataSources();
                        for (int i = 0; i < selectedDataSources.length; ++i) {
                            TOTorrent torrent;
                            String contentHash;
                            DownloadManager dm = (DownloadManager)selectedDataSources[i];
                            if (dm == null || (contentHash = PlatformTorrentUtils.getContentHash(torrent = dm.getTorrent())) == null || contentHash.length() <= 0) continue;
                            String url = ConstantsV3.URL_PREFIX + "download/" + contentHash + ".torrent?referal=coq";
                            DownloadUrlInfo dlInfo = new DownloadUrlInfo(url);
                            TorrentUIUtilsV3.loadTorrent(AzureusCoreFactory.getSingleton(), dlInfo, false, false, true, false);
                        }
                    }
                }
            });
        }
        SWTSkinObjectContainer soContents = new SWTSkinObjectContainer(this.skin, this.skin.getSkinProperties(), this.getUpdateUIName(), "", this.soMain);
        this.skin.layout();
        this.viewComposite = soContents.getComposite();
        this.viewComposite.setBackground(this.viewComposite.getDisplay().getSystemColor(22));
        this.viewComposite.setForeground(this.viewComposite.getDisplay().getSystemColor(21));
        this.viewComposite.setLayoutData((Object)Utils.getFilledFormData());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.viewComposite.setLayout((Layout)gridLayout);
        this.view.initialize(this.viewComposite);
        if (this.torrentFilterMode == 3 && (so = this.skin.getSkinObject("library-list-button-right", soParent.getParent())) != null) {
            so.setVisible(true);
            SWTSkinButtonUtility btn = new SWTSkinButtonUtility(so);
            btn.setTextID("Mark All UnNew");
            btn.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    TableViewSWT tv = ((MyTorrentsView)SBC_LibraryTableView.this.view).getTableView();
                    Object[] dataSources = tv.getDataSources();
                    for (int i = 0; i < dataSources.length; ++i) {
                        Object ds = dataSources[i];
                        if (!(ds instanceof DownloadManager)) continue;
                        PlatformTorrentUtils.setHasBeenOpened((DownloadManager)ds, true);
                        tv.removeDataSource(ds);
                    }
                }
            });
        }
        return null;
    }

    public String getUpdateUIName() {
        return ID;
    }

    public void updateUI() {
        if (this.viewComposite == null || this.viewComposite.isDisposed() || !this.viewComposite.isVisible() || this.view == null) {
            return;
        }
        this.view.refresh();
    }

    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        if (this.torrentFilterMode == 3 && this.view instanceof MyTorrentsView) {
            MyTorrentsView torrentsView = (MyTorrentsView)this.view;
            TableViewSWT tv = torrentsView.getTableView();
            Object[] dataSources = tv.getDataSources();
            for (int i = 0; i < dataSources.length; ++i) {
                DownloadManager dm = (DownloadManager)dataSources[i];
                if (!torrentsView.isOurDownloadManager(dm)) {
                    tv.removeDataSource(dm);
                    continue;
                }
                tv.addDataSource(dm);
            }
        }
        if (this.view instanceof MyTorrentsView) {
            ((MyTorrentsView)this.view).updateSelectedContent();
        }
        this.updateUI();
        return null;
    }

    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        if (this.view instanceof MyTorrentsView) {
            ((MyTorrentsView)this.view).updateSelectedContent();
        }
        return super.skinObjectHidden(skinObject, params);
    }

    public boolean isEnabled(String itemKey) {
        try {
            if (this.view != null) {
                return this.view.isEnabled(itemKey);
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        return false;
    }

    public boolean isSelected(String itemKey) {
        try {
            if (this.view != null) {
                return this.view.isSelected(itemKey);
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        return false;
    }

    public void itemActivated(String itemKey) {
        try {
            if (this.view != null) {
                this.view.itemActivated(itemKey);
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
    }

    protected int getTableMode() {
        return 1;
    }

    protected boolean useBigTable() {
        return false;
    }

    protected TableColumnCore[] getColumns() {
        if (this.torrentFilterMode == 1) {
            return TableColumnCreator.createCompleteDM("MySeeders");
        }
        if (this.torrentFilterMode == 2) {
            return TableColumnCreator.createIncompleteDM("MyTorrents");
        }
        if (this.torrentFilterMode == 3) {
            return TableColumnCreatorV3.createUnopenedDM("Unopened", false);
        }
        if (this.torrentFilterMode == 0) {
            return TableColumnCreator.createCompleteDM("MyLibrary.big");
        }
        return null;
    }

    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.view != null) {
            this.view.delete();
        }
        return super.skinObjectDestroyed(skinObject, params);
    }
}

