/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.messenger.config.PlatformDCAdManager;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.browser.listener.DownloadUrlInfoSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.ui.swt.utils.TorrentUIUtilsV3;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.DCAdManager;
import com.aelitis.azureus.util.DataSourceUtils;
import com.aelitis.azureus.util.PlayUtils;
import com.aelitis.azureus.util.PublishUtils;
import com.aelitis.azureus.util.win32.Win32Utils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.program.Program;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.ForceRecheckListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class TorrentListViewsUtils {
    public static final boolean ENABLE_ON_HOVER = false;

    public static void stop(DownloadManager dm) {
        int state = dm.getState();
        if (state == 100) {
            dm.stopIt(75, false, false);
        } else if (state == 70) {
            ManagerUtils.queue(dm, null);
        } else {
            ManagerUtils.stop(dm, null);
        }
    }

    public static void viewDetails(TableRowCore row, String ref) {
        TorrentListViewsUtils.viewDetails(DataSourceUtils.getHash(row.getDataSource(true)), ref);
    }

    public static void viewDetails(DownloadManager dm, String ref) {
        if (dm == null) {
            return;
        }
        if (!PlatformTorrentUtils.isContent(dm.getTorrent(), true)) {
            return;
        }
        try {
            TorrentListViewsUtils.viewDetails(dm.getTorrent().getHashWrapper().toBase32String(), ref);
        }
        catch (TOTorrentException e) {
            Debug.out(e);
        }
    }

    public static void viewDetails(String hash, String ref) {
        if (hash == null) {
            return;
        }
        String url = ConstantsV3.URL_PREFIX + "details/" + hash + ".html?" + ConstantsV3.URL_SUFFIX + "&client_ref=" + ref;
        UIFunctions functions = UIFunctionsManager.getUIFunctions();
        if (functions != null) {
            functions.viewURL(url, "browse", 0, 0, false, false);
        }
    }

    public static void playOrStreamDataSource(Object ds, SWTSkinButtonUtility btn) {
        String referal = "unknown";
        if (ds instanceof VuzeActivitiesEntry) {
            referal = "playdashboardactivity";
        } else if (ds instanceof DownloadManager) {
            referal = "playdownloadmanager";
        } else if (ds instanceof ISelectedContent) {
            referal = "selectedcontent";
        }
        TorrentListViewsUtils.playOrStreamDataSource(ds, btn, referal);
    }

    public static void playOrStreamDataSource(Object ds, SWTSkinButtonUtility btn, String referal) {
        TorrentListViewsUtils.debugDCAD("enter - playOrStreamDataSource");
        DownloadManager dm = DataSourceUtils.getDM(ds);
        if (dm == null) {
            TorrentListViewsUtils.downloadDataSource(ds, true, referal);
        } else {
            TorrentListViewsUtils.playOrStream(dm, btn);
        }
        TorrentListViewsUtils.debugDCAD("exit - playOrStreamDataSource");
    }

    public static void downloadDataSource(Object ds, boolean playNow, String referal) {
        TOTorrent torrent = DataSourceUtils.getTorrent(ds);
        if (torrent != null && !DataSourceUtils.isPlatformContent(ds)) {
            TorrentUIUtilsV3.addTorrentToGM(torrent);
        } else {
            AzureusCore core = AzureusCoreFactory.getSingleton();
            DownloadUrlInfo dlInfo = DataSourceUtils.getDownloadInfo(ds);
            if (dlInfo instanceof DownloadUrlInfoSWT) {
                TorrentUIUtilsV3.loadTorrent(core, dlInfo, playNow, false, true, true);
                return;
            }
            String hash = DataSourceUtils.getHash(ds);
            if (hash != null) {
                if (ds instanceof VuzeActivitiesEntry && ((VuzeActivitiesEntry)ds).isDRM()) {
                    TorrentListViewsUtils.viewDetails(hash, "drm-play");
                    return;
                }
                String url = ConstantsV3.URL_PREFIX + "download/" + hash + ".torrent?referal=" + referal;
                dlInfo = new DownloadUrlInfo(url);
                TorrentUIUtilsV3.loadTorrent(core, dlInfo, playNow, false, true, true);
            } else if (dlInfo != null) {
                TorrentUIUtilsV3.loadTorrent(core, dlInfo, playNow, false, true, true);
            }
        }
    }

    public static boolean playOrStream(DownloadManager dm, SWTSkinButtonUtility btn) {
        boolean played = TorrentListViewsUtils._playOrStream(dm, btn);
        if (played) {
            PlatformTorrentUtils.setHasBeenOpened(dm, true);
        }
        return played;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean _playOrStream(final DownloadManager dm, final SWTSkinButtonUtility btn) {
        TorrentListViewsUtils.debugDCAD("enter - playOrStream");
        if (dm == null) {
            return false;
        }
        TOTorrent torrent = dm.getTorrent();
        if (PlayUtils.canUseEMP(torrent)) {
            TorrentListViewsUtils.debug("Can use EMP");
            if (TorrentListViewsUtils.openInEMP(dm)) {
                return true;
            }
            TorrentListViewsUtils.debug("Open EMP Failed");
        } else {
            TorrentListViewsUtils.debug("Can't use EMP. torrent says " + PlatformTorrentUtils.useEMP(torrent));
        }
        if (btn != null) {
            btn.setDisabled(true);
        }
        boolean reenableButton = false;
        try {
            String url2;
            String sFileType;
            String sTextID;
            if (!PlayUtils.canProgressiveOrIsComplete(torrent)) {
                boolean bl = false;
                return bl;
            }
            String sFile = null;
            EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(dm);
            if (edm != null) {
                boolean doProgressive = edm.getProgressiveMode();
                if (doProgressive && edm.getProgressivePlayETA() > 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (!doProgressive && dm.getDiskManagerFileInfo().length > 1 && PlatformTorrentUtils.getContentPrimaryFileIndex(torrent) == -1) {
                    Utils.launch(dm.getSaveLocation().getAbsolutePath());
                    boolean bl = true;
                    return bl;
                }
                File file = edm.getPrimaryFile().getFile(true);
                sFile = file.getAbsolutePath();
            } else {
                sFile = dm.getDownloadState().getPrimaryFile();
                File file = new File(sFile);
            }
            String ext = FileUtil.getExtension(sFile);
            String sPrefix = "v3.mb.openFile.";
            UIFunctionsSWT functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (functionsSWT == null) {
                boolean bl = false;
                return bl;
            }
            Program program = Program.findProgram((String)ext);
            if (program == null) {
                sTextID = sPrefix + "text.unknown";
                sFileType = ext;
            } else {
                sTextID = sPrefix + "text.known";
                sFileType = program.getName();
            }
            String[] buttons = new String[program == null ? 2 : 3];
            buttons[0] = MessageText.getString(sPrefix + "button.guide");
            buttons[buttons.length - 1] = MessageText.getString(sPrefix + "button.cancel");
            MessageBoxShell mb = null;
            if (program != null) {
                buttons[1] = MessageText.getString(sPrefix + "button.play");
                mb = new MessageBoxShell(functionsSWT.getMainShell(), MessageText.getString(sPrefix + "title"), MessageText.getString(sTextID, new String[]{dm.getDisplayName(), sFileType, ext}), buttons, 0, sPrefix + ".remember_id", MessageText.getString(sPrefix + "remember"), false, 0);
                mb.setRememberOnlyIfButton(1);
                mb.setRelatedObject(dm);
            } else {
                mb = new MessageBoxShell(functionsSWT.getMainShell(), MessageText.getString(sPrefix + "title"), MessageText.getString(sTextID, new String[]{dm.getDisplayName(), sFileType, ext}), buttons, 0);
                mb.setRelatedObject(dm);
            }
            int i = mb.open();
            if (i == 0 && UrlUtils.isURL(url2 = MessageText.getString(sPrefix + "guideurl"))) {
                Utils.launch(url2);
            }
            if (i != 1 || program == null) {
                boolean url2 = false;
                return url2;
            }
            boolean bComplete = dm.isDownloadComplete(false);
            if (bComplete) {
                if (PlatformTorrentUtils.isContentAdEnabled(torrent)) {
                    final String sfFile = sFile;
                    TorrentListViewsUtils.debug("calling createASX from ...Tor.Utils.playOrStream, in is complete block.");
                    DCAdManager.getInstance().createASX(dm, new DCAdManager.ASXCreatedListener(){

                        public void asxCreated(File asxFile) {
                            if (btn != null) {
                                btn.setDisabled(false);
                            }
                            TorrentListViewsUtils.runFile(dm.getTorrent(), asxFile.getAbsolutePath());
                        }

                        public void asxFailed() {
                            if (btn != null) {
                                btn.setDisabled(false);
                            }
                            TorrentListViewsUtils.runFile(dm.getTorrent(), sfFile);
                        }
                    });
                } else {
                    reenableButton = true;
                    TorrentListViewsUtils.runFile(dm.getTorrent(), sFile);
                }
            } else {
                reenableButton = true;
                try {
                    TorrentListViewsUtils.playViaMediaServer(DownloadManagerImpl.getDownloadStatic(dm));
                }
                catch (DownloadException e) {
                    Debug.out(e);
                }
            }
        }
        finally {
            if (btn != null && reenableButton) {
                btn.setDisabled(false);
            }
        }
        TorrentListViewsUtils.debugDCAD("enter - playOrStream");
        return true;
    }

    private static void debug(String string) {
        if (Constants.isCVSVersion()) {
            System.out.println(string);
        }
    }

    private static void runFile(TOTorrent torrent, String runFile) {
        TorrentListViewsUtils.runFile(torrent, runFile, false);
    }

    private static void runFile(final TOTorrent torrent, final String runFile, final boolean forceWMP) {
        AEThread2 thread = new AEThread2("runFile", true){

            public void run() {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        TorrentListViewsUtils.debugDCAD("enter - runFile - runSupport");
                        if (PlayUtils.canUseEMP(torrent)) {
                            Debug.out("Shouldn't call runFile with EMP torrent.");
                        }
                        if (PlatformTorrentUtils.isContentDRM(torrent) || forceWMP) {
                            if (!TorrentListViewsUtils.runInMediaPlayer(runFile)) {
                                Utils.launch(runFile);
                            }
                        } else {
                            Utils.launch(runFile);
                        }
                        TorrentListViewsUtils.debugDCAD("exit - runFile - runSupport");
                    }
                });
            }
        };
        thread.start();
    }

    private static boolean openInEMP(DownloadManager dm) {
        TorrentListViewsUtils.debugDCAD("enter - openInEMP");
        Class<?> epwClass = null;
        try {
            PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp");
            if (pi == null) {
                return false;
            }
            epwClass = pi.getPlugin().getClass().getClassLoader().loadClass("com.azureus.plugins.azemp.ui.swt.emp.EmbeddedPlayerWindowSWT");
        }
        catch (ClassNotFoundException e1) {
            return false;
        }
        try {
            TorrentListViewsUtils.debug("EmbeddedPlayerWindowSWT - openWindow");
            Method method = epwClass.getMethod("openWindow", DownloadManager.class);
            method.invoke(null, dm);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (e.getMessage() == null || !e.getMessage().toLowerCase().endsWith("only")) {
                Debug.out(e);
            }
            return false;
        }
    }

    private static void handleNoFileExists(DownloadManager dm) {
        UIFunctionsSWT functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (functionsSWT == null) {
            return;
        }
        ManagerUtils.start(dm);
        String sPrefix = "v3.mb.PlayFileNotFound.";
        MessageBoxShell mb = new MessageBoxShell(functionsSWT.getMainShell(), MessageText.getString(sPrefix + "title"), MessageText.getString(sPrefix + "text", new String[]{dm.getDisplayName()}), new String[]{MessageText.getString(sPrefix + "button.remove"), MessageText.getString(sPrefix + "button.redownload"), MessageText.getString("Button.cancel")}, 2);
        mb.setRelatedObject(dm);
        int i = mb.open();
        if (i == 0) {
            ManagerUtils.remove(dm, functionsSWT.getMainShell(), true, false);
        } else if (i == 1) {
            dm.forceRecheck(new ForceRecheckListener(){

                public void forceRecheckComplete(DownloadManager dm) {
                    ManagerUtils.start(dm);
                }
            });
        }
    }

    private static boolean runInMediaPlayer(String mediaFile) {
        String wmpEXE;
        TorrentListViewsUtils.debugDCAD("enter - runInMediaPlayer");
        if (ConstantsV3.isWindows && new File(wmpEXE = Win32Utils.getWMP()).exists()) {
            try {
                Runtime.getRuntime().exec(wmpEXE + " \"" + mediaFile + "\"");
                return true;
            }
            catch (IOException e) {
                Debug.out("error playing " + mediaFile + " via WMP " + mediaFile, e);
            }
        }
        return false;
    }

    private static boolean isTrustedContent(String ext) {
        PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azupnpav", true);
        ArrayList<String> whiteList = new ArrayList<String>();
        String[] goodExts = null;
        if (pi != null) {
            try {
                goodExts = (String[])pi.getIPC().invoke("getRecognizedExtensions", null);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (goodExts == null) {
            goodExts = new String[]{"mpg", "avi", "mov", "flv", "flc", "mp4", "mpeg", "divx", "wmv", "asf", "mp3", "wma", "wav", "h264", "mkv"};
        }
        for (int i = 0; i < goodExts.length; ++i) {
            String name;
            Program program = Program.findProgram((String)goodExts[i]);
            if (program == null || whiteList.contains(name = program.getName())) continue;
            whiteList.add(name);
        }
        Program program = Program.findProgram((String)ext);
        if (program == null) {
            return false;
        }
        return whiteList.contains(program.getName());
    }

    private static boolean isUntrustworthyContent(String ext) {
        Object[] badExts = new String[]{"bas", "bat", "com", "cmd", "cpl", "exe", "js", "lnk", "mdb", "msi", "osx", "pif", "reg", "scr", "vb", "vbe", "vbs", "wsh", "wsf"};
        if (ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        return Arrays.binarySearch(badExts, ext) >= 0;
    }

    public static String getMediaServerContentURL(DownloadManager dm) {
        try {
            return PlayUtils.getMediaServerContentURL(DownloadManagerImpl.getDownloadStatic(dm));
        }
        catch (DownloadException downloadException) {
            return null;
        }
    }

    public static void playViaMediaServer(Download download) {
        TorrentListViewsUtils.debugDCAD("enter - playViaMediaServer");
        try {
            final DownloadManager dm = ((DownloadImpl)download).getDownload();
            TOTorrent torrent = dm.getTorrent();
            if (PlatformTorrentUtils.isContentAdEnabled(torrent)) {
                TorrentListViewsUtils.debug("calling createASX from ...Tor.Utils.playViaMediaServer, in is complete block. dm=" + dm);
                DCAdManager.getInstance().createASX(dm, new DCAdManager.ASXCreatedListener(){

                    public void asxCreated(File asxFile) {
                        TorrentListViewsUtils.runFile(dm.getTorrent(), asxFile.getAbsolutePath(), true);
                    }

                    public void asxFailed() {
                        TorrentListViewsUtils.runFile(dm.getTorrent(), PlayUtils.getContentUrl(dm), true);
                    }
                });
            } else {
                TorrentListViewsUtils.runFile(torrent, PlayUtils.getContentUrl(dm), true);
            }
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LogIDs.UI3, "IPC to media server plugin failed", e));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void removeDownload(final DownloadManager dm, final TableView tableView) {
        TorrentListViewsUtils.debug("removeDownload");
        AERunnable failure = null;
        if (tableView != null) {
            tableView.removeDataSource(dm, true);
            failure = new AERunnable(){

                public void runSupport() {
                    tableView.addDataSource(dm, true);
                }
            };
        }
        if (PublishUtils.isPublished(dm) || dm.getDownloadState().getFlag(64L)) {
            ManagerUtils.remove(dm, null, true, false, failure);
            return;
        }
        boolean deleteTorrent = true;
        boolean deleteData = true;
        if (dm.getDownloadState().getFlag(16L)) {
            ManagerUtils.asyncStopDelete(dm, 70, deleteTorrent, deleteData, failure);
            return;
        }
        String path = dm.getSaveLocation().toString();
        String title = MessageText.getString("deletedata.title");
        String text = MessageText.getString("v3.deleteContent.message", new String[]{dm.getDisplayName()});
        MessageBoxShell mb = new MessageBoxShell(Utils.findAnyShell(), title, text, new String[]{MessageText.getString("Button.cancel"), MessageText.getString("Button.deleteContent.fromComputer"), MessageText.getString("Button.deleteContent.fromLibrary")}, 2, null, null, false, 0);
        mb.setRelatedObject(dm);
        mb.setLeftImage(ImageLoaderFactory.getInstance().getImage("image.trash"));
        int result = mb.open();
        if (result != 1 && result != 2) {
            if (failure == null) return;
            failure.runSupport();
            return;
        }
        if (result == 2) {
            deleteData = false;
        }
        ManagerUtils.asyncStopDelete(dm, 70, deleteTorrent, deleteData, failure);
    }

    public static void main(String[] args) {
        AzureusCoreFactory.create();
        System.out.println(TorrentListViewsUtils.isTrustedContent(FileUtil.getExtension("moo.exep")));
        System.out.println(TorrentListViewsUtils.isUntrustworthyContent(FileUtil.getExtension("moo.exe")));
    }

    public static void showHomeHint(DownloadManager dm) {
    }

    public static void debugDCAD(String s) {
        PlatformDCAdManager.debug("TorrentListViewsUtils: " + s);
    }

    public static boolean playOrStream(DownloadManager dm) {
        return TorrentListViewsUtils.playOrStream(dm, null);
    }
}

