/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.messenger.config.PlatformBuddyMessenger;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.shells.friends.SharePage;
import com.aelitis.azureus.ui.swt.shells.friends.ShareWizard;
import com.aelitis.azureus.ui.swt.utils.SWTLoginUtils;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.Utils;

public class VuzeShareUtils {
    private static VuzeShareUtils instance;

    public static VuzeShareUtils getInstance() {
        if (null == instance) {
            instance = new VuzeShareUtils();
        }
        return instance;
    }

    public void shareTorrent(ISelectedContent content, String referer) {
        if (content instanceof SelectedContentV3) {
            SelectedContentV3 sc = (SelectedContentV3)content;
            this.shareTorrent(sc, referer);
        } else if (content instanceof SelectedContent) {
            SelectedContent sc = (SelectedContent)content;
            this.shareTorrent(new SelectedContentV3(sc), referer);
        }
    }

    public void shareTorrent(final SelectedContentV3 currentContent, final String referer) {
        PlatformBuddyMessenger.startShare(referer, currentContent.isPlatformContent() ? currentContent.getHash() : null);
        if (!VuzeBuddyManager.isEnabled()) {
            VuzeBuddyManager.showDisabledDialog();
            return;
        }
        if (currentContent.getDM() != null && TorrentUtils.isReallyPrivate(currentContent.getDM().getTorrent())) {
            Utils.openMessageBox(Utils.findAnyShell(), 32, "v3.share.private", (String[])null);
            return;
        }
        SWTLoginUtils.waitForLogin(new SWTLoginUtils.loginWaitListener(){

            public void loginComplete() {
                try {
                    ShareWizard wizard = new ShareWizard(UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell(), 2160);
                    wizard.setText("Vuze - Wizard");
                    wizard.setSize(500, 550);
                    SharePage newSharePage = (SharePage)wizard.getPage("share.wizard.page");
                    newSharePage.setShareItem(currentContent, referer);
                    UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                    if (null == uiFunctions) {
                        Utils.centreWindow(wizard.getShell());
                    } else {
                        Utils.centerWindowRelativeTo(wizard.getShell(), (Control)uiFunctions.getMainShell());
                    }
                    wizard.open();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

