/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin.sidebar;

import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarEntry;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImage;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImageListener;
import org.gudy.azureus2.ui.swt.Utils;

public class SideBarVitalityImageSWT
implements SideBarVitalityImage {
    private String imageID;
    private final SideBarEntrySWT sideBarEntry;
    private List listeners = Collections.EMPTY_LIST;
    private String tooltip;
    private Rectangle hitArea;
    private boolean visible = true;
    private int currentAnimationIndex;
    private String suffix = "";
    private TimerEventPerformer performer = new TimerEventPerformer(){
        private boolean exec_pending = false;
        private Object lock = this;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(TimerEvent event2) {
            Object object = this.lock;
            synchronized (object) {
                if (this.exec_pending) {
                    return;
                }
                this.exec_pending = true;
            }
            Utils.execSWTThread(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    TreeItem treeItem;
                    Object object = lock;
                    synchronized (object) {
                        exec_pending = false;
                    }
                    if (SideBarVitalityImageSWT.this.images == null || SideBarVitalityImageSWT.this.images.length == 0 || !SideBarVitalityImageSWT.this.visible || SideBarVitalityImageSWT.this.hitArea == null) {
                        return;
                    }
                    SideBarVitalityImageSWT.this.currentAnimationIndex++;
                    if (SideBarVitalityImageSWT.this.currentAnimationIndex >= SideBarVitalityImageSWT.this.images.length) {
                        SideBarVitalityImageSWT.this.currentAnimationIndex = 0;
                    }
                    if ((treeItem = SideBarVitalityImageSWT.this.sideBarEntry.getTreeItem()) == null || treeItem.isDisposed()) {
                        return;
                    }
                    Tree parent = treeItem.getParent();
                    parent.redraw(((SideBarVitalityImageSWT)SideBarVitalityImageSWT.this).hitArea.x, ((SideBarVitalityImageSWT)SideBarVitalityImageSWT.this).hitArea.y, ((SideBarVitalityImageSWT)SideBarVitalityImageSWT.this).hitArea.width, ((SideBarVitalityImageSWT)SideBarVitalityImageSWT.this).hitArea.height, false);
                    parent.update();
                }
            });
        }
    };
    private TimerEventPeriodic timerEvent;
    private Image[] images;
    private int delayTime = -1;
    private String fullImageID;

    public SideBarVitalityImageSWT(SideBarEntrySWT entry, String imageID) {
        this.sideBarEntry = entry;
        this.setImageID(imageID);
    }

    public String getImageID() {
        return this.imageID;
    }

    public SideBarEntry getSideBarEntry() {
        return this.sideBarEntry;
    }

    public void addListener(SideBarVitalityImageListener l) {
        if (this.listeners == Collections.EMPTY_LIST) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.add(l);
    }

    public void triggerClickedListeners(int x, int y) {
        Object[] list = this.listeners.toArray();
        for (int i = 0; i < list.length; ++i) {
            SideBarVitalityImageListener l = (SideBarVitalityImageListener)list[i];
            try {
                l.sbVitalityImage_clicked(x, y);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public void setToolTip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public void setHitArea(Rectangle hitArea) {
        this.hitArea = hitArea;
    }

    public Rectangle getHitArea() {
        return this.hitArea;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        if (visible) {
            this.createTimerEvent();
        } else if (this.timerEvent != null) {
            this.timerEvent.cancel();
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SideBarVitalityImageSWT.this.sideBarEntry != null) {
                    SideBarVitalityImageSWT.this.sideBarEntry.redraw();
                }
            }
        });
    }

    private void createTimerEvent() {
        if (this.timerEvent != null) {
            this.timerEvent.cancel();
        }
        if (this.images.length > 1) {
            ImageLoader imageLoader = ImageLoaderFactory.getInstance();
            int delay = this.delayTime == -1 ? imageLoader.getAnimationDelay(this.imageID) : this.delayTime;
            this.timerEvent = SimpleTimer.addPeriodicEvent("Animate " + this.imageID + this.suffix, delay, this.performer);
        }
    }

    public int getCurrentAnimationIndex(Image[] images) {
        if (this.currentAnimationIndex >= images.length) {
            this.currentAnimationIndex = 0;
        } else if (this.currentAnimationIndex < 0) {
            this.currentAnimationIndex = 0;
        }
        return this.currentAnimationIndex;
    }

    public void switchSuffix(String suffix) {
        if (suffix == null) {
            suffix = "";
        }
        if (suffix.equals(this.suffix)) {
            return;
        }
        this.suffix = suffix;
        this.setImageID(this.imageID);
    }

    public void setImageID(String id) {
        String newFullImageID = id + this.suffix;
        if (newFullImageID.equals(this.fullImageID)) {
            return;
        }
        this.imageID = id;
        ImageLoader imageLoader = ImageLoaderFactory.getInstance();
        this.images = imageLoader.getImages(newFullImageID);
        if (this.images == null || this.images.length == 0) {
            newFullImageID = id;
            this.images = imageLoader.getImages(id);
        }
        this.fullImageID = newFullImageID;
        this.currentAnimationIndex = 0;
        this.createTimerEvent();
    }

    public Image getImage() {
        if (this.images == null || this.images.length == 0 || this.currentAnimationIndex >= this.images.length) {
            return null;
        }
        return this.images[this.currentAnimationIndex];
    }

    public void setDelayTime(int delayTime) {
        if (this.delayTime == delayTime) {
            return;
        }
        this.delayTime = delayTime;
        this.createTimerEvent();
    }

    public int getDelayTime() {
        return this.delayTime;
    }
}

