/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.widgets;

import java.io.InputStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.ui.swt.ImageRepository;

public class AnimatedImage {
    private static final int SPEED = 100;
    Canvas canvas;
    boolean running;
    private AEThread2 runner;
    private Image[] images;
    private int currentImage = 0;

    public AnimatedImage(Composite parent) {
        this.canvas = new Canvas(parent, 0);
        Color background = null;
        for (Composite p = parent; p != null && background == null; p = p.getParent()) {
            background = p.getBackground();
            if (background == null) continue;
            System.out.println("background : " + background + ", composite : " + p);
        }
        this.canvas.setBackground(background);
        this.canvas.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                AnimatedImage.this.stop();
                AnimatedImage.this.disposeImages();
            }
        });
    }

    private void renderNextImage() {
        Display display;
        if (!this.canvas.isDisposed() && !(display = this.canvas.getDisplay()).isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!AnimatedImage.this.canvas.isDisposed() && AnimatedImage.this.images != null) {
                        Image image;
                        AnimatedImage.this.currentImage++;
                        if (AnimatedImage.this.currentImage >= AnimatedImage.this.images.length) {
                            AnimatedImage.this.currentImage = 0;
                        }
                        if (AnimatedImage.this.currentImage < AnimatedImage.this.images.length && (image = AnimatedImage.this.images[AnimatedImage.this.currentImage]) != null && !image.isDisposed()) {
                            GC gc = new GC((Drawable)AnimatedImage.this.canvas);
                            Point canvasSize = AnimatedImage.this.canvas.getSize();
                            Rectangle imageBounds = image.getBounds();
                            gc.drawImage(image, (canvasSize.x - imageBounds.width) / 2, (canvasSize.y - imageBounds.height) / 2);
                            gc.dispose();
                        }
                    }
                }
            });
        }
    }

    public void setLayoutData(Object data) {
        this.canvas.setLayoutData(data);
    }

    public void start() {
        this.running = true;
        this.runner = new AEThread2("image runner", true){

            public void run() {
                while (AnimatedImage.this.running) {
                    try {
                        AnimatedImage.this.renderNextImage();
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        AnimatedImage.this.running = false;
                    }
                }
            }
        };
        this.runner.start();
    }

    public void stop() {
        this.running = false;
    }

    public Control getControl() {
        return this.canvas;
    }

    public void dispose() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
    }

    public void setImageFromName(String imageName) {
        InputStream is = ImageRepository.getImageAsStream(imageName);
        if (null == is) {
            return;
        }
        ImageLoader loader = new ImageLoader();
        ImageData[] imageDataArray = loader.load(is);
        this.images = new Image[imageDataArray.length];
        for (int i = 0; i < imageDataArray.length; ++i) {
            ImageData imageData = imageDataArray[i];
            imageData.transparentPixel = 0;
            this.images[i] = new Image((Device)this.canvas.getDisplay(), imageData.width, imageData.height);
            GC offScreenImageGC = new GC((Drawable)this.images[i]);
            offScreenImageGC.setBackground(this.canvas.getBackground());
            offScreenImageGC.fillRectangle(0, 0, imageData.width, imageData.height);
            Image tempImage = new Image((Device)this.canvas.getDisplay(), imageData);
            offScreenImageGC.drawImage(tempImage, 0, 0);
            tempImage.dispose();
            offScreenImageGC.dispose();
        }
    }

    private void setImages(Image[] images) {
        this.disposeImages();
        this.images = images;
    }

    private void disposeImages() {
        if (this.images != null) {
            for (int i = 0; i < this.images.length; ++i) {
                if (this.images[i] == null || this.images[i].isDisposed()) continue;
                this.images[i].dispose();
            }
        }
    }
}

