/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.crypto.VuzeCryptoManager;
import com.aelitis.azureus.util.Constants;
import java.util.Locale;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Base32;

public class ConstantsV3 {
    public static boolean isOSX = org.gudy.azureus2.core3.util.Constants.isOSX;
    public static boolean isWindows = org.gudy.azureus2.core3.util.Constants.isWindows;
    public static boolean isUnix = org.gudy.azureus2.core3.util.Constants.isUnix;
    public static final String DEFAULT_ADDRESS = "www.vuze.com";
    public static final String DEFAULT_PORT = "80";
    public static final String DEFAULT_RELAY_ADDRESS = "www.vuze.com";
    public static final String DEFAULT_RELAY_PORT = "80";
    public static String URL_ADDRESS = System.getProperty("platform_address", "www.vuze.com");
    public static String URL_PORT = System.getProperty("platform_port", "80");
    public static final String URL_PREFIX = "http://" + URL_ADDRESS + ":" + URL_PORT + "/";
    public static final String DEFAULT_AUTHORIZED_RPC = "https://" + URL_ADDRESS + ":443/rpc";
    public static String URL_SUFFIX;
    public static final String URL_ADD_SEARCH = "search?q=";
    public static final String URL_PLATFORM_MESSAGE = "?service=rpc";
    public static final String URL_POST_PLATFORM_DATA = "service=rpc";
    public static final String URL_BIG_BROWSE = "browse.start";
    public static final String URL_MINI_BROWSE = "dashboard.start";
    public static final String URL_PUBLISH = "publish.start";
    public static final String URL_WELCOME = "welcome.start";
    public static final String URL_PUBLISHED = "PublishedContent.html";
    public static final String URL_PUBLISHNEW = "PublishNewContent.html";
    public static final String URL_PUBLISH_ABOUT = "Publish.html";
    public static final String URL_DETAILS = "details/";
    public static final String URL_COMMENTS = "comment/";
    public static final String URL_SHARE = "share/";
    public static final String URL_PROFILE = "profile/";
    public static final String URL_BUDDY_ACCEPT = "buddy-accept/";
    public static final String URL_DOWNLOAD = "download/";
    public static final String URL_SUPPORT;
    public static final String URL_FAQ = "http://faq.vuze.com/";
    public static final String URL_FAQ_BY_TOPIC_ENTRY = "http://faq.vuze.com/?View=entry&EntryID=";
    public static final String URL_PUBLISH_INFO;
    public static final String URL_RPC = "rpc/";
    public static final String URL_BLOG = "http://blog.vuze.com/";
    public static final String URL_FORUMS = "http://forum.vuze.com/";
    public static final String URL_WIKI = "http://wiki.vuze.com/";
    public static String URL_RELAY_RPC;
    public static final String URL_AUTHORIZED_RPC;
    public static final String URL_POP_UP = "?popup";
    public static final String URL_LOGIN = "login.start";
    public static final String URL_LOGOUT = "logout.start";
    public static final String URL_REGISTRATION = "register.start";
    public static final String URL_MY_PROFILE = "profile.start";
    public static final String URL_ACCOUNT = "account.start";
    public static final boolean DISABLE_BUDDIES_BAR;
    public static final String URL_PAGE_VERIFIER_VALUE = "vuzePage";
    public static final boolean DIAG_TO_STDOUT;
    public static final String DL_REFERAL_PLAYDASHACTIVITY = "playdashboardactivity";
    public static final String DL_REFERAL_UNKNOWN = "unknown";
    public static final String DL_REFERAL_LAUNCH = "launch";
    public static final String DL_REFERAL_PLAYDM = "playdownloadmanager";
    public static final String DL_REFERAL_SELCONTENT = "selectedcontent";
    public static final String DL_REFERAL_DBLCLICK = "dblclick";
    public static final String DL_REFERAL_TOOLBAR = "toolbar";
    public static final String DL_REFERAL_DASHACTIVITY = "dashboardactivity";
    public static String AZID;

    public static void initialize(AzureusCore core) {
        AZID = Base32.encode(VuzeCryptoManager.getSingleton().getPlatformAZID());
        COConfigurationManager.addAndFireParameterListener("locale", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                URL_SUFFIX = "azid=" + AZID + "&azv=" + "4.0.0.1_B06" + "&locale=" + Locale.getDefault().toString();
            }
        });
        Constants.initialize();
    }

    public static String appendURLSuffix(String url) {
        if (url.indexOf("azid=") < 0) {
            url = url + (url.indexOf(63) < 0 ? "?" : "&") + URL_SUFFIX;
        }
        return url;
    }

    public static String urlRelativeToPlatform(String url) {
        if (!url.startsWith("http")) {
            url = URL_PREFIX + (url.startsWith("/") ? url.substring(1) : url);
        }
        return url;
    }

    static {
        URL_SUPPORT = URL_PREFIX + "support/";
        URL_PUBLISH_INFO = URL_PREFIX + URL_PUBLISH_ABOUT;
        URL_RELAY_RPC = System.getProperty("relay_url", "http://" + System.getProperty("relay_address", "www.vuze.com") + ":" + System.getProperty("relay_port", "80") + "/msgrelay/rpc");
        URL_AUTHORIZED_RPC = System.getProperty("authorized_rpc", "1").equals("1") ? DEFAULT_AUTHORIZED_RPC : URL_PREFIX + "app";
        DISABLE_BUDDIES_BAR = System.getProperty("debug.buddies.bar", "1").equals("0");
        DIAG_TO_STDOUT = System.getProperty("DIAG_TO_STDOUT", "0").equals("1");
    }
}

