/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.messenger.config.PlatformDCAdManager;
import com.aelitis.azureus.core.torrent.MetaDataUpdateListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.AzpdFileAccess;
import com.aelitis.azureus.util.ExternalStimulusHandler;
import com.aelitis.azureus.util.ExternalStimulusListener;
import com.aelitis.azureus.util.PlayUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.ForceRecheckListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class DCAdManager
implements PlatformDCAdManager.GetAdvertDataReplyListener {
    private static DCAdManager instance = null;
    private static final long TIMEOUT_CHECKINGFORADS_MS = 120000L;
    private static final long EXPIRE_ASX = 600000L;
    private AzureusCore core;
    private List adsDMList = new ArrayList();
    private List adSupportedDMList = new ArrayList();
    private Object lastVuzeId;
    private int checkingForAds = 0;
    private long lastCheckingForAds = 0L;

    public static synchronized DCAdManager getInstance() {
        if (instance == null) {
            instance = new DCAdManager();
        }
        return instance;
    }

    private DCAdManager() {
    }

    public void initialize(AzureusCore _core) {
        this.core = _core;
        this.startAdTrackerListener();
        GlobalManager gm = this.core.getGlobalManager();
        gm.addListener(new GlobalManagerAdapter(){

            public void downloadManagerRemoved(DownloadManager dm) {
                DCAdManager.this.adsDMList.remove(dm);
                DCAdManager.this.deleteAsxFile(dm);
                DCAdManager.this.deleteAzpdFile(dm);
            }

            public void downloadManagerAdded(DownloadManager dm) {
                TOTorrent torrent = dm.getTorrent();
                if (PlatformTorrentUtils.isContentAdEnabled(torrent)) {
                    dm.setData("ASX", DCAdManager.this.determineASXFileLocation(dm));
                    try {
                        dm.setData("azpd", AzpdFileAccess.determineAzpdFileLocation(dm));
                    }
                    catch (TOTorrentException tote) {
                        DCAdManager.debug("Failed to set azpd location", tote);
                    }
                }
                DCAdManager.this.downloadManagerAddedHook(new DownloadManager[]{dm});
            }
        }, false);
        DownloadManager[] dms = gm.getDownloadManagers().toArray(new DownloadManager[0]);
        this.initDownloadManagerLists(dms);
        PlatformTorrentUtils.addListener(new MetaDataUpdateListener(){

            public void metaDataUpdated(TOTorrent torrent) {
                GlobalManager gm = DCAdManager.this.core.getGlobalManager();
                DownloadManager dm = gm.getDownloadManager(torrent);
                if (dm != null && PlatformTorrentUtils.isContentAdEnabled(dm.getTorrent())) {
                    DCAdManager.this.downloadManagerAddedHook(new DownloadManager[]{dm});
                }
            }
        });
        PlatformDCAdManager.loadUnsentImpressions();
        PlatformDCAdManager.sendUnsentImpressions(5000L);
        this.startAzpdFileCheckTimer(dms);
    }

    private void startAzpdFileCheckTimer(final DownloadManager[] dms) {
        long INIT_WAIT_TIME = 300000L;
        long startTime = System.currentTimeMillis() + 300000L;
        SimpleTimer.addEvent("azpdFileExpireThreadStartTimer", startTime, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                DCAdManager.this.startLazyAzpdFileCheckThread(dms);
            }
        });
    }

    private void startLazyAzpdFileCheckThread(final DownloadManager[] dms) {
        String THREAD_NAME = "azpdFileExpireThread";
        long CALL_WAIT_TIME = 5000L;
        AEThread2 thread = new AEThread2("azpdFileExpireThread", true){

            public void run() {
                if (dms == null) {
                    DCAdManager.debug("azpdFileExpireThread: exit");
                    return;
                }
                if (dms.length == 0) {
                    DCAdManager.debug("azpdFileExpireThread: exit. Nothing to check.");
                    return;
                }
                DCAdManager.debug("azpdFileExpireThread: starting.");
                for (DownloadManager dm : dms) {
                    File f;
                    if (!DCAdManager.isAdEnabledContent(dm)) continue;
                    try {
                        f = AzpdFileAccess.determineAzpdFileLocation(dm);
                    }
                    catch (TOTorrentException tot) {
                        DCAdManager.debug("azpdFileExpireThread: had " + tot.getMessage());
                        f = null;
                    }
                    if (f == null) continue;
                    DCAdManager.debug("azpdFileExpireThread: checking " + f.getAbsolutePath());
                    if (!AzpdFileAccess.isAzpdFileExpired(f)) continue;
                    DCAdManager.debug("azpdFileExpireThread: found expired azpd file " + f + ". Will refresh. ");
                    DCAdManager.this.downloadManagerAddedHook(new DownloadManager[]{dm});
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        DCAdManager.debug("azpdFileExpireThread: interrupted before while running.");
                        return;
                    }
                }
                DCAdManager.debug("azpdFileExpireThread: finished.");
            }
        };
        thread.start();
    }

    public static boolean isAdEnabledContent(DownloadManager dm) {
        TOTorrent torrent = dm.getTorrent();
        return PlatformTorrentUtils.isContent(torrent, true) && PlatformTorrentUtils.isContentAdEnabled(torrent);
    }

    private void deleteAsxFile(DownloadManager dm) {
        File asxFile = (File)dm.getData("ASX");
        if (asxFile != null) {
            try {
                asxFile.delete();
            }
            catch (Exception e) {
                DCAdManager.debug("failed to delete file: " + asxFile.getAbsolutePath());
            }
        } else {
            try {
                asxFile = this.determineASXFileLocation(dm);
                if (asxFile != null) {
                    asxFile.delete();
                }
            }
            catch (Exception e) {
                DCAdManager.debug("error while deleting asx file.", e);
            }
        }
    }

    private void deleteAzpdFile(DownloadManager dm) {
        File azpdFile = (File)dm.getData("azpd");
        if (azpdFile != null) {
            try {
                azpdFile.delete();
            }
            catch (Exception e) {
                DCAdManager.debug("failed to delete azpd file: " + azpdFile.getAbsolutePath());
            }
        } else {
            try {
                azpdFile = AzpdFileAccess.determineAzpdFileLocation(dm);
                if (azpdFile != null) {
                    azpdFile.delete();
                }
            }
            catch (Exception e) {
                DCAdManager.debug("error while deleting azpd file.", e);
            }
        }
    }

    private void startAdTrackerListener() {
        ExternalStimulusHandler.addListener(new ExternalStimulusListener(){

            public boolean receive(String name, Map values) {
                if (values == null) {
                    return false;
                }
                if (name.equals("adtracker")) {
                    DCAdManager.this.processImpression(values);
                    return true;
                }
                return false;
            }

            public int query(String name, Map values) {
                return Integer.MIN_VALUE;
            }
        });
    }

    protected void processImpression(Map values) {
        try {
            String vuzeId;
            String contentHash = (String)values.get("contentHash");
            if (contentHash == null) {
                DCAdManager.debug("No Content Hash on processImpression!");
                return;
            }
            String impressionID = (String)values.get("impressionTracker");
            if (impressionID == null) {
                DCAdManager.debug("No impressionTracker");
                return;
            }
            String thirdPartyImpressionUrl = (String)values.get("thirdPartyImp");
            if (thirdPartyImpressionUrl == null) {
                thirdPartyImpressionUrl = "";
            }
            if ((vuzeId = (String)values.get("vuzeId")) == null) {
                DCAdManager.debug(" No vuzeId ");
                return;
            }
            if (vuzeId.equals(this.lastVuzeId)) {
                return;
            }
            this.lastVuzeId = vuzeId;
            String adHash = (String)values.get("srcURL");
            if (adHash == null) {
                DCAdManager.debug("No srcURL");
                return;
            }
            String torrentHash = (String)values.get("torrentHash");
            if (torrentHash == null) {
                DCAdManager.debug("No torrentHash");
                return;
            }
            DownloadManager dmContent = null;
            if (torrentHash != null) {
                dmContent = this.core.getGlobalManager().getDownloadManager(new HashWrapper(Base32.decode(torrentHash)));
            }
            if (dmContent == null) {
                dmContent = this.core.getGlobalManager().getDownloadManager(new HashWrapper(Base32.decode(contentHash)));
            }
            if (dmContent != null) {
                DCAdManager.debug("clear last asx for " + dmContent.getTorrent().getHashWrapper().toBase32String());
                dmContent.setData("LastASX", null);
            }
            DCAdManager.debug("imp " + impressionID + " commencing on " + contentHash + "/" + torrentHash);
            DownloadManager dm = this.core.getGlobalManager().getDownloadManager(new HashWrapper(Base32.decode(adHash)));
            if (dm == null) {
                DCAdManager.debug("DM for Ad not found");
            }
            PlatformDCAdManager.saveImpression(impressionID, SystemTime.getCurrentTime(), contentHash, torrentHash, adHash, thirdPartyImpressionUrl, 5000L);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    private void downloadManagerAddedHook(final DownloadManager[] dms) {
        AEThread2 thread = new AEThread2("downloadManagerAddedHook", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DCAdManager.debug("enter - downloadManagerAddedHook");
                try {
                    DCAdManager.this.increaseCheckingForAds();
                    List adSupportedContentList = DCAdManager.this.initDownloadManagerLists(dms);
                    if (adSupportedContentList.size() == 0) {
                        DCAdManager.debug("none of the " + dms.length + " new torrent(s) are ad enabled.  SKIPPING getAdvert");
                        DCAdManager.this.determineReasonAdNotEnabled(dms);
                        return;
                    }
                    DCAdManager.this.callGetAdvert(adSupportedContentList);
                }
                finally {
                    DCAdManager.this.decreaseCheckingForAds();
                }
                DCAdManager.debug("exit - downloadManagerAddedHook");
            }
        };
        thread.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callGetAdvert(List adSupportedContentList) {
        try {
            this.increaseCheckingForAds();
            DCAdManager.debug("sending ad request for " + adSupportedContentList.size() + " pieces of content.  We already have " + this.adsDMList.size() + " ads");
            DownloadManager[] dmAdable = adSupportedContentList.toArray(new DownloadManager[0]);
            for (int i = 0; i < dmAdable.length; ++i) {
                DownloadManager dm = dmAdable[i];
                this.increaseCheckingForAds();
                PlatformDCAdManager.getAdvert(dm, 2000L, this);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        finally {
            this.decreaseCheckingForAds();
        }
    }

    public void messageSent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adsReceived(List torrents, Map webParams) {
        try {
            DCAdManager.debug("enter - adsReceived has #" + torrents.size() + " torrents");
            for (TOTorrent torrent : torrents) {
                try {
                    DownloadManager adDM;
                    DCAdManager.debug("Ad: " + new String(torrent.getName()));
                    TorrentUtils.setFlag(torrent, 1, true);
                    String adId = PlatformTorrentUtils.getAdId(torrent);
                    if (adId == null) {
                        PlatformTorrentUtils.setAdId(torrent, "1");
                    }
                    File tempFile = File.createTempFile("AZ_", ".torrent");
                    DCAdManager.debug("  Writing to " + tempFile);
                    torrent.serialiseToBEncodedFile(tempFile);
                    String sDefDir = null;
                    try {
                        sDefDir = COConfigurationManager.getDirectoryParameter("Default save path");
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (sDefDir == null) {
                        sDefDir = tempFile.getParent();
                    }
                    if ((adDM = this.core.getGlobalManager().addDownloadManager(tempFile.getAbsolutePath(), sDefDir)) != null) {
                        if (adDM.getAssumedComplete()) {
                            this.adsDMList.add(adDM);
                            adDM.setForceStart(false);
                        } else {
                            adDM.setForceStart(true);
                            DCAdManager.debug("Force Start " + adDM);
                            adDM.addListener(new DownloadManagerAdapter(){

                                public void downloadComplete(DownloadManager manager) {
                                    if (!DCAdManager.this.adsDMList.contains(manager)) {
                                        DCAdManager.this.adsDMList.add(manager);
                                    }
                                    manager.setForceStart(false);
                                    manager.removeListener(this);
                                }
                            });
                        }
                        DCAdManager.debug("  ADDED ad " + adDM.getDisplayName());
                    }
                    tempFile.deleteOnExit();
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
        finally {
            this.decreaseCheckingForAds();
        }
        DCAdManager.debug("exit - adsReceived");
    }

    public void replyReceived(String replyType, Map mapHashes) {
        this.decreaseCheckingForAds();
        DCAdManager.debug("bad reply. " + mapHashes.get("text"));
    }

    private void determineReasonAdNotEnabled(DownloadManager[] dms) {
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = dms[i];
            TOTorrent torrent = dm.getTorrent();
            StringBuffer sb = new StringBuffer();
            sb.append(new String(torrent.getName())).append(" reasons: ");
            if (PlatformTorrentUtils.isContent(torrent, true)) {
                sb.append("A-isContent , ");
            }
            if (PlatformTorrentUtils.getContentHash(torrent) != null) {
                sb.append("B-getConentHash , ");
            }
            if (PlatformTorrentUtils.isContentAdEnabled(torrent)) {
                sb.append("C-isContentAdEnabled");
            }
            DCAdManager.debug(sb.toString());
        }
    }

    private File determineASXFileLocation(DownloadManager dm) {
        DCAdManager.debug("determineASXFileLocation");
        EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(dm);
        File file = edm != null ? edm.getPrimaryFile().getFile(true) : new File(dm.getDownloadState().getPrimaryFile());
        return new File(file.getAbsolutePath() + ".asx");
    }

    public String replaceASXParams(DownloadManager dmContent) {
        DCAdManager.debug("replaceASXParams");
        Map playerDataMap = AzpdFileAccess.getPlayerDataMap(dmContent);
        String origPlaylist = (String)playerDataMap.get("playlist");
        if (origPlaylist == null) {
            DCAdManager.debug("The data map is missing 'playlist' key. - playerDataMap=" + playerDataMap);
            throw new IllegalStateException("The data map is missing 'playlist' key: " + playerDataMap);
        }
        StringBuffer repBuffer = new StringBuffer(origPlaylist);
        String contentPath = PlayUtils.getContentUrl(dmContent);
        DCAdManager.debug("  contentPath: " + contentPath);
        DCAdManager.replace(repBuffer, "<##-CONTENT-PATH-##>", contentPath);
        boolean isNullAd = this.determinIfNullAd(dmContent);
        if (!isNullAd) {
            try {
                File adFile = this.getAdMediaFromContentDownloadManager(dmContent);
                DCAdManager.debug("  adPath: " + adFile.getAbsolutePath());
                DCAdManager.replace(repBuffer, "<##-AD-PATH-##>", adFile.getAbsolutePath());
            }
            catch (Exception e) {
                DCAdManager.debug("reokacASXParams: " + e.toString());
                DCAdManager.replace(repBuffer, "<##-AD-PATH-##>", "http://www.vuze.com/img43/asx_noad.gif");
            }
        }
        DCAdManager.addParmasToDownloadManager(dmContent, playerDataMap);
        return repBuffer.toString();
    }

    private boolean determinIfNullAd(DownloadManager contentDM) {
        Map map = AzpdFileAccess.getPlayerDataMap(contentDM);
        List adHashList = (List)map.get("ad_hash");
        if (adHashList == null) {
            return true;
        }
        return adHashList.size() <= 0;
    }

    public static void addParmasToDownloadManager(DownloadManager dmContent, Map playerData) {
        String createTime = "" + System.currentTimeMillis();
        playerData.put("create-time", createTime);
        dmContent.setData("web-ad-params", playerData);
    }

    public void writeASXFile(File asxFileLocation, DownloadManager dmContent) {
        String finishedASX = this.replaceASXParams(dmContent);
        FileUtil.writeBytesAsFile(asxFileLocation.getAbsolutePath(), finishedASX.getBytes());
    }

    private static void replace(StringBuffer sb, String param, String value) {
        DCAdManager.replace(sb, param, value, 0);
    }

    private static void replace(StringBuffer sb, String param, String value, int startIndex) {
        int s = sb.indexOf(param, startIndex);
        sb.replace(s, s + param.length(), value);
    }

    private File getAdMediaFromContentDownloadManager(DownloadManager contentDM) {
        DCAdManager.debug("getAdMediaFromContentDownloadManager");
        GlobalManager gm = contentDM.getGlobalManager();
        Map map = AzpdFileAccess.getPlayerDataMap(contentDM);
        List adHashList = (List)map.get("ad_hash");
        String adHash = (String)adHashList.get(0);
        if (adHash == null || adHash.equals("")) {
            throw new IllegalStateException("No adHash found map=" + map);
        }
        HashWrapper adHashWrapper = new HashWrapper(Base32.decode(adHash));
        DownloadManager dmAd = gm.getDownloadManager(adHashWrapper);
        if (dmAd == null) {
            DCAdManager.debug("###  TODO  ### - Need to find an alternate method to get the ad media file location. ");
            throw new NullPointerException("Need to get an ad to play.");
        }
        File adFile = dmAd.getDiskManagerFileInfo()[0].getFile(true);
        return adFile;
    }

    public void createASX(DownloadManager dm, String url, ASXCreatedListener createdListener) {
        this.createASX(dm, createdListener);
    }

    public void createASX(DownloadManager dm, ASXCreatedListener asxCreatedListener) {
        if (dm == null) {
            DCAdManager.debug("createASX - null dm");
            return;
        }
        String name = dm.getDisplayName();
        DCAdManager.debug("enter - createASX");
        try {
            File asxFile;
            TOTorrent torrent = dm.getTorrent();
            if (torrent == null || !PlatformTorrentUtils.isContent(torrent, true)) {
                DCAdManager.debug("createASX - " + name + " not our content");
                return;
            }
            Object lastASXObject = dm.getData("LastASX");
            if (lastASXObject instanceof Long) {
                long lastASX = (Long)lastASXObject;
                if (SystemTime.getCurrentTime() - lastASX < 600000L && (asxFile = this.determineASXFileLocation(dm)).isFile()) {
                    DCAdManager.debug("playing " + name + " using existing asx: " + asxFile + "; expires in " + (600000L - (SystemTime.getCurrentTime() - lastASX)));
                    if (asxCreatedListener != null) {
                        asxCreatedListener.asxCreated(asxFile);
                    }
                    return;
                }
            }
            File newASXFile = this.determineASXFileLocation(dm);
            this.writeASXFile(newASXFile, dm);
            asxFile = this.determineASXFileLocation(dm);
            if (asxFile.isFile()) {
                DCAdManager.debug("playing " + name + " using existing asx: " + asxFile);
                if (asxCreatedListener != null) {
                    asxCreatedListener.asxCreated(asxFile);
                }
                return;
            }
            DCAdManager.debug("getting asx for " + name);
        }
        catch (Exception e) {
            if (asxCreatedListener != null) {
                asxCreatedListener.asxFailed();
            }
            DCAdManager.debug("createASX exception for " + name, e);
        }
        DCAdManager.debug("exit - createASX");
    }

    public boolean isAd(String nowPlaying) {
        if (nowPlaying == null) {
            return false;
        }
        File file = new File(nowPlaying);
        DownloadManager[] ads = this.getAds(true);
        for (int i = 0; i < ads.length; ++i) {
            DownloadManager downloadManager = ads[i];
            DiskManagerFileInfo[] fileInfos = downloadManager.getDiskManagerFileInfo();
            for (int j = 0; j < fileInfos.length; ++j) {
                DiskManagerFileInfo fileinfo = fileInfos[j];
                File adFile = fileinfo.getFile(true);
                if (!adFile.equals(file)) continue;
                return true;
            }
        }
        return false;
    }

    public DownloadManager[] getAds(boolean bIncludeIncomplete) {
        if (bIncludeIncomplete) {
            DCAdManager.debug("There are " + this.adsDMList.size() + " ads. including incomplete.");
            return this.adsDMList.toArray(new DownloadManager[0]);
        }
        ArrayList ads = new ArrayList(this.adsDMList);
        Iterator iter = ads.iterator();
        while (iter.hasNext()) {
            DownloadManager dm = (DownloadManager)iter.next();
            if (dm.getAssumedComplete()) continue;
            iter.remove();
        }
        DCAdManager.debug("There are " + ads.size() + " ads ");
        return ads.toArray(new DownloadManager[0]);
    }

    List initDownloadManagerLists(DownloadManager[] dms) {
        ArrayList<DownloadManager> adSupportedContentList = new ArrayList<DownloadManager>();
        if (dms == null) {
            return adSupportedContentList;
        }
        for (int i = 0; i < dms.length; ++i) {
            final DownloadManager dm = dms[i];
            TOTorrent torrent = dm.getTorrent();
            if (torrent == null) {
                return adSupportedContentList;
            }
            if (PlatformTorrentUtils.getAdId(torrent) != null) {
                try {
                    DCAdManager.debug("found ad " + dm + ": " + PlatformTorrentUtils.getAdId(torrent) + ": " + dm.getTorrent().getHashWrapper().toBase32String());
                }
                catch (TOTorrentException e) {
                    e.printStackTrace();
                }
                if (!this.adsDMList.contains(dm)) {
                    this.adsDMList.add(dm);
                }
            }
            if (!PlatformTorrentUtils.isContent(torrent, false) || !PlatformTorrentUtils.isContentAdEnabled(torrent)) continue;
            adSupportedContentList.add(dm);
            if (this.adSupportedDMList.contains(dm)) continue;
            this.adSupportedDMList.add(dm);
            if (dm.getAssumedComplete()) continue;
            dm.addListener(new DownloadManagerAdapter(){

                public void downloadComplete(DownloadManager manager) {
                    DCAdManager.debug("calling createASX from ...Hook, in torrent has AD block content=" + dm.getDisplayName());
                    DCAdManager.this.createASX(dm, null);
                }
            });
        }
        if (this.adsDMList.size() > 0) {
            new AEThread2("DCAdManager:adchecker", true){

                public void run() {
                    for (int i = 0; i < DCAdManager.this.adsDMList.size(); ++i) {
                        DownloadManager dm = (DownloadManager)DCAdManager.this.adsDMList.get(i);
                        if (dm.getAssumedComplete() && dm.filesExist()) {
                            dm.setForceStart(false);
                            continue;
                        }
                        if (dm.getState() == 100) {
                            dm.forceRecheck(new ForceRecheckListener(){

                                public void forceRecheckComplete(DownloadManager dm) {
                                    dm.setForceStart(true);
                                }
                            });
                        } else {
                            dm.setForceStart(true);
                        }
                        dm.addListener(new DownloadManagerAdapter(){

                            public void downloadComplete(DownloadManager manager) {
                                if (!DCAdManager.this.adsDMList.contains(manager)) {
                                    DCAdManager.this.adsDMList.add(manager);
                                }
                                manager.setForceStart(false);
                                manager.removeListener(this);
                            }
                        });
                    }
                }
            }.start();
        }
        return adSupportedContentList;
    }

    public void refreshAd(DownloadManager dm) {
        this.downloadManagerAddedHook(new DownloadManager[]{dm});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseCheckingForAds() {
        DCAdManager dCAdManager = this;
        synchronized (dCAdManager) {
            ++this.checkingForAds;
            this.lastCheckingForAds = SystemTime.getCurrentTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseCheckingForAds() {
        DCAdManager dCAdManager = this;
        synchronized (dCAdManager) {
            if (this.checkingForAds > 0) {
                --this.checkingForAds;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCheckingForNewAds() {
        DCAdManager dCAdManager = this;
        synchronized (dCAdManager) {
            if (SystemTime.getCurrentTime() - this.lastCheckingForAds > 120000L) {
                this.checkingForAds = 0;
            }
            return this.checkingForAds > 0;
        }
    }

    private static void debug(String msg) {
        PlatformDCAdManager.debug("DCAdManager: " + msg);
    }

    private static void debug(String msg, Throwable t) {
        PlatformDCAdManager.debug("DCAdManager: " + msg, t);
    }

    public static interface ASXCreatedListener {
        public void asxCreated(File var1);

        public void asxFailed();
    }
}

