/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import java.util.List;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.util.Base32;

public class MapUtils {
    public static int getMapInt(Map map, String key, int def) {
        try {
            return ((Number)map.get(key)).intValue();
        }
        catch (Exception e) {
            return def;
        }
    }

    public static long getMapLong(Map map, String key, long def) {
        try {
            return ((Number)map.get(key)).longValue();
        }
        catch (Exception e) {
            return def;
        }
    }

    public static String getMapString(Map map, String key, String def) {
        try {
            Object o = map.get(key);
            if (o == null && !map.containsKey(key)) {
                return def;
            }
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof byte[]) {
                return new String((byte[])o, "utf-8");
            }
            return def;
        }
        catch (Exception t) {
            return def;
        }
    }

    public static byte[] getMapByteArray(Map map, String key, byte[] def) {
        try {
            Object o = map.get(key);
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            String b64Key = key + ".B64";
            if (map.containsKey(b64Key) && (o = map.get(b64Key)) instanceof String) {
                return Base64.decode((String)o);
            }
            String b32Key = key + ".B32";
            if (map.containsKey(b32Key) && (o = map.get(b32Key)) instanceof String) {
                return Base32.decode((String)o);
            }
            return def;
        }
        catch (Exception t) {
            return def;
        }
    }

    public static Object getMapObject(Map map, String key, Object def, Class cla) {
        try {
            Object o = map.get(key);
            if (cla.isInstance(o)) {
                return o;
            }
            return def;
        }
        catch (Exception t) {
            return def;
        }
    }

    public static boolean getMapBoolean(Map map, String key, boolean def) {
        try {
            Object o = map.get(key);
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof Long) {
                return (Long)o == 1L;
            }
            return def;
        }
        catch (Exception e) {
            return def;
        }
    }

    public static List getMapList(Map map, String key, List def) {
        try {
            List list = (List)map.get(key);
            if (list == null && !map.containsKey(key)) {
                return def;
            }
            return list;
        }
        catch (Exception t) {
            return def;
        }
    }

    public static Map getMapMap(Map map, String key, Map def) {
        try {
            Map valMap = (Map)map.get(key);
            if (valMap == null && !map.containsKey(key)) {
                return def;
            }
            return valMap;
        }
        catch (Exception t) {
            return def;
        }
    }
}

