/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.util.DataSourceUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import org.eclipse.swt.program.Program;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;

public class PlayUtils {
    private static boolean triedLoadingEmpPluginClass = false;
    private static Method methodIsExternallyPlayable;

    public static boolean prepareForPlay(DownloadManager dm) {
        EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(dm);
        if (edm != null) {
            edm.setProgressiveMode(true);
            return true;
        }
        return false;
    }

    public static boolean canProgressiveOrIsComplete(TOTorrent torrent) {
        if (torrent == null) {
            return false;
        }
        try {
            DownloadManagerEnhancer enhancer = DownloadManagerEnhancer.getSingleton();
            EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(torrent.getHash());
            if (edm == null) {
                return enhancer.isProgressiveAvailable() && PlatformTorrentUtils.isContentProgressive(torrent);
            }
            boolean complete = edm.getDownloadManager().isDownloadComplete(false);
            if (complete) {
                return true;
            }
            if (!edm.supportsProgressiveMode()) {
                return false;
            }
        }
        catch (TOTorrentException e) {
            return false;
        }
        return true;
    }

    public static boolean canUseEMP(TOTorrent torrent) {
        if (PlayUtils.canPlayViaExternalEMP(torrent)) {
            return true;
        }
        if (!PlatformTorrentUtils.useEMP(torrent) || !PlatformTorrentUtils.embeddedPlayerAvail()) {
            return false;
        }
        return PlayUtils.canProgressiveOrIsComplete(torrent);
    }

    private static boolean canPlay(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        TOTorrent torrent = dm.getTorrent();
        return PlayUtils.canUseEMP(torrent);
    }

    private static boolean canPlay(TOTorrent torrent) {
        if (!PlatformTorrentUtils.isContent(torrent, false)) {
            return false;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        DownloadManager dm = gm.getDownloadManager(torrent);
        if (dm != null) {
            return dm.getAssumedComplete() || PlayUtils.canUseEMP(torrent);
        }
        return PlayUtils.canUseEMP(torrent);
    }

    public static boolean canPlayDS(Object ds) {
        if (ds == null) {
            return false;
        }
        DownloadManager dm = DataSourceUtils.getDM(ds);
        if (dm != null) {
            return PlayUtils.canPlay(dm);
        }
        TOTorrent torrent = DataSourceUtils.getTorrent(ds);
        if (torrent != null) {
            return PlayUtils.canPlay(torrent);
        }
        if (ds instanceof VuzeActivitiesEntry) {
            return ((VuzeActivitiesEntry)ds).isPlayable();
        }
        if (ds instanceof SelectedContentV3) {
            SelectedContentV3 sel = (SelectedContentV3)ds;
            return sel.canPlay();
        }
        return false;
    }

    public static String getContentUrl(DownloadManager dmContent) {
        String contentPath;
        if (dmContent.isDownloadComplete(false)) {
            EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(dmContent);
            File file = edm != null ? edm.getPrimaryFile().getFile(true) : new File(dmContent.getDownloadState().getPrimaryFile());
            try {
                contentPath = file.toURL().toString();
            }
            catch (MalformedURLException e) {
                contentPath = file.getAbsolutePath();
            }
        } else {
            contentPath = PlayUtils.getMediaServerContentURL(dmContent);
        }
        return contentPath;
    }

    public static String getMediaServerContentURL(DownloadManager dm) {
        try {
            return PlayUtils.getMediaServerContentURL(DownloadManagerImpl.getDownloadStatic(dm));
        }
        catch (DownloadException downloadException) {
            return null;
        }
    }

    public static String getMediaServerContentURL(Download dl) {
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getPluginInterfaceByID("azupnpav", false);
        if (pi == null) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not found"));
            return null;
        }
        if (!pi.getPluginState().isOperational()) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not operational"));
            return null;
        }
        try {
            Program program = Program.findProgram((String)".qtl");
            boolean hasQuickTime = program == null ? false : program.getName().toLowerCase().indexOf("quicktime") != -1;
            pi.getIPC().invoke("setQuickTimeAvailable", new Object[]{new Boolean(hasQuickTime)});
            Object url = pi.getIPC().invoke("getContentURL", new Object[]{dl});
            if (url instanceof String) {
                return (String)url;
            }
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LogIDs.UI3, 1, "IPC to media server plugin failed", e));
        }
        return null;
    }

    private static final synchronized boolean loadEmpPluginClass() {
        if (!triedLoadingEmpPluginClass) {
            triedLoadingEmpPluginClass = true;
            try {
                PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp");
                if (pi == null) {
                    return false;
                }
                Class<?> empPluginClass = pi.getPlugin().getClass();
                methodIsExternallyPlayable = empPluginClass.getMethod("isExternallyPlayabale", TOTorrent.class);
            }
            catch (Exception e1) {
                return false;
            }
        }
        return true;
    }

    private static final boolean canPlayViaExternalEMP(TOTorrent torrent) {
        block5: {
            if (!PlayUtils.loadEmpPluginClass()) {
                return false;
            }
            if (methodIsExternallyPlayable == null) {
                return false;
            }
            try {
                Object retObj = methodIsExternallyPlayable.invoke(null, torrent);
                if (retObj instanceof Boolean) {
                    return (Boolean)retObj;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (e.getMessage() != null && e.getMessage().toLowerCase().endsWith("only")) break block5;
                Debug.out(e);
            }
        }
        return false;
    }
}

