/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDWrapper
implements Comparable<IDWrapper> {
    public static final char[] hex_char = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final byte[] raw_id;

    public IDWrapper(byte[] _raw_id) {
        this.raw_id = _raw_id;
    }

    public byte[] getRawId() {
        return this.raw_id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IDWrapper) {
            IDWrapper other = (IDWrapper)obj;
            return Arrays.equals(this.raw_id, other.raw_id);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.raw_id);
    }

    @Override
    public int compareTo(IDWrapper other) {
        if (this == other) {
            return 0;
        }
        for (int i = 0; i < this.raw_id.length; ++i) {
            if (this.raw_id[i] == other.raw_id[i]) continue;
            return (this.raw_id[i] & 0xFF) < (other.raw_id[i] & 0xFF) ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(64);
        sbuf.append("0x");
        for (int i = 0; i < this.raw_id.length; ++i) {
            sbuf.append(hex_char[this.raw_id[i] >> 4 & 0xF]);
            sbuf.append(hex_char[this.raw_id[i] & 0xF]);
        }
        return sbuf.toString();
    }
}

