/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.config.impl.StringListImpl;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashSet;

public class ConfigurationManager
implements AEDiagnosticsEvidenceGenerator {
    private static ConfigurationManager config_temp = null;
    private static ConfigurationManager config = null;
    private static AEMonitor class_mon = new AEMonitor("ConfigMan:class");
    private Map propertiesMap;
    private List transient_properties = new ArrayList();
    private List listeners = new ArrayList();
    private Hashtable parameterListeners = new Hashtable();
    private AEMonitor this_mon = new AEMonitor("ConfigMan");
    private static FrequencyLimitedDispatcher dirty_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        public void runSupport() {
            COConfigurationManager.save();
        }
    }, 30000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationManager getInstance() {
        try {
            class_mon.enter();
            if (config == null) {
                if (config_temp == null) {
                    config_temp = new ConfigurationManager();
                    config_temp.load();
                    config_temp.initialise();
                    config = config_temp;
                } else {
                    if (ConfigurationManager.config_temp.propertiesMap == null) {
                        config_temp.load();
                    }
                    ConfigurationManager configurationManager = config_temp;
                    return configurationManager;
                }
            }
            ConfigurationManager configurationManager = config;
            return configurationManager;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationManager getInstance(Map data) {
        try {
            class_mon.enter();
            if (config == null) {
                config = new ConfigurationManager(data);
            }
            ConfigurationManager configurationManager = config;
            return configurationManager;
        }
        finally {
            class_mon.exit();
        }
    }

    private ConfigurationManager() {
    }

    private ConfigurationManager(Map data) {
        if (data.get("Logger.DebugFiles.Enabled") == null) {
            data.put("Logger.DebugFiles.Enabled", new Long(0L));
        }
        this.propertiesMap = data;
    }

    protected void initialise() {
        ConfigurationChecker.checkConfiguration();
        ConfigurationChecker.setSystemProperties();
        AEDiagnostics.addEvidenceGenerator(this);
    }

    public void load(String filename) {
        Map data = FileUtil.readResilientConfigFile(filename, false);
        if (this.propertiesMap == null) {
            this.propertiesMap = data;
        }
    }

    public void load() {
        this.load("azureus.config");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filename) {
        ArrayList listeners_copy;
        if (this.propertiesMap == null) {
            return;
        }
        TreeMap properties_clone = new TreeMap(this.propertiesMap);
        if (!this.transient_properties.isEmpty()) {
            properties_clone.keySet().removeAll(this.transient_properties);
        }
        FileUtil.writeResilientConfigFile(filename, properties_clone);
        try {
            this.this_mon.enter();
            listeners_copy = new ArrayList(this.listeners);
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < listeners_copy.size(); ++i) {
            COConfigurationListener l = (COConfigurationListener)listeners_copy.get(i);
            if (l != null) {
                try {
                    l.configurationSaved();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                continue;
            }
            Debug.out("COConfigurationListener is null");
        }
    }

    public void save() {
        this.save("azureus.config");
    }

    public void setDirty() {
        dirty_dispatcher.dispatch();
    }

    public boolean isNewInstall() {
        return ConfigurationChecker.isNewInstall();
    }

    public Set getDefinedParameters() {
        return this.propertiesMap.keySet();
    }

    public boolean getBooleanParameter(String parameter, boolean defaultValue) {
        int defaultInt = defaultValue ? 1 : 0;
        int result = this.getIntParameter(parameter, defaultInt);
        return result != 0;
    }

    public boolean getBooleanParameter(String parameter) {
        int result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getIntParameter(parameter, def.getIntParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getIntParameter(parameter, 0);
        }
        return result != 0;
    }

    public boolean setParameter(String parameter, boolean value) {
        return this.setParameter(parameter, value ? 1 : 0);
    }

    private Long getLongParameterRaw(String parameter) {
        try {
            return (Long)this.propertiesMap.get(parameter);
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
            return null;
        }
    }

    public int getIntParameter(String parameter, int defaultValue) {
        Long tempValue = this.getLongParameterRaw(parameter);
        return tempValue != null ? tempValue.intValue() : defaultValue;
    }

    public int getIntParameter(String parameter) {
        int result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getIntParameter(parameter, def.getIntParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getIntParameter(parameter, 0);
        }
        return result;
    }

    public long getLongParameter(String parameter, long defaultValue) {
        Long tempValue = this.getLongParameterRaw(parameter);
        return tempValue != null ? tempValue : defaultValue;
    }

    public long getLongParameter(String parameter) {
        long result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getLongParameter(parameter, def.getLongParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getLongParameter(parameter, 0L);
        }
        return result;
    }

    private byte[] getByteParameterRaw(String parameter) {
        return (byte[])this.propertiesMap.get(parameter);
    }

    public byte[] getByteParameter(String parameter) {
        byte[] result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getByteParameter(parameter, def.getByteParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getByteParameter(parameter, ConfigurationDefaults.def_bytes);
        }
        return result;
    }

    public byte[] getByteParameter(String parameter, byte[] defaultValue) {
        byte[] tempValue = this.getByteParameterRaw(parameter);
        return tempValue != null ? tempValue : defaultValue;
    }

    private String getStringParameter(String parameter, byte[] defaultValue) {
        byte[] bp = this.getByteParameter(parameter, defaultValue);
        if (bp == null) {
            bp = this.getByteParameter(parameter, null);
        }
        if (bp == null) {
            return null;
        }
        return ConfigurationManager.bytesToString(bp);
    }

    public String getStringParameter(String parameter, String defaultValue) {
        String tempValue = this.getStringParameter(parameter, (byte[])null);
        return tempValue != null ? tempValue : defaultValue;
    }

    public String getStringParameter(String parameter) {
        String result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getStringParameter(parameter, def.getStringParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getStringParameter(parameter, "");
        }
        return result;
    }

    public StringList getStringListParameter(String parameter) {
        try {
            List rawList = (List)this.propertiesMap.get(parameter);
            if (rawList == null) {
                return new StringListImpl();
            }
            return new StringListImpl(rawList);
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
            return new StringListImpl();
        }
    }

    public boolean setParameter(String parameter, StringList value) {
        try {
            ArrayList<byte[]> encoded = new ArrayList<byte[]>();
            List l = ((StringListImpl)value).getList();
            for (int i = 0; i < l.size(); ++i) {
                encoded.add(ConfigurationManager.stringToBytes((String)l.get(i)));
            }
            this.propertiesMap.put(parameter, encoded);
            this.notifyParameterListeners(parameter);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public List getListParameter(String parameter, List def) {
        try {
            List rawList = (List)this.propertiesMap.get(parameter);
            if (rawList == null) {
                return def;
            }
            return rawList;
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
            return def;
        }
    }

    public boolean setParameter(String parameter, List value) {
        try {
            this.propertiesMap.put(parameter, value);
            this.notifyParameterListeners(parameter);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public Map getMapParameter(String parameter, Map def) {
        try {
            Map map = (Map)this.propertiesMap.get(parameter);
            if (map == null) {
                return def;
            }
            return map;
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
            return def;
        }
    }

    public boolean setParameter(String parameter, Map value) {
        try {
            this.propertiesMap.put(parameter, value);
            this.notifyParameterListeners(parameter);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public String getDirectoryParameter(String parameter) throws IOException {
        String dir = this.getStringParameter(parameter);
        if (dir.length() > 0) {
            File temp = new File(dir);
            if (!temp.exists()) {
                FileUtil.mkdirs(temp);
            }
            if (!temp.isDirectory()) {
                throw new IOException("Configuration error. This is not a directory: " + dir);
            }
        }
        return dir;
    }

    public float getFloatParameter(String parameter) {
        return this.getFloatParameter(parameter, 0.0f);
    }

    public float getFloatParameter(String parameter, float def_val) {
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            Object o = this.propertiesMap.get(parameter);
            if (o instanceof Number) {
                return ((Number)o).floatValue();
            }
            String s = this.getStringParameter(parameter);
            if (!s.equals("")) {
                return Float.parseFloat(s);
            }
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
        }
        try {
            return def.getFloatParameter(parameter);
        }
        catch (Exception e2) {
            return def_val;
        }
    }

    public boolean setParameter(String parameter, float defaultValue) {
        String newValue = String.valueOf(defaultValue);
        return this.setParameter(parameter, ConfigurationManager.stringToBytes(newValue));
    }

    public boolean setParameter(String parameter, int defaultValue) {
        Long newValue = new Long(defaultValue);
        try {
            Long oldValue = this.propertiesMap.put(parameter, newValue);
            return this.notifyParameterListenersIfChanged(parameter, newValue, oldValue);
        }
        catch (ClassCastException e) {
            this.notifyParameterListeners(parameter);
            return true;
        }
    }

    public boolean setParameter(String parameter, long defaultValue) {
        Long newValue = new Long(defaultValue);
        try {
            Long oldValue = this.propertiesMap.put(parameter, newValue);
            return this.notifyParameterListenersIfChanged(parameter, newValue, oldValue);
        }
        catch (ClassCastException e) {
            this.notifyParameterListeners(parameter);
            return true;
        }
    }

    public boolean setParameter(String parameter, byte[] defaultValue) {
        try {
            byte[] oldValue = this.propertiesMap.put(parameter, defaultValue);
            return this.notifyParameterListenersIfChanged(parameter, defaultValue, oldValue);
        }
        catch (ClassCastException e) {
            this.notifyParameterListeners(parameter);
            return true;
        }
    }

    public boolean setParameter(String parameter, String defaultValue) {
        return this.setParameter(parameter, ConfigurationManager.stringToBytes(defaultValue));
    }

    public boolean hasParameter(String key, boolean explicit) {
        if (this.propertiesMap.containsKey(key)) {
            return true;
        }
        return !explicit && ConfigurationDefaults.getInstance().hasParameter(key);
    }

    public boolean verifyParameter(String parameter, String value) {
        List verifiers = ConfigurationDefaults.getInstance().getVerifiers(parameter);
        if (verifiers != null) {
            try {
                for (int i = 0; i < verifiers.size(); ++i) {
                    COConfigurationManager.ParameterVerifier verifier = (COConfigurationManager.ParameterVerifier)verifiers.get(i);
                    if (verifier == null) continue;
                    try {
                        if (verifier.verify(parameter, value)) continue;
                        return false;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return true;
    }

    public boolean setRGBParameter(String parameter, int red, int green, int blue) {
        boolean bAnyChanged = false;
        bAnyChanged |= this.setParameter(parameter + ".red", red);
        bAnyChanged |= this.setParameter(parameter + ".green", green);
        if (bAnyChanged |= this.setParameter(parameter + ".blue", blue)) {
            this.notifyParameterListeners(parameter);
        }
        return bAnyChanged;
    }

    public boolean setRGBParameter(String parameter, int[] rgb, boolean override) {
        boolean changed = false;
        if (rgb == null) {
            changed |= this.removeParameter(parameter + ".override");
            changed |= this.removeParameter(parameter + ".red");
            changed |= this.removeParameter(parameter + ".green");
            changed |= this.removeParameter(parameter + ".blue");
        } else {
            changed |= this.setParameter(parameter + ".override", override);
            changed |= this.setRGBParameter(parameter, rgb[0], rgb[1], rgb[2]);
        }
        if (changed) {
            this.notifyParameterListeners(parameter);
        }
        return changed;
    }

    public boolean setParameter(String parameter) throws ConfigurationParameterNotFoundException {
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            return this.setParameter(parameter, def.getIntParameter(parameter));
        }
        catch (Exception e) {
            return this.setParameter(parameter, def.getStringParameter(parameter));
        }
    }

    public Object getParameter(String name) {
        Object value = this.propertiesMap.get(name);
        if (value == null) {
            value = ConfigurationDefaults.getInstance().getParameter(name);
        }
        return value;
    }

    public void setParameterRawNoNotify(String parameter, Object value) {
        this.propertiesMap.put(parameter, value);
    }

    public void registerTransientParameter(String param) {
        this.transient_properties.add(param);
    }

    public boolean removeParameter(String parameter) {
        boolean removed;
        boolean bl = removed = this.propertiesMap.remove(parameter) != null;
        if (removed) {
            this.notifyParameterListeners(parameter);
        }
        return removed;
    }

    public boolean removeRGBParameter(String parameter) {
        boolean bAnyChanged = false;
        bAnyChanged |= this.removeParameter(parameter + ".red");
        bAnyChanged |= this.removeParameter(parameter + ".green");
        bAnyChanged |= this.removeParameter(parameter + ".blue");
        if (bAnyChanged |= this.removeParameter(parameter + ".override")) {
            this.notifyParameterListeners(parameter);
        }
        return bAnyChanged;
    }

    public boolean doesParameterNonDefaultExist(String parameter) {
        return this.propertiesMap.containsKey(parameter);
    }

    private boolean notifyParameterListenersIfChanged(String parameter, Long newValue, Long oldValue) {
        if (oldValue == null || 0 != newValue.compareTo(oldValue)) {
            this.notifyParameterListeners(parameter);
            return true;
        }
        return false;
    }

    private boolean notifyParameterListenersIfChanged(String parameter, byte[] newValue, byte[] oldValue) {
        if (oldValue == null || !Arrays.equals(newValue, oldValue)) {
            this.notifyParameterListeners(parameter);
            return true;
        }
        return false;
    }

    private void notifyParameterListeners(String parameter) {
        LightHashSet parameterListener = (LightHashSet)this.parameterListeners.get(parameter);
        if (parameterListener == null) {
            return;
        }
        for (ParameterListener listener : parameterListener) {
            if (listener == null) continue;
            try {
                listener.parameterChanged(parameter);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameterListener(String parameter, ParameterListener listener) {
        try {
            this.this_mon.enter();
            if (parameter == null || listener == null) {
                return;
            }
            LightHashSet parameterListener = (LightHashSet)this.parameterListeners.get(parameter);
            if (parameterListener == null) {
                parameterListener = new LightHashSet(1);
                this.parameterListeners.put(parameter, parameterListener);
            }
            if (!parameterListener.contains(listener)) {
                parameterListener.add(listener);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameterListener(String parameter, ParameterListener listener) {
        try {
            this.this_mon.enter();
            if (parameter == null || listener == null) {
                return;
            }
            LightHashSet parameterListener = (LightHashSet)this.parameterListeners.get(parameter);
            if (parameterListener != null) {
                parameterListener.remove(listener);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(COConfigurationListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(COConfigurationListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("Configuration Details");
        try {
            writer.indent();
            writer.println("System Properties");
            try {
                writer.indent();
                Properties props = System.getProperties();
                for (String string : new TreeSet<Object>(props.keySet())) {
                    writer.println(string + "=" + props.get(string));
                }
            }
            finally {
                writer.exdent();
            }
            writer.println("Azureus Config");
            try {
                writer.indent();
                for (String key : new TreeSet(this.propertiesMap.keySet())) {
                    if (key.startsWith("core.crypto.")) continue;
                    Object v = this.propertiesMap.get(key);
                    boolean bParamExists = ConfigurationDefaults.getInstance().doesParameterDefaultExist(key.toString());
                    if (!bParamExists) {
                        key = "[NoDef] " + key;
                    }
                    if (v instanceof Long) {
                        writer.println(key + "=" + v);
                        continue;
                    }
                    if (v instanceof List) {
                        writer.println(key + "=" + v + "[list]");
                        continue;
                    }
                    if (v instanceof Map) {
                        writer.println(key + "=" + v + "[map]");
                        continue;
                    }
                    if (v instanceof byte[]) {
                        byte[] b = (byte[])v;
                        boolean hex = false;
                        for (int i = 0; i < b.length; ++i) {
                            char c = (char)b[i];
                            if (Character.isLetterOrDigit(c) || "`\ufffd\ufffd\ufffd\"\ufffd\ufffd\ufffd$%^&*()-_=+[{]};:'@#~,<.>/?'".indexOf(c) != -1) continue;
                            hex = true;
                            break;
                        }
                        writer.println(key + "=" + (hex ? ByteFormatter.nicePrint(b) : ConfigurationManager.bytesToString((byte[])v)));
                        continue;
                    }
                    writer.println(key + "=" + v + "[unknown]");
                }
            }
            finally {
                writer.exdent();
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected static String bytesToString(byte[] bytes) {
        try {
            return new String(bytes, "UTF8");
        }
        catch (Throwable e) {
            return new String(bytes);
        }
    }

    protected static byte[] stringToBytes(String str) {
        try {
            return str.getBytes("UTF8");
        }
        catch (Throwable e) {
            return str.getBytes();
        }
    }
}

