/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import java.io.File;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;

public class DiskManagerUtil {
    private static final LogIDs LOGID = LogIDs.DISK;
    protected static int max_read_block_size;

    public static boolean checkBlockConsistencyForHint(DiskManager dm, String originator, int pieceNumber, int offset, int length) {
        if (length <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " length=" + length + " <= 0"));
            }
            return false;
        }
        if (pieceNumber < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " pieceNumber=" + pieceNumber + " < 0"));
            }
            return false;
        }
        if (pieceNumber >= dm.getNbPieces()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " pieceNumber=" + pieceNumber + " >= this.nbPieces=" + dm.getNbPieces()));
            }
            return false;
        }
        int pLength = dm.getPieceLength(pieceNumber);
        if (offset < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " offset=" + offset + " < 0"));
            }
            return false;
        }
        if (offset > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " offset=" + offset + " > pLength=" + pLength));
            }
            return false;
        }
        if (offset + length > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " offset=" + offset + " + length=" + length + " > pLength=" + pLength));
            }
            return false;
        }
        return true;
    }

    public static boolean checkBlockConsistencyForRead(DiskManager dm, String originator, int pieceNumber, int offset, int length) {
        if (!DiskManagerUtil.checkBlockConsistencyForHint(dm, originator, pieceNumber, offset, length)) {
            return false;
        }
        if (length > max_read_block_size) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Read invalid: " + originator + " length=" + length + " > " + max_read_block_size));
            }
            return false;
        }
        if (!dm.getPiece(pieceNumber).isDone()) {
            Logger.log(new LogEvent((Object)dm, LOGID, 3, "Read invalid: " + originator + " piece #" + pieceNumber + " not done"));
            return false;
        }
        return true;
    }

    public static void doFileExistenceChecks(DiskManagerFileInfoSet fileSet, boolean[] toCheck, DownloadManager dm, boolean allowAlloction) {
        DiskManagerFileInfo[] files = fileSet.getFiles();
        int lastPieceScanned = -1;
        int windowStart = -1;
        int windowEnd = -1;
        String[] types = DiskManagerImpl.getStorageTypes(dm);
        for (int i = 0; i < files.length; ++i) {
            int firstPiece = files[i].getFirstPieceNumber();
            int lastPiece = files[i].getLastPieceNumber();
            if (toCheck[i]) {
                if (lastPieceScanned < firstPiece) {
                    windowStart = firstPiece;
                    while (i > 0 && files[i - 1].getLastPieceNumber() >= windowStart) {
                        --i;
                    }
                }
                if (windowEnd < lastPiece) {
                    windowEnd = lastPiece;
                }
            }
            if ((windowStart > firstPiece || firstPiece > windowEnd) && (windowStart > lastPiece || lastPiece > windowEnd)) continue;
            File currentFile = files[i].getFile(true);
            if (!RDResumeHandler.fileMustExist(dm, files[i])) {
                if (types[i].equals("C")) {
                    currentFile.delete();
                }
            } else if (allowAlloction && types[i].equals("L") && !currentFile.exists()) {
                dm.setDataAlreadyAllocated(false);
            }
            lastPieceScanned = lastPiece;
        }
    }

    static {
        ParameterListener param_listener = new ParameterListener(){

            public void parameterChanged(String str) {
                max_read_block_size = COConfigurationManager.getIntParameter("BT Request Max Block Size");
            }
        };
        COConfigurationManager.addAndFireParameterListener("BT Request Max Block Size", param_listener);
    }
}

