/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequest;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequestListener;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.access.impl.DiskManagerReadRequestImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.SystemTime;

public class DMReaderImpl
implements DMReader {
    private static final LogIDs LOGID = LogIDs.DISK;
    private DiskManagerHelper disk_manager;
    private DiskAccessController disk_access;
    private int async_reads;
    private Set read_requests = new HashSet();
    private AESemaphore async_read_sem = new AESemaphore("DMReader:asyncReads");
    private boolean started;
    private boolean stopped;
    protected AEMonitor this_mon = new AEMonitor("DMReader");

    public DMReaderImpl(DiskManagerHelper _disk_manager) {
        this.disk_manager = _disk_manager;
        this.disk_access = this.disk_manager.getDiskAccessController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new RuntimeException("can't start twice");
            }
            if (this.stopped) {
                throw new RuntimeException("already been stopped");
            }
            this.started = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        int read_wait;
        try {
            this.this_mon.enter();
            if (this.stopped || !this.started) {
                return;
            }
            this.stopped = true;
            read_wait = this.async_reads;
        }
        finally {
            this.this_mon.exit();
        }
        long log_time = SystemTime.getCurrentTime();
        for (int i = 0; i < read_wait; ++i) {
            long now = SystemTime.getCurrentTime();
            if (now < log_time) {
                log_time = now;
            } else if (now - log_time > 1000L) {
                log_time = now;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_manager, LOGID, "Waiting for reads to complete - " + (read_wait - i) + " remaining"));
                }
            }
            this.async_read_sem.reserve();
        }
    }

    public DiskManagerReadRequest createReadRequest(int pieceNumber, int offset, int length) {
        return new DiskManagerReadRequestImpl(pieceNumber, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOutstandingReadRequestForPiece(int piece_number) {
        try {
            this.this_mon.enter();
            Iterator it = this.read_requests.iterator();
            while (it.hasNext()) {
                DiskManagerReadRequest request2 = (DiskManagerReadRequest)((Object[])it.next())[0];
                if (request2.getPieceNumber() != piece_number) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public DirectByteBuffer readBlock(int pieceNumber, int offset, int length) {
        DiskManagerReadRequest request2 = this.createReadRequest(pieceNumber, offset, length);
        final AESemaphore sem = new AESemaphore("DMReader:readBlock");
        final DirectByteBuffer[] result = new DirectByteBuffer[]{null};
        this.readBlock(request2, new DiskManagerReadRequestListener(){

            public void readCompleted(DiskManagerReadRequest request2, DirectByteBuffer data) {
                result[0] = data;
                sem.release();
            }

            public void readFailed(DiskManagerReadRequest request2, Throwable cause) {
                sem.release();
            }

            public int getPriority() {
                return -1;
            }

            public void requestExecuted(long bytes) {
            }
        });
        sem.reserve();
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBlock(DiskManagerReadRequest request2, final DiskManagerReadRequestListener _listener) {
        request2.requestStarts();
        final DiskManagerReadRequestListener listener = new DiskManagerReadRequestListener(){

            public void readCompleted(DiskManagerReadRequest request2, DirectByteBuffer data) {
                request2.requestEnds(true);
                _listener.readCompleted(request2, data);
            }

            public void readFailed(DiskManagerReadRequest request2, Throwable cause) {
                request2.requestEnds(false);
                _listener.readFailed(request2, cause);
            }

            public int getPriority() {
                return _listener.getPriority();
            }

            public void requestExecuted(long bytes) {
                _listener.requestExecuted(bytes);
            }
        };
        DirectByteBuffer buffer = null;
        try {
            int currentFile;
            int length = request2.getLength();
            buffer = DirectByteBufferPool.getBuffer((byte)6, length);
            if (buffer == null) {
                Debug.out("DiskManager::readBlock:: ByteBufferPool returned null buffer");
                listener.readFailed(request2, new Exception("Out of memory"));
                return;
            }
            int pieceNumber = request2.getPieceNumber();
            int offset = request2.getOffset();
            DMPieceList pieceList2 = this.disk_manager.getPieceList(pieceNumber);
            if (pieceList2.size() == 0) {
                Debug.out("no pieceList entries for " + pieceNumber);
                listener.readCompleted(request2, buffer);
                return;
            }
            long previousFilesLength = 0L;
            long fileOffset = pieceList2.get(0).getOffset();
            for (currentFile = 0; currentFile < pieceList2.size() && pieceList2.getCumulativeLengthToPiece(currentFile) < offset; ++currentFile) {
                previousFilesLength = pieceList2.getCumulativeLengthToPiece(currentFile);
                fileOffset = 0L;
            }
            fileOffset += (long)offset - previousFilesLength;
            ArrayList<Object[]> chunks = new ArrayList<Object[]>();
            int buffer_position = 0;
            while (buffer_position < length && currentFile < pieceList2.size()) {
                DMPieceMapEntry map_entry = pieceList2.get(currentFile);
                int length_available = map_entry.getLength() - (int)(fileOffset - map_entry.getOffset());
                int entry_read_limit = buffer_position + length_available;
                entry_read_limit = Math.min(length, entry_read_limit);
                chunks.add(new Object[]{map_entry.getFile().getCacheFile(), new Long(fileOffset), new Integer(entry_read_limit)});
                buffer_position = entry_read_limit;
                ++currentFile;
                fileOffset = 0L;
            }
            if (chunks.size() == 0) {
                Debug.out("no chunk reads for " + pieceNumber);
                listener.readCompleted(request2, buffer);
                return;
            }
            final Object[] request_wrapper = new Object[]{request2};
            DiskManagerReadRequestListener l = new DiskManagerReadRequestListener(){

                public void readCompleted(DiskManagerReadRequest request2, DirectByteBuffer data) {
                    this.complete();
                    listener.readCompleted(request2, data);
                }

                public void readFailed(DiskManagerReadRequest request2, Throwable cause) {
                    this.complete();
                    listener.readFailed(request2, cause);
                }

                public int getPriority() {
                    return _listener.getPriority();
                }

                public void requestExecuted(long bytes) {
                    _listener.requestExecuted(bytes);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void complete() {
                    try {
                        DMReaderImpl.this.this_mon.enter();
                        DMReaderImpl.this.async_reads--;
                        if (!DMReaderImpl.this.read_requests.remove(request_wrapper)) {
                            Debug.out("request not found");
                        }
                        if (DMReaderImpl.this.stopped) {
                            DMReaderImpl.this.async_read_sem.release();
                        }
                    }
                    finally {
                        DMReaderImpl.this.this_mon.exit();
                    }
                }
            };
            try {
                this.this_mon.enter();
                if (this.stopped) {
                    buffer.returnToPool();
                    listener.readFailed(request2, new Exception("Disk reader has been stopped"));
                    return;
                }
                ++this.async_reads;
                this.read_requests.add(request_wrapper);
            }
            finally {
                this.this_mon.exit();
            }
            new requestDispatcher(request2, l, buffer, chunks);
        }
        catch (Throwable e) {
            if (buffer != null) {
                buffer.returnToPool();
            }
            this.disk_manager.setFailed("Disk read error - " + Debug.getNestedExceptionMessage(e));
            Debug.printStackTrace(e);
            listener.readFailed(request2, e);
        }
    }

    protected class requestDispatcher
    implements DiskAccessRequestListener {
        private DiskManagerReadRequest dm_request;
        private DiskManagerReadRequestListener listener;
        private DirectByteBuffer buffer;
        private List chunks;
        private int buffer_length;
        private int chunk_index;

        protected requestDispatcher(DiskManagerReadRequest _request, DiskManagerReadRequestListener _listener, DirectByteBuffer _buffer, List _chunks) {
            this.dm_request = _request;
            this.listener = _listener;
            this.buffer = _buffer;
            this.chunks = _chunks;
            this.buffer_length = this.buffer.limit((byte)7);
            this.dispatch();
        }

        protected void dispatch() {
            try {
                if (this.chunk_index == this.chunks.size()) {
                    this.buffer.limit((byte)7, this.buffer_length);
                    this.buffer.position((byte)7, 0);
                    this.listener.readCompleted(this.dm_request, this.buffer);
                } else if (this.chunk_index == 1 && this.chunks.size() > 32) {
                    for (int i = 1; i < this.chunks.size(); ++i) {
                        final AESemaphore sem = new AESemaphore("DMR:dispatch:asyncReq");
                        final Throwable[] error = new Throwable[]{null};
                        this.doRequest(new DiskAccessRequestListener(){

                            public void requestComplete(DiskAccessRequest request2) {
                                sem.release();
                            }

                            public void requestCancelled(DiskAccessRequest request2) {
                                Debug.out("shouldn't get here");
                            }

                            public void requestFailed(DiskAccessRequest request2, Throwable cause) {
                                error[0] = cause;
                                sem.release();
                            }

                            public int getPriority() {
                                return requestDispatcher.this.listener.getPriority();
                            }

                            public void requestExecuted(long bytes) {
                                requestDispatcher.this.listener.requestExecuted(bytes);
                            }
                        });
                        sem.reserve();
                        if (error[0] == null) continue;
                        throw error[0];
                    }
                    this.buffer.limit((byte)7, this.buffer_length);
                    this.buffer.position((byte)7, 0);
                    this.listener.readCompleted(this.dm_request, this.buffer);
                } else {
                    this.doRequest(this);
                }
            }
            catch (Throwable e) {
                this.failed(e);
            }
        }

        protected void doRequest(DiskAccessRequestListener l) {
            short cache_policy;
            Object[] stuff = (Object[])this.chunks.get(this.chunk_index++);
            this.buffer.limit((byte)7, (Integer)stuff[2]);
            short s = cache_policy = this.dm_request.getUseCache() ? (short)1 : 0;
            if (this.dm_request.getFlush()) {
                cache_policy = (short)(cache_policy | 2);
            }
            DMReaderImpl.this.disk_access.queueReadRequest((CacheFile)stuff[0], (Long)stuff[1], this.buffer, cache_policy, l);
        }

        public void requestComplete(DiskAccessRequest request2) {
            this.dispatch();
        }

        public void requestCancelled(DiskAccessRequest request2) {
            Debug.out("shouldn't get here");
        }

        public void requestFailed(DiskAccessRequest request2, Throwable cause) {
            this.failed(cause);
        }

        public int getPriority() {
            return this.listener.getPriority();
        }

        public void requestExecuted(long bytes) {
            this.listener.requestExecuted(bytes);
        }

        protected void failed(Throwable cause) {
            this.buffer.returnToPool();
            DMReaderImpl.this.disk_manager.setFailed("Disk read error - " + Debug.getNestedExceptionMessage(cause));
            Debug.printStackTrace(cause);
            this.listener.readFailed(this.dm_request, cause);
        }
    }
}

