/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.IpFilterImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class IpFilterAutoLoaderImpl {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String CFG_AUTOLOAD_LAST = "Ip Filter Autoload Last Date";
    public static final String CFG_AUTOLOAD_FILE = "Ip Filter Autoload File";
    private static AEMonitor class_mon = new AEMonitor("IpFilterAutoLoaderImpl:class");
    private Object timerEventFilterReload;
    private final IpFilterImpl ipFilter;

    public IpFilterAutoLoaderImpl(IpFilterImpl ipFilter) {
        this.ipFilter = ipFilter;
        COConfigurationManager.setLongDefault(CFG_AUTOLOAD_LAST, 0L);
        COConfigurationManager.setStringDefault(CFG_AUTOLOAD_FILE, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDATFilters(InputStream fin) {
        try {
            class_mon.enter();
            ArrayList<IpRangeImpl> new_ipRanges = new ArrayList<IpRangeImpl>(1024);
            InputStreamReader streamReader = null;
            BufferedReader reader = null;
            try {
                Pattern pattern = Pattern.compile("^(.*):([0-9\\.]+)[^0-9]+([0-9\\.]+).*");
                int parseMode = -1;
                streamReader = new InputStreamReader(fin, "utf8");
                reader = new BufferedReader(streamReader);
                int numConsecutiveUnknowns = 0;
                while (numConsecutiveUnknowns < 1000) {
                    String line = reader.readLine();
                    if (line == null) {
                        break;
                    }
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    String description = "";
                    String startIp = null;
                    String endIp = null;
                    int level = 0;
                    if (parseMode <= 0 || parseMode == 1) {
                        Matcher matcher = pattern.matcher(line);
                        if (matcher.find()) {
                            if (parseMode != 1) {
                                parseMode = 1;
                            }
                            description = matcher.group(1);
                            startIp = matcher.group(2);
                            endIp = matcher.group(3);
                        } else {
                            Logger.log(new LogEvent(LOGID, 1, "unrecognized line while reading ip filter: " + line));
                        }
                    }
                    if (parseMode != 1) {
                        String[] sections;
                        if (parseMode != 2) {
                            parseMode = 2;
                        }
                        if ((sections = line.split(" *[-,] *", 4)).length >= 2 && (sections[0].indexOf(46) < 0 || sections[1].indexOf(46) < 0 || sections[0].length() > 15 || sections[1].length() > 15 || sections[0].length() < 7 || sections[1].length() < 7)) {
                            ++numConsecutiveUnknowns;
                            continue;
                        }
                        if (sections.length >= 4) {
                            startIp = sections[0];
                            endIp = sections[1];
                            description = sections[3];
                            try {
                                level = Integer.parseInt(sections[2]);
                            }
                            catch (NumberFormatException e) {
                                description = sections[2] + " " + description;
                            }
                            for (int i = 4; i < sections.length; ++i) {
                                description = description + " " + sections[i];
                            }
                            numConsecutiveUnknowns = 0;
                        } else if (sections.length == 3) {
                            startIp = sections[0];
                            endIp = sections[1];
                            description = sections[2];
                            numConsecutiveUnknowns = 0;
                        } else if (sections.length == 2) {
                            startIp = sections[0];
                            endIp = sections[1];
                            numConsecutiveUnknowns = 0;
                        } else {
                            ++numConsecutiveUnknowns;
                            continue;
                        }
                        if (level >= 128) continue;
                    }
                    if (startIp == null || endIp == null) continue;
                    IpRangeImpl ipRange = new IpRangeImpl(description, startIp, endIp, true);
                    ipRange.setAddedToRangeList(true);
                    new_ipRanges.add(ipRange);
                }
            }
            catch (IOException e) {
                Debug.out(e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable e) {}
                }
                if (streamReader != null) {
                    try {
                        streamReader.close();
                    }
                    catch (Throwable e) {}
                }
                Iterator it = new_ipRanges.iterator();
                while (it.hasNext()) {
                    ((IpRange)it.next()).checkValid();
                }
                this.ipFilter.markAsUpToDate();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    private int getP2BFileVersion(InputStream is) {
        try {
            for (int i = 0; i < 4; ++i) {
                int byteRead = is.read();
                if (byteRead == 255) continue;
                return -1;
            }
            byte[] MAGIC = new byte[]{80, 50, 66};
            for (int i = 0; i < MAGIC.length; ++i) {
                byte b = MAGIC[i];
                if (b == is.read()) continue;
                return -1;
            }
            int p2bVersion = is.read();
            Logger.log(new LogEvent(LOGID, "Log Filter: loading p2b version " + p2bVersion));
            return p2bVersion;
        }
        catch (IOException e) {
            Debug.out(e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadOtherFilters(boolean allowAsyncDownloading, boolean loadOldWhileAsyncDownloading) {
        String encoding;
        byte[] ipBytes;
        byte[] descBytes;
        int p2bVersion = -1;
        class_mon.enter();
        ArrayList<IpRangeImpl> new_ipRanges = new ArrayList<IpRangeImpl>(1024);
        InputStream fin = null;
        BufferedInputStream bin = null;
        boolean isURL = false;
        try {
            String file = COConfigurationManager.getStringParameter(CFG_AUTOLOAD_FILE);
            Logger.log(new LogEvent(LOGID, "IP Filter file: " + file));
            File filtersFile = new File(file);
            if (filtersFile.exists()) {
                isURL = false;
            } else {
                if (!UrlUtils.isURL(file)) {
                    return;
                }
                isURL = true;
                filtersFile = FileUtil.getUserFile("ipfilter.dl");
                if (filtersFile.exists()) {
                    if (allowAsyncDownloading) {
                        Logger.log(new LogEvent(LOGID, "Downloading " + file + "  async"));
                        this.downloadFiltersAsync(new URL(file));
                        if (!loadOldWhileAsyncDownloading) {
                            return;
                        }
                    }
                } else {
                    Logger.log(new LogEvent(LOGID, "sync Downloading " + file));
                    try {
                        ResourceDownloader rd = ResourceDownloaderFactoryImpl.getSingleton().create(new URL(file));
                        fin = rd.download();
                        FileUtil.copyFile(fin, filtersFile);
                        this.setNextAutoDownload(true);
                    }
                    catch (ResourceDownloaderException e) {
                        if (bin != null) {
                            try {
                                bin.close();
                            }
                            catch (Throwable e2) {
                                // empty catch block
                            }
                        }
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (Throwable e3) {
                                // empty catch block
                            }
                        }
                        Iterator it = new_ipRanges.iterator();
                        while (it.hasNext()) {
                            ((IpRange)it.next()).checkValid();
                        }
                        this.ipFilter.markAsUpToDate();
                        if (!isURL) {
                            this.setFileReloadTimer();
                        }
                        class_mon.exit();
                        return;
                    }
                }
            }
            fin = new FileInputStream(filtersFile);
            bin = new BufferedInputStream(fin, 16384);
            byte[] headerBytes = new byte[2];
            bin.mark(3);
            bin.read(headerBytes, 0, 2);
            bin.reset();
            if (headerBytes[1] == -117 && headerBytes[0] == 31) {
                GZIPInputStream gzip = new GZIPInputStream(bin);
                filtersFile = FileUtil.getUserFile("ipfilter.ext");
                FileUtil.copyFile((InputStream)gzip, filtersFile);
                fin = new FileInputStream(filtersFile);
                bin = new BufferedInputStream(fin, 16384);
            } else if (headerBytes[0] == 80 && headerBytes[1] == 75) {
                ZipInputStream zip = new ZipInputStream(bin);
                ZipEntry zipEntry = zip.getNextEntry();
                while (zipEntry != null && zipEntry.getSize() < 0x100000L) {
                    zipEntry = zip.getNextEntry();
                }
                if (zipEntry == null) {
                    return;
                }
                filtersFile = FileUtil.getUserFile("ipfilter.ext");
                FileUtil.copyFile((InputStream)zip, filtersFile);
                fin = new FileInputStream(filtersFile);
                bin = new BufferedInputStream(fin, 16384);
            }
            bin.mark(8);
            p2bVersion = this.getP2BFileVersion(bin);
            if (p2bVersion < 1 || p2bVersion > 3) {
                bin.reset();
                this.loadDATFilters(bin);
                return;
            }
            descBytes = new byte[255];
            ipBytes = new byte[4];
            String string = encoding = p2bVersion == 1 ? "ISO-8859-1" : "UTF-8";
            if (p2bVersion != 1 && p2bVersion != 2) {
                int read = bin.read(ipBytes);
                if (read < 4) {
                    return;
                }
                int numDescs = ByteFormatter.byteArrayToInt(ipBytes);
                String[] descs = new String[numDescs];
                for (int i = 0; i < numDescs; ++i) {
                    descs[i] = this.readString(bin, descBytes, encoding);
                }
                read = bin.read(ipBytes);
                if (read < 4) {
                    return;
                }
                int numRanges = ByteFormatter.byteArrayToInt(ipBytes);
                int i = 0;
                while (i < numRanges) {
                    read = bin.read(ipBytes);
                    if (read < 4) {
                        return;
                    }
                    int descIdx = ByteFormatter.byteArrayToInt(ipBytes);
                    read = bin.read(ipBytes);
                    if (read < 4) {
                        return;
                    }
                    int startIp = ByteFormatter.byteArrayToInt(ipBytes);
                    read = bin.read(ipBytes);
                    if (read < 4) {
                        return;
                    }
                    int endIp = ByteFormatter.byteArrayToInt(ipBytes);
                    String description = descIdx < descs.length && descIdx >= 0 ? descs[descIdx] : "";
                    IpRangeImpl ipRange = new IpRangeImpl(description, startIp, endIp, true);
                    ipRange.setAddedToRangeList(true);
                    new_ipRanges.add(ipRange);
                    ++i;
                }
                return;
            }
        }
        catch (IOException e) {
            Debug.out(e);
            return;
        }
        finally {
            class_mon.exit();
        }
        while (true) {
            String description = this.readString(bin, descBytes, encoding);
            int read = bin.read(ipBytes);
            if (read < 4) {
                return;
            }
            int startIp = ByteFormatter.byteArrayToInt(ipBytes);
            read = bin.read(ipBytes);
            if (read < 4) {
                return;
            }
            int endIp = ByteFormatter.byteArrayToInt(ipBytes);
            IpRangeImpl ipRange = new IpRangeImpl(description, startIp, endIp, true);
            ipRange.setAddedToRangeList(true);
            new_ipRanges.add(ipRange);
        }
    }

    private void setFileReloadTimer() {
        if (this.timerEventFilterReload instanceof TimerEvent) {
            ((TimerEvent)this.timerEventFilterReload).cancel();
        } else if (this.timerEventFilterReload instanceof TimerEventPeriodic) {
            ((TimerEventPeriodic)this.timerEventFilterReload).cancel();
        }
        this.timerEventFilterReload = SimpleTimer.addPeriodicEvent("IP Filter download", 60000L, new TimerEventPerformer(){
            long lastFileModified;

            public void perform(TimerEvent event2) {
                event2.cancel();
                String file = COConfigurationManager.getStringParameter(IpFilterAutoLoaderImpl.CFG_AUTOLOAD_FILE);
                File filtersFile = new File(file);
                if (!filtersFile.exists()) {
                    return;
                }
                long fileModified = filtersFile.lastModified();
                if (this.lastFileModified == 0L) {
                    this.lastFileModified = fileModified;
                } else if (this.lastFileModified != fileModified) {
                    try {
                        IpFilterAutoLoaderImpl.this.ipFilter.reload();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void downloadFiltersAsync(URL url) {
        ResourceDownloader rd = ResourceDownloaderFactoryImpl.getSingleton().create(url);
        rd.addListener(new ResourceDownloaderAdapter(){

            public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean completed(ResourceDownloader downloader, InputStream data) {
                try {
                    IpFilterAutoLoaderImpl.this.setNextAutoDownload(true);
                    Logger.log(new LogEvent(LOGID, "downloaded..waiting"));
                    class_mon.enter();
                    Logger.log(new LogEvent(LOGID, "downloaded.. copying"));
                    try {
                        FileUtil.copyFile(data, FileUtil.getUserFile("ipfilter.dl"));
                        AEThread thread = new AEThread("reload ipfilters", true){

                            public void runSupport() {
                                try {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.setStatusText("Reloading Filters..");
                                    }
                                    IpFilterAutoLoaderImpl.this.ipFilter.reload(false);
                                    if (uif != null) {
                                        uif.setStatusText(null);
                                    }
                                }
                                catch (Exception e) {
                                    Debug.out(e);
                                }
                            }
                        };
                        thread.setPriority(4);
                        thread.start();
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
                finally {
                    class_mon.exit();
                }
                return true;
            }
        });
        rd.asyncDownload();
    }

    public void setNextAutoDownload(boolean updateLastDownloadedDate) {
        long lastDL;
        long now = SystemTime.getCurrentTime();
        if (updateLastDownloadedDate) {
            COConfigurationManager.setParameter(CFG_AUTOLOAD_LAST, now);
            lastDL = now;
        } else {
            lastDL = COConfigurationManager.getLongParameter(CFG_AUTOLOAD_LAST);
            if (lastDL > now) {
                lastDL = now;
                COConfigurationManager.setParameter(CFG_AUTOLOAD_LAST, now);
            }
        }
        long nextDL = lastDL + 604800000L;
        if (this.timerEventFilterReload instanceof TimerEvent) {
            ((TimerEvent)this.timerEventFilterReload).cancel();
        } else if (this.timerEventFilterReload instanceof TimerEventPeriodic) {
            ((TimerEventPeriodic)this.timerEventFilterReload).cancel();
        }
        this.timerEventFilterReload = SimpleTimer.addEvent("IP Filter download", nextDL, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                String file = COConfigurationManager.getStringParameter(IpFilterAutoLoaderImpl.CFG_AUTOLOAD_FILE);
                try {
                    IpFilterAutoLoaderImpl.this.downloadFiltersAsync(new URL(file));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        });
    }

    private String readString(BufferedInputStream bin, byte[] descBytes, String encoding) {
        int pos = 0;
        try {
            int byteRead;
            while ((byteRead = bin.read()) >= 0) {
                if (pos < descBytes.length) {
                    descBytes[pos] = (byte)byteRead;
                    ++pos;
                }
                if (byteRead != 0) continue;
                break;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (pos > 1) {
            try {
                return new String(descBytes, 0, pos - 1, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return "";
    }
}

