/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.impl;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.stats.StatsWriterPeriodic;
import org.gudy.azureus2.core3.stats.impl.StatsWriterImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class StatsWriterPeriodicImpl
implements StatsWriterPeriodic,
COConfigurationListener {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static StatsWriterPeriodicImpl singleton;
    private static AEMonitor class_mon;
    private static int start_count;
    private static Thread current_thread;
    private long last_write_time = 0L;
    private AzureusCore core;
    private boolean config_enabled;
    private int config_period;
    private String config_dir;
    private String config_file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatsWriterPeriodic create(AzureusCore _core) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new StatsWriterPeriodicImpl(_core);
            }
            StatsWriterPeriodicImpl statsWriterPeriodicImpl = singleton;
            return statsWriterPeriodicImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected StatsWriterPeriodicImpl(AzureusCore _core) {
        this.core = _core;
        COConfigurationManager.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        this.readConfigValues();
        while (true) {
            try {
                class_mon.enter();
                if (Thread.currentThread() != current_thread) break;
                this.writeStats();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            finally {
                class_mon.exit();
            }
            try {
                int period = !this.config_enabled ? 30000 : this.config_period * 1000;
                if (period > 30000) {
                    period = 30000;
                }
                Thread.sleep(period);
            }
            catch (InterruptedException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void readConfigValues() {
        this.config_enabled = COConfigurationManager.getBooleanParameter("Stats Enable");
        this.config_period = COConfigurationManager.getIntParameter("Stats Period");
        this.config_dir = COConfigurationManager.getStringParameter("Stats Dir");
        this.config_file = COConfigurationManager.getStringParameter("Stats File");
    }

    protected void writeStats() {
        if (!this.config_enabled) {
            return;
        }
        int period = this.config_period;
        long now = SystemTime.getCurrentTime() / 1000L;
        if (now < this.last_write_time) {
            this.last_write_time = now;
        }
        if (now - this.last_write_time < (long)(period - 1)) {
            return;
        }
        this.last_write_time = now;
        try {
            String file;
            String file_name;
            String dir = this.config_dir;
            dir = dir.trim();
            if (dir.length() == 0) {
                dir = File.separator;
            }
            if (!(file_name = dir).endsWith(File.separator)) {
                file_name = file_name + File.separator;
            }
            if ((file = this.config_file).trim().length() == 0) {
                file = "Azureus_Stats.xml";
            }
            file_name = file_name + file;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Stats Logged to '" + file_name + "'"));
            }
            new StatsWriterImpl(this.core).write(file_name);
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Stats Logging fails", e));
        }
    }

    public void configurationSaved() {
        this.readConfigValues();
        this.writeStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            class_mon.enter();
            if (++start_count == 1) {
                current_thread = new AEThread("StatsWriter"){

                    public void runSupport() {
                        StatsWriterPeriodicImpl.this.update();
                    }
                };
                current_thread.setDaemon(true);
                current_thread.start();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            class_mon.enter();
            if (--start_count == 0) {
                current_thread = null;
            }
        }
        finally {
            class_mon.exit();
        }
    }

    static {
        class_mon = new AEMonitor("StatsWriterPeriodic");
    }
}

