/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.HashWrapper;

public class PRUDPPacketRequestScrape
extends PRUDPPacketRequest {
    protected List hashes;

    public PRUDPPacketRequestScrape(long con_id, byte[] _hash) {
        super(2, con_id);
        this.hashes = new ArrayList();
        this.hashes.add(_hash);
    }

    public PRUDPPacketRequestScrape(long con_id, List hashwrappers) {
        super(2, con_id);
        this.hashes = new ArrayList();
        Iterator it = hashwrappers.iterator();
        while (it.hasNext()) {
            this.hashes.add(((HashWrapper)it.next()).getBytes());
        }
    }

    protected PRUDPPacketRequestScrape(DataInputStream is, long con_id, int trans_id) throws IOException {
        super(2, con_id, trans_id);
        byte[] hash;
        while (is.read(hash = new byte[20]) == 20) {
            this.hashes.add(hash);
        }
    }

    public List getHashes() {
        return this.hashes;
    }

    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        Iterator it = this.hashes.iterator();
        while (it.hasNext()) {
            os.write((byte[])it.next());
        }
    }

    public String getString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.getString());
        buf.append("[");
        Iterator it = this.hashes.iterator();
        while (it.hasNext()) {
            buf.append(ByteFormatter.nicePrint((byte[])it.next(), true));
            if (!it.hasNext()) continue;
            buf.append(";");
        }
        buf.append("]");
        return buf.toString();
    }
}

