/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelector;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelectorFactory;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessorFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRNonBlockingServer
extends TRTrackerServerTCP
implements VirtualServerChannelSelector.SelectListener {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private static final int TIMEOUT_CHECK_INTERVAL = 10000;
    private static final int CLOSE_DELAY = 5000;
    private TRNonBlockingServerProcessorFactory processor_factory;
    private final VirtualChannelSelector read_selector;
    private final VirtualChannelSelector write_selector;
    private List connections_to_close = new ArrayList();
    private List processors = new ArrayList();
    private long total_timeouts;
    private long total_connections;
    public static final int MAX_CONCURRENT_CONNECTIONS = COConfigurationManager.getIntParameter("Tracker TCP NonBlocking Conc Max");
    private final AEMonitor this_mon = new AEMonitor("TRNonBlockingServer");
    private VirtualServerChannelSelector accept_server;
    private volatile boolean closed;

    public TRNonBlockingServer(String _name, int _port, InetAddress _bind_ip, boolean _apply_ip_filter, TRNonBlockingServerProcessorFactory _processor_factory) throws TRTrackerServerException {
        this(_name, _port, _bind_ip, _apply_ip_filter, true, _processor_factory);
    }

    public TRNonBlockingServer(String _name, int _port, InetAddress _bind_ip, boolean _apply_ip_filter, boolean _start_up_ready, TRNonBlockingServerProcessorFactory _processor_factory) throws TRTrackerServerException {
        super(_name, _port, false, _apply_ip_filter, _start_up_ready);
        this.processor_factory = _processor_factory;
        this.read_selector = new VirtualChannelSelector(_name + ":" + _port, 1, false);
        this.write_selector = new VirtualChannelSelector(_name + ":" + _port, 4, true);
        boolean ok = false;
        if (_port == 0) {
            throw new TRTrackerServerException("port of 0 not currently supported");
        }
        try {
            InetSocketAddress address = _bind_ip == null ? ((_bind_ip = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress()) == null ? new InetSocketAddress(_port) : new InetSocketAddress(_bind_ip, _port)) : new InetSocketAddress(_bind_ip, _port);
            this.accept_server = VirtualServerChannelSelectorFactory.createBlocking(address, 0, this);
            this.accept_server.start();
            AEThread read_thread = new AEThread("TRTrackerServer:readSelector"){

                public void runSupport() {
                    TRNonBlockingServer.this.selectLoop(TRNonBlockingServer.this.read_selector);
                }
            };
            read_thread.setDaemon(true);
            read_thread.start();
            AEThread write_thread = new AEThread("TRTrackerServer:writeSelector"){

                public void runSupport() {
                    TRNonBlockingServer.this.selectLoop(TRNonBlockingServer.this.write_selector);
                }
            };
            write_thread.setDaemon(true);
            write_thread.start();
            AEThread close_thread = new AEThread("TRTrackerServer:closeScheduler"){

                public void runSupport() {
                    TRNonBlockingServer.this.closeLoop();
                }
            };
            close_thread.setDaemon(true);
            close_thread.start();
            Logger.log(new LogEvent(LOGID, "TRTrackerServer: Non-blocking listener established on port " + this.getPort()));
            ok = true;
        }
        catch (Throwable e) {
            Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.getPort()});
            throw new TRTrackerServerException("TRTrackerServer: accept fails", e);
        }
        finally {
            if (!ok) {
                this.destroySupport();
            }
        }
    }

    protected void selectLoop(VirtualChannelSelector selector) {
        long last_time = 0L;
        while (!this.closed) {
            try {
                selector.select(100L);
                if (selector != this.read_selector) continue;
                long now = SystemTime.getCurrentTime();
                if (now < last_time) {
                    last_time = now;
                    continue;
                }
                if (now - last_time < 10000L) continue;
                last_time = now;
                this.checkTimeouts(now);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newConnectionAccepted(ServerSocketChannel server, SocketChannel channel) {
        int num_processors;
        final TRNonBlockingServerProcessor processor2 = this.processor_factory.create(this, channel);
        try {
            this.this_mon.enter();
            ++this.total_connections;
            this.processors.add(processor2);
            num_processors = this.processors.size();
        }
        finally {
            this.this_mon.exit();
        }
        if (MAX_CONCURRENT_CONNECTIONS != 0 && num_processors > MAX_CONCURRENT_CONNECTIONS) {
            this.removeAndCloseConnection(processor2);
        } else if (this.isIPFilterEnabled() && this.ip_filter.isInRange(channel.socket().getInetAddress().getHostAddress(), "Tracker", null)) {
            this.removeAndCloseConnection(processor2);
        } else {
            VirtualChannelSelector.VirtualSelectorListener read_listener = new VirtualChannelSelector.VirtualSelectorListener(){
                private boolean selector_registered;

                public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                    try {
                        int read_result = processor2.processRead();
                        if (read_result == 0) {
                            if (this.selector_registered) {
                                TRNonBlockingServer.this.read_selector.pauseSelects(sc);
                            }
                        } else if (read_result < 0) {
                            TRNonBlockingServer.this.removeAndCloseConnection(processor2);
                        } else if (!this.selector_registered) {
                            this.selector_registered = true;
                            TRNonBlockingServer.this.read_selector.register(sc, this, null);
                        }
                        return read_result != 2;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        TRNonBlockingServer.this.removeAndCloseConnection(processor2);
                        return false;
                    }
                }

                public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                    TRNonBlockingServer.this.removeAndCloseConnection(processor2);
                }
            };
            read_listener.selectSuccess(this.read_selector, channel, null);
        }
    }

    protected void readyToWrite(final TRNonBlockingServerProcessor processor2) {
        VirtualChannelSelector.VirtualSelectorListener write_listener = new VirtualChannelSelector.VirtualSelectorListener(){
            private boolean selector_registered;

            public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                try {
                    int write_result = processor2.processWrite();
                    if (write_result > 0) {
                        if (this.selector_registered) {
                            TRNonBlockingServer.this.write_selector.resumeSelects(sc);
                        } else {
                            this.selector_registered = true;
                            TRNonBlockingServer.this.write_selector.register(sc, this, null);
                        }
                    } else if (write_result == 0) {
                        TRNonBlockingServer.this.removeAndCloseConnection(processor2);
                    } else if (write_result < 0) {
                        processor2.failed();
                        TRNonBlockingServer.this.removeAndCloseConnection(processor2);
                    }
                    return write_result != 2;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    TRNonBlockingServer.this.removeAndCloseConnection(processor2);
                    return false;
                }
            }

            public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                TRNonBlockingServer.this.removeAndCloseConnection(processor2);
            }
        };
        write_listener.selectSuccess(this.write_selector, processor2.getSocketChannel(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAndCloseConnection(TRNonBlockingServerProcessor processor2) {
        processor2.completed();
        try {
            this.this_mon.enter();
            if (this.processors.remove(processor2)) {
                this.read_selector.cancel(processor2.getSocketChannel());
                this.write_selector.cancel(processor2.getSocketChannel());
                this.connections_to_close.add(processor2);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTimeouts(long now) {
        try {
            this.this_mon.enter();
            ArrayList<TRNonBlockingServerProcessor> new_processors = new ArrayList<TRNonBlockingServerProcessor>(this.processors.size());
            for (int i = 0; i < this.processors.size(); ++i) {
                TRNonBlockingServerProcessor processor2 = (TRNonBlockingServerProcessor)this.processors.get(i);
                if (now - processor2.getStartTime() > PROCESSING_GET_LIMIT) {
                    this.read_selector.cancel(processor2.getSocketChannel());
                    this.write_selector.cancel(processor2.getSocketChannel());
                    this.connections_to_close.add(processor2);
                    ++this.total_timeouts;
                    continue;
                }
                new_processors.add(processor2);
            }
            this.processors = new_processors;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLoop() {
        long default_delay;
        List pending_list = new ArrayList();
        long delay = default_delay = 3333L;
        while (!this.closed) {
            if (delay > 0L) {
                try {
                    Thread.sleep(delay);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            long start = SystemTime.getCurrentTime();
            for (int i = 0; i < pending_list.size(); ++i) {
                try {
                    TRNonBlockingServerProcessor processor2 = (TRNonBlockingServerProcessor)pending_list.get(i);
                    processor2.closed();
                    processor2.getSocketChannel().close();
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            try {
                this.this_mon.enter();
                pending_list = this.connections_to_close;
                this.connections_to_close = new ArrayList();
            }
            finally {
                this.this_mon.exit();
            }
            long duration = SystemTime.getCurrentTime() - start;
            if (duration < 0L) {
                duration = 0L;
            }
            delay = default_delay - duration;
        }
    }

    protected void closeSupport() {
        this.closed = true;
        this.accept_server.stop();
        this.destroySupport();
    }
}

