/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.DebugLight;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class AEThread2 {
    public static final boolean TRACE_TIMES = false;
    private static final int MIN_RETAINED = 2;
    private static final int MAX_RETAINED = 16;
    private static final int THREAD_TIMEOUT_CHECK_PERIOD = 10000;
    private static final int THREAD_TIMEOUT = 60000;
    private static final LinkedList daemon_threads = new LinkedList();
    private static long last_timeout_check;
    private static long total_starts;
    private static long total_creates;
    private threadWrapper wrapper;
    private String name;
    private boolean daemon;
    private int priority = 5;
    private volatile JoinLock lock = new JoinLock();

    public AEThread2(String _name, boolean _daemon) {
        this.name = _name;
        this.daemon = _daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        JoinLock newLock;
        JoinLock currentLock = this.lock;
        Object object = currentLock;
        synchronized (object) {
            newLock = currentLock.released ? (this.lock = new JoinLock()) : currentLock;
        }
        if (this.daemon) {
            object = daemon_threads;
            synchronized (object) {
                ++total_starts;
                if (daemon_threads.isEmpty()) {
                    ++total_creates;
                    this.wrapper = new threadWrapper(this.name, true);
                } else {
                    this.wrapper = (threadWrapper)daemon_threads.removeLast();
                    this.wrapper.setName(this.name);
                }
            }
        } else {
            this.wrapper = new threadWrapper(this.name, false);
        }
        if (this.priority != this.wrapper.getPriority()) {
            this.wrapper.setPriority(this.priority);
        }
        this.wrapper.currentLock = newLock;
        this.wrapper.start(this, this.name);
    }

    public void setPriority(int _priority) {
        this.priority = _priority;
        if (this.wrapper != null) {
            this.wrapper.setPriority(this.priority);
        }
    }

    public void setName(String s) {
        this.name = s;
        if (this.wrapper != null) {
            this.wrapper.setName(this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public void interrupt() {
        if (this.wrapper == null) {
            throw new IllegalStateException("Interrupted before started!");
        }
        this.wrapper.interrupt();
    }

    public boolean isCurrentThread() {
        return this.wrapper == Thread.currentThread();
    }

    public String toString() {
        if (this.wrapper == null) {
            return this.name + " [daemon=" + this.daemon + ",priority=" + this.priority + "]";
        }
        return this.wrapper.toString();
    }

    public abstract void run();

    public static boolean isOurThread(Thread thread) {
        return AEThread.isOurThread(thread);
    }

    public static void setOurThread() {
        AEThread.setOurThread();
    }

    public static void setOurThread(Thread thread) {
        AEThread.setOurThread(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        JoinLock currentLock;
        JoinLock joinLock = currentLock = this.lock;
        synchronized (joinLock) {
            while (!currentLock.released) {
                try {
                    currentLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected static class threadWrapper
    extends Thread {
        private AESemaphore sem;
        private AEThread2 target;
        private JoinLock currentLock;
        private long last_active_time;

        protected threadWrapper(String name, boolean daemon) {
            super(name);
            this.setDaemon(daemon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            do {
                Object object = this.currentLock;
                synchronized (object) {
                    try {
                        this.target.run();
                    }
                    catch (Throwable e) {
                        DebugLight.printStackTrace(e);
                    }
                    finally {
                        this.currentLock.released = true;
                        this.currentLock.notifyAll();
                    }
                }
                if (this.isInterrupted() || !Thread.currentThread().isDaemon()) break;
                object = daemon_threads;
                synchronized (object) {
                    this.last_active_time = SystemTime.getCurrentTime();
                    if (this.last_active_time < last_timeout_check || this.last_active_time - last_timeout_check > 10000L) {
                        last_timeout_check = this.last_active_time;
                        while (daemon_threads.size() > 0 && daemon_threads.size() > 2) {
                            threadWrapper thread = (threadWrapper)daemon_threads.getFirst();
                            long thread_time = thread.last_active_time;
                            if (this.last_active_time >= thread_time && this.last_active_time - thread_time <= 60000L) break;
                            daemon_threads.removeFirst();
                            thread.retire();
                        }
                    }
                    if (daemon_threads.size() >= 16) {
                        return;
                    }
                    daemon_threads.addLast(this);
                    this.setName("AEThead2:parked[" + daemon_threads.size() + "]");
                }
                this.sem.reserve();
            } while (this.target != null);
        }

        protected void start(AEThread2 _target, String _name) {
            this.target = _target;
            this.setName(_name);
            if (this.sem == null) {
                this.sem = new AESemaphore("AEThread2");
                super.start();
            } else {
                this.sem.release();
            }
        }

        protected void retire() {
            this.target = null;
            this.sem.release();
        }
    }

    private static final class JoinLock {
        volatile boolean released = false;

        private JoinLock() {
        }
    }
}

