/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.security.SecureRandom;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;

public class RandomUtils {
    public static final Random RANDOM = new Random(System.currentTimeMillis());
    public static final Random SECURE_RANDOM = new SecureRandom();
    public static final int LISTEN_PORT_MIN = 10000;
    public static final int LISTEN_PORT_MAX = 65535;

    public static byte[] generateRandomBytes(int num_to_generate) {
        byte[] id = new byte[num_to_generate];
        RANDOM.nextBytes(id);
        return id;
    }

    public static String generateRandomAlphanumerics(int num_to_generate) {
        String alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuffer buff = new StringBuffer(num_to_generate);
        for (int i = 0; i < num_to_generate; ++i) {
            int pos = (int)(RANDOM.nextDouble() * (double)alphabet.length());
            buff.append(alphabet.charAt(pos));
        }
        return buff.toString();
    }

    public static int generateRandomNetworkListenPort() {
        int min;
        int port;
        int existing_tcp = COConfigurationManager.getIntParameter("TCP.Listen.Port");
        int existing_udp = COConfigurationManager.getIntParameter("UDP.Listen.Port");
        int existing_udp2 = COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port");
        while ((port = (min = 10000) + RANDOM.nextInt(65536 - min)) >= 45100 && port <= 45110 || port == existing_tcp || port == existing_udp || port == existing_udp2) {
        }
        return port;
    }

    public static int generateRandomPlusMinus1() {
        return RANDOM.nextBoolean() ? -1 : 1;
    }

    public static float nextFloat() {
        return RANDOM.nextFloat();
    }

    public static void nextBytes(byte[] bytes) {
        RANDOM.nextBytes(bytes);
    }

    public static void nextSecureBytes(byte[] bytes) {
        SECURE_RANDOM.nextBytes(bytes);
    }

    public static int nextInt(int n) {
        return RANDOM.nextInt(n);
    }

    public static byte nextByte() {
        return (byte)RANDOM.nextInt();
    }

    public static int nextInt() {
        return RANDOM.nextInt();
    }

    public static long nextLong() {
        return RANDOM.nextLong();
    }

    public static int generateRandomIntUpto(int max) {
        return RandomUtils.nextInt(max);
    }

    public static int generateRandomIntBetween(int min, int max) {
        return min + RandomUtils.generateRandomIntUpto(max + 1 - min);
    }
}

