/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.gudy.azureus2.core3.util.SystemTime;

public class TimeFormatter {
    static final String[] TIME_SUFFIXES = new String[]{"s", "m", "h", "d", "y"};
    public static final String[] DATEFORMATS_DESC = new String[]{"EEEE, MMMM d, yyyy", "EEE, MMMM d, yyyy", "MMMM d, ''yy", "EEE, MMM d, yyyy", "EEE, MMM d, ''yy", "MMM d, ''yy", "yyyy/MM/dd", "yyyy/MM", "''yy/MM"};
    private static final SimpleDateFormat http_date_format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);

    public static String format(long time_secs) {
        int end;
        if (time_secs == 31536000L || time_secs >= 1827387392L) {
            return "\u221e";
        }
        if (time_secs < 0L) {
            return "";
        }
        int[] vals = new int[]{(int)time_secs % 60, (int)(time_secs / 60L) % 60, (int)(time_secs / 3600L) % 24, (int)(time_secs / 86400L) % 365, (int)(time_secs / 31536000L)};
        for (end = vals.length - 1; vals[end] == 0 && end > 0; --end) {
        }
        String result = vals[end] + TIME_SUFFIXES[end];
        while (--end >= 0 && vals[end] == 0) {
        }
        if (end >= 0) {
            result = result + " " + TimeFormatter.twoDigits(vals[end]) + TIME_SUFFIXES[end];
        }
        return result;
    }

    public static String format100ths(long time_millis) {
        long time_secs = time_millis / 1000L;
        int hundredths = (int)(time_millis - time_secs * 1000L) / 10;
        if (time_millis == 0L || time_secs >= 60L) {
            return TimeFormatter.format(time_secs);
        }
        return time_secs + "." + TimeFormatter.twoDigits(hundredths) + TIME_SUFFIXES[0];
    }

    public static String formatColon(long time) {
        if (time == 31536000L || time >= 1827387392L) {
            return "\u221e";
        }
        if (time < 0L) {
            return "";
        }
        int secs = (int)time % 60;
        int mins = (int)(time / 60L) % 60;
        int hours = (int)(time / 3600L) % 24;
        int days = (int)(time / 86400L) % 365;
        int years = (int)(time / 31536000L);
        String result = "";
        if (years > 0) {
            result = result + years + "y ";
        }
        if (years > 0 || days > 0) {
            result = result + days + "d ";
        }
        result = result + TimeFormatter.twoDigits(hours) + ":" + TimeFormatter.twoDigits(mins) + ":" + TimeFormatter.twoDigits(secs);
        return result;
    }

    private static String twoDigits(int i) {
        return i < 10 ? "0" + i : String.valueOf(i);
    }

    public static int parseColon(String str) {
        int[] multipliers = new int[]{1, 60, 3600, 86400, 31536000};
        String[] bits = str.split(":");
        int result = 0;
        for (int i = 0; i < bits.length; ++i) {
            String bit = bits[bits.length - (i + 1)].trim();
            if (bit.length() <= 0) continue;
            result += multipliers[i] * Integer.parseInt(bit);
        }
        return result;
    }

    public static String formatNanoAsMilli(long nanos) {
        long truncator = 60000000000L;
        nanos -= nanos / 60000000000L * 60000000000L;
        return String.valueOf((double)nanos / 1000000.0) + " ms";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHTTPDate(long millis) {
        SimpleDateFormat simpleDateFormat = http_date_format;
        synchronized (simpleDateFormat) {
            return http_date_format.format(new Date(millis));
        }
    }

    public static String milliStamp() {
        long nanos = SystemTime.getHighPrecisionCounter();
        long truncator = 60000000000L;
        nanos -= nanos / 60000000000L * 60000000000L;
        String str = String.valueOf(nanos / 1000000L);
        while (str.length() < 5) {
            str = "0" + str;
        }
        return str + ": ";
    }

    public static void milliTrace(String str) {
        System.out.println(TimeFormatter.milliStamp() + str);
    }

    static {
        http_date_format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

