/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.util.Java15Utils;
import com.aelitis.net.magneturi.MagnetURIHandler;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourceuploader.ResourceUploader;

public class UrlUtils {
    private static final ThreadPool connect_pool = new ThreadPool("URLConnectWithTimeout", 8, true);
    private static final String[] prefixes;
    private static int MAGNETURL_STARTS_AT;
    private static final Object[] XMLescapes;
    private static String last_headers;
    private static final String default_headers = "SG9zdDogbG9jYWxob3N0OjQ1MTAwClVzZXItQWdlbnQ6IE1vemlsbGEvNS4wIChXaW5kb3dzOyBVOyBXaW5kb3dzIE5UIDUuMTsgZW4tVVM7IHJ2OjEuOC4xLjE0KSBHZWNrby8yMDA4MDQwNCBGaXJlZm94LzIuMC4wLjE0CkFjY2VwdDogdGV4dC94bWwsYXBwbGljYXRpb24veG1sLGFwcGxpY2F0aW9uL3hodG1sK3htbCx0ZXh0L2h0bWw7cT0wLjksdGV4dC9wbGFpbjtxPTAuOCxpbWFnZS9wbmcsKi8qO3E9MC41CkFjY2VwdC1MYW5ndWFnZTogZW4tdXMsZW47cT0wLjUKQWNjZXB0LUVuY29kaW5nOiBnemlwLGRlZmxhdGUKQWNjZXB0LUNoYXJzZXQ6IElTTy04ODU5LTEsdXRmLTg7cT0wLjcsKjtxPTAuNwpLZWVwLUFsaXZlOiAzMDAKQ29ubmVjdGlvbjoga2VlcC1hbGl2ZQ==";

    public static boolean isURL(String sURL) {
        return UrlUtils.parseTextForURL(sURL, true) != null;
    }

    public static boolean isURL(String sURL, boolean bGuess) {
        return UrlUtils.parseTextForURL(sURL, true, bGuess) != null;
    }

    public static String parseTextForURL(String text, boolean accept_magnets) {
        return UrlUtils.parseTextForURL(text, accept_magnets, true);
    }

    public static String parseTextForURL(String text, boolean accept_magnets, boolean guess) {
        String textLower;
        if (text == null || text.length() < 5) {
            return null;
        }
        String href = UrlUtils.parseHTMLforURL(text);
        if (href != null) {
            return href;
        }
        try {
            text = text.trim();
            text = URLDecoder.decode(text);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            textLower = text.toLowerCase();
        }
        catch (Throwable e) {
            textLower = text;
        }
        int max = accept_magnets ? prefixes.length : MAGNETURL_STARTS_AT;
        int end = -1;
        int start = textLower.length();
        String strURL = null;
        for (int i = 0; i < max; ++i) {
            int testBegin = textLower.indexOf(prefixes[i]);
            if (testBegin < 0 || testBegin >= start) continue;
            end = text.indexOf("\n", testBegin + prefixes[i].length());
            String strURLTest = end >= 0 ? text.substring(testBegin, end - 1) : text.substring(testBegin);
            try {
                URL parsedURL = new URL(strURLTest);
                strURL = parsedURL.toExternalForm();
                continue;
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
                if (i < MAGNETURL_STARTS_AT) continue;
                strURL = strURLTest;
            }
        }
        if (strURL != null) {
            return strURL;
        }
        if (new File(text).exists()) {
            return null;
        }
        if (accept_magnets && text.matches("^[a-fA-F0-9]{40}$")) {
            byte[] infohash = ByteFormatter.decodeString(text.toUpperCase());
            return "magnet:?xt=urn:btih:" + Base32.encode(infohash);
        }
        if (accept_magnets && text.matches("^[a-zA-Z2-7]{32}$")) {
            return "magnet:?xt=urn:btih:" + text;
        }
        if (accept_magnets && guess) {
            String hash;
            Pattern pattern = Pattern.compile("[^a-zA-Z2-7][a-zA-Z2-7]{32}[^a-zA-Z2-7]");
            Matcher matcher = pattern.matcher(text);
            if (matcher.find()) {
                hash = text.substring(matcher.start() + 1, matcher.start() + 33);
                return "magnet:?xt=urn:btih:" + hash;
            }
            pattern = Pattern.compile("[^a-fA-F0-9][a-fA-F0-9]{40}[^a-fA-F0-9]");
            matcher = pattern.matcher(text);
            if (matcher.find()) {
                hash = text.substring(matcher.start() + 1, matcher.start() + 41);
                byte[] infohash = ByteFormatter.decodeString(hash.toUpperCase());
                return "magnet:?xt=urn:btih:" + Base32.encode(infohash);
            }
        }
        return null;
    }

    public static String parseHTMLforURL(String text) {
        if (text == null) {
            return null;
        }
        Pattern pat = Pattern.compile("<.*a\\s++.*href=\"?([^\\'\"\\s>]++).*", 2);
        Matcher m = pat.matcher(text);
        if (m.find()) {
            String sURL = m.group(1);
            try {
                sURL = URLDecoder.decode(sURL);
            }
            catch (Exception e) {
                // empty catch block
            }
            return sURL;
        }
        return null;
    }

    public static void main(String[] args) {
        MagnetURIHandler.getSingleton();
        byte[] infohash = ByteFormatter.decodeString("1234567890123456789012345678901234567890");
        String[] test = new String[]{"http://moo.com", "http%3A%2F/moo%2Ecom", "magnet:?moo", "magnet%3A%3Fxt=urn:btih:26", "magnet%3A//%3Fmooo", "magnet:?xt=urn:btih:" + Base32.encode(infohash), "aaaaaaaaaabbbbbbbbbbccccccccccdddddddddd", "magnet:?dn=OpenOffice.org_2.0.3_Win32Intel_install.exe&xt=urn:sha1:PEMIGLKMNFI4HZ4CCHZNPKZJNMAAORKN&xt=urn:tree:tiger:JMIJVWHCQUX47YYH7O4XIBCORNU2KYKHBBC6DHA&xt=urn:ed2k:1c0804541f34b6583a383bb8f2cec682&xl=96793015&xs=http://mirror.switch.ch/ftp/mirror/OpenOffice/stable/2.0.3/OOo_2.0.3_Win32Intel_install.exe"};
        for (int i = 0; i < test.length; ++i) {
            System.out.println("decode: " + test[i] + " -> " + URLDecoder.decode(test[i]));
            System.out.println("isURL: " + test[i] + " -> " + UrlUtils.isURL(test[i]));
            System.out.println("parse: " + test[i] + " -> " + UrlUtils.parseTextForURL(test[i], true));
        }
    }

    public static String encode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(s).replaceAll("\\+", "%20");
        }
    }

    public static String escapeXML(String s) {
        if (s == null) {
            return "";
        }
        String ret = s;
        for (int i = 0; i < XMLescapes.length; ++i) {
            String[] escapeEntry = (String[])XMLescapes[i];
            ret = ret.replaceAll(escapeEntry[0], escapeEntry[1]);
        }
        return ret;
    }

    public static String unescapeXML(String s) {
        if (s == null) {
            return "";
        }
        String ret = s;
        for (int i = 0; i < XMLescapes.length; ++i) {
            String[] escapeEntry = (String[])XMLescapes[i];
            ret = ret.replaceAll(escapeEntry[1], escapeEntry[0]);
        }
        return ret;
    }

    public static String convertIPV6Host(String host) {
        if (host.indexOf(58) != -1) {
            return "[" + host + "]";
        }
        return host;
    }

    public static String expandIPV6Host(String host) {
        if (host.indexOf(58) != -1) {
            try {
                return InetAddress.getByAddress(InetAddress.getByName(host).getAddress()).getHostAddress();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return host;
    }

    public static void connectWithTimeout(URLConnection connection, long connect_timeout) throws IOException {
        UrlUtils.connectWithTimeouts(connection, connect_timeout, -1L);
    }

    public static void connectWithTimeouts(final URLConnection connection, long connect_timeout, long read_timeout) throws IOException {
        if (Java15Utils.isAvailable()) {
            if (connect_timeout != -1L) {
                Java15Utils.setConnectTimeout(connection, (int)connect_timeout);
            }
            if (read_timeout != -1L) {
                Java15Utils.setReadTimeout(connection, (int)read_timeout);
            }
            connection.connect();
        } else {
            final AESemaphore sem = new AESemaphore("URLUtils:cwt");
            final Throwable[] res = new Throwable[]{null};
            if (connect_pool.isFull()) {
                Debug.out("Connect pool is full, forcing timeout");
                throw new IOException("Timeout");
            }
            connect_pool.run(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    try {
                        connection.connect();
                    }
                    catch (Throwable e) {
                        res[0] = e;
                    }
                    finally {
                        sem.release();
                    }
                }
            });
            boolean ok = sem.reserve(connect_timeout);
            if (ok) {
                Throwable error = res[0];
                if (error != null) {
                    if (error instanceof IOException) {
                        throw (IOException)error;
                    }
                    throw new IOException(Debug.getNestedExceptionMessage(error));
                }
            } else {
                throw new IOException("Timeout");
            }
        }
    }

    public static void setBrowserHeaders(ResourceDownloader rd, String referer) {
        UrlUtils.setBrowserHeaders(rd, null, referer);
    }

    public static void setBrowserHeaders(ResourceDownloader rd, String encoded_headers, String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(encoded_headers);
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos == -1) continue;
                String lhs = header.substring(0, pos).trim();
                String rhs = header.substring(pos + 1).trim();
                if (lhs.equalsIgnoreCase("Host") || lhs.equalsIgnoreCase("Referer")) continue;
                rd.setProperty("URL_" + lhs, rhs);
            }
            if (referer != null && referer.length() > 0) {
                rd.setProperty("URL_Referer", referer);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public static void setBrowserHeaders(ResourceUploader ru, String encoded_headers, String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(encoded_headers);
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos == -1) continue;
                String lhs = header.substring(0, pos).trim();
                String rhs = header.substring(pos + 1).trim();
                if (lhs.equalsIgnoreCase("Host") || lhs.equalsIgnoreCase("Referer")) continue;
                ru.setProperty("URL_" + lhs, rhs);
            }
            if (referer != null && referer.length() > 0) {
                ru.setProperty("URL_Referer", referer);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public static void setBrowserHeaders(URLConnection connection, String referer) {
        UrlUtils.setBrowserHeaders(connection, null, referer);
    }

    public static void setBrowserHeaders(URLConnection connection, String encoded_headers, String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(encoded_headers);
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos == -1) continue;
                String lhs = header.substring(0, pos).trim();
                String rhs = header.substring(pos + 1).trim();
                if (lhs.equalsIgnoreCase("Host") || lhs.equalsIgnoreCase("Referer")) continue;
                connection.setRequestProperty(lhs, rhs);
            }
            if (referer != null && referer.length() > 0) {
                connection.setRequestProperty("Referer", referer);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public static Map getBrowserHeaders(String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(null);
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos == -1) continue;
                String lhs = header.substring(0, pos).trim();
                String rhs = header.substring(pos + 1).trim();
                if (lhs.equalsIgnoreCase("Host") || lhs.equalsIgnoreCase("Referer")) continue;
                result.put(lhs, rhs);
            }
            if (referer != null && referer.length() > 0) {
                result.put("Referer", referer);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBrowserHeadersToUse(String encoded_headers) {
        String headers_to_use = encoded_headers;
        Class<UrlUtils> clazz = UrlUtils.class;
        synchronized (UrlUtils.class) {
            if (headers_to_use == null) {
                headers_to_use = last_headers != null ? last_headers : default_headers;
            } else {
                if (last_headers == null || !headers_to_use.equals(last_headers)) {
                    COConfigurationManager.setParameter("metasearch.web.last.headers", headers_to_use);
                }
                last_headers = headers_to_use;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return headers_to_use;
        }
    }

    public static boolean queryHasParameter(String query_string, String param_name, boolean case_sensitive) {
        if (!case_sensitive) {
            query_string = query_string.toLowerCase();
            param_name = param_name.toLowerCase();
        }
        if (query_string.charAt(0) == '?') {
            query_string = '&' + query_string.substring(1);
        } else if (query_string.charAt(0) != '&') {
            query_string = '&' + query_string;
        }
        return query_string.indexOf("&" + param_name + "=") != -1;
    }

    public static boolean containsPasskey(URL url) {
        String url_str = url.toExternalForm();
        return url_str.matches(".*[0-9a-z]{20,40}.*");
    }

    static {
        connect_pool.setWarnWhenFull();
        prefixes = new String[]{"http://", "https://", "ftp://", "dht://", "magnet:?", "magnet://?"};
        MAGNETURL_STARTS_AT = 3;
        XMLescapes = new Object[]{new String[]{"&", "&amp;"}, new String[]{">", "&gt;"}, new String[]{"<", "&lt;"}, new String[]{"\"", "&quot;"}, new String[]{"'", "&apos;"}};
        last_headers = COConfigurationManager.getStringParameter("metasearch.web.last.headers", null);
    }
}

