/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.xml.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;

public class XUXmlWriter {
    private static final int INDENT_AMOUNT = 4;
    private String current_indent_string;
    private PrintWriter writer;
    private boolean generic_simple;

    protected XUXmlWriter() {
        this.resetIndent();
    }

    protected XUXmlWriter(OutputStream _output_stream) {
        this.setOutputStream(_output_stream);
        this.resetIndent();
    }

    protected void setOutputStream(OutputStream _output_stream) {
        try {
            this.writer = new PrintWriter(new OutputStreamWriter(_output_stream, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
            this.writer = new PrintWriter(_output_stream);
        }
    }

    protected void setOutputWriter(Writer _writer) {
        this.writer = _writer instanceof PrintWriter ? (PrintWriter)_writer : new PrintWriter(_writer);
    }

    protected void setGenericSimple(boolean simple) {
        this.generic_simple = simple;
    }

    protected void writeTag(String tag, String content) {
        this.writeLineRaw("<" + tag + ">" + XUXmlWriter.escapeXML(content) + "</" + tag + ">");
    }

    protected void writeTag(String tag, long content) {
        this.writeLineRaw("<" + tag + ">" + content + "</" + tag + ">");
    }

    protected void writeTag(String tag, boolean content) {
        this.writeLineRaw("<" + tag + ">" + (content ? "YES" : "NO") + "</" + tag + ">");
    }

    protected void writeLineRaw(String str) {
        this.writer.println(this.current_indent_string + str);
    }

    protected void writeLineEscaped(String str) {
        this.writer.println(this.current_indent_string + XUXmlWriter.escapeXML(str));
    }

    protected void resetIndent() {
        this.current_indent_string = "";
    }

    protected void indent() {
        for (int i = 0; i < 4; ++i) {
            this.current_indent_string = this.current_indent_string + " ";
        }
    }

    protected void exdent() {
        this.current_indent_string = this.current_indent_string.length() >= 4 ? this.current_indent_string.substring(0, this.current_indent_string.length() - 4) : "";
    }

    public static String escapeXML(String str) {
        if (str == null) {
            return "";
        }
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll("'", "&apos;");
        str = str.replaceAll("--", "&#45;&#45;");
        return str;
    }

    public static String unescapeXML(String str) {
        if (str == null) {
            return "";
        }
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("&apos;", "'");
        str = str.replaceAll("&#45;&#45;", "--");
        str = str.replaceAll("&amp;", "&");
        return str;
    }

    protected void flushOutputStream() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    protected void closeOutputStream() {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeGenericMapEntry(String name, Object value) {
        if (this.generic_simple) {
            name = name.replace(' ', '_').toUpperCase();
            this.writeLineRaw("<" + name + ">");
            try {
                this.indent();
                this.writeGeneric(value);
            }
            finally {
                this.exdent();
            }
            this.writeLineRaw("</" + name + ">");
        } else {
            this.writeLineRaw("<KEY name=\"" + XUXmlWriter.escapeXML(name) + "\">");
            try {
                this.indent();
                this.writeGeneric(value);
            }
            finally {
                this.exdent();
            }
            this.writeLineRaw("</KEY>");
        }
    }

    protected void writeGeneric(Object obj) {
        if (obj instanceof Map) {
            this.writeGeneric((Map)obj);
        } else if (obj instanceof List) {
            this.writeGeneric((List)obj);
        } else if (obj instanceof byte[]) {
            this.writeGeneric((byte[])obj);
        } else {
            this.writeGeneric((Long)obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeGeneric(Map map) {
        this.writeLineRaw("<MAP>");
        try {
            this.indent();
            for (String key : map.keySet()) {
                this.writeGenericMapEntry(key, map.get(key));
            }
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</MAP>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeGeneric(List list) {
        this.writeLineRaw("<LIST>");
        try {
            this.indent();
            for (int i = 0; i < list.size(); ++i) {
                this.writeGeneric(list.get(i));
            }
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</LIST>");
    }

    protected void writeGeneric(byte[] bytes) {
        if (this.generic_simple) {
            try {
                this.writeLineRaw(XUXmlWriter.escapeXML(new String(bytes, "UTF-8")));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            this.writeTag("BYTES", this.encodeBytes(bytes));
        }
    }

    protected void writeGeneric(Long l) {
        if (this.generic_simple) {
            this.writeLineRaw(l.toString());
        } else {
            this.writeTag("LONG", "" + l);
        }
    }

    protected void writeTag(String tag, byte[] content) {
        this.writeLineRaw("<" + tag + ">" + this.encodeBytes(content) + "</" + tag + ">");
    }

    protected void writeLocalisableTag(String tag, byte[] content) {
        boolean use_bytes = true;
        String utf_string = null;
        try {
            utf_string = new String(content, "UTF8");
            if (Arrays.equals(content, utf_string.getBytes("UTF8"))) {
                use_bytes = false;
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        this.writeLineRaw("<" + tag + " encoding=\"" + (use_bytes ? "bytes" : "utf8") + "\">" + (use_bytes ? this.encodeBytes(content) : XUXmlWriter.escapeXML(utf_string)) + "</" + tag + ">");
    }

    protected String encodeBytes(byte[] bytes) {
        String data = ByteFormatter.nicePrint(bytes, true);
        return data;
    }

    protected String getUTF(byte[] bytes) {
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
            return "";
        }
    }
}

