/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.macosx;

import com.apple.cocoa.application.NSApplication;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.HashSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerListener;
import org.gudy.azureus2.platform.PlatformManagerPingCallback;
import org.gudy.azureus2.platform.macosx.NativeInvocationBridge;
import org.gudy.azureus2.platform.macosx.PListEditor;
import org.gudy.azureus2.platform.macosx.access.jnilib.OSXAccess;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class PlatformManagerImpl
implements PlatformManager,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected static PlatformManagerImpl singleton;
    protected static AEMonitor class_mon;
    private static String fileBrowserName;
    private final HashSet capabilitySet = new HashSet();

    public static PlatformManagerImpl getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeSingleton() {
        try {
            class_mon.enter();
            singleton = new PlatformManagerImpl();
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Failed to initialize platform manager for Mac OS X", e));
        }
        finally {
            class_mon.exit();
        }
        COConfigurationManager.addAndFireParameterListener("FileBrowse.usePathFinder", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                fileBrowserName = COConfigurationManager.getBooleanParameter("FileBrowse.usePathFinder") ? "Path Finder" : "Finder";
            }
        });
    }

    public PlatformManagerImpl() {
        this.capabilitySet.add(PlatformManagerCapabilities.RecoverableFileDelete);
        this.capabilitySet.add(PlatformManagerCapabilities.ShowFileInBrowser);
        this.capabilitySet.add(PlatformManagerCapabilities.ShowPathInCommandLine);
        this.capabilitySet.add(PlatformManagerCapabilities.CreateCommandLineProcess);
        this.capabilitySet.add(PlatformManagerCapabilities.GetUserDataDirectory);
        this.capabilitySet.add(PlatformManagerCapabilities.UseNativeScripting);
        this.capabilitySet.add(PlatformManagerCapabilities.PlaySystemAlert);
        this.capabilitySet.add(PlatformManagerCapabilities.RequestUserAttention);
        if (OSXAccess.isLoaded()) {
            this.capabilitySet.add(PlatformManagerCapabilities.GetVersion);
        }
        AEDiagnostics.addEvidenceGenerator(this);
        this.checkPList();
    }

    public int getPlatformType() {
        return 3;
    }

    public String getVersion() throws PlatformManagerException {
        if (!OSXAccess.isLoaded()) {
            throw new PlatformManagerException("Unsupported capability called on platform manager");
        }
        return OSXAccess.getVersion();
    }

    protected PListEditor getPList() throws IOException {
        String plist = System.getProperty("user.dir") + SystemProperties.SEP + SystemProperties.getApplicationName() + ".app/Contents/Info.plist";
        PListEditor editor = new PListEditor(plist);
        return editor;
    }

    protected void checkPList() {
        try {
            PListEditor editor = this.getPList();
            editor.setFileTypeExtensions(new String[]{"torrent", "tor", "vuze", "vuz"});
            editor.setSimpleStringValue("CFBundleName", "Vuze");
            editor.setSimpleStringValue("CFBundleTypeName", "Vuze Download");
            editor.setSimpleStringValue("CFBundleGetInfoString", "Vuze");
            editor.setSimpleStringValue("CFBundleShortVersionString", "4.0.0.1_B06");
            editor.setSimpleStringValue("CFBundleVersion", "4.0.0.1_B06");
            editor.setArrayValues("CFBundleURLSchemes", "string", new String[]{"magnet", "dht", "vuze"});
        }
        catch (Throwable e) {
            Debug.out("Failed to update plist", e);
        }
    }

    protected void touchPList() {
        try {
            PListEditor editor = this.getPList();
            editor.touchFile();
        }
        catch (Throwable e) {
            Debug.out("Failed to touch plist", e);
        }
    }

    public String getUserDataDirectory() throws PlatformManagerException {
        return new File(System.getProperty("user.home") + "/Library/Application Support/" + SystemProperties.APPLICATION_NAME).getPath() + SystemProperties.SEP;
    }

    public File getLocation(long location_id) throws PlatformManagerException {
        switch ((int)location_id) {
            case 1: {
                return new File(this.getUserDataDirectory());
            }
            case 3: {
                try {
                    return new File(OSXAccess.getDocDir());
                }
                catch (Throwable e) {
                    return new File(System.getProperty("user.home"), "Documents");
                }
            }
        }
        return null;
    }

    public boolean isApplicationRegistered() throws PlatformManagerException {
        return true;
    }

    public String getApplicationCommandLine() throws PlatformManagerException {
        try {
            String bundle_path = System.getProperty("user.dir") + SystemProperties.SEP + SystemProperties.getApplicationName() + ".app";
            File osx_app_bundle = new File(bundle_path).getAbsoluteFile();
            if (!osx_app_bundle.exists()) {
                String msg = "OSX app bundle not found: [" + osx_app_bundle.toString() + "]";
                System.out.println(msg);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, msg));
                }
                throw new PlatformManagerException(msg);
            }
            return "open -a \"" + osx_app_bundle.toString() + "\"";
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public boolean isAdditionalFileTypeRegistered(String name, String type) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    public void unregisterAdditionalFileType(String name, String type) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    public void registerAdditionalFileType(String name, String description, String type, String content_type) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    public void registerApplication() throws PlatformManagerException {
        this.touchPList();
    }

    public void createProcess(String cmd, boolean inheritsHandles) throws PlatformManagerException {
        try {
            PlatformManagerImpl.performRuntimeExec(cmd.split(" "));
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to create process", e);
        }
    }

    public void performRecoverableFileDelete(String path) throws PlatformManagerException {
        boolean useOSA;
        File file = new File(path);
        if (!file.exists()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Cannot find " + file.getName()));
            }
            return;
        }
        boolean bl = useOSA = !NativeInvocationBridge.sharedInstance().isEnabled() || !NativeInvocationBridge.sharedInstance().performRecoverableFileDelete(file);
        if (useOSA) {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("tell application \"");
                sb.append("Finder");
                sb.append("\" to move (posix file \"");
                sb.append(path);
                sb.append("\" as alias) to the trash");
                PlatformManagerImpl.performOSAScript(sb);
            }
            catch (Throwable e) {
                throw new PlatformManagerException("Failed to move file", e);
            }
        }
    }

    public boolean hasCapability(PlatformManagerCapabilities capability) {
        return this.capabilitySet.contains(capability);
    }

    public void dispose() {
        NativeInvocationBridge.sharedInstance().dispose();
    }

    public void setTCPTOSEnabled(boolean enabled) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    public void copyFilePermissions(String from_file_name, String to_file_name) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    public void showFile(String path) throws PlatformManagerException {
        File file = new File(path);
        if (!file.exists()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Cannot find " + file.getName()));
            }
            throw new PlatformManagerException("File not found");
        }
        this.showInFinder(file);
    }

    public void playSystemAlert() {
        try {
            PlatformManagerImpl.performRuntimeExec(new String[]{"beep"});
        }
        catch (IOException e) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Cannot play system alert"));
            }
            Logger.log(new LogEvent(LOGID, "", e));
        }
    }

    public void showInFinder(File path) {
        boolean useOSA;
        boolean bl = useOSA = !NativeInvocationBridge.sharedInstance().isEnabled() || !NativeInvocationBridge.sharedInstance().showInFinder(path, fileBrowserName);
        if (useOSA) {
            StringBuffer sb = new StringBuffer();
            sb.append("tell application \"");
            sb.append(PlatformManagerImpl.getFileBrowserName());
            sb.append("\" to reveal (posix file \"");
            sb.append(path);
            sb.append("\" as alias)");
            try {
                PlatformManagerImpl.performOSAScript(sb);
            }
            catch (IOException e) {
                Logger.log(new LogAlert(false, 3, e.getMessage()));
            }
        }
    }

    public void showInTerminal(String path) {
        this.showInTerminal(new File(path));
    }

    public void showInTerminal(File path) {
        if (path.isFile()) {
            path = path.getParentFile();
        }
        if (path != null && path.isDirectory()) {
            StringBuffer sb = new StringBuffer();
            sb.append("tell application \"");
            sb.append("Terminal");
            sb.append("\" to do script \"cd ");
            sb.append(path.getAbsolutePath().replaceAll(" ", "\\ "));
            sb.append("\"");
            try {
                PlatformManagerImpl.performOSAScript(sb);
            }
            catch (IOException e) {
                Logger.log(new LogAlert(false, 3, e.getMessage()));
            }
        } else if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, 1, "Cannot find " + path.getName()));
        }
    }

    protected static String performOSAScript(CharSequence cmd) throws IOException {
        return PlatformManagerImpl.performOSAScript(new CharSequence[]{cmd});
    }

    protected static String performOSAScript(CharSequence[] cmds) throws IOException {
        long start = System.currentTimeMillis();
        Debug.outNoStack("Executing OSAScript: ");
        for (int i = 0; i < cmds.length; ++i) {
            Debug.outNoStack("\t" + cmds[i]);
        }
        String[] cmdargs = new String[2 * cmds.length + 1];
        cmdargs[0] = "osascript";
        for (int i = 0; i < cmds.length; ++i) {
            cmdargs[i * 2 + 1] = "-e";
            cmdargs[i * 2 + 2] = String.valueOf(cmds[i]);
        }
        Process osaProcess = PlatformManagerImpl.performRuntimeExec(cmdargs);
        BufferedReader reader = new BufferedReader(new InputStreamReader(osaProcess.getInputStream()));
        String line = reader.readLine();
        reader.close();
        Debug.outNoStack("OSAScript Output: " + line);
        reader = new BufferedReader(new InputStreamReader(osaProcess.getErrorStream()));
        String errorMsg = reader.readLine();
        reader.close();
        Debug.outNoStack("OSAScript Error (if any): " + errorMsg);
        Debug.outNoStack(MessageFormat.format("OSAScript execution ended ({0}ms)", String.valueOf(System.currentTimeMillis() - start)));
        try {
            osaProcess.destroy();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (errorMsg != null) {
            throw new IOException(errorMsg);
        }
        return line;
    }

    protected static String performOSAScript(File script) throws IOException {
        long start = System.currentTimeMillis();
        Debug.outNoStack("Executing OSAScript from file: " + script.getPath());
        Process osaProcess = PlatformManagerImpl.performRuntimeExec(new String[]{"osascript", script.getPath()});
        BufferedReader reader = new BufferedReader(new InputStreamReader(osaProcess.getInputStream()));
        String line = reader.readLine();
        reader.close();
        Debug.outNoStack("OSAScript Output: " + line);
        reader = new BufferedReader(new InputStreamReader(osaProcess.getErrorStream()));
        String errorMsg = reader.readLine();
        reader.close();
        Debug.outNoStack("OSAScript Error (if any): " + errorMsg);
        Debug.outNoStack(MessageFormat.format("OSAScript execution ended ({0}ms)", String.valueOf(System.currentTimeMillis() - start)));
        try {
            osaProcess.destroy();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (errorMsg != null) {
            throw new IOException(errorMsg);
        }
        return line;
    }

    protected static boolean compileOSAScript(CharSequence cmd, File destination) {
        return PlatformManagerImpl.compileOSAScript(new CharSequence[]{cmd}, destination);
    }

    protected static boolean compileOSAScript(CharSequence[] cmds, File destination) {
        String errorMsg;
        long start = System.currentTimeMillis();
        Debug.outNoStack("Compiling OSAScript: " + destination.getPath());
        for (int i = 0; i < cmds.length; ++i) {
            Debug.outNoStack("\t" + cmds[i]);
        }
        String[] cmdargs = new String[2 * cmds.length + 3];
        cmdargs[0] = "osacompile";
        for (int i = 0; i < cmds.length; ++i) {
            cmdargs[i * 2 + 1] = "-e";
            cmdargs[i * 2 + 2] = String.valueOf(cmds[i]);
        }
        cmdargs[cmdargs.length - 2] = "-o";
        cmdargs[cmdargs.length - 1] = destination.getPath();
        try {
            Process osaProcess = PlatformManagerImpl.performRuntimeExec(cmdargs);
            BufferedReader reader = new BufferedReader(new InputStreamReader(osaProcess.getErrorStream()));
            errorMsg = reader.readLine();
            reader.close();
        }
        catch (IOException e) {
            Debug.outNoStack("OSACompile Execution Failed: " + e.getMessage());
            Debug.printStackTrace(e);
            return false;
        }
        Debug.outNoStack("OSACompile Error (if any): " + errorMsg);
        Debug.outNoStack(MessageFormat.format("OSACompile execution ended ({0}ms)", String.valueOf(System.currentTimeMillis() - start)));
        return errorMsg == null;
    }

    protected static Process performRuntimeExec(String[] cmdargs) throws IOException {
        try {
            return Runtime.getRuntime().exec(cmdargs);
        }
        catch (IOException e) {
            Logger.log(new LogAlert(false, e.getMessage(), e));
            throw e;
        }
    }

    private static String getFileBrowserName() {
        return fileBrowserName;
    }

    public boolean testNativeAvailability(String name) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    public void traceRoute(InetAddress interface_address, InetAddress target, PlatformManagerPingCallback callback) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    public void ping(InetAddress interface_address, InetAddress target, PlatformManagerPingCallback callback) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    public void addListener(PlatformManagerListener listener) {
    }

    public void removeListener(PlatformManagerListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("PlatformManager: MacOSX");
        try {
            writer.indent();
            if (OSXAccess.isLoaded()) {
                try {
                    writer.println("Version " + this.getVersion());
                    writer.println("User Data Dir: " + this.getLocation(1L));
                    writer.println("User Doc Dir: " + this.getLocation(3L));
                }
                catch (PlatformManagerException platformManagerException) {}
            } else {
                writer.println("Not loaded");
            }
        }
        finally {
            writer.exdent();
        }
    }

    public String getAzComputerID() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void requestUserAttention(int type, Object data) throws PlatformManagerException {
        try {
            NSApplication app = NSApplication.sharedApplication();
            if (type == 1) {
                app.requestUserAttention(10);
                return;
            }
            if (type == 2) {
                app.requestUserAttention(0);
                return;
            }
            if (type != 3) return;
        }
        catch (Exception e) {
            throw new PlatformManagerException("Failed to request user attention", e);
        }
    }

    static {
        class_mon = new AEMonitor("PlatformManager");
        fileBrowserName = "Finder";
        PlatformManagerImpl.initializeSingleton();
    }
}

