/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.win32;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerListener;
import org.gudy.azureus2.platform.PlatformManagerPingCallback;
import org.gudy.azureus2.platform.win32.access.AEWin32Access;
import org.gudy.azureus2.platform.win32.access.AEWin32AccessListener;
import org.gudy.azureus2.platform.win32.access.AEWin32Manager;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class PlatformManagerImpl
implements PlatformManager,
AEWin32AccessListener {
    public static final int RT_NONE = 0;
    public static final int RT_AZ = 1;
    public static final int RT_OTHER = 2;
    public static final String DLL_NAME = "aereg";
    public static final String VUZE_ASSOC = "Vuze";
    public static final String NEW_MAIN_ASSOC = "Azureus";
    public static final String OLD_MAIN_ASS0C = "BitTorrent";
    private static boolean initialising;
    private static boolean init_tried;
    private static PlatformManagerImpl singleton;
    private static AEMonitor class_mon;
    private final Set capabilitySet = new HashSet();
    private List listeners = new ArrayList();
    private final AEWin32Access access = AEWin32Manager.getAccessor(true);
    private final String app_name;
    private final String app_exe_name;
    private File az_exe;
    private boolean az_exe_checked;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlatformManagerImpl getSingleton() throws PlatformManagerException {
        try {
            block13: {
                class_mon.enter();
                if (singleton != null) {
                    PlatformManagerImpl platformManagerImpl = singleton;
                    return platformManagerImpl;
                }
                try {
                    if (initialising) {
                        System.err.println("PlatformManager: recursive entry during initialisation");
                    }
                    initialising = true;
                    if (init_tried) break block13;
                    init_tried = true;
                    try {
                        singleton = new PlatformManagerImpl();
                        singleton.applyPatches();
                    }
                    catch (PlatformManagerException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        if (e instanceof PlatformManagerException) {
                            throw (PlatformManagerException)e;
                        }
                        throw new PlatformManagerException("Win32Platform: failed to initialise", e);
                    }
                }
                finally {
                    initialising = false;
                }
            }
            PlatformManagerImpl platformManagerImpl = singleton;
            return platformManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected PlatformManagerImpl() throws PlatformManagerException {
        this.access.addListener(this);
        this.app_name = SystemProperties.getApplicationName();
        this.app_exe_name = this.app_name + ".exe";
        this.initializeCapabilities();
    }

    private void initializeCapabilities() {
        if (this.access.isEnabled()) {
            this.capabilitySet.add(PlatformManagerCapabilities.CreateCommandLineProcess);
            this.capabilitySet.add(PlatformManagerCapabilities.GetUserDataDirectory);
            this.capabilitySet.add(PlatformManagerCapabilities.RecoverableFileDelete);
            this.capabilitySet.add(PlatformManagerCapabilities.RegisterFileAssociations);
            this.capabilitySet.add(PlatformManagerCapabilities.ShowFileInBrowser);
            this.capabilitySet.add(PlatformManagerCapabilities.GetVersion);
            this.capabilitySet.add(PlatformManagerCapabilities.SetTCPTOSEnabled);
            this.capabilitySet.add(PlatformManagerCapabilities.ComputerIDAvailability);
            if (Constants.compareVersions(this.access.getVersion(), "1.11") >= 0 && !Constants.isWindows9598ME) {
                this.capabilitySet.add(PlatformManagerCapabilities.CopyFilePermissions);
            }
            if (Constants.compareVersions(this.access.getVersion(), "1.12") >= 0) {
                this.capabilitySet.add(PlatformManagerCapabilities.TestNativeAvailability);
            }
            if (Constants.compareVersions(this.access.getVersion(), "1.14") >= 0) {
                this.capabilitySet.add(PlatformManagerCapabilities.TraceRouteAvailability);
            }
            if (Constants.compareVersions(this.access.getVersion(), "1.15") >= 0) {
                this.capabilitySet.add(PlatformManagerCapabilities.PingAvailability);
            }
        } else {
            this.capabilitySet.add(PlatformManagerCapabilities.GetVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyPatches() {
        try {
            File exe_loc = this.getApplicationEXELocation();
            String az_exe_string = exe_loc.toString();
            String current = this.access.readStringValue(1, "Azureus\\DefaultIcon", "");
            String target = az_exe_string + "," + this.getIconIndex();
            if (current.indexOf(this.app_exe_name) != -1 && !current.equals(target)) {
                this.writeStringToHKCRandHKCU("Azureus\\DefaultIcon", "", target);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this.hasCapability(PlatformManagerCapabilities.CopyFilePermissions) && !COConfigurationManager.getBooleanParameter("platform.win32.permfixdone2", false)) {
            try {
                String str = SystemProperties.getApplicationPath();
                if (str.endsWith(File.separator)) {
                    str = str.substring(0, str.length() - 1);
                }
                this.fixPermissions(new File(str), new File(str));
            }
            catch (Throwable throwable) {
            }
            finally {
                COConfigurationManager.setParameter("platform.win32.permfixdone2", true);
            }
        }
    }

    protected void fixPermissions(File parent, File dir) throws PlatformManagerException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.isFile()) continue;
            this.copyFilePermissions(parent.getAbsolutePath(), file.getAbsolutePath());
        }
    }

    protected int getIconIndex() throws PlatformManagerException {
        return 0;
    }

    public String getVersion() {
        return this.access.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getApplicationEXELocation() throws PlatformManagerException {
        if (this.az_exe == null) {
            try {
                String az_home = SystemProperties.getApplicationPath();
                this.az_exe = new File(az_home + File.separator + this.app_exe_name).getAbsoluteFile();
                if (!this.az_exe.exists()) {
                    try {
                        az_home = this.access.getApplicationInstallDir(this.app_name);
                        this.az_exe = new File(az_home + File.separator + this.app_exe_name).getAbsoluteFile();
                        if (!this.az_exe.exists()) {
                            throw new PlatformManagerException(this.app_exe_name + " not found in " + az_home + ", please re-install");
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (!this.az_exe.exists()) {
                    String msg = this.app_exe_name + " not found in " + az_home + " - can't check file associations. Please re-install " + this.app_name;
                    this.az_exe = null;
                    if (!this.az_exe_checked) {
                        Logger.log(new LogAlert(false, 1, msg));
                    }
                    throw new PlatformManagerException(msg);
                }
            }
            finally {
                this.az_exe_checked = true;
            }
        }
        return this.az_exe;
    }

    public int getPlatformType() {
        return 1;
    }

    public String getUserDataDirectory() throws PlatformManagerException {
        try {
            return this.access.getUserAppData() + SystemProperties.SEP + this.app_name + SystemProperties.SEP;
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to read registry details", e);
        }
    }

    public File getLocation(long location_id) throws PlatformManagerException {
        if (location_id == 1L) {
            return new File(this.getUserDataDirectory());
        }
        if (location_id == 2L) {
            try {
                return new File(this.access.getUserMusicDir());
            }
            catch (Throwable e) {
                throw new PlatformManagerException("Failed to read registry details", e);
            }
        }
        if (location_id == 3L) {
            try {
                return new File(this.access.getUserDocumentsDir());
            }
            catch (Throwable e) {
                throw new PlatformManagerException("Failed to read registry details", e);
            }
        }
        if (location_id == 4L) {
            try {
                return new File(this.access.getUserVideoDir());
            }
            catch (Throwable e) {
                throw new PlatformManagerException("Failed to read registry details", e);
            }
        }
        return null;
    }

    public String getApplicationCommandLine() {
        try {
            return this.getApplicationEXELocation().toString();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public boolean isApplicationRegistered() throws PlatformManagerException {
        boolean vuze_reg;
        boolean reg;
        File exe_loc = this.getApplicationEXELocation();
        if (exe_loc.exists()) {
            this.checkExeKey(exe_loc);
        }
        try {
            if (this.getAdditionalFileTypeRegistrationDetails("Magnet", ".magnet") == 0) {
                this.registerMagnet();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        try {
            if (this.getAdditionalFileTypeRegistrationDetails("DHT", ".dht") == 0) {
                this.registerDHT();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (this.isAdditionalFileTypeRegistered(OLD_MAIN_ASS0C, ".torrent")) {
            this.unregisterAdditionalFileType(OLD_MAIN_ASS0C, ".torrent");
            this.registerAdditionalFileType(NEW_MAIN_ASSOC, Constants.APP_NAME + " Download", ".torrent", "application/x-bittorrent");
        }
        if (!(reg = this.isAdditionalFileTypeRegistered(NEW_MAIN_ASSOC, ".torrent")) && !COConfigurationManager.getBooleanParameter("platform.win32.autoregdone", false)) {
            this.registerAdditionalFileType(NEW_MAIN_ASSOC, Constants.APP_NAME + " Download", ".torrent", "application/x-bittorrent");
            COConfigurationManager.setParameter("platform.win32.autoregdone", true);
            reg = true;
        }
        if (!(vuze_reg = this.isAdditionalFileTypeRegistered(VUZE_ASSOC, ".vuze"))) {
            this.registerAdditionalFileType(VUZE_ASSOC, "Vuze File", ".vuze", "application/x-vuze");
        }
        return reg;
    }

    protected void checkExeKey(File exe) {
        this.checkExeKey(4, exe);
        this.checkExeKey(3, exe);
    }

    protected void checkExeKey(int hkey, File exe) {
        String exe_str = exe.getAbsolutePath();
        String str = null;
        try {
            str = this.access.readStringValue(hkey, "software\\" + this.app_name, "exec");
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (str == null || !str.equals(exe_str)) {
                this.access.writeStringValue(hkey, "software\\" + this.app_name, "exec", exe_str);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public boolean isAdditionalFileTypeRegistered(String name, String type) throws PlatformManagerException {
        return this.getAdditionalFileTypeRegistrationDetails(name, type) == 1;
    }

    public int getAdditionalFileTypeRegistrationDetails(String name, String type) throws PlatformManagerException {
        String az_exe_str;
        try {
            az_exe_str = this.getApplicationEXELocation().toString();
        }
        catch (Throwable e) {
            return 0;
        }
        try {
            String test1 = this.access.readStringValue(1, name + "\\shell\\open\\command", "");
            if (!test1.equals("\"" + az_exe_str + "\" \"%1\"")) {
                return test1.length() == 0 ? 0 : 2;
            }
            String test2 = this.access.readStringValue(1, type, "");
            if (!test2.equals(NEW_MAIN_ASSOC)) {
                return test2.length() == 0 ? 0 : 2;
            }
            try {
                String always_open_with = this.access.readStringValue(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + type, "Application");
                if (always_open_with.length() > 0) {
                    return 2;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            return 1;
        }
        catch (Throwable e) {
            if (e.getMessage() == null || e.getMessage().indexOf("RegOpenKey failed") == -1) {
                Debug.printStackTrace(e);
            }
            return 0;
        }
    }

    public void registerApplication() throws PlatformManagerException {
        this.registerMagnet();
        this.registerDHT();
        this.registerAdditionalFileType(NEW_MAIN_ASSOC, Constants.APP_NAME + " Download", ".torrent", "application/x-bittorrent");
        this.registerAdditionalFileType(VUZE_ASSOC, "Vuze File", ".vuze", "application/x-vuze");
    }

    protected void registerMagnet() {
        try {
            this.registerAdditionalFileType("Magnet", "Magnet URI", ".magnet", "application/x-magnet", true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void registerDHT() {
        try {
            this.registerAdditionalFileType("DHT", "DHT URI", ".dht", "application/x-dht", true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void registerAdditionalFileType(String name, String description, String type, String content_type) throws PlatformManagerException {
        this.registerAdditionalFileType(name, description, type, content_type, false);
    }

    public void registerAdditionalFileType(String name, String description, String type, String content_type, boolean url_protocol) throws PlatformManagerException {
        try {
            String az_exe_string = this.getApplicationEXELocation().toString();
            this.unregisterAdditionalFileType(name, type);
            this.writeStringToHKCRandHKCU(type, "", name);
            this.writeStringToHKCRandHKCU(type, "Content Type", content_type);
            this.writeStringToHKCRandHKCU("MIME\\Database\\Content Type\\" + content_type, "Extension", type);
            this.writeStringToHKCRandHKCU(name, "", description);
            this.writeStringToHKCRandHKCU(name + "\\shell", "", "open");
            this.writeStringToHKCRandHKCU(name + "\\DefaultIcon", "", az_exe_string + "," + this.getIconIndex());
            this.writeStringToHKCRandHKCU(name + "\\shell\\open\\command", "", "\"" + az_exe_string + "\" \"%1\"");
            this.writeStringToHKCRandHKCU(name, "Content Type", content_type);
            if (url_protocol) {
                this.writeStringToHKCRandHKCU(name, "URL Protocol", "");
            }
        }
        catch (PlatformManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to write registry details", e);
        }
    }

    private void writeStringToHKCRandHKCU(String subkey, String name, String value) {
        block4: {
            try {
                this.access.writeStringValue(1, subkey, name, value);
            }
            catch (Throwable e) {
                if (Constants.isWindowsVista) break block4;
                Debug.out(e);
            }
        }
        try {
            this.access.writeStringValue(4, "Software\\Classes\\" + subkey, name, value);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    public void unregisterAdditionalFileType(String name, String type) throws PlatformManagerException {
        try {
            try {
                this.access.deleteValue(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + type, "Application");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.access.deleteKey(1, type);
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.access.deleteKey(1, name, true);
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.access.deleteKey(4, "Software\\Classes\\" + type);
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.access.deleteKey(4, "Software\\Classes\\" + name, true);
            }
            catch (Throwable e) {}
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to delete registry details", e);
        }
    }

    public void createProcess(String command_line, boolean inherit_handles) throws PlatformManagerException {
        try {
            this.access.createProcess(command_line, inherit_handles);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to create process", e);
        }
    }

    public void performRecoverableFileDelete(String file_name) throws PlatformManagerException {
        try {
            this.access.moveToRecycleBin(file_name);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to move file", e);
        }
    }

    public void setTCPTOSEnabled(boolean enabled) throws PlatformManagerException {
        try {
            this.access.writeWordValue(3, "System\\CurrentControlSet\\Services\\Tcpip\\Parameters", "DisableUserTOSSetting", enabled ? 0 : 1);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to write registry details", e);
        }
    }

    public void copyFilePermissions(String from_file_name, String to_file_name) throws PlatformManagerException {
        try {
            this.access.copyFilePermissions(from_file_name, to_file_name);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to copy file permissions", e);
        }
    }

    public void showFile(String file_name) throws PlatformManagerException {
        try {
            File file = new File(file_name);
            this.access.createProcess("explorer.exe " + (file.isDirectory() ? "/e," : "/e,/select,") + "\"" + file_name + "\"", false);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to show file " + file_name, e);
        }
    }

    public boolean testNativeAvailability(String name) throws PlatformManagerException {
        if (!this.hasCapability(PlatformManagerCapabilities.TestNativeAvailability)) {
            throw new PlatformManagerException("Unsupported capability called on platform manager");
        }
        try {
            return this.access.testNativeAvailability(name);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to test availability", e);
        }
    }

    public void traceRoute(InetAddress interface_address, InetAddress target, PlatformManagerPingCallback callback) throws PlatformManagerException {
        if (!this.hasCapability(PlatformManagerCapabilities.TraceRouteAvailability)) {
            throw new PlatformManagerException("Unsupported capability called on platform manager");
        }
        try {
            this.access.traceRoute(interface_address, target, callback);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to trace route", e);
        }
    }

    public void ping(InetAddress interface_address, InetAddress target, PlatformManagerPingCallback callback) throws PlatformManagerException {
        if (!this.hasCapability(PlatformManagerCapabilities.PingAvailability)) {
            throw new PlatformManagerException("Unsupported capability called on platform manager");
        }
        try {
            this.access.ping(interface_address, target, callback);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to trace route", e);
        }
    }

    public int shellExecute(String operation, String file, String parameters, String directory, int SW_const) throws PlatformManagerException {
        try {
            return this.access.shellExecute(operation, file, parameters, directory, SW_const);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to shellExecute", e);
        }
    }

    public boolean hasCapability(PlatformManagerCapabilities capability) {
        return this.capabilitySet.contains(capability);
    }

    public void dispose() {
    }

    public void eventOccurred(int type) {
        int t_type;
        if (type == 1) {
            t_type = 1;
        } else if (type == 2) {
            t_type = 2;
        } else if (type == 3) {
            t_type = 3;
        } else {
            return;
        }
        if (t_type != -1) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    ((PlatformManagerListener)this.listeners.get(i)).eventOccurred(t_type);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void addListener(PlatformManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(PlatformManagerListener listener) {
        this.listeners.remove(listener);
    }

    public String getAzComputerID() {
        boolean needWrite = false;
        String cid = null;
        try {
            cid = this.access.readStringValue(3, "SOFTWARE\\" + this.app_name, "CID");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (cid == null || cid.length() == 0) {
            needWrite = true;
            try {
                File fCID;
                File commonPath = new File(this.access.getCommonAppData(), this.app_name);
                if (commonPath.isDirectory() && (fCID = new File(commonPath, "azCID.txt")).exists()) {
                    cid = FileUtil.readFileAsString(fCID, 255, "utf8");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cid == null || cid.length() == 0) {
            needWrite = true;
            cid = COConfigurationManager.getStringParameter("ID");
        }
        if (cid == null || cid.length() == 0) {
            needWrite = true;
            cid = RandomUtils.generateRandomAlphanumerics(20);
        }
        if (needWrite) {
            this.setAzComputerID(cid);
        }
        return cid;
    }

    private void setAzComputerID(String cid) {
        try {
            this.access.writeStringValue(3, "SOFTWARE\\" + this.app_name, "CID", cid);
        }
        catch (Exception e) {
            Debug.out("Could not write CID: " + e.getMessage());
        }
        try {
            File commonPath;
            String sCommonAppData = this.access.getCommonAppData();
            if (sCommonAppData != null && sCommonAppData.length() > 0 && (commonPath = new File(sCommonAppData)).isDirectory()) {
                commonPath = new File(commonPath, this.app_name);
                FileUtil.mkdirs(commonPath);
                File fCID = new File(commonPath, "azCID.txt");
                FileUtil.writeBytesAsFile(fCID.getAbsolutePath(), cid.getBytes("utf8"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            PlatformManagerImpl impl = new PlatformManagerImpl();
            System.out.println(impl.getAzComputerID());
        }
        catch (PlatformManagerException e) {
            e.printStackTrace();
        }
    }

    public void requestUserAttention(int type, Object data) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    static {
        class_mon = new AEMonitor("PlatformManager");
    }
}

