/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.plugins.utils;

import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.InputStream;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.utils.Formatters;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourceuploader.ResourceUploaderFactory;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourceuploader.ResourceUploaderFactoryImpl;

public class StaticUtilities {
    private static Formatters formatters;

    public static Formatters getFormatters() {
        return formatters;
    }

    public static ResourceDownloaderFactory getResourceDownloaderFactory() {
        return ResourceDownloaderFactoryImpl.getSingleton();
    }

    public static ResourceUploaderFactory getResourceUploaderFactory() {
        return ResourceUploaderFactoryImpl.getSingleton();
    }

    public static PluginInterface getDefaultPluginInterface() {
        return AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface();
    }

    public static RSSFeed getRSSFeed(InputStream is) throws SimpleXMLParserDocumentException {
        return StaticUtilities.getDefaultPluginInterface().getUtilities().getRSSFeed(is);
    }

    public static int promptUser(String title, String desc, String[] options, int default_option) {
        UIInstance[] instances = StaticUtilities.getDefaultPluginInterface().getUIManager().getUIInstances();
        if (instances.length > 0) {
            return instances[0].promptUser(title, desc, options, default_option);
        }
        Debug.out("No UIInstances to handle prompt: " + title + "/" + desc);
        return -1;
    }

    public static UIManager getUIManager(long millis_to_wait_for_attach) {
        final UIManager ui_manager = StaticUtilities.getDefaultPluginInterface().getUIManager();
        if (ui_manager.getUIInstances().length == 0) {
            final AESemaphore sem = new AESemaphore("waitforui");
            ui_manager.addUIListener(new UIManagerListener(){

                public void UIAttached(UIInstance instance) {
                    ui_manager.removeUIListener(this);
                    sem.releaseForever();
                }

                public void UIDetached(UIInstance instance) {
                }
            });
            long time_to_go = millis_to_wait_for_attach;
            while (ui_manager.getUIInstances().length == 0 && !sem.reserve(1000L)) {
                if ((time_to_go -= 1000L) > 0L) continue;
                Debug.out("Timeout waiting for UI to attach");
                break;
            }
        }
        return ui_manager;
    }

    static {
        try {
            Class<?> c = Class.forName("org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl");
            formatters = (Formatters)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

