/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ddb;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginKeyStats;
import com.aelitis.azureus.plugins.dht.DHTPluginListener;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginProgressListener;
import com.aelitis.azureus.plugins.dht.DHTPluginTransferHandler;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseEvent;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseException;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKeyStats;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferHandler;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferType;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseContactImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseHelpers;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseKeyImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseTTTorrent;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseValueImpl;

public class DDBaseImpl
implements DistributedDatabase {
    private static DDBaseImpl singleton;
    protected static AEMonitor class_mon;
    protected static Map transfer_map;
    private static DDBaseTTTorrent torrent_transfer;
    private AzureusCore azureus_core;
    private DHTPlugin dht_use_accessor;
    private CopyOnWriteList listeners = new CopyOnWriteList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDBaseImpl getSingleton(AzureusCore azureus_core) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new DDBaseImpl(azureus_core);
            }
        }
        finally {
            class_mon.exit();
        }
        return singleton;
    }

    protected DDBaseImpl(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
        torrent_transfer = new DDBaseTTTorrent(_azureus_core, this);
        this.grabDHT();
    }

    public DDBaseTTTorrent getTTTorrent() {
        return torrent_transfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DHTPlugin grabDHT() {
        if (this.dht_use_accessor != null) {
            return this.dht_use_accessor;
        }
        try {
            PluginInterface dht_pi;
            class_mon.enter();
            if (this.dht_use_accessor == null && (dht_pi = this.azureus_core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class)) != null) {
                this.dht_use_accessor = (DHTPlugin)dht_pi.getPlugin();
                if (this.dht_use_accessor.isEnabled()) {
                    this.dht_use_accessor.addListener(new DHTPluginListener(){

                        public void localAddressChanged(DHTPluginContact local_contact) {
                            List l = DDBaseImpl.this.listeners.getList();
                            dbEvent ev = new dbEvent(10);
                            for (int i = 0; i < l.size(); ++i) {
                                ((DistributedDatabaseListener)l.get(i)).event(ev);
                            }
                        }
                    });
                    try {
                        this.addTransferHandler(torrent_transfer, torrent_transfer);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        finally {
            class_mon.exit();
        }
        return this.dht_use_accessor;
    }

    public boolean isAvailable() {
        DHTPlugin dht = this.grabDHT();
        if (dht == null) {
            return false;
        }
        return dht.isEnabled();
    }

    public boolean isExtendedUseAllowed() {
        DHTPlugin dht = this.grabDHT();
        if (dht == null) {
            return false;
        }
        return dht.isExtendedUseAllowed();
    }

    public DistributedDatabaseContact getLocalContact() {
        DHTPlugin dht = this.grabDHT();
        if (dht == null) {
            return null;
        }
        return new DDBaseContactImpl(this, dht.getLocalAddress());
    }

    protected void throwIfNotAvailable() throws DistributedDatabaseException {
        if (!this.isAvailable()) {
            throw new DistributedDatabaseException("DHT not available");
        }
    }

    protected DHTPlugin getDHT() throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        return this.grabDHT();
    }

    protected void log(String str) {
        DHTPlugin dht = this.grabDHT();
        if (dht != null) {
            dht.log(str);
        }
    }

    public DistributedDatabaseKey createKey(Object key) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        return new DDBaseKeyImpl(key);
    }

    public DistributedDatabaseKey createKey(Object key, String description) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        return new DDBaseKeyImpl(key, description);
    }

    public DistributedDatabaseValue createValue(Object value) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        return new DDBaseValueImpl(new DDBaseContactImpl(this, this.getDHT().getLocalAddress()), value, SystemTime.getCurrentTime(), -1L);
    }

    public DistributedDatabaseContact importContact(InetSocketAddress address) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        DHTPluginContact contact = this.getDHT().importContact(address);
        if (contact == null) {
            throw new DistributedDatabaseException("import of '" + address + "' failed");
        }
        return new DDBaseContactImpl(this, contact);
    }

    public void write(DistributedDatabaseListener listener, DistributedDatabaseKey key, DistributedDatabaseValue value) throws DistributedDatabaseException {
        this.write(listener, key, new DistributedDatabaseValue[]{value});
    }

    public void write(DistributedDatabaseListener listener, DistributedDatabaseKey key, DistributedDatabaseValue[] values) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        for (int i = 0; i < values.length; ++i) {
            if (((DDBaseValueImpl)values[i]).getBytes().length <= DDBaseValueImpl.MAX_VALUE_SIZE) continue;
            throw new DistributedDatabaseException("Value size limited to " + DDBaseValueImpl.MAX_VALUE_SIZE + " bytes");
        }
        if (values.length == 0) {
            this.delete(listener, key);
        } else if (values.length == 1) {
            this.getDHT().put(((DDBaseKeyImpl)key).getBytes(), key.getDescription(), ((DDBaseValueImpl)values[0]).getBytes(), (byte)0, new listenerMapper(listener, 1, key, 0L, false, false));
        } else {
            byte[] current_key = ((DDBaseKeyImpl)key).getBytes();
            byte[] payload = new byte[512];
            int payload_length = 1;
            int pos = 0;
            while (pos < values.length) {
                DDBaseValueImpl value = (DDBaseValueImpl)values[pos];
                byte[] bytes = value.getBytes();
                int len = bytes.length;
                if (payload_length + len < payload.length - 2) {
                    payload[payload_length++] = (byte)((len & 0xFF00) >> 8);
                    payload[payload_length++] = (byte)(len & 0xFF);
                    System.arraycopy(bytes, 0, payload, payload_length, len);
                    payload_length += len;
                    ++pos;
                    continue;
                }
                payload[0] = 1;
                byte[] copy = new byte[payload_length];
                System.arraycopy(payload, 0, copy, 0, copy.length);
                byte[] f_current_key = current_key;
                this.getDHT().put(f_current_key, key.getDescription(), copy, (byte)4, new listenerMapper(listener, 1, key, 0L, false, false));
                payload_length = 1;
                current_key = new SHA1Simple().calculateHash(current_key);
            }
            if (payload_length > 1) {
                payload[0] = 0;
                byte[] copy = new byte[payload_length];
                System.arraycopy(payload, 0, copy, 0, copy.length);
                byte[] f_current_key = current_key;
                this.getDHT().put(f_current_key, key.getDescription(), copy, (byte)4, new listenerMapper(listener, 1, key, 0L, false, false));
            }
        }
    }

    public void read(DistributedDatabaseListener listener, DistributedDatabaseKey key, long timeout) throws DistributedDatabaseException {
        this.read(listener, key, timeout, 0);
    }

    public void read(DistributedDatabaseListener listener, DistributedDatabaseKey key, long timeout, int options) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        boolean exhaustive = (options & 1) != 0;
        boolean high_priority = (options & 2) != 0;
        this.getDHT().get(((DDBaseKeyImpl)key).getBytes(), key.getDescription(), (byte)0, 256, timeout, exhaustive, high_priority, new listenerMapper(listener, 2, key, timeout, exhaustive, high_priority));
    }

    public void readKeyStats(DistributedDatabaseListener listener, DistributedDatabaseKey key, long timeout) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        this.getDHT().get(((DDBaseKeyImpl)key).getBytes(), key.getDescription(), (byte)8, 256, timeout, false, false, new listenerMapper(listener, 6, key, timeout, false, false));
    }

    public void delete(DistributedDatabaseListener listener, DistributedDatabaseKey key) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        this.getDHT().remove(((DDBaseKeyImpl)key).getBytes(), key.getDescription(), new listenerMapper(listener, 3, key, 0L, false, false));
    }

    public void delete(DistributedDatabaseListener listener, DistributedDatabaseKey key, DistributedDatabaseContact[] targets) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        DHTPluginContact[] plugin_targets = new DHTPluginContact[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            plugin_targets[i] = ((DDBaseContactImpl)targets[i]).getContact();
        }
        this.getDHT().remove(plugin_targets, ((DDBaseKeyImpl)key).getBytes(), key.getDescription(), new listenerMapper(listener, 3, key, 0L, false, false));
    }

    public void addTransferHandler(final DistributedDatabaseTransferType type, final DistributedDatabaseTransferHandler handler) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        HashWrapper type_key = DDBaseHelpers.getKey(type.getClass());
        if (transfer_map.get(type_key) != null) {
            throw new DistributedDatabaseException("Handler for class '" + type.getClass().getName() + "' already defined");
        }
        transfer_map.put(type_key, handler);
        final String handler_name = type == torrent_transfer ? "Torrent Transfer" : "Plugin Defined";
        this.getDHT().registerHandler(type_key.getHash(), new DHTPluginTransferHandler(){

            public String getName() {
                return handler_name;
            }

            public byte[] handleRead(DHTPluginContact originator, byte[] xfer_key) {
                try {
                    DDBaseValueImpl res = (DDBaseValueImpl)handler.read(new DDBaseContactImpl(DDBaseImpl.this, originator), type, new DDBaseKeyImpl(xfer_key));
                    if (res == null) {
                        return null;
                    }
                    return res.getBytes();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    return null;
                }
            }

            public void handleWrite(DHTPluginContact originator, byte[] xfer_key, byte[] value) {
                try {
                    DDBaseContactImpl contact = new DDBaseContactImpl(DDBaseImpl.this, originator);
                    handler.write(contact, type, new DDBaseKeyImpl(xfer_key), new DDBaseValueImpl(contact, value, SystemTime.getCurrentTime(), -1L));
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        });
    }

    public DistributedDatabaseTransferType getStandardTransferType(int standard_type) throws DistributedDatabaseException {
        if (standard_type == 1) {
            return torrent_transfer;
        }
        throw new DistributedDatabaseException("unknown type");
    }

    protected DistributedDatabaseValue read(DDBaseContactImpl contact, final DistributedDatabaseProgressListener listener, DistributedDatabaseTransferType type, DistributedDatabaseKey key, long timeout) throws DistributedDatabaseException {
        if (type == torrent_transfer) {
            return torrent_transfer.read(contact, listener, type, key, timeout);
        }
        DHTPluginContact plugin_contact = contact.getContact();
        byte[] data = plugin_contact.read(new DHTPluginProgressListener(){

            public void reportSize(long size) {
                listener.reportSize(size);
            }

            public void reportActivity(String str) {
                listener.reportActivity(str);
            }

            public void reportCompleteness(int percent) {
                listener.reportCompleteness(percent);
            }
        }, DDBaseHelpers.getKey(type.getClass()).getHash(), ((DDBaseKeyImpl)key).getBytes(), timeout);
        if (data == null) {
            return null;
        }
        return new DDBaseValueImpl(contact, data, SystemTime.getCurrentTime(), -1L);
    }

    public void addListener(DistributedDatabaseListener l) {
        this.listeners.add(l);
    }

    public void removeListener(DistributedDatabaseListener l) {
        this.listeners.remove(l);
    }

    static {
        class_mon = new AEMonitor("DDBaseImpl:class");
        transfer_map = new HashMap();
    }

    protected class dbEvent
    implements DistributedDatabaseEvent {
        private int type;
        private DistributedDatabaseKey key;
        private DistributedDatabaseKeyStats key_stats;
        private DistributedDatabaseValue value;
        private DDBaseContactImpl contact;

        protected dbEvent(int _type) {
            this.type = _type;
        }

        protected dbEvent(int _type, DistributedDatabaseKey _key) {
            this.type = _type;
            this.key = _key;
        }

        protected dbEvent(int _type, DistributedDatabaseKey _key, DHTPluginContact _contact, DHTPluginValue _value) {
            this.type = _type;
            this.key = _key;
            this.contact = new DDBaseContactImpl(DDBaseImpl.this, _contact);
            this.value = new DDBaseValueImpl(this.contact, _value.getValue(), _value.getCreationTime(), _value.getVersion());
        }

        protected dbEvent(int _type, DistributedDatabaseKey _key, DHTPluginContact _contact, DistributedDatabaseKeyStats _key_stats) {
            this.type = _type;
            this.key = _key;
            this.contact = new DDBaseContactImpl(DDBaseImpl.this, _contact);
            this.key_stats = _key_stats;
        }

        protected dbEvent(int _type, DistributedDatabaseKey _key, DHTPluginContact _contact, byte[] _value, long _ct, long _v) {
            this.type = _type;
            this.key = _key;
            this.contact = new DDBaseContactImpl(DDBaseImpl.this, _contact);
            this.value = new DDBaseValueImpl(this.contact, _value, _ct, _v);
        }

        public int getType() {
            return this.type;
        }

        public DistributedDatabaseKey getKey() {
            return this.key;
        }

        public DistributedDatabaseKeyStats getKeyStats() {
            return this.key_stats;
        }

        public DistributedDatabaseValue getValue() {
            return this.value;
        }

        public DistributedDatabaseContact getContact() {
            return this.contact;
        }
    }

    protected class listenerMapper
    implements DHTPluginOperationListener {
        private DistributedDatabaseListener listener;
        private int type;
        private DistributedDatabaseKey key;
        private byte[] key_bytes;
        private long timeout;
        private boolean complete_disabled;
        private boolean exhaustive;
        private boolean high_priority;
        private int continuation_num;

        protected listenerMapper(DistributedDatabaseListener _listener, int _type, DistributedDatabaseKey _key, long _timeout, boolean _exhaustive, boolean _high_priority) {
            this.listener = _listener;
            this.type = _type;
            this.key = _key;
            this.key_bytes = ((DDBaseKeyImpl)this.key).getBytes();
            this.timeout = _timeout;
            this.exhaustive = _exhaustive;
            this.high_priority = _high_priority;
            this.continuation_num = 1;
        }

        private listenerMapper(DistributedDatabaseListener _listener, int _type, DistributedDatabaseKey _key, byte[] _key_bytes, long _timeout, int _continuation_num) {
            this.listener = _listener;
            this.type = _type;
            this.key = _key;
            this.key_bytes = _key_bytes;
            this.timeout = _timeout;
            this.continuation_num = _continuation_num;
        }

        public void diversified() {
        }

        public void starts(byte[] _key) {
            this.listener.event(new dbEvent(7, this.key));
        }

        public void valueRead(DHTPluginContact originator, DHTPluginValue _value) {
            if (this.type == 6) {
                if ((_value.getFlags() & 8) == 0) {
                    return;
                }
                try {
                    final DHTPluginKeyStats stats = DDBaseImpl.this.getDHT().decodeStats(_value);
                    DistributedDatabaseKeyStats ddb_stats = new DistributedDatabaseKeyStats(){

                        public int getEntryCount() {
                            return stats.getEntryCount();
                        }

                        public int getSize() {
                            return stats.getSize();
                        }

                        public int getReadsPerMinute() {
                            return stats.getReadsPerMinute();
                        }

                        public byte getDiversification() {
                            return stats.getDiversification();
                        }
                    };
                    this.listener.event(new dbEvent(this.type, this.key, originator, ddb_stats));
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            } else {
                byte[] value = _value.getValue();
                if (_value.getFlags() == 4) {
                    int len;
                    for (int pos = 1; pos < value.length; pos += len) {
                        if ((len = (value[pos++] << 8 & 0xFF00) + (value[pos++] & 0xFF)) > value.length - pos) {
                            Debug.out("Invalid length: len = " + len + ", remaining = " + (value.length - pos));
                            break;
                        }
                        byte[] d = new byte[len];
                        System.arraycopy(value, pos, d, 0, len);
                        this.listener.event(new dbEvent(this.type, this.key, originator, d, _value.getCreationTime(), _value.getVersion()));
                    }
                    if (value[0] == 1) {
                        byte[] next_key_bytes = new SHA1Simple().calculateHash(this.key_bytes);
                        this.complete_disabled = true;
                        DDBaseImpl.this.grabDHT().get(next_key_bytes, this.key.getDescription() + " [continuation " + this.continuation_num + "]", (byte)0, 256, this.timeout, this.exhaustive, this.high_priority, new listenerMapper(this.listener, 2, this.key, next_key_bytes, this.timeout, this.continuation_num + 1));
                    }
                } else {
                    this.listener.event(new dbEvent(this.type, this.key, originator, _value));
                }
            }
        }

        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            this.listener.event(new dbEvent(this.type, this.key, target, value));
        }

        public void complete(byte[] timeout_key, boolean timeout_occurred) {
            if (!this.complete_disabled) {
                this.listener.event(new dbEvent(timeout_occurred ? 5 : 4, this.key));
            }
        }
    }
}

