/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import com.aelitis.azureus.core.util.HTTPUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;

public class TrackerWebPageResponseImpl
implements TrackerWebPageResponse {
    private static final String NL = "\r\n";
    private OutputStream os;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
    private String content_type = "text/html";
    private int reply_status = 200;
    private Map header_map = new LinkedHashMap();
    private TrackerWebPageRequest request;
    private AsyncController async_control;
    private boolean is_async;

    protected TrackerWebPageResponseImpl(OutputStream _os, TrackerWebPageRequest _request, AsyncController _async_control) {
        this.os = _os;
        this.request = _request;
        this.async_control = _async_control;
        String formatted_date_now = TimeFormatter.getHTTPDate(SystemTime.getCurrentTime());
        this.setHeader("Last-Modified", formatted_date_now);
        this.setHeader("Expires", formatted_date_now);
    }

    public void setLastModified(long time) {
        String formatted_date = TimeFormatter.getHTTPDate(time);
        this.setHeader("Last-Modified", formatted_date);
    }

    public void setExpires(long time) {
        String formatted_date = TimeFormatter.getHTTPDate(time);
        this.setHeader("Expires", formatted_date);
    }

    public void setContentType(String type) {
        this.content_type = type;
    }

    public void setReplyStatus(int status) {
        this.reply_status = status;
    }

    public void setHeader(String name, String value) {
        this.addHeader(name, value, true);
    }

    protected void addHeader(String name, String value, boolean replace) {
        Iterator it = this.header_map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.equalsIgnoreCase(name)) continue;
            if (replace) {
                it.remove();
                continue;
            }
            return;
        }
        this.header_map.put(name, value);
    }

    public OutputStream getOutputStream() {
        return this.baos;
    }

    protected void complete() throws IOException {
        if (this.is_async) {
            return;
        }
        byte[] reply_bytes = this.baos.toByteArray();
        String status_string = "BAD";
        if (this.reply_status == 200) {
            status_string = "OK";
        } else if (this.reply_status == 204) {
            status_string = "No Content";
        } else if (this.reply_status == 206) {
            status_string = "Partial Content";
        } else if (this.reply_status == 401) {
            status_string = "Unauthorized";
        } else if (this.reply_status == 404) {
            status_string = "Not Found";
        } else if (this.reply_status == 501) {
            status_string = "Not Implemented";
        }
        String reply_header = "HTTP/1.1 " + this.reply_status + " " + status_string + NL;
        this.addHeader("Server", "Azureus 4.0.0.1_B06", false);
        this.addHeader("Connection", "close", false);
        this.addHeader("Content-Type", this.content_type, false);
        for (String name : this.header_map.keySet()) {
            String value = (String)this.header_map.get(name);
            reply_header = reply_header + name + ": " + value + NL;
        }
        reply_header = reply_header + "Content-Length: " + reply_bytes.length + NL + NL;
        this.os.write(reply_header.getBytes());
        this.os.flush();
        this.os.write(reply_bytes);
        this.os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useFile(String root_dir, String relative_url) throws IOException {
        String target = root_dir + relative_url.replace('/', File.separatorChar);
        File canonical_file = new File(target).getCanonicalFile();
        if (!canonical_file.toString().startsWith(root_dir)) {
            return false;
        }
        if (canonical_file.isDirectory()) {
            return false;
        }
        if (canonical_file.canRead()) {
            String str = canonical_file.toString().toLowerCase();
            int pos = str.lastIndexOf(".");
            if (pos == -1) {
                return false;
            }
            String file_type = str.substring(pos + 1);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(canonical_file);
                this.useStream(file_type, fis);
                boolean bl = true;
                return bl;
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        return false;
    }

    public void useStream(String file_type, InputStream input_stream) throws IOException {
        int len;
        Map headers;
        String accept_encoding;
        OutputStream os = this.getOutputStream();
        String response_type = HTTPUtils.guessContentTypeFromFileType(file_type);
        if (HTTPUtils.useCompressionForFileType(response_type) && HTTPUtils.canGZIP(accept_encoding = (String)(headers = this.request.getHeaders()).get("accept-encoding"))) {
            os = new GZIPOutputStream(os);
            this.header_map.put("Content-Encoding", "gzip");
        }
        this.setContentType(response_type);
        byte[] buffer = new byte[4096];
        while ((len = input_stream.read(buffer)) > 0) {
            os.write(buffer, 0, len);
        }
        if (os instanceof GZIPOutputStream) {
            ((GZIPOutputStream)os).finish();
        }
    }

    public void writeTorrent(TrackerTorrent tracker_torrent) throws IOException {
        try {
            TRHostTorrent host_torrent = ((TrackerTorrentImpl)tracker_torrent).getHostTorrent();
            TOTorrent torrent = host_torrent.getTorrent();
            TOTorrent torrent_to_send = TOTorrentFactory.deserialiseFromMap(torrent.serialiseToMap());
            torrent_to_send.removeAdditionalProperties();
            if (!TorrentUtils.isDecentralised(torrent_to_send)) {
                URL[][] url_sets = TRTrackerUtils.getAnnounceURLs();
                if (host_torrent.getStatus() != 3 && url_sets.length > 0 && COConfigurationManager.getBooleanParameter("Tracker Host Add Our Announce URLs")) {
                    String protocol = torrent_to_send.getAnnounceURL().getProtocol();
                    for (int i = 0; i < url_sets.length; ++i) {
                        URL[] urls = url_sets[i];
                        if (!urls[0].getProtocol().equalsIgnoreCase(protocol)) continue;
                        torrent_to_send.setAnnounceURL(urls[0]);
                        torrent_to_send.getAnnounceURLGroup().setAnnounceURLSets(new TOTorrentAnnounceURLSet[0]);
                        for (int j = 1; j < urls.length; ++j) {
                            TorrentUtils.announceGroupsInsertLast(torrent_to_send, new URL[]{urls[j]});
                        }
                        break;
                    }
                }
            }
            this.baos.write(BEncoder.encode(torrent_to_send.serialiseToMap()));
            this.setContentType("application/x-bittorrent");
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            throw new IOException(e.toString());
        }
    }

    public void setAsynchronous(boolean a) throws IOException {
        if (this.async_control == null) {
            throw new IOException("Request is not non-blocking");
        }
        if (a) {
            this.is_async = true;
            this.async_control.setAsyncStart();
        } else {
            this.is_async = false;
            this.complete();
            this.async_control.setAsyncComplete();
        }
    }

    public boolean getAsynchronous() {
        return this.is_async;
    }
}

