/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.components;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.plugins.ui.components.UIPropertyChangeListener;
import org.gudy.azureus2.plugins.ui.components.UITextArea;
import org.gudy.azureus2.pluginsimpl.local.ui.components.UIComponentImpl;

public class UITextAreaImpl
extends UIComponentImpl
implements UITextArea {
    private int max_size = 60000;
    private int max_file_size = 20 * this.max_size;
    PrintWriter pw;
    int current_file_size;
    File file;
    boolean useFile = true;
    AEMonitor file_mon = new AEMonitor("filemon");
    LinkedList delay_text = new LinkedList();
    int delay_size = 0;
    FrequencyLimitedDispatcher dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        public void runSupport() {
            UITextAreaImpl.this.delayAppend();
        }
    }, 500);

    public UITextAreaImpl() {
        this.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        if (this.useFile) {
            try {
                this.file_mon.enter();
                if (this.pw == null) {
                    try {
                        this.file = AETemporaryFileHandler.createTempFile();
                        FileWriter fr = new FileWriter(this.file);
                        this.pw = new PrintWriter(fr);
                        this.pw.print(text);
                        this.current_file_size = text.length();
                        this.pw.flush();
                        return;
                    }
                    catch (IOException e) {}
                }
            }
            finally {
                this.file_mon.exit();
            }
        }
        if (text.length() > this.max_size) {
            int size_to_show = this.max_size - 10000;
            if (size_to_show < 0) {
                size_to_show = this.max_size;
            }
            text = text.substring(text.length() - size_to_show);
        }
        this.setProperty("value", text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendText(String text) {
        if (this.useFile && this.pw != null) {
            try {
                this.file_mon.enter();
                if (this.current_file_size > this.max_file_size) {
                    this.getFileText();
                }
                this.pw.print(text);
                this.current_file_size += text.length();
                this.pw.flush();
                return;
            }
            finally {
                this.file_mon.exit();
            }
        }
        UITextAreaImpl uITextAreaImpl = this;
        synchronized (uITextAreaImpl) {
            this.delay_text.addLast(text);
            this.delay_size += text.length();
            while (this.delay_size > this.max_size && this.delay_text.size() != 0) {
                String s = (String)this.delay_text.removeFirst();
                this.delay_size -= s.length();
            }
        }
        this.dispatcher.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delayAppend() {
        String text;
        String str = this.getText();
        UITextAreaImpl uITextAreaImpl = this;
        synchronized (uITextAreaImpl) {
            if (this.delay_text.size() == 1) {
                text = (String)this.delay_text.get(0);
            } else {
                StringBuffer sb = new StringBuffer(this.delay_size);
                Iterator it = this.delay_text.iterator();
                while (it.hasNext()) {
                    sb.append((String)it.next());
                }
                text = sb.toString();
            }
            this.delay_text.clear();
            this.delay_size = 0;
        }
        if (str == null) {
            this.setText(text);
        } else {
            this.setText(str + text);
        }
    }

    public String getText() {
        if (this.useFile && this.pw != null) {
            return this.getFileText();
        }
        return (String)this.getProperty("value");
    }

    public void setMaximumSize(int _max_size) {
        this.max_size = _max_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileText() {
        boolean recreate = this.pw != null;
        try {
            this.file_mon.enter();
            if (recreate) {
                this.pw.close();
            }
            String text = null;
            try {
                text = FileUtil.readFileEndAsString(this.file, this.max_size);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (text == null) {
                text = "";
            }
            if (recreate) {
                try {
                    FileWriter fr = new FileWriter(this.file);
                    this.pw = new PrintWriter(fr);
                    this.pw.print(text);
                    this.current_file_size = text.length();
                }
                catch (IOException e) {
                    this.useFile = false;
                    e.printStackTrace();
                }
            }
            String string = text;
            return string;
        }
        finally {
            this.file_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(UIPropertyChangeListener l) {
        if (this.useFile) {
            if (this.pw != null) {
                try {
                    this.file_mon.enter();
                    this.pw.close();
                    this.pw = null;
                }
                finally {
                    this.file_mon.exit();
                }
            }
            this.useFile = false;
            this.setText(this.getFileText());
        }
        super.addPropertyChangeListener(l);
    }
}

