/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;

public class BooleanParameterImpl
extends ParameterImpl
implements BooleanParameter {
    private boolean default_value;

    public BooleanParameterImpl(PluginConfigImpl config, String key, String label, boolean defaultValue) {
        super(config, key, label);
        this.default_value = defaultValue;
        config.notifyParamExists(this.getKey());
        COConfigurationManager.setBooleanDefault(this.getKey(), defaultValue);
    }

    public boolean getDefaultValue() {
        return this.default_value;
    }

    public boolean getValue() {
        return this.config.getUnsafeBooleanParameter(this.getKey(), this.getDefaultValue());
    }

    public void setValue(boolean b) {
        this.config.setUnsafeBooleanParameter(this.getKey(), b);
    }
}

