/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.tables;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.impl.TableColumnImpl;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerEventAdapter;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.tables.TableContextMenuItemImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;

public class TableManagerImpl
implements TableManager {
    private UIManagerImpl ui_manager;

    public TableManagerImpl(UIManagerImpl _ui_manager) {
        this.ui_manager = _ui_manager;
    }

    public TableColumn createColumn(String tableID, String cellID) {
        final TableColumnImpl column = new TableColumnImpl(tableID, cellID);
        this.ui_manager.addUIListener(new UIManagerListener(){

            public void UIDetached(UIInstance instance) {
            }

            public void UIAttached(UIInstance instance) {
                UIManagerEventAdapter event2 = new UIManagerEventAdapter(10, column);
                UIManagerImpl.fireEvent(event2);
            }
        });
        return column;
    }

    public void registerColumn(Class forDataSourceType, String cellID, TableColumnCreationListener listener) {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.registerColumn(forDataSourceType, cellID, listener);
    }

    public void addColumn(final TableColumn tableColumn) {
        if (!(tableColumn instanceof TableColumnCore)) {
            throw new UIRuntimeException("TableManager.addColumn(..) can only add columns created by createColumn(..)");
        }
        this.ui_manager.addUIListener(new UIManagerListener(){

            public void UIDetached(UIInstance instance) {
            }

            public void UIAttached(UIInstance instance) {
                UIManagerEventAdapter event2 = new UIManagerEventAdapter(11, tableColumn);
                UIManagerImpl.fireEvent(event2);
            }
        });
    }

    public TableContextMenuItem addContextMenuItem(TableContextMenuItem parent, String resourceKey) {
        if (!(parent instanceof TableContextMenuItemImpl)) {
            throw new UIRuntimeException("parent must have been created by addContextMenuItem");
        }
        if (parent.getStyle() != 5) {
            throw new UIRuntimeException("parent menu item must have the menu style associated");
        }
        TableContextMenuItemImpl item = new TableContextMenuItemImpl((TableContextMenuItemImpl)parent, resourceKey);
        UIManagerImpl.fireEvent(14, new Object[]{item, parent});
        return item;
    }

    public TableContextMenuItem addContextMenuItem(String tableID, String resourceKey) {
        TableContextMenuItemImpl item = new TableContextMenuItemImpl(tableID, resourceKey);
        UIManagerImpl.fireEvent(12, item);
        return item;
    }
}

