/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.InputStream;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderDelayedFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderErrorImpl;

public class ResourceDownloaderDelayedImpl
extends ResourceDownloaderBaseImpl {
    protected ResourceDownloaderDelayedFactory factory;
    protected ResourceDownloaderBaseImpl delegate;
    protected long size = -2L;

    protected ResourceDownloaderDelayedImpl(ResourceDownloaderBaseImpl _parent, ResourceDownloaderDelayedFactory _factory) {
        super(_parent);
        this.factory = _factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getDelegate() {
        block6: {
            try {
                this.this_mon.enter();
                if (this.delegate != null) break block6;
                try {
                    this.delegate = (ResourceDownloaderBaseImpl)this.factory.create();
                    this.delegate.setParent(this);
                    if (this.size >= 0L) {
                        this.delegate.setSize(this.size);
                    }
                }
                catch (ResourceDownloaderException e) {
                    this.delegate = new ResourceDownloaderErrorImpl(this, e);
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    public String getName() {
        if (this.delegate == null) {
            return "<...>";
        }
        return this.delegate.getName();
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderDelayedImpl c = new ResourceDownloaderDelayedImpl(parent, this.factory);
        c.setSize(this.size);
        c.setProperties(this);
        return c;
    }

    public InputStream download() throws ResourceDownloaderException {
        this.getDelegate();
        return this.delegate.download();
    }

    public void asyncDownload() {
        this.getDelegate();
        this.delegate.asyncDownload();
    }

    protected void setSize(long _size) {
        this.size = _size;
        if (this.delegate != null && this.size >= 0L) {
            this.delegate.setSize(this.size);
        }
    }

    public void setProperty(String name, Object value) throws ResourceDownloaderException {
        this.setPropertySupport(name, value);
        if (this.delegate != null) {
            this.delegate.setProperty(name, value);
        }
    }

    public long getSize() throws ResourceDownloaderException {
        this.getDelegate();
        return this.delegate.getSize();
    }

    public void cancel() {
        this.setCancelled();
        this.getDelegate();
        this.delegate.cancel();
    }

    public void reportActivity(String activity) {
        this.getDelegate();
        this.delegate.reportActivity(activity);
    }

    public void addListener(ResourceDownloaderListener l) {
        this.getDelegate();
        this.delegate.addListener(l);
    }

    public void removeListener(ResourceDownloaderListener l) {
        this.getDelegate();
        this.delegate.removeListener(l);
    }
}

