/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.rss;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSItem;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSUtils;

public class RSSItemImpl
implements RSSItem {
    private boolean is_atom;
    private SimpleXMLParserDocumentNode node;

    protected RSSItemImpl(SimpleXMLParserDocumentNode _node, boolean _is_atom) {
        this.is_atom = _is_atom;
        this.node = _node;
    }

    public String getTitle() {
        if (this.node.getChild("title") != null) {
            return this.node.getChild("title").getValue();
        }
        return null;
    }

    public String getDescription() {
        if (this.node.getChild("description") != null) {
            return this.node.getChild("description").getValue();
        }
        return null;
    }

    public URL getLink() {
        SimpleXMLParserDocumentNode link_node = this.node.getChild("link");
        if (link_node != null) {
            try {
                if (this.is_atom) {
                    return new URL(link_node.getAttribute("href").getValue());
                }
                return new URL(link_node.getValue());
            }
            catch (MalformedURLException e) {
                Debug.printStackTrace(e);
                return null;
            }
        }
        return null;
    }

    public Date getPublicationDate() {
        SimpleXMLParserDocumentNode pd = this.node.getChild(this.is_atom ? "published" : "pubdate");
        if (pd != null) {
            if (this.is_atom) {
                return RSSUtils.parseAtomDate(pd.getValue());
            }
            return RSSUtils.parseRSSDate(pd.getValue());
        }
        return null;
    }

    public String getUID() {
        String value;
        SimpleXMLParserDocumentNode uid = this.node.getChild(this.is_atom ? "id" : "guid");
        if (uid != null && (value = uid.getValue().trim()).length() > 0) {
            return value;
        }
        return null;
    }

    public SimpleXMLParserDocumentNode getNode() {
        return this.node;
    }
}

