/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.DenyAllFilter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.OptionsConsoleCommand;

public class Log
extends OptionsConsoleCommand {
    private Map channel_listener_map = new HashMap();

    public Log() {
        super("log", "l");
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(new Option("f", "filename", true, "filename to write log to"));
        return options;
    }

    public void execute(String commandName, final ConsoleInput ci, CommandLine commandLine) {
        Appender con = Logger.getRootLogger().getAppender("ConsoleAppender");
        List args = commandLine.getArgList();
        if (con != null && !args.isEmpty()) {
            String subcommand = (String)args.get(0);
            if ("off".equalsIgnoreCase(subcommand)) {
                if (args.size() == 1) {
                    con.addFilter((Filter)new DenyAllFilter());
                    ci.out.println("> Console logging off");
                } else {
                    String name = (String)args.get(1);
                    Object[] entry = (Object[])this.channel_listener_map.remove(name);
                    if (entry == null) {
                        ci.out.println("> Channel '" + name + "' not being logged");
                    } else {
                        ((LoggerChannel)entry[0]).removeListener((LoggerChannelListener)entry[1]);
                        ci.out.println("> Channel '" + name + "' logging off");
                    }
                }
            } else if ("on".equalsIgnoreCase(subcommand)) {
                if (args.size() == 1) {
                    if (commandLine.hasOption('f')) {
                        String filename = commandLine.getOptionValue('f');
                        try {
                            FileAppender newAppender = new FileAppender((Layout)new PatternLayout("%d{ISO8601} %c{1}-%p: %m%n"), filename, true);
                            newAppender.setName("ConsoleAppender");
                            Logger.getRootLogger().removeAppender(con);
                            Logger.getRootLogger().addAppender((Appender)newAppender);
                            ci.out.println("> Logging to filename: " + filename);
                        }
                        catch (IOException e) {
                            ci.out.println("> Unable to log to file: " + filename + ": " + e);
                        }
                    } else {
                        if (!(con instanceof ConsoleAppender)) {
                            Logger.getRootLogger().removeAppender(con);
                            con = new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"));
                            con.setName("ConsoleAppender");
                            Logger.getRootLogger().addAppender(con);
                        }
                        ci.out.println("> Console logging on");
                    }
                    con.clearFilters();
                } else {
                    String name;
                    Map channel_map = this.getChannelMap(ci);
                    LoggerChannel channel = (LoggerChannel)channel_map.get(name = (String)args.get(1));
                    if (channel == null) {
                        ci.out.println("> Channel '" + name + "' not found");
                    } else if (this.channel_listener_map.get(name) != null) {
                        ci.out.println("> Channel '" + name + "' already being logged");
                    } else {
                        LoggerChannelListener l = new LoggerChannelListener(){

                            public void messageLogged(int type, String content) {
                                ci.out.println("[" + name + "] " + content);
                            }

                            public void messageLogged(String str, Throwable error) {
                                ci.out.println("[" + name + "] " + str);
                                error.printStackTrace(ci.out);
                            }
                        };
                        channel.addListener(l);
                        this.channel_listener_map.put(name, new Object[]{channel, l});
                        ci.out.println("> Channel '" + name + "' on");
                    }
                }
            } else if (subcommand.equalsIgnoreCase("list")) {
                Map channel_map = this.getChannelMap(ci);
                for (String name : channel_map.keySet()) {
                    ci.out.println("  " + name + " [" + (this.channel_listener_map.get(name) == null ? "off" : "on") + "]");
                }
            } else {
                ci.out.println("> Command 'log': Subcommand '" + subcommand + "' unknown.");
            }
        } else {
            ci.out.println("> Console logger not found or missing subcommand for 'log'\r\n> log syntax: log [-f filename] (on [name]|off [name]|list)");
        }
    }

    protected Map getChannelMap(ConsoleInput ci) {
        HashMap<String, LoggerChannel> channel_map = new HashMap<String, LoggerChannel>();
        PluginInterface[] pis = ci.azureus_core.getPluginManager().getPluginInterfaces();
        for (int i = 0; i < pis.length; ++i) {
            LoggerChannel[] logs = pis[i].getLogger().getChannels();
            if (logs.length <= 0) continue;
            if (logs.length == 1) {
                channel_map.put(pis[i].getPluginName(), logs[0]);
                continue;
            }
            for (int j = 0; j < logs.length; ++j) {
                channel_map.put(pis[i].getPluginName() + "." + logs[j].getName(), logs[j]);
            }
        }
        return channel_map;
    }

    public static void commandLogtest(ConsoleInput ci, List args) {
        Logger.getLogger((String)"azureus2").fatal((Object)("Logging test" + (args == null || args.isEmpty() ? "" : ": " + args.get(0).toString())));
    }

    public String getCommandDescriptions() {
        return "log [-f filename] (on [name]|off [name]|list)\t\t\tl\tTurn on/off console logging";
    }
}

