/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.ControlUtils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class CategoryAdderWindow {
    private Category newCategory = null;

    public CategoryAdderWindow(Display display) {
        Button ok;
        Button cancel;
        final Shell shell = ShellFactory.createShell(display, 67680);
        shell.setText(MessageText.getString("CategoryAddWindow.title"));
        Utils.setShellIcon(shell);
        GridLayout layout = new GridLayout();
        shell.setLayout((Layout)layout);
        Label label = new Label((Composite)shell, 0);
        Messages.setLanguageText((Widget)label, "CategoryAddWindow.message");
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        label.setLayoutData((Object)gridData);
        final Text category = new Text((Composite)shell, 2048);
        gridData = new GridData();
        gridData.widthHint = 300;
        category.setLayoutData((Object)gridData);
        Composite panel = new Composite((Composite)shell, 0);
        RowLayout rLayout = new RowLayout();
        rLayout.marginTop = 0;
        rLayout.marginLeft = 0;
        rLayout.marginBottom = 0;
        rLayout.marginRight = 0;
        try {
            rLayout.fill = true;
        }
        catch (NoSuchFieldError e) {
            // empty catch block
        }
        rLayout.spacing = ControlUtils.getButtonMargin();
        panel.setLayout((Layout)rLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = Constants.isOSX ? 0x1000008 : 0x1000000;
        panel.setLayoutData((Object)gridData);
        if (Constants.isOSX) {
            cancel = CategoryAdderWindow.createAlertButton(panel, "Button.cancel");
            ok = CategoryAdderWindow.createAlertButton(panel, "Button.ok");
        } else {
            ok = CategoryAdderWindow.createAlertButton(panel, "Button.ok");
            cancel = CategoryAdderWindow.createAlertButton(panel, "Button.cancel");
        }
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                try {
                    if (category.getText() != "") {
                        CategoryAdderWindow.this.newCategory = CategoryManager.createCategory(category.getText());
                    }
                    shell.dispose();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                shell.dispose();
            }
        });
        shell.setDefaultButton(ok);
        shell.pack();
        Utils.createURLDropTarget((Composite)shell, category);
        Utils.centreWindow(shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private static Button createAlertButton(Composite panel, String localizationKey) {
        Button button = new Button(panel, 8);
        button.setText(MessageText.getString(localizationKey));
        RowData rData = new RowData();
        rData.width = Math.max(ControlUtils.getDialogButtonMinWidth(), button.computeSize((int)-1, (int)-1).x);
        button.setLayoutData((Object)rData);
        return button;
    }

    public Category getNewCategory() {
        return this.newCategory;
    }
}

