/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.pluginsimpl.local.ui.menus.MenuItemImpl;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;

public class MenuBuildUtils {
    public static final PluginMenuController BASIC_MENU_ITEM_CONTROLLER = new MenuItemPluginMenuControllerImpl(null);

    public static void addMaintenanceListenerForMenu(final Menu menu, final MenuBuilder builder) {
        menu.addMenuListener(new MenuListener(){
            boolean bShown = false;

            public void menuHidden(MenuEvent e) {
                this.bShown = false;
                if (Constants.isOSX) {
                    return;
                }
                e.widget.getDisplay().asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        if (bShown || menu.isDisposed()) {
                            return;
                        }
                        MenuItem[] items = menu.getItems();
                        for (int i = 0; i < items.length; ++i) {
                            items[i].dispose();
                        }
                    }
                });
            }

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                this.bShown = true;
                builder.buildMenu(menu);
            }
        });
    }

    public static void addPluginMenuItems(Composite composite, org.gudy.azureus2.plugins.ui.menus.MenuItem[] items, Menu parent, boolean prev_was_separator, boolean enable_items, PluginMenuController controller) {
        for (int i = 0; i < items.length; ++i) {
            int swt_style;
            final MenuItemImpl az_menuitem = (MenuItemImpl)items[i];
            controller.notifyFillListeners(az_menuitem);
            if (!az_menuitem.isVisible()) continue;
            int style = az_menuitem.getStyle();
            boolean this_is_separator = false;
            boolean is_container = false;
            if (style == 5) {
                swt_style = 64;
                is_container = true;
            } else if (style == 1) {
                swt_style = 8;
            } else if (style == 2) {
                swt_style = 32;
            } else if (style == 3) {
                swt_style = 16;
            } else if (style == 4) {
                this_is_separator = true;
                swt_style = 2;
            } else {
                swt_style = 8;
            }
            final MenuItem menuItem = new MenuItem(parent, swt_style);
            if (swt_style == 2 || prev_was_separator && this_is_separator || this_is_separator && i == items.length - 1) continue;
            prev_was_separator = this_is_separator;
            if (enable_items && (style == 2 || style == 3)) {
                Boolean selection_value = (Boolean)az_menuitem.getData();
                if (selection_value == null) {
                    throw new RuntimeException("MenuItem with resource name \"" + az_menuitem.getResourceKey() + "\" needs to have a boolean value entered via setData before being used!");
                }
                menuItem.setSelection(selection_value.booleanValue());
            }
            final Listener main_listener = controller.makeSelectionListener(az_menuitem);
            menuItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    if (!(az_menuitem.getStyle() != 2 && az_menuitem.getStyle() != 3 || menuItem.isDisposed())) {
                        az_menuitem.setData(new Boolean(menuItem.getSelection()));
                    }
                    main_listener.handleEvent(e);
                }
            });
            if (is_container) {
                Menu this_menu = new Menu((Decorations)composite.getShell(), 4);
                menuItem.setMenu(this_menu);
                MenuBuildUtils.addPluginMenuItems(composite, az_menuitem.getItems(), this_menu, false, enable_items, controller);
            }
            String custom_title = az_menuitem.getText();
            menuItem.setText(custom_title);
            Graphic g = az_menuitem.getGraphic();
            if (g instanceof UISWTGraphic) {
                Utils.setMenuItemImage(menuItem, ((UISWTGraphic)g).getImage());
            }
            menuItem.setEnabled(enable_items && az_menuitem.isEnabled());
        }
    }

    public static class MenuItemPluginMenuControllerImpl
    implements PluginMenuController {
        private Object[] objects;

        public MenuItemPluginMenuControllerImpl(Object[] o) {
            this.objects = o;
        }

        public Listener makeSelectionListener(org.gudy.azureus2.plugins.ui.menus.MenuItem menu_item) {
            final MenuItemImpl mii = (MenuItemImpl)menu_item;
            return new Listener(){

                public void handleEvent(Event e) {
                    mii.invokeListenersMulti(MenuItemPluginMenuControllerImpl.this.objects);
                }
            };
        }

        public void notifyFillListeners(org.gudy.azureus2.plugins.ui.menus.MenuItem menu_item) {
            ((MenuItemImpl)menu_item).invokeMenuWillBeShownListeners(this.objects);
        }
    }

    public static interface PluginMenuController {
        public Listener makeSelectionListener(org.gudy.azureus2.plugins.ui.menus.MenuItem var1);

        public void notifyFillListeners(org.gudy.azureus2.plugins.ui.menus.MenuItem var1);
    }

    public static interface MenuBuilder {
        public void buildMenu(Menu var1);
    }
}

