/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.ui.common.RememberedDecisionsManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;

public class MessageBoxWindow {
    public static final String ICON_ERROR = "error";
    public static final String ICON_WARNING = "warning";
    public static final String ICON_INFO = "info";
    private Shell shell;
    private AESemaphore result_sem = new AESemaphore("MessageBoxWindow");
    private volatile int result;
    private volatile boolean result_set;

    public static int open(String id, int options, int remember_map, boolean default_is_yes, Display display, String icon, String title, String message) {
        int remembered = RememberedDecisionsManager.getRememberedDecision(id, remember_map);
        if (remembered > 0) {
            return remembered;
        }
        return new MessageBoxWindow(id, options, remember_map != 0, default_is_yes, display, icon, title, message).getResult();
    }

    protected MessageBoxWindow(final String id, int options, boolean remember_decision, boolean default_is_yes, Display display, String icon, String title, String message) {
        Button checkBox;
        this.shell = new Shell(display, 65632);
        this.shell.setText(title);
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.shell.setLayout((Layout)layout);
        Label label = new Label((Composite)this.shell, 0);
        Image image = ImageRepository.getImage(icon);
        if (image != null) {
            label.setImage(image);
        }
        BufferedLabel msg_label = new BufferedLabel((Composite)this.shell, 64);
        msg_label.setText(message);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        msg_label.setLayoutData(gridData);
        if (remember_decision) {
            checkBox = new Button((Composite)this.shell, 32);
            checkBox.setSelection(false);
            checkBox.setText(MessageText.getString("MessageBoxWindow.rememberdecision"));
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            checkBox.setLayoutData((Object)gridData);
        } else {
            checkBox = null;
            Label pad = new Label((Composite)this.shell, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            pad.setLayoutData((Object)gridData);
        }
        Label labelSeparator = new Label((Composite)this.shell, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        labelSeparator.setLayoutData((Object)gridData);
        label = new Label((Composite)this.shell, 0);
        final int yes_option = options & 0x60;
        Button bYes = new Button((Composite)this.shell, 8);
        bYes.setText(MessageText.getString(yes_option == 64 ? "Button.yes" : "Button.ok"));
        gridData = new GridData(896);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 70;
        bYes.setLayoutData((Object)gridData);
        bYes.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MessageBoxWindow.this.setResult(id, yes_option, checkBox == null ? false : checkBox.getSelection());
            }
        });
        final int no_option = options & 0x180;
        Button bNo = new Button((Composite)this.shell, 8);
        bNo.setText(MessageText.getString(no_option == 128 ? "Button.no" : "Button.cancel"));
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = 70;
        bNo.setLayoutData((Object)gridData);
        bNo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MessageBoxWindow.this.setResult(id, no_option, checkBox == null ? false : checkBox.getSelection());
            }
        });
        this.shell.setDefaultButton(default_is_yes ? bYes : bNo);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    MessageBoxWindow.this.setResult(id, 0, false);
                }
            }
        });
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event arg0) {
                MessageBoxWindow.this.setResult(id, 0, false);
            }
        });
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.shell.open();
        (default_is_yes ? bYes : bNo).setFocus();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void setResult(String id, int option, boolean remember) {
        if (!this.result_set) {
            this.result = option;
            this.result_set = true;
            if (remember) {
                RememberedDecisionsManager.setRemembered(id, this.result);
            }
            this.result_sem.release();
            this.close();
        }
    }

    protected void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    protected int getResult() {
        this.result_sem.reserve();
        return this.result;
    }
}

